/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

public enum Role {
    NORMAL(1),
    STANDBY(2),
    PROXY(3),
    OBSERVER(4),
    RESTORING(5);

    final byte mCode;

    private Role(byte code) {
        this.mCode = code;
    }

    boolean providesConsensus() {
        return this.isCandidate();
    }

    boolean canProxy() {
        return this.mCode <= 3;
    }

    boolean isCandidate() {
        return this.mCode <= 2;
    }

    static Role decode(byte code) {
        return switch (code) {
            case 1 -> NORMAL;
            case 2 -> STANDBY;
            case 3 -> PROXY;
            case 4 -> OBSERVER;
            case 5 -> RESTORING;
            default -> throw new IllegalArgumentException();
        };
    }
}

