/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Map;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.repl.GroupFile;
import org.cojen.tupl.repl.OptionsDecoder;
import org.cojen.tupl.repl.OptionsEncoder;
import org.cojen.tupl.repl.SnapshotReceiver;

final class SocketSnapshotReceiver
implements SnapshotReceiver {
    private final Socket mSocket;
    private final long mLength;
    private final long mPrevTerm;
    private final long mTerm;
    private final long mPosition;
    private final Map<String, String> mOptions;

    SocketSnapshotReceiver(GroupFile groupFile, Socket socket, Map<String, String> requestOptions) throws IOException {
        OptionsDecoder dec;
        OptionsEncoder enc = new OptionsEncoder();
        enc.encodeIntLE(0);
        enc.encodeMap(requestOptions == null ? Collections.emptyMap() : requestOptions);
        enc.writeTo(socket.getOutputStream());
        try {
            dec = new OptionsDecoder(socket.getInputStream());
        }
        catch (EOFException e) {
            Utils.closeQuietly(socket);
            throw new IOException("Disconnected");
        }
        int encoding = dec.decodeIntLE();
        if (encoding != 0) {
            Utils.closeQuietly(socket);
            throw new IOException("Unknown encoding: " + encoding);
        }
        this.mSocket = socket;
        this.mLength = dec.decodeLongLE();
        this.mPrevTerm = dec.decodeLongLE();
        this.mTerm = dec.decodeLongLE();
        this.mPosition = dec.decodeLongLE();
        this.mOptions = dec.decodeMap();
        groupFile.readFrom(socket.getInputStream());
    }

    @Override
    public SocketAddress senderAddress() {
        return this.mSocket.getRemoteSocketAddress();
    }

    @Override
    public Map<String, String> options() {
        return this.mOptions;
    }

    @Override
    public long length() {
        return this.mLength;
    }

    public long prevTerm() {
        return this.mPrevTerm;
    }

    public long term() {
        return this.mTerm;
    }

    @Override
    public long position() {
        return this.mPosition;
    }

    @Override
    public InputStream inputStream() throws IOException {
        return this.mSocket.getInputStream();
    }

    @Override
    public void close() throws IOException {
        this.mSocket.close();
    }

    public String toString() {
        return "SnapshotReceiver{sender=" + this.senderAddress() + ", length=" + this.length() + ", prevTerm=" + this.prevTerm() + ", term=" + this.term() + ", position=" + this.position() + "}";
    }
}

