/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Map;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.repl.GroupFile;
import org.cojen.tupl.repl.OptionsDecoder;
import org.cojen.tupl.repl.OptionsEncoder;
import org.cojen.tupl.repl.SnapshotSender;
import org.cojen.tupl.repl.TermLog;

abstract class SocketSnapshotSender
extends OutputStream
implements SnapshotSender {
    private final GroupFile mGroupFile;
    private final Socket mSocket;
    private final OutputStream mOut;
    private final Map<String, String> mOptions;
    private static final VarHandle cSendingHandle;
    private volatile int mSending;

    SocketSnapshotSender(GroupFile groupFile, Socket socket) throws IOException {
        OptionsDecoder dec;
        try {
            dec = new OptionsDecoder(socket.getInputStream());
        }
        catch (EOFException e) {
            Utils.closeQuietly(socket);
            throw new IOException("Disconnected");
        }
        int encoding = dec.decodeIntLE();
        if (encoding != 0) {
            Utils.closeQuietly(socket);
            throw new IOException("Unknown encoding: " + encoding);
        }
        this.mGroupFile = groupFile;
        this.mSocket = socket;
        this.mOut = socket.getOutputStream();
        this.mOptions = dec.decodeMap();
    }

    @Override
    public final SocketAddress receiverAddress() {
        return this.mSocket.getRemoteSocketAddress();
    }

    @Override
    public final Map<String, String> options() {
        return this.mOptions;
    }

    @Override
    public final OutputStream begin(long length, long position, Map<String, String> options) throws IOException {
        if (!cSendingHandle.compareAndSet(this, 0, 1)) {
            throw new IllegalStateException("Already began");
        }
        try {
            TermLog termLog = this.termLogAt(position);
            if (termLog == null) {
                throw new IllegalStateException("Unknown term at position: " + position);
            }
            OptionsEncoder enc = new OptionsEncoder();
            enc.encodeIntLE(0);
            enc.encodeLongLE(length);
            enc.encodeLongLE(termLog.prevTermAt(position));
            enc.encodeLongLE(termLog.term());
            enc.encodeLongLE(position);
            enc.encodeMap(options == null ? Collections.emptyMap() : options);
            enc.writeTo(this);
            this.mGroupFile.writeTo(this);
            return this;
        }
        catch (Throwable e) {
            Utils.closeQuietly(this);
            throw e;
        }
    }

    @Override
    public final void write(int b) throws IOException {
        this.mOut.write(b);
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this.mOut.write(b, off, len);
    }

    @Override
    public final void flush() throws IOException {
        this.mOut.flush();
    }

    @Override
    public void close() throws IOException {
        this.mSocket.close();
    }

    abstract TermLog termLogAt(long var1) throws IOException;

    static {
        try {
            cSendingHandle = MethodHandles.lookup().findVarHandle(SocketSnapshotSender.class, "mSending", Integer.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }
}

