/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.repl.ChannelManager;
import org.cojen.tupl.repl.Controller;
import org.cojen.tupl.repl.FileStateLog;
import org.cojen.tupl.repl.Replicator;
import org.cojen.tupl.repl.ReplicatorConfig;

public interface StreamReplicator
extends Replicator {
    public static StreamReplicator open(ReplicatorConfig config) throws IOException {
        if (config == null) {
            throw new IllegalArgumentException("No configuration");
        }
        File base = config.mBaseFile;
        if (base == null) {
            throw new IllegalArgumentException("No base file configured");
        }
        if (base.isDirectory()) {
            throw new IllegalArgumentException("Base file is a directory: " + base);
        }
        long groupToken1 = config.mGroupToken1;
        long groupToken2 = config.mGroupToken2;
        if (groupToken1 == 0L && groupToken2 == 0L) {
            throw new IllegalArgumentException("No group token configured");
        }
        SocketAddress localAddress = config.mLocalAddress;
        if (localAddress == null) {
            throw new IllegalArgumentException("No local address configured");
        }
        SocketAddress listenAddress = config.mListenAddress;
        ServerSocket localSocket = config.mLocalSocket;
        if (listenAddress == null && (listenAddress = localAddress) instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)listenAddress;
            listenAddress = new InetSocketAddress(isa.getPort());
        }
        if (localSocket == null) {
            localSocket = ChannelManager.newServerSocket(config.mServerSocketFactory, listenAddress);
        }
        FileStateLog log = null;
        try {
            Set<SocketAddress> seeds = config.mSeeds;
            if (seeds == null) {
                seeds = Collections.emptySet();
            }
            if (config.mMkdirs) {
                base.getParentFile().mkdirs();
            }
            log = FileStateLog.open(base);
            return Controller.open(config.mEventListener, log, groupToken1, groupToken2, new File(base.getPath() + ".group"), config.mSocketFactory, localAddress, listenAddress, config.mLocalRole, seeds, localSocket, config.mProxyWrites, config.mChecksumSockets);
        }
        catch (Throwable e) {
            Utils.closeQuietly(localSocket);
            Utils.closeQuietly(log);
            throw e;
        }
    }

    @Override
    public Reader newReader(long var1, boolean var3);

    @Override
    public Writer newWriter();

    @Override
    public Writer newWriter(long var1);

    public void controlMessageReceived(long var1, byte[] var3) throws IOException;

    public void controlMessageAcceptor(Consumer<byte[]> var1);

    public static interface Writer
    extends Replicator.Writer {
        default public int write(byte[] messages) throws IOException {
            return this.write(messages, 0, messages.length);
        }

        default public int write(byte[] messages, int offset, int length) throws IOException {
            return this.write(null, messages, offset, length, this.position() + (long)length);
        }

        default public int write(byte[] messages, int offset, int length, long highestPosition) throws IOException {
            return this.write(null, messages, offset, length, highestPosition);
        }

        public int write(byte[] var1, byte[] var2, int var3, int var4, long var5) throws IOException;
    }

    public static interface Reader
    extends Replicator.Reader {
        default public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        public int read(byte[] var1, int var2, int var3) throws IOException;

        default public void readFully(byte[] buf, int offset, int length) throws IOException {
            while (true) {
                int amt;
                if ((amt = this.read(buf, offset, length)) <= 0) {
                    throw new EOFException();
                }
                if ((length -= amt) <= 0) break;
                offset += amt;
            }
        }

        public int tryRead(byte[] var1, int var2, int var3) throws IOException;
    }
}

