/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.util.Arrays;
import java.util.Objects;

public abstract class ArrayKey {
    public static Bytes make(byte[] array) {
        return new Bytes(array);
    }

    public static PrefixBytes make(int prefix, byte[] array) {
        return new PrefixBytes(prefix, array);
    }

    public static ObjPrefixBytes make(Object prefix, byte[] array) {
        return new ObjPrefixBytes(prefix, array);
    }

    public static Obj make(Object first, Object[] rest) {
        Object[] array = new Object[1 + rest.length];
        array[0] = first;
        System.arraycopy(rest, 0, array, 1, rest.length);
        return new Obj(array);
    }

    public static final class Bytes {
        final byte[] array;

        Bytes(byte[] array) {
            this.array = array;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof Bytes)) return false;
            Bytes other = (Bytes)obj;
            if (!Arrays.equals(this.array, other.array)) return false;
            return true;
        }

        public String toString() {
            return Arrays.toString(this.array);
        }
    }

    public static final class PrefixBytes {
        final int prefix;
        final byte[] array;

        PrefixBytes(int prefix, byte[] array) {
            this.prefix = prefix;
            this.array = array;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array) * 31 + this.prefix;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof PrefixBytes)) return false;
            PrefixBytes other = (PrefixBytes)obj;
            if (this.prefix != other.prefix) return false;
            if (!Arrays.equals(this.array, other.array)) return false;
            return true;
        }

        public String toString() {
            return this.prefix + ", " + Arrays.toString(this.array);
        }
    }

    public static final class ObjPrefixBytes {
        final Object prefix;
        final byte[] array;

        ObjPrefixBytes(Object prefix, byte[] array) {
            this.prefix = prefix;
            this.array = array;
        }

        public int hashCode() {
            return Objects.hashCode(this.prefix) * 31 + Arrays.hashCode(this.array);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof ObjPrefixBytes)) return false;
            ObjPrefixBytes other = (ObjPrefixBytes)obj;
            if (!Objects.equals(this.prefix, other.prefix)) return false;
            if (!Arrays.equals(this.array, other.array)) return false;
            return true;
        }

        public String toString() {
            return this.prefix + ", " + Arrays.toString(this.array);
        }
    }

    public static final class Obj {
        final Object[] array;

        Obj(Object[] array) {
            this.array = array;
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.array);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof Obj)) return false;
            Obj other = (Obj)obj;
            if (!Arrays.deepEquals(this.array, other.array)) return false;
            return true;
        }

        public String toString() {
            return Arrays.deepToString(this.array);
        }
    }
}

