/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.tupl.Scanner;
import org.cojen.tupl.Table;

abstract class ArrayScanner<R>
implements Scanner<R> {
    private static final Object[] EMPTY = new Object[1];
    private final Table<R> mTable;
    private R[] mRows;
    private int mPosition;

    ArrayScanner() {
        this.mTable = null;
        this.close();
    }

    ArrayScanner(Table<R> table, R[] rows) {
        this.mTable = table;
        this.mRows = rows;
    }

    @Override
    public final R row() {
        return this.mRows[this.mPosition];
    }

    @Override
    public final R step() {
        R[] rows = this.mRows;
        int pos = this.mPosition;
        rows[pos++] = null;
        if (pos < rows.length) {
            this.mPosition = pos;
            return rows[pos];
        }
        this.close();
        return null;
    }

    @Override
    public final R step(R dst) {
        R[] rows = this.mRows;
        int pos = this.mPosition;
        rows[pos++] = null;
        if (pos < rows.length) {
            this.mTable.copyRow(rows[pos], dst);
            rows[pos] = dst;
            this.mPosition = pos;
            return dst;
        }
        this.close();
        return null;
    }

    @Override
    public final void close() {
        this.mRows = EMPTY;
        this.mPosition = 0;
    }

    @Override
    public final long estimateSize() {
        return this.mRows.length - this.mPosition;
    }

    @Override
    public final int characteristics() {
        return 1364;
    }
}

