/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;

class ArrayStringMaker {
    private static HashMap<Class<?>, MethodHandle> cSignedCache;
    private static HashMap<Class<?>, MethodHandle> cUnsignedCache;

    ArrayStringMaker() {
    }

    static synchronized MethodHandle make(Class<?> arrayType, boolean unsigned) {
        MethodHandle mh;
        HashMap<Class<Object>, MethodHandle> cache;
        Class<?> elementType = ((Class)arrayType).getComponentType();
        if (!unsigned && !ArrayStringMaker.isPrimitiveElement(elementType)) {
            int dims = 1;
            while ((elementType = elementType.getComponentType()) != null) {
                ++dims;
            }
            arrayType = Object[].class;
            while (--dims > 0) {
                arrayType = ((Class)arrayType).arrayType();
            }
        }
        if (unsigned) {
            cache = cUnsignedCache;
            if (cache == null) {
                cache = new HashMap();
                cUnsignedCache = cache;
            }
        } else {
            cache = cSignedCache;
            if (cache == null) {
                cache = new HashMap();
                cSignedCache = cache;
            }
        }
        if ((mh = cache.get(arrayType)) == null) {
            mh = ArrayStringMaker.doMake(arrayType, unsigned);
            cache.put((Class<?>)arrayType, mh);
        }
        return mh;
    }

    private static boolean isPrimitiveElement(Class<?> elementType) {
        do {
            if (!elementType.isPrimitive()) continue;
            return true;
        } while ((elementType = elementType.getComponentType()) != null);
        return false;
    }

    private static MethodHandle doMake(Class<?> arrayType, boolean unsigned) {
        MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)MethodHandles.lookup(), StringBuilder.class, (String)"append", (Object[])new Object[]{StringBuilder.class, arrayType, Integer.TYPE});
        Variable builderVar = mm.param(0);
        Variable arrayVar = mm.param(1);
        Variable limitVar = mm.param(2);
        Label notNull = mm.label();
        arrayVar.ifNe(null, notNull);
        Label builderNotNull = mm.label();
        builderVar.ifNe(null, builderNotNull);
        builderVar.set((Object)mm.new_(StringBuilder.class, new Object[]{4}));
        builderNotNull.here();
        builderVar.invoke("append", new Object[]{"null"});
        mm.return_((Object)builderVar);
        notNull.here();
        Label builderNotNull2 = mm.label();
        builderVar.ifNe(null, builderNotNull2);
        Variable mathVar = mm.var(Math.class);
        Variable capacityVar = mathVar.invoke("min", new Object[]{limitVar, arrayVar.alength()});
        capacityVar.set((Object)mathVar.invoke("max", new Object[]{16, capacityVar}));
        builderVar.set((Object)mm.new_(StringBuilder.class, new Object[]{capacityVar}));
        builderNotNull2.here();
        builderVar.invoke("append", new Object[]{Character.valueOf('[')});
        Variable ixVar = mm.var(Integer.TYPE).set((Object)0);
        Label start = mm.label().here();
        Label end = mm.label();
        ixVar.ifGe((Object)arrayVar.alength(), end);
        Label cont = null;
        Label first = mm.label();
        ixVar.ifEq((Object)0, first);
        builderVar.invoke("append", new Object[]{", "});
        first.here();
        Label notLimit = mm.label();
        ixVar.ifLt((Object)limitVar, notLimit);
        builderVar.invoke("append", new Object[]{"..."});
        mm.goto_(end);
        notLimit.here();
        Variable elementVar = arrayVar.aget((Object)ixVar);
        Class elementType = elementVar.classType();
        if (elementType.isArray()) {
            mm.invoke(ArrayStringMaker.make(elementType, unsigned), new Object[]{builderVar, elementVar, limitVar});
        } else if (!unsigned) {
            builderVar.invoke("append", new Object[]{elementVar});
        } else {
            if (!elementType.isPrimitive()) {
                Label elementNotNull = mm.label();
                elementVar.ifNe(null, elementNotNull);
                builderVar.invoke("append", new Object[]{"null"});
                cont = mm.label().goto_();
                elementNotNull.here();
                try {
                    elementVar = elementVar.unbox();
                    elementType = elementVar.classType();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            if (elementType == Byte.TYPE) {
                builderVar.invoke("append", new Object[]{elementVar.cast(Integer.TYPE).and((Object)255)});
            } else if (elementType == Short.TYPE) {
                builderVar.invoke("append", new Object[]{elementVar.cast(Integer.TYPE).and((Object)65535)});
            } else if (elementType == Integer.TYPE) {
                builderVar.invoke("append", new Object[]{elementVar.cast(Long.TYPE).and((Object)0xFFFFFFFFL)});
            } else if (elementType == Long.TYPE) {
                Variable elementStrVar = mm.var(Long.class).invoke("toUnsignedString", new Object[]{elementVar});
                builderVar.invoke("append", new Object[]{elementStrVar});
            } else {
                builderVar.invoke("append", new Object[]{elementVar});
            }
        }
        if (cont != null) {
            cont.here();
        }
        ixVar.inc((Object)1);
        mm.goto_(start);
        end.here();
        builderVar.invoke("append", new Object[]{Character.valueOf(']')});
        mm.return_((Object)builderVar);
        return mm.finish();
    }
}

