/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.BasicUpdater;
import org.cojen.tupl.rows.ScanController;
import org.cojen.tupl.rows.Trigger;

final class AutoCommitUpdater<R>
extends BasicUpdater<R> {
    LockResult mLockResult;

    AutoCommitUpdater(BaseTable<R> table, ScanController<R> controller) {
        super(table, controller);
    }

    @Override
    protected LockResult toFirst(Cursor c) throws IOException {
        LockResult result = c.first();
        c.register();
        this.mLockResult = result;
        return this.mLockResult;
    }

    @Override
    protected LockResult toNext(Cursor c) throws IOException {
        LockResult result = this.mLockResult;
        if (result != null && result.isAcquired()) {
            c.link().unlock();
        }
        this.mLockResult = c.next();
        return this.mLockResult;
    }

    @Override
    protected void unlocked() {
        this.mLockResult = null;
    }

    @Override
    protected void finished() throws IOException {
        this.mRow = null;
        if (this.mLockResult != null) {
            this.mLockResult = null;
            this.mCursor.link().exit();
        }
    }

    @Override
    protected void storeValue(Cursor c, byte[] value) throws IOException {
        c.commit(value);
        this.mLockResult = null;
    }

    @Override
    protected void storeValue(Trigger<R> trigger, R row, Cursor c, byte[] value) throws IOException {
        Transaction txn = c.link();
        byte[] oldValue = c.value();
        if (oldValue == null) {
            trigger.insertP(txn, row, c.key(), value);
        } else {
            trigger.storeP(txn, row, c.key(), oldValue, value);
        }
        c.commit(value);
        this.mLockResult = null;
    }

    @Override
    protected void postStoreKeyValue(Transaction txn) throws IOException {
        txn.commit();
        this.mLockResult = null;
    }

    @Override
    protected void doDelete() throws IOException {
        this.mCursor.commit(null);
    }

    @Override
    protected void doDelete(Trigger<R> trigger, R row) throws IOException {
        Cursor c = this.mCursor;
        byte[] oldValue = c.value();
        if (oldValue != null) {
            trigger.delete(c.link(), c.key(), oldValue);
            c.commit(null);
        }
    }
}

