/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.concurrent.TimeUnit;
import java.util.random.RandomGenerator;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.core.RowPredicateLock;
import org.cojen.tupl.rows.CommonCleaner;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.util.LocalPool;

public abstract class AutomaticKeyGenerator<R> {
    private final Index mIndex;
    private final LocalPool<SoftReference<KeyState>> mStatePool;

    AutomaticKeyGenerator(Index index) {
        this.mIndex = index;
        this.mStatePool = new LocalPool(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] store(Transaction txn, R row, byte[] key, byte[] value) throws IOException {
        LocalPool.Entry<SoftReference<KeyState>> entry = this.mStatePool.access();
        try {
            Cursor c;
            KeyState state;
            SoftReference<KeyState> stateRef = entry.get();
            if (stateRef != null && (state = stateRef.get()) != null) {
                c = state.mCursor;
            } else {
                c = this.mIndex.newCursor(Transaction.BOGUS);
                c.autoload(false);
                RandomGenerator rnd = RandomGenerator.of("L64X128MixRandom");
                this.randomPosition(key, rnd, c);
                state = AutomaticKeyGenerator.register(c, rnd);
                entry.replace(new SoftReference<KeyState>(state));
            }
            try {
                long endNanos = 0L;
                byte[] srcKey = c.key();
                while (true) {
                    RowPredicateLock.Closer closer;
                    if ((closer = this.incrementKey(txn, row, srcKey, key, value)) != null) {
                        LockResult result;
                        try {
                            result = this.mIndex.tryLockUpgradable(txn, key, 0L);
                        }
                        catch (Throwable e) {
                            if (!(closer instanceof RowPredicateLock.NonCloser)) {
                                txn.unlock();
                                closer.close();
                            }
                            throw e;
                        }
                        if (result != LockResult.ACQUIRED) {
                            if (!(closer instanceof RowPredicateLock.NonCloser)) {
                                txn.unlock();
                                closer.close();
                            }
                        } else {
                            if (!(closer instanceof RowPredicateLock.NonCloser)) {
                                txn.unlockCombine();
                            }
                            try {
                                c.findNearby(key);
                            }
                            catch (Throwable e) {
                                txn.unlock();
                                closer.close();
                                throw e;
                            }
                            if (c.value() == null) {
                                c.link(txn);
                                try {
                                    c.store(value);
                                }
                                finally {
                                    closer.close();
                                    c.link(Transaction.BOGUS);
                                }
                                byte[] byArray = key;
                                return byArray;
                            }
                            txn.unlock();
                            closer.close();
                            key = (byte[])key.clone();
                        }
                    }
                    srcKey = key;
                    if (endNanos == 0L) {
                        long nanosTimeout = txn.lockTimeout(TimeUnit.NANOSECONDS);
                        if (nanosTimeout >= 0L) {
                            if (nanosTimeout == 0L) {
                                throw AutomaticKeyGenerator.failed(txn);
                            }
                            endNanos = System.nanoTime() + nanosTimeout;
                            if (endNanos == 0L) {
                                ++endNanos;
                            }
                        }
                    } else {
                        if (endNanos - System.nanoTime() <= 0L) {
                            throw AutomaticKeyGenerator.failed(txn);
                        }
                        Thread.yield();
                    }
                    this.randomPosition(key, state.mRandom, c);
                }
            }
            finally {
                Reference.reachabilityFence(state);
            }
        }
        finally {
            entry.release();
        }
    }

    public abstract void writeTail(byte[] var1, DataOutput var2) throws IOException;

    public void clear() {
        this.mStatePool.clear(ref -> {
            KeyState state = (KeyState)ref.get();
            if (state != null) {
                ref.clear();
                state.mCursor.reset();
            }
        });
    }

    protected abstract void randomKey(byte[] var1, RandomGenerator var2);

    protected abstract RowPredicateLock.Closer incrementKey(Transaction var1, R var2, byte[] var3, byte[] var4, byte[] var5) throws IOException;

    private void randomPosition(byte[] key, RandomGenerator rnd, Cursor c) throws IOException {
        this.randomKey(key, rnd);
        c.find(key);
        c.register();
    }

    private static LockFailureException failed(Transaction txn) {
        String message;
        long nanosTimeout = txn.lockTimeout(TimeUnit.NANOSECONDS);
        if (nanosTimeout == 0L) {
            message = "Unable to immediately generate a unique identifier";
        } else {
            TimeUnit unit = RowUtils.inferUnit(TimeUnit.NANOSECONDS, nanosTimeout);
            long timeout = unit.convert(nanosTimeout, TimeUnit.NANOSECONDS);
            StringBuilder b = new StringBuilder("Unable to generate a unique identifier within ");
            RowUtils.appendTimeout(b, timeout, unit);
            message = b.toString();
        }
        return new LockFailureException(message);
    }

    private static KeyState register(Cursor c, RandomGenerator rnd) {
        try {
            Cleaner cleaner = CommonCleaner.access();
            KeyState state = new KeyState(c, rnd);
            cleaner.register(state, c::reset);
            return state;
        }
        catch (Throwable e) {
            c.reset();
            throw e;
        }
    }

    private static class KeyState {
        final Cursor mCursor;
        final RandomGenerator mRandom;

        KeyState(Cursor c, RandomGenerator rnd) {
            this.mCursor = c;
            this.mRandom = rnd;
        }
    }

    public static class OfULong<R>
    extends OfLong<R> {
        public OfULong(Index index, long min, long max, OfLong.Applier<R> applier) {
            super(index, min, max, applier);
        }

        @Override
        protected long decode(byte[] key) {
            return RowUtils.decodeLongBE(key, key.length - 8);
        }

        @Override
        protected void encode(byte[] key, long colValue) {
            RowUtils.encodeLongBE(key, key.length - 8, colValue);
        }
    }

    public static class OfLong<R>
    extends AutomaticKeyGenerator<R> {
        private final long mMin;
        private final long mMax;
        private final Applier<R> mApplier;

        public OfLong(Index index, long min, long max, Applier<R> applier) {
            super(index);
            this.mMin = min;
            this.mMax = max;
            this.mApplier = applier;
        }

        @Override
        public void writeTail(byte[] key, DataOutput out) throws IOException {
            out.writeLong(this.decode(key));
        }

        @Override
        protected void randomKey(byte[] key, RandomGenerator rnd) {
            long colValue;
            while ((colValue = this.mMax != Long.MAX_VALUE ? rnd.nextLong(this.mMin, this.mMax + 1L) : (this.mMin != Long.MIN_VALUE ? rnd.nextLong(this.mMin - 1L, this.mMax) + 1L : rnd.nextLong())) == 0L) {
            }
            this.encode(key, colValue);
        }

        @Override
        protected RowPredicateLock.Closer incrementKey(Transaction txn, R row, byte[] srcKey, byte[] dstKey, byte[] value) throws IOException {
            long colValue = this.decode(srcKey) + 1L;
            if (colValue == 0L) {
                colValue = 1L;
            }
            if (colValue == Long.MIN_VALUE || colValue > this.mMax) {
                colValue = this.mMin;
            }
            this.encode(dstKey, colValue);
            Applier<R> applier = this.mApplier;
            if (applier == null) {
                return RowPredicateLock.NonCloser.THE;
            }
            if (row != null) {
                return applier.applyToRow(txn, row, colValue);
            }
            return applier.tryOpenAcquire(txn, dstKey, value);
        }

        protected long decode(byte[] key) {
            return RowUtils.decodeLongBE(key, key.length - 8) ^ Long.MIN_VALUE;
        }

        protected void encode(byte[] key, long colValue) {
            RowUtils.encodeLongBE(key, key.length - 8, colValue ^ Long.MIN_VALUE);
        }

        public static interface Applier<R> {
            public RowPredicateLock.Closer applyToRow(Transaction var1, R var2, long var3) throws IOException;

            public RowPredicateLock.Closer tryOpenAcquire(Transaction var1, byte[] var2, byte[] var3) throws IOException;
        }
    }

    public static class OfUInt<R>
    extends OfInt<R> {
        public OfUInt(Index index, int min, int max, OfInt.Applier<R> applier) {
            super(index, min, max, applier);
        }

        @Override
        protected int decode(byte[] key) {
            return RowUtils.decodeIntBE(key, key.length - 4);
        }

        @Override
        protected void encode(byte[] key, int colValue) {
            RowUtils.encodeIntBE(key, key.length - 4, colValue);
        }
    }

    public static class OfInt<R>
    extends AutomaticKeyGenerator<R> {
        private final int mMin;
        private final int mMax;
        private final Applier<R> mApplier;

        public OfInt(Index index, int min, int max, Applier<R> applier) {
            super(index);
            this.mMin = min;
            this.mMax = max;
            this.mApplier = applier;
        }

        @Override
        public void writeTail(byte[] key, DataOutput out) throws IOException {
            out.writeInt(this.decode(key));
        }

        @Override
        protected void randomKey(byte[] key, RandomGenerator rnd) {
            int colValue;
            while ((colValue = this.mMax != Integer.MAX_VALUE ? rnd.nextInt(this.mMin, this.mMax + 1) : (this.mMin != Integer.MIN_VALUE ? rnd.nextInt(this.mMin - 1, this.mMax) + 1 : rnd.nextInt())) == 0) {
            }
            this.encode(key, colValue);
        }

        @Override
        protected RowPredicateLock.Closer incrementKey(Transaction txn, R row, byte[] srcKey, byte[] dstKey, byte[] value) throws IOException {
            int colValue = this.decode(srcKey) + 1;
            if (colValue == 0) {
                colValue = 1;
            }
            if (colValue == Integer.MIN_VALUE || colValue > this.mMax) {
                colValue = this.mMin;
            }
            this.encode(dstKey, colValue);
            Applier<R> applier = this.mApplier;
            if (applier == null) {
                return RowPredicateLock.NonCloser.THE;
            }
            if (row != null) {
                return applier.applyToRow(txn, row, colValue);
            }
            return applier.tryOpenAcquire(txn, dstKey, value);
        }

        protected int decode(byte[] key) {
            return RowUtils.decodeIntBE(key, key.length - 4) ^ Integer.MIN_VALUE;
        }

        protected void encode(byte[] key, int colValue) {
            RowUtils.encodeIntBE(key, key.length - 4, colValue ^ Integer.MIN_VALUE);
        }

        public static interface Applier<R> {
            public RowPredicateLock.Closer applyToRow(Transaction var1, R var2, int var3) throws IOException;

            public RowPredicateLock.Closer tryOpenAcquire(Transaction var1, byte[] var2, byte[] var3) throws IOException;
        }
    }
}

