/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.DataOutput;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import org.cojen.tupl.ClosedIndexException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Entry;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.Table;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Updater;
import org.cojen.tupl.core.RowPredicate;
import org.cojen.tupl.core.RowPredicateLock;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.diag.QueryPlan;
import org.cojen.tupl.filter.ComplexFilterException;
import org.cojen.tupl.filter.FalseFilter;
import org.cojen.tupl.filter.Parser;
import org.cojen.tupl.filter.Query;
import org.cojen.tupl.filter.RowFilter;
import org.cojen.tupl.filter.TrueFilter;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.remote.RemoteTableProxy;
import org.cojen.tupl.rows.ArrayKey;
import org.cojen.tupl.rows.AutoCommitUpdater;
import org.cojen.tupl.rows.AutoUnlockScanner;
import org.cojen.tupl.rows.AutomaticKeyGenerator;
import org.cojen.tupl.rows.BaseTableIndex;
import org.cojen.tupl.rows.BasicScanner;
import org.cojen.tupl.rows.BasicUpdater;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.ComparatorMaker;
import org.cojen.tupl.rows.DisjointUnionQueryLauncher;
import org.cojen.tupl.rows.EmptyScanController;
import org.cojen.tupl.rows.FilteredScanMaker;
import org.cojen.tupl.rows.IndexSelector;
import org.cojen.tupl.rows.JoinedUpdater;
import org.cojen.tupl.rows.MultiCache;
import org.cojen.tupl.rows.NonRepeatableUpdater;
import org.cojen.tupl.rows.OrderBy;
import org.cojen.tupl.rows.PrimaryTable;
import org.cojen.tupl.rows.QueryLauncher;
import org.cojen.tupl.rows.RangeUnionScanControllerFactory;
import org.cojen.tupl.rows.RemoteProxyMaker;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowPredicateMaker;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.RowWriter;
import org.cojen.tupl.rows.ScanController;
import org.cojen.tupl.rows.ScanControllerFactory;
import org.cojen.tupl.rows.ScanQueryLauncher;
import org.cojen.tupl.rows.SingleScanController;
import org.cojen.tupl.rows.SortedQueryLauncher;
import org.cojen.tupl.rows.TableManager;
import org.cojen.tupl.rows.Trigger;
import org.cojen.tupl.rows.TxnResetScanner;
import org.cojen.tupl.rows.UpgradableUpdater;
import org.cojen.tupl.rows.WeakCache;
import org.cojen.tupl.rows.WriteRowMaker;
import org.cojen.tupl.views.ViewUtils;

public abstract class BaseTable<R>
implements Table<R>,
ScanControllerFactory<R> {
    final TableManager<R> mTableManager;
    protected final Index mSource;
    private static final int PLAIN = 0;
    private static final int DOUBLE_CHECK = 1;
    private static final int FOR_UPDATE = 2;
    private static final int FOR_UPDATE_DOUBLE_CHECK = 3;
    private final MultiCache<String, ScanControllerFactory<R>, Query> mFilterFactoryCache;
    private final MultiCache<String, QueryLauncher<R>, IndexSelector> mQueryLauncherCache;
    private Trigger<R> mTrigger;
    private static final VarHandle cTriggerHandle;
    protected final RowPredicateLock<R> mIndexLock;
    private WeakCache<Object, MethodHandle, byte[]> mDecodePartialCache;
    private static final VarHandle cDecodePartialCacheHandle;
    private WeakCache<Object, MethodHandle, byte[]> mWriteRowCache;
    private static final VarHandle cWriteRowCacheHandle;

    protected BaseTable(TableManager<R> manager, Index source, RowPredicateLock<R> indexLock) {
        this.mTableManager = Objects.requireNonNull(manager);
        this.mSource = Objects.requireNonNull(source);
        this.mIndexLock = Objects.requireNonNull(indexLock);
        int[] typeMap = new int[]{0, 1};
        if (this.joinedPrimaryTableClass() == null) {
            typeMap[1] = 0;
        }
        this.mFilterFactoryCache = MultiCache.newSoftCache(typeMap, this::newFilteredFactory);
        if (this.supportsSecondaries()) {
            typeMap = new int[]{0, 1, 2, 3};
            if (this.joinedPrimaryTableClass() == null) {
                typeMap[1] = 0;
                typeMap[3] = 2;
            }
            this.mQueryLauncherCache = MultiCache.newSoftCache(typeMap, (type, queryStr, selector) -> {
                try {
                    return this.newQueryLauncher(type, (String)queryStr, (IndexSelector)selector);
                }
                catch (IOException e) {
                    throw RowUtils.rethrow(e);
                }
            });
            Trigger trigger = new Trigger();
            trigger.mMode = 1;
            cTriggerHandle.setRelease(this, trigger);
        } else {
            this.mQueryLauncherCache = null;
        }
    }

    public final TableManager<R> tableManager() {
        return this.mTableManager;
    }

    @Override
    public final Scanner<R> newScanner(Transaction txn) throws IOException {
        return this.newScanner(txn, null);
    }

    final Scanner<R> newScanner(Transaction txn, R row) throws IOException {
        return this.newScanner(txn, row, this.unfiltered());
    }

    @Override
    public final Scanner<R> newScanner(Transaction txn, String queryStr, Object ... args) throws IOException {
        return this.newScanner(txn, (R)null, queryStr, args);
    }

    protected Scanner<R> newScanner(Transaction txn, R row, String queryStr, Object ... args) throws IOException {
        QueryLauncher<R> launcher = this.scannerQueryLauncher(txn, queryStr);
        while (true) {
            try {
                return launcher.newScanner(txn, row, args);
            }
            catch (ClosedIndexException | LockFailureException e) {
                QueryLauncher<R> newLauncher;
                try {
                    newLauncher = this.scannerQueryLauncher(txn, queryStr);
                }
                catch (Throwable e2) {
                    e.addSuppressed(e);
                    throw e;
                }
                if (newLauncher == launcher) {
                    throw e;
                }
                launcher = newLauncher;
                continue;
            }
            break;
        }
    }

    final Scanner<R> newScanner(Transaction txn, R row, ScanController<R> controller) throws IOException {
        BasicScanner<R> scanner;
        RowPredicateLock.Closer closer;
        block8: {
            block7: {
                block6: {
                    closer = null;
                    if (txn != null) break block6;
                    if (this.joinedPrimaryTableClass() == null) break block7;
                    txn = this.mSource.newTransaction(null);
                    closer = this.mIndexLock.addGuard(txn);
                    if (controller.isJoined()) {
                        txn.lockMode(LockMode.REPEATABLE_READ);
                        scanner = new AutoUnlockScanner<R>(this, controller);
                    } else {
                        txn.lockMode(LockMode.READ_COMMITTED);
                        scanner = new TxnResetScanner<R>(this, controller);
                    }
                    break block8;
                }
                if (!txn.lockMode().noReadLock) {
                    closer = this.mIndexLock.addPredicate(txn, controller.predicate());
                }
            }
            scanner = new BasicScanner<R>(this, controller);
        }
        try {
            scanner.init(txn, row);
            return scanner;
        }
        catch (Throwable e) {
            if (closer != null) {
                closer.close();
            }
            throw e;
        }
    }

    final Scanner<R> newScannerThisTable(Transaction txn, R row, String queryStr, Object ... args) throws IOException {
        return this.newScanner(txn, row, this.scannerFilteredFactory(txn, queryStr).scanController(args));
    }

    private ScanControllerFactory<R> scannerFilteredFactory(Transaction txn, String queryStr) {
        int type = RowUtils.isUnlocked(txn) ? 1 : 0;
        return this.mFilterFactoryCache.obtain(type, queryStr, null);
    }

    private QueryLauncher<R> scannerQueryLauncher(Transaction txn, String queryStr) throws IOException {
        int type = RowUtils.isUnlocked(txn) ? 1 : 0;
        return this.mQueryLauncherCache.obtain(type, queryStr, null);
    }

    @Override
    public final Updater<R> newUpdater(Transaction txn) throws IOException {
        return this.newUpdater(txn, null);
    }

    final Updater<R> newUpdater(Transaction txn, R row) throws IOException {
        return this.newUpdater(txn, row, this.unfiltered());
    }

    @Override
    public final Updater<R> newUpdater(Transaction txn, String queryStr, Object ... args) throws IOException {
        return this.newUpdater(txn, (R)null, queryStr, args);
    }

    protected Updater<R> newUpdater(Transaction txn, R row, String queryStr, Object ... args) throws IOException {
        QueryLauncher<R> launcher = this.updaterQueryLauncher(txn, queryStr);
        while (true) {
            try {
                return launcher.newUpdater(txn, row, args);
            }
            catch (ClosedIndexException | LockFailureException e) {
                QueryLauncher<R> newLauncher;
                try {
                    newLauncher = this.updaterQueryLauncher(txn, queryStr);
                }
                catch (Throwable e2) {
                    e.addSuppressed(e);
                    throw e;
                }
                if (newLauncher == launcher) {
                    throw e;
                }
                launcher = newLauncher;
                continue;
            }
            break;
        }
    }

    protected Updater<R> newUpdater(Transaction txn, R row, ScanController<R> controller) throws IOException {
        return this.newUpdater(txn, row, controller, null);
    }

    final Updater<R> newUpdater(Transaction txn, R row, ScanController<R> controller, BaseTableIndex<R> secondary) throws IOException {
        BasicUpdater updater;
        RowPredicateLock.Closer closer;
        block12: {
            block11: {
                closer = null;
                if (txn != null) break block11;
                txn = this.mSource.newTransaction(null);
                updater = new AutoCommitUpdater<R>(this, controller);
                if (secondary != null) {
                    secondary.mIndexLock.addGuard(txn);
                }
                break block12;
            }
            switch (txn.lockMode()) {
                default: {
                    updater = new BasicUpdater<R>(this, controller);
                    break;
                }
                case REPEATABLE_READ: {
                    updater = new UpgradableUpdater<R>(this, controller);
                    break;
                }
                case READ_COMMITTED: {
                    updater = new NonRepeatableUpdater<R>(this, controller);
                    break;
                }
                case READ_UNCOMMITTED: {
                    updater = new NonRepeatableUpdater<R>(this, controller);
                    break block12;
                }
                case UNSAFE: {
                    updater = new BasicUpdater<R>(this, controller);
                    break block12;
                }
            }
            RowPredicateLock lock = secondary == null ? this.mIndexLock : secondary.mIndexLock;
            closer = lock.addPredicate(txn, controller.predicate());
        }
        try {
            if (secondary == null) {
                updater.init(txn, row);
                return updater;
            }
            JoinedUpdater<R> joined = new JoinedUpdater<R>(secondary, controller, updater);
            joined.init(txn, row);
            return joined;
        }
        catch (Throwable e) {
            if (closer != null) {
                closer.close();
            }
            throw e;
        }
    }

    final Updater<R> newUpdaterThisTable(Transaction txn, R row, String queryStr, Object ... args) throws IOException {
        return this.newUpdater(txn, row, this.updaterFilteredFactory(txn, queryStr).scanController(args));
    }

    private ScanControllerFactory<R> updaterFilteredFactory(Transaction txn, String queryStr) {
        int type = RowUtils.isUnsafe(txn) ? 1 : 0;
        return this.mFilterFactoryCache.obtain(type, queryStr, null);
    }

    private QueryLauncher<R> updaterQueryLauncher(Transaction txn, String queryStr) {
        int type = RowUtils.isUnsafe(txn) ? 3 : 2;
        return this.mQueryLauncherCache.obtain(type, queryStr, null);
    }

    public final String toString() {
        StringBuilder b = new StringBuilder();
        RowUtils.appendMiniString(b, this);
        b.append('{');
        b.append("rowType").append(": ").append(this.rowType().getName());
        b.append(", ").append("primaryIndex").append(": ").append(this.mSource);
        return b.append('}').toString();
    }

    public final void scanWrite(Transaction txn, DataOutput out) throws IOException {
        RowWriter writer = new RowWriter(out);
        Scanner scanner = this.newScanner(txn, writer);
        try {
            while (scanner.step(writer) != null) {
            }
        }
        catch (Throwable e) {
            Utils.closeQuietly(scanner);
            Utils.rethrow(e);
        }
        out.writeByte(0);
    }

    public final void scanWrite(Transaction txn, DataOutput out, String queryStr, Object ... args) throws IOException {
        RowWriter writer = new RowWriter(out);
        this.scannerQueryLauncher(txn, queryStr).scanWrite(txn, writer, args);
        out.writeByte(0);
    }

    @Override
    public final Transaction newTransaction(DurabilityMode durabilityMode) {
        return this.mSource.newTransaction(durabilityMode);
    }

    @Override
    public final boolean isEmpty() throws IOException {
        return this.mSource.isEmpty();
    }

    @Override
    public final Comparator<R> comparator(String spec) {
        return ComparatorMaker.comparator(this.rowType(), spec);
    }

    @Override
    public final RowPredicate<R> predicate(String queryStr, Object ... args) {
        if (queryStr == null) {
            return RowPredicate.all();
        }
        return this.mFilterFactoryCache.obtain(0, queryStr, null).predicate(args);
    }

    @Override
    public int characteristics() {
        return 4369;
    }

    protected Table<R> viewPrimaryKey() {
        return new PrimaryTable(this);
    }

    protected BaseTableIndex<R> viewAlternateKey(String ... columns) throws IOException {
        return this.viewIndexTable(true, columns);
    }

    protected BaseTableIndex<R> viewSecondaryIndex(String ... columns) throws IOException {
        return this.viewIndexTable(false, columns);
    }

    final BaseTableIndex<R> viewIndexTable(boolean alt, String ... columns) throws IOException {
        return this.rowStore().indexTable(this, alt, columns);
    }

    protected Table<R> viewUnjoined() {
        return this;
    }

    @Override
    public QueryPlan scannerPlan(Transaction txn, String queryStr, Object ... args) throws IOException {
        if (queryStr == null) {
            return this.plan(args);
        }
        return this.scannerQueryLauncher(txn, queryStr).plan(args);
    }

    @Override
    public QueryPlan updaterPlan(Transaction txn, String queryStr, Object ... args) throws IOException {
        if (queryStr == null) {
            return this.plan(args);
        }
        return this.updaterQueryLauncher(txn, queryStr).plan(args);
    }

    final QueryPlan scannerPlanThisTable(Transaction txn, String queryStr, Object ... args) {
        if (queryStr == null) {
            return this.plan(args);
        }
        return this.scannerFilteredFactory(txn, queryStr).plan(args);
    }

    @Override
    public void close() throws IOException {
        this.mSource.close();
    }

    @Override
    public boolean isClosed() {
        return this.mSource.isClosed();
    }

    @Override
    public final ScanControllerFactory<R> reverse() {
        return new ScanControllerFactory<R>(){

            @Override
            public QueryPlan plan(Object ... args) {
                return BaseTable.this.planReverse(args);
            }

            @Override
            public ScanControllerFactory<R> reverse() {
                return BaseTable.this;
            }

            @Override
            public RowPredicate<R> predicate(Object ... args) {
                return RowPredicate.all();
            }

            @Override
            public int characteristics() {
                return BaseTable.this.characteristics();
            }

            @Override
            public ScanController<R> scanController(Object ... args) {
                return BaseTable.this.unfilteredReverse();
            }

            @Override
            public ScanController<R> scanController(RowPredicate<R> predicate) {
                return BaseTable.this.unfilteredReverse();
            }
        };
    }

    @Override
    public final RowPredicate<R> predicate(Object ... args) {
        return RowPredicate.all();
    }

    @Override
    public final ScanController<R> scanController(Object ... args) {
        return this.unfiltered();
    }

    @Override
    public final ScanController<R> scanController(RowPredicate<R> predicate) {
        return this.unfiltered();
    }

    private ScanControllerFactory<R> newFilteredFactory(int type, String queryStr, Query query) {
        RowFilter rf;
        byte[] secondaryDesc;
        NavigableMap allColumns;
        Class rowType = this.rowType();
        RowInfo rowInfo = RowInfo.find(rowType);
        NavigableMap availableColumns = allColumns = rowInfo.allColumns;
        RowGen primaryRowGen = null;
        if (this.joinedPrimaryTableClass() != null) {
            primaryRowGen = rowInfo.rowGen();
        }
        if ((secondaryDesc = this.secondaryDescriptor()) != null) {
            rowInfo = RowStore.secondaryRowInfo(rowInfo, secondaryDesc);
            if (this.joinedPrimaryTableClass() == null) {
                availableColumns = rowInfo.allColumns;
            }
        }
        if (query == null) {
            query = new Parser(allColumns, queryStr).parseQuery(availableColumns).reduce();
        }
        if ((rf = query.filter()) instanceof FalseFilter) {
            return EmptyScanController.factory();
        }
        if (rf instanceof TrueFilter && query.projection() == null) {
            return this;
        }
        String canonical = query.toString();
        if (!canonical.equals(queryStr)) {
            return this.mFilterFactoryCache.obtain(type, canonical, query);
        }
        ColumnInfo[] keyColumns = (ColumnInfo[])rowInfo.keyColumns.values().toArray(ColumnInfo[]::new);
        RowFilter[][] ranges = this.multiRangeExtract(rf, keyColumns);
        this.splitRemainders(rowInfo, ranges);
        if ((type & 1) != 0 && primaryRowGen != null) {
            BaseTable.doubleCheckRemainder(ranges, primaryRowGen.info);
        }
        Class<RowPredicate<R>> baseClass = this.mIndexLock.evaluatorClass();
        RowGen rowGen = rowInfo.rowGen();
        Class<? extends RowPredicate> predClass = new RowPredicateMaker(this.rowStoreRef(), baseClass, rowType, rowGen, primaryRowGen, this.mTableManager.mPrimaryIndex.id(), this.mSource.id(), rf, queryStr, ranges).finish();
        if (ranges.length > 1) {
            ScanControllerFactory[] rangeFactories = new ScanControllerFactory[ranges.length];
            for (int i = 0; i < ranges.length; ++i) {
                rangeFactories[i] = this.newFilteredFactory(rowGen, ranges[i], predClass, query.projection());
            }
            return new RangeUnionScanControllerFactory(rangeFactories);
        }
        RowFilter[] range = ranges[0];
        if (range[0] == null && range[1] == null) {
            range[2] = rf;
            range[3] = null;
            this.splitRemainders(rowInfo, new RowFilter[][]{range});
        }
        return this.newFilteredFactory(rowGen, range, predClass, query.projection());
    }

    private ScanControllerFactory<R> newFilteredFactory(RowGen rowGen, RowFilter[] range, Class<? extends RowPredicate> predClass, Map<String, ColumnInfo> projection) {
        SingleScanController<R> unfiltered = this.unfiltered();
        RowFilter lowBound = range[0];
        RowFilter highBound = range[1];
        RowFilter filter = range[2];
        RowFilter joinFilter = range[3];
        return new FilteredScanMaker<R>(this.rowStoreRef(), this, rowGen, unfiltered, predClass, lowBound, highBound, filter, joinFilter, projection).finish();
    }

    private RowFilter[][] multiRangeExtract(RowFilter rf, ColumnInfo ... keyColumns) {
        try {
            return rf.dnf().multiRangeExtract(false, false, keyColumns);
        }
        catch (ComplexFilterException e) {
            this.complex(rf, e);
            try {
                return new RowFilter[][]{rf.cnf().rangeExtract(keyColumns)};
            }
            catch (ComplexFilterException e2) {
                return new RowFilter[][]{{null, null, rf, null}};
            }
        }
    }

    private void splitRemainders(RowInfo rowInfo, RowFilter[] ... ranges) {
        if (this.joinedPrimaryTableClass() != null) {
            RowFilter.splitRemainders(rowInfo.allColumns, ranges);
        }
    }

    private static void doubleCheckRemainder(RowFilter[][] ranges, RowInfo rowInfo) {
        for (RowFilter[] r : ranges) {
            RowFilter remainder = BaseTable.and(BaseTable.and(BaseTable.and(r[3], r[2]), r[0]), r[1]);
            remainder = remainder.retain(rowInfo.valueColumns, false, TrueFilter.THE);
            r[3] = remainder.reduceMore();
        }
    }

    private static RowFilter and(RowFilter a, RowFilter b) {
        return a != null ? (b != null ? a.and(b) : a) : (b != null ? b : TrueFilter.THE);
    }

    private void complex(RowFilter rf, ComplexFilterException e) {
        EventListener listener;
        RowStore rs = (RowStore)this.rowStoreRef().get();
        if (rs != null && (listener = rs.mDatabase.eventListener()) != null) {
            listener.notify(EventType.TABLE_COMPLEX_FILTER, "Complex filter: %1$s \"%2$s\" %3$s", this.rowType().getName(), rf.toString(), e.getMessage());
        }
    }

    private QueryLauncher<R> newQueryLauncher(int type, String queryStr, IndexSelector selector) throws IOException {
        QueryLauncher<R> launcher;
        int num;
        RowInfo rowInfo;
        if (selector != null) {
            rowInfo = selector.primaryInfo();
        } else {
            rowInfo = RowInfo.find(this.rowType());
            NavigableMap allColumns = rowInfo.allColumns;
            Query query = new Parser(allColumns, queryStr).parseQuery(allColumns).reduce();
            selector = new IndexSelector(this, rowInfo, query, (type & 2) != 0);
        }
        if ((type & 2) != 0) {
            Map<String, ColumnInfo> proj;
            if (selector.orderBy() != null && (proj = selector.query().projection()) != null && !proj.keySet().containsAll(rowInfo.keyColumns.keySet())) {
                throw new IllegalStateException("Sorted Updater query must select all primary key columns");
            }
            if (!selector.forUpdateRuleChosen()) {
                return this.mQueryLauncherCache.obtain(type & 0xFFFFFFFD, queryStr, selector);
            }
        }
        if ((num = selector.numSelected()) <= 1) {
            launcher = this.newSubLauncher(type, selector, 0);
        } else {
            QueryLauncher[] launchers = new QueryLauncher[num];
            for (int i = 0; i < num; ++i) {
                launchers[i] = this.newSubLauncher(type, selector, i);
            }
            launcher = new DisjointUnionQueryLauncher(launchers);
        }
        OrderBy orderBy = selector.orderBy();
        if (orderBy != null) {
            launcher = new SortedQueryLauncher<R>(this, launcher, orderBy);
        }
        return launcher;
    }

    private QueryLauncher<R> newSubLauncher(int type, IndexSelector<R> selector, int i) {
        BaseTable<R> subTable = selector.selectedIndexTable(i);
        Query subQuery = selector.selectedQuery(i);
        String subQueryStr = subQuery.toString();
        ScanControllerFactory<R> subFactory = subTable.mFilterFactoryCache.obtain(type & 0xFFFFFFFD, subQueryStr, subQuery);
        if (selector.selectedReverse(i)) {
            subFactory = subFactory.reverse();
        }
        return new ScanQueryLauncher<R>(subTable, subFactory, selector.projection());
    }

    void clearQueryCache() {
        if (this.mQueryLauncherCache != null) {
            this.mQueryLauncherCache.clear();
        }
    }

    protected abstract R toRow(byte[] var1);

    protected final RowStore rowStore() throws DatabaseException {
        RowStore rs = (RowStore)this.rowStoreRef().get();
        if (rs == null) {
            throw new DatabaseException("Closed");
        }
        return rs;
    }

    protected final WeakReference<RowStore> rowStoreRef() {
        return this.mTableManager.mRowStoreRef;
    }

    protected abstract QueryPlan planReverse(Object ... var1);

    protected abstract SingleScanController<R> unfiltered();

    protected abstract SingleScanController<R> unfilteredReverse();

    protected final MethodHandle decodePartialHandle(byte[] spec, int schemaVersion) {
        WeakCache existing;
        WeakCache<Object, MethodHandle, Object> cache = this.mDecodePartialCache;
        if (cache == null && (existing = cDecodePartialCacheHandle.compareAndExchange(this, null, cache = new WeakCache<Object, MethodHandle, byte[]>(){

            @Override
            protected MethodHandle newValue(Object key, byte[] spec) {
                int schemaVersion = 0;
                if (key instanceof ArrayKey.PrefixBytes) {
                    ArrayKey.PrefixBytes pb = (ArrayKey.PrefixBytes)key;
                    schemaVersion = pb.prefix;
                }
                return BaseTable.this.makeDecodePartialHandle(spec, schemaVersion);
            }
        })) != null) {
            cache = existing;
        }
        Object key = schemaVersion == 0 ? ArrayKey.make(spec) : ArrayKey.make(schemaVersion, spec);
        return (MethodHandle)cache.obtain(key, (Object)spec);
    }

    protected abstract MethodHandle makeDecodePartialHandle(byte[] var1, int var2);

    protected final MethodHandle writeRowHandle(byte[] spec) {
        WeakCache existing;
        WeakCache<Object, MethodHandle, Object> cache = this.mWriteRowCache;
        if (cache == null && (existing = cWriteRowCacheHandle.compareAndExchange(this, null, cache = new WeakCache<Object, MethodHandle, byte[]>(){

            @Override
            protected MethodHandle newValue(Object key, byte[] spec) {
                if (BaseTable.this.isEvolvable()) {
                    return WriteRowMaker.makeWriteRowHandle(BaseTable.this.rowStoreRef(), BaseTable.this.rowType(), BaseTable.this.mSource.id(), spec);
                }
                RowInfo primaryRowInfo = RowInfo.find(BaseTable.this.rowType());
                byte[] secondaryDesc = BaseTable.this.secondaryDescriptor();
                RowInfo rowInfo = secondaryDesc == null ? primaryRowInfo : RowStore.secondaryRowInfo(primaryRowInfo, secondaryDesc);
                return WriteRowMaker.makeWriteRowHandle(rowInfo, spec);
            }
        })) != null) {
            cache = existing;
        }
        return (MethodHandle)cache.obtain((Object)ArrayKey.make(spec), (Object)spec);
    }

    public final RemoteTableProxy newRemoteProxy(byte[] descriptor) throws IOException {
        int schemaVersion;
        if (!this.isEvolvable()) {
            schemaVersion = 0;
        } else {
            RowInfo rowInfo = RowInfo.find(this.rowType());
            schemaVersion = this.rowStore().schemaVersion(rowInfo, false, this.mSource.id(), true);
        }
        return RemoteProxyMaker.make(this, schemaVersion, descriptor);
    }

    public final void redoPredicateMode(Transaction txn) throws IOException {
        this.mIndexLock.redoPredicateMode(txn);
    }

    public final Transaction enterScope(Transaction txn) throws IOException {
        return ViewUtils.enterScope(this.mSource, txn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void storeNoTrigger(Transaction txn, R row, byte[] key, byte[] value) throws IOException {
        Index source = this.mSource;
        txn = ViewUtils.enterScope(source, txn);
        try {
            this.redoPredicateMode(txn);
            try (RowPredicateLock.Closer closer = this.mIndexLock.openAcquire(txn, row);){
                source.store(txn, key, value);
            }
            txn.commit();
        }
        finally {
            txn.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] exchangeNoTrigger(Transaction txn, R row, byte[] key, byte[] value) throws IOException {
        byte[] oldValue;
        Index source = this.mSource;
        txn = ViewUtils.enterScope(source, txn);
        try {
            this.redoPredicateMode(txn);
            try (RowPredicateLock.Closer closer = this.mIndexLock.openAcquire(txn, row);){
                oldValue = source.exchange(txn, key, value);
            }
            txn.commit();
        }
        finally {
            txn.exit();
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean insertNoTrigger(Transaction txn, R row, byte[] key, byte[] value) throws IOException {
        boolean result;
        Index source = this.mSource;
        txn = ViewUtils.enterScope(source, txn);
        try {
            this.redoPredicateMode(txn);
            try (RowPredicateLock.Closer closer = this.mIndexLock.openAcquire(txn, row);){
                result = source.insert(txn, key, value);
            }
            txn.commit();
        }
        finally {
            txn.exit();
        }
        return result;
    }

    protected final boolean replaceNoTrigger(Transaction txn, R row, byte[] key, byte[] value) throws IOException {
        return this.mSource.replace(txn, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void storeAndTrigger(Transaction txn, R row, byte[] key, byte[] value) throws IOException {
        while (true) {
            Trigger<R> trigger = this.trigger();
            trigger.acquireShared();
            try {
                int mode = trigger.mode();
                if (mode == 1) {
                    this.mSource.store(txn, key, value);
                    return;
                }
                if (mode == 2) continue;
                Index source = this.mSource;
                txn = ViewUtils.enterScope(source, txn);
                try {
                    this.redoPredicateMode(txn);
                    try (Cursor c = source.newCursor(txn);){
                        try (RowPredicateLock.Closer closer = this.mIndexLock.openAcquireP(txn, row, key, value);){
                            c.find(key);
                        }
                        byte[] oldValue = c.value();
                        if (oldValue == null) {
                            trigger.insertP(txn, row, key, value);
                        } else {
                            trigger.storeP(txn, row, key, oldValue, value);
                        }
                        c.commit(value);
                    }
                }
                finally {
                    txn.exit();
                }
                return;
            }
            finally {
                trigger.releaseShared();
                continue;
            }
            break;
        }
    }

    /*
     * Exception decompiling
     */
    final byte[] exchangeAndTrigger(Transaction txn, R row, byte[] key, byte[] value) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    final boolean insertAndTrigger(Transaction txn, R row, byte[] key, byte[] value) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    final boolean replaceAndTrigger(Transaction txn, R row, byte[] key, byte[] value) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final byte[] updateAndTrigger(Transaction txn, R row, byte[] key, ValueUpdater updater) throws IOException {
        txn = ViewUtils.enterScope(this.mSource, txn);
        try (Cursor c = this.mSource.newCursor(txn);){
            c.find(key);
            byte[] originalValue = c.value();
            if (originalValue == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] newValue = updater.updateValue(originalValue);
            while (true) {
                Trigger<R> trigger = this.trigger();
                trigger.acquireShared();
                try {
                    int mode = trigger.mode();
                    if (mode == 1) {
                        c.commit(newValue);
                        byte[] byArray = newValue;
                        return byArray;
                    }
                    if (mode == 2) continue;
                    c.store(newValue);
                    this.redoPredicateMode(txn);
                    trigger.storeP(txn, row, key, originalValue, newValue);
                    txn.commit();
                    byte[] byArray = newValue;
                    return byArray;
                }
                finally {
                    trigger.releaseShared();
                    continue;
                }
                break;
            }
        }
        finally {
            txn.exit();
        }
    }

    /*
     * Exception decompiling
     */
    final boolean deleteAndTrigger(Transaction txn, byte[] key) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    final byte[] storeAutoAndTrigger(AutomaticKeyGenerator<R> autogen, Transaction txn, R row, byte[] key, byte[] value) throws IOException {
        txn = ViewUtils.enterScopex(this.mSource, txn);
        try {
            this.redoPredicateMode(txn);
            while (true) {
                block10: {
                    if ((trigger = this.trigger()) == null) {
                        key = autogen.store(txn, null, key, value);
                        txn.commit();
                        var7_8 = key;
                        return var7_8;
                    }
                    trigger.acquireShared();
                    mode = trigger.mode();
                    if (mode != 1) break block10;
                    key = autogen.store(txn, null, key, value);
                    ** GOTO lbl23
                }
                if (mode != 2) break;
                trigger.releaseShared();
            }
            try {
                key = autogen.store(txn, null, key, value);
                trigger.insertP(txn, row, key, value);
lbl23:
                // 2 sources

                txn.commit();
                var8_9 = key;
            }
            catch (Throwable var9_10) {
                trigger.releaseShared();
                throw var9_10;
            }
            trigger.releaseShared();
            return var8_9;
        }
        finally {
            txn.exit();
        }
    }

    protected byte[] secondaryDescriptor() {
        return null;
    }

    protected BaseTable<R> joinedPrimaryTable() {
        return null;
    }

    protected Class<?> joinedPrimaryTableClass() {
        return null;
    }

    boolean isEvolvable() {
        return BaseTable.isEvolvable(this.rowType());
    }

    static boolean isEvolvable(Class<?> rowType) {
        return rowType != Entry.class;
    }

    boolean supportsSecondaries() {
        return true;
    }

    final void setTrigger(Trigger<R> trigger) {
        if (this.mTrigger == null) {
            throw new UnsupportedOperationException();
        }
        if (trigger == null) {
            trigger = new Trigger();
            trigger.mMode = 1;
        }
        cTriggerHandle.getAndSet(this, trigger).disable();
    }

    final Trigger<R> getTrigger() {
        return this.mTrigger;
    }

    public final Trigger<R> trigger() {
        return cTriggerHandle.getOpaque(this);
    }

    static RowFilter parseFilter(Class<?> rowType, String queryStr) {
        Parser parser = new Parser(RowInfo.find(rowType).allColumns, queryStr);
        parser.skipProjection();
        return parser.parseFilter();
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cTriggerHandle = lookup.findVarHandle(BaseTable.class, "mTrigger", Trigger.class);
            cDecodePartialCacheHandle = lookup.findVarHandle(BaseTable.class, "mDecodePartialCache", WeakCache.class);
            cWriteRowCacheHandle = lookup.findVarHandle(BaseTable.class, "mWriteRowCache", WeakCache.class);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    @FunctionalInterface
    public static interface ValueUpdater {
        public byte[] updateValue(byte[] var1);
    }
}

