/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import java.util.Objects;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.UnpositionedCursorException;
import org.cojen.tupl.core.RowPredicate;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.RowConsumer;
import org.cojen.tupl.rows.RowEvaluator;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.ScanController;
import org.cojen.tupl.rows.StoppedCursorException;

class BasicScanner<R>
implements Scanner<R> {
    final BaseTable<R> mTable;
    final ScanController<R> mController;
    Cursor mCursor;
    RowEvaluator<R> mEvaluator;
    R mRow;

    BasicScanner(BaseTable<R> table, ScanController<R> controller) {
        this.mTable = table;
        this.mController = controller;
    }

    void init(Transaction txn, R row) throws IOException {
        block3: while (true) {
            Cursor c;
            this.beginBatch(row, this.mController.evaluator());
            this.mCursor = c = this.mController.newCursor(this.mTable.mSource, txn);
            LockResult result = this.toFirst(c);
            while (true) {
                byte[] key;
                if ((key = c.key()) == null) {
                    if (this.mController.next()) continue block3;
                    break block3;
                }
                try {
                    R decoded = this.evalRow(c, result, row);
                    if (decoded != null) {
                        this.mRow = decoded;
                        return;
                    }
                }
                catch (StoppedCursorException e) {
                    if (result != LockResult.ACQUIRED) continue;
                    c.link().unlock();
                    this.unlocked();
                    continue;
                }
                catch (Throwable e) {
                    throw RowUtils.fail(this, e);
                }
                if (result == LockResult.ACQUIRED) {
                    c.link().unlock();
                    this.unlocked();
                }
                result = this.toNext(c);
            }
            break;
        }
        this.finished();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        RowUtils.appendMiniString(b, this);
        b.append('{');
        RowPredicate<R> predicate = this.mController.predicate();
        if (predicate == RowPredicate.all()) {
            b.append("unfiltered");
        } else {
            b.append("filter").append(": ").append(predicate);
        }
        return b.append('}').toString();
    }

    @Override
    public final long estimateSize() {
        return this.mController.estimateSize();
    }

    @Override
    public final int characteristics() {
        return this.mController.characteristics();
    }

    @Override
    public final R row() {
        return this.mRow;
    }

    @Override
    public final R step() throws IOException {
        return this.doStep(null);
    }

    @Override
    public final R step(R row) throws IOException {
        Objects.requireNonNull(row);
        return this.doStep(row);
    }

    protected final R doStep(R row) throws IOException {
        block10: {
            Cursor c = this.mCursor;
            try {
                while (true) {
                    LockResult result = this.toNext(c);
                    while (true) {
                        if (c.key() == null) {
                            if (this.mController.next()) {
                                this.beginBatch(row, this.mController.evaluator());
                                Transaction txn = c.link();
                                this.mCursor = c = this.mController.newCursor(this.mTable.mSource, txn);
                                this.toFirst(c);
                                continue;
                            }
                            break block10;
                        }
                        try {
                            R decoded = this.evalRow(c, result, row);
                            if (decoded != null) {
                                this.mRow = decoded;
                                return decoded;
                            }
                        }
                        catch (StoppedCursorException e) {
                            if (result != LockResult.ACQUIRED) continue;
                            c.link().unlock();
                            this.unlocked();
                            continue;
                        }
                        break;
                    }
                    if (result != LockResult.ACQUIRED) continue;
                    c.link().unlock();
                    this.unlocked();
                }
            }
            catch (UnpositionedCursorException result) {
            }
            catch (Throwable e) {
                throw RowUtils.fail(this, e);
            }
        }
        this.finished();
        return null;
    }

    protected void beginBatch(R row, RowEvaluator<R> evaluator) throws IOException {
        this.mEvaluator = evaluator;
        if (row instanceof RowConsumer) {
            RowConsumer consumer = (RowConsumer)row;
            consumer.beginBatch(this, evaluator);
        }
    }

    protected R evalRow(Cursor c, LockResult result, R row) throws IOException {
        return this.mEvaluator.evalRow(c, result, row);
    }

    @Override
    public final void close() throws IOException {
        this.finished();
        this.mCursor.reset();
    }

    protected LockResult toFirst(Cursor c) throws IOException {
        return c.first();
    }

    protected LockResult toNext(Cursor c) throws IOException {
        return c.next();
    }

    protected void unlocked() {
    }

    protected void finished() throws IOException {
        this.mRow = null;
    }
}

