/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.TreeSet;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.UniqueConstraintException;
import org.cojen.tupl.UnpositionedCursorException;
import org.cojen.tupl.Updater;
import org.cojen.tupl.core.RowPredicateLock;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.BasicScanner;
import org.cojen.tupl.rows.RowEvaluator;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.ScanController;
import org.cojen.tupl.rows.Trigger;
import org.cojen.tupl.views.ViewUtils;

class BasicUpdater<R>
extends BasicScanner<R>
implements Updater<R> {
    TreeSet<byte[]> mKeysToSkip;

    BasicUpdater(BaseTable<R> table, ScanController<R> controller) {
        super(table, controller);
    }

    @Override
    public final R update() throws IOException {
        this.updateCurrent();
        return this.doStep(null);
    }

    @Override
    public final R update(R row) throws IOException {
        Objects.requireNonNull(row);
        this.updateCurrent();
        return this.doStep(row);
    }

    private void updateCurrent() throws IOException {
        try {
            Object current = this.mRow;
            if (current == null) {
                throw new IllegalStateException("No current row");
            }
            this.doUpdateCurrent(current);
        }
        catch (UnpositionedCursorException e) {
            this.finished();
            throw new IllegalStateException("No current row");
        }
        catch (UniqueConstraintException e) {
            throw e;
        }
        catch (Throwable e) {
            throw RowUtils.fail(this, e);
        }
        this.unlocked();
    }

    private void doUpdateCurrent(R row) throws IOException {
        int cmp;
        Cursor c = this.mCursor;
        RowEvaluator evaluator = this.mEvaluator;
        byte[] key = evaluator.updateKey(row, c.key());
        byte[] value = evaluator.updateValue(row, c.value());
        if (key == null || (cmp = c.compareKeyTo(key)) == 0) {
            this.doUpdateAsStore(c, value);
            return;
        }
        if (!(cmp >= 0 || this.mController.predicate().testP(row, key, value) && this.addKeyToSkip(key))) {
            cmp = 0;
        }
        try {
            this.doUpdateAsDeleteInsert(row, c, key, value);
        }
        catch (UniqueConstraintException e) {
            if (cmp < 0) {
                this.mKeysToSkip.remove(key);
            }
            throw e;
        }
    }

    boolean addKeyToSkip(byte[] key) {
        if (this.mKeysToSkip == null) {
            this.mKeysToSkip = new TreeSet(RowUtils.KEY_COMPARATOR);
        }
        return this.mKeysToSkip.add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateAsStore(Cursor c, byte[] value) throws IOException {
        Trigger trigger = this.mTable.getTrigger();
        if (trigger == null) {
            this.storeValue(c, value);
            return;
        }
        while (true) {
            trigger.acquireShared();
            try {
                int mode = trigger.mode();
                if (mode == 1) {
                    this.storeValue(c, value);
                    return;
                }
                if (mode != 2) {
                    this.storeValue(trigger, this.mRow, c, value);
                    return;
                }
            }
            finally {
                trigger.releaseShared();
            }
            trigger = this.mTable.trigger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateAsDeleteInsert(R row, Cursor c, byte[] key, byte[] value) throws IOException {
        Index source = this.mTable.mSource;
        Transaction txn = ViewUtils.enterScope(source, c.link());
        try {
            boolean result;
            Trigger<R> trigger = this.mTable.getTrigger();
            if (trigger != null) {
                while (true) {
                    trigger.acquireShared();
                    try {
                        int mode = trigger.mode();
                        if (mode == 1) break;
                        if (mode != 2) {
                            byte[] oldValue = c.value();
                            if (oldValue != null) {
                                trigger.delete(txn, c.key(), oldValue);
                            }
                            trigger.insertP(txn, row, key, value);
                            break;
                        }
                    }
                    finally {
                        trigger.releaseShared();
                    }
                    trigger = this.mTable.trigger();
                }
            }
            RowPredicateLock<R> lock = this.mTable.mIndexLock;
            lock.redoPredicateMode(txn);
            try (RowPredicateLock.Closer closer = lock.openAcquireP(txn, row, key, value);){
                result = source.insert(txn, key, value);
            }
            if (!result) {
                throw new UniqueConstraintException("Primary key");
            }
            c.commit(null);
        }
        finally {
            txn.exit();
        }
        this.postStoreKeyValue(txn);
    }

    final void joinedUpdateCurrent() throws IOException {
        try {
            Object current = this.mRow;
            if (current == null) {
                throw new IllegalStateException("No current row");
            }
            Cursor c = this.mCursor;
            RowEvaluator evaluator = this.mEvaluator;
            byte[] key = evaluator.updateKey(current, c.key());
            byte[] value = evaluator.updateValue(current, c.value());
            if (Arrays.equals(key, c.key())) {
                this.doUpdateAsStore(c, value);
            } else {
                this.doUpdateAsDeleteInsert(current, c, key, value);
            }
        }
        catch (UnpositionedCursorException e) {
            this.finished();
            throw new IllegalStateException("No current row");
        }
        catch (UniqueConstraintException e) {
            throw e;
        }
        catch (Throwable e) {
            throw RowUtils.fail(this, e);
        }
        this.unlocked();
    }

    @Override
    public final R delete() throws IOException {
        this.deleteCurrent();
        return this.doStep(null);
    }

    @Override
    public final R delete(R row) throws IOException {
        Objects.requireNonNull(row);
        this.deleteCurrent();
        return this.doStep(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void deleteCurrent() throws IOException {
        block11: {
            try {
                Trigger trigger = this.mTable.getTrigger();
                if (trigger == null) {
                    this.doDelete();
                    break block11;
                }
                while (true) {
                    block12: {
                        trigger.acquireShared();
                        try {
                            int mode = trigger.mode();
                            if (mode == 1) {
                                this.doDelete();
                                break;
                            }
                            if (mode == 2) break block12;
                            Object current = this.mRow;
                            if (current == null) {
                                throw new IllegalStateException("No current row");
                            }
                            this.doDelete(trigger, current);
                            break;
                        }
                        finally {
                            trigger.releaseShared();
                        }
                    }
                    trigger = this.mTable.trigger();
                }
            }
            catch (UnpositionedCursorException e) {
                this.finished();
                throw new IllegalStateException("No current row");
            }
            catch (Throwable e) {
                throw RowUtils.fail(this, e);
            }
        }
        this.unlocked();
    }

    @Override
    protected LockResult toFirst(Cursor c) throws IOException {
        LockResult result = c.first();
        c.register();
        return result;
    }

    protected void storeValue(Cursor c, byte[] value) throws IOException {
        c.store(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeValue(Trigger<R> trigger, R row, Cursor c, byte[] value) throws IOException {
        Transaction txn = ViewUtils.enterScope(this.mTable.mSource, c.link());
        try {
            byte[] oldValue = c.value();
            c.store(value);
            this.mTable.redoPredicateMode(txn);
            if (oldValue == null) {
                trigger.insertP(txn, row, c.key(), value);
            } else {
                trigger.storeP(txn, row, c.key(), oldValue, value);
            }
            txn.commit();
        }
        finally {
            txn.exit();
        }
    }

    protected void postStoreKeyValue(Transaction txn) throws IOException {
    }

    protected void doDelete() throws IOException {
        this.mCursor.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete(Trigger<R> trigger, R row) throws IOException {
        Cursor c = this.mCursor;
        Transaction txn = ViewUtils.enterScope(this.mTable.mSource, c.link());
        try {
            byte[] oldValue = c.value();
            if (oldValue != null) {
                trigger.delete(txn, c.key(), oldValue);
                c.commit(null);
            }
        }
        finally {
            txn.exit();
        }
    }

    @Override
    protected final R evalRow(Cursor c, LockResult result, R row) throws IOException {
        if (this.mKeysToSkip != null && this.mKeysToSkip.remove(c.key())) {
            return null;
        }
        return super.evalRow(c, result, row);
    }
}

