/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.math.BigInteger;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.RowUtils;

final class BigDecimalColumnCodec
extends ColumnCodec {
    private final ColumnCodec mUnscaledCodec;
    private Variable mScaleVar;
    private Variable mUnscaledVar;

    BigDecimalColumnCodec(ColumnInfo info, ColumnCodec unscaledCodec, MethodMaker mm) {
        super(info, mm);
        this.mUnscaledCodec = unscaledCodec;
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new BigDecimalColumnCodec(this.mInfo, this.mUnscaledCodec.bind(mm), mm);
    }

    @Override
    protected final boolean doEquals(Object obj) {
        return ((BigDecimalColumnCodec)obj).mUnscaledCodec.equals(this.mUnscaledCodec);
    }

    @Override
    public final int doHashCode() {
        return this.mUnscaledCodec.doHashCode();
    }

    @Override
    int codecFlags() {
        return this.mUnscaledCodec.codecFlags();
    }

    @Override
    int minSize() {
        return 0;
    }

    @Override
    void encodePrepare() {
        this.mScaleVar = this.mMaker.var(Integer.TYPE);
        this.mUnscaledVar = this.mMaker.var(BigInteger.class);
        this.mUnscaledCodec.encodePrepare();
    }

    @Override
    void encodeSkip() {
        this.mScaleVar.set((Object)0);
        this.mUnscaledVar.set(null);
        this.mUnscaledCodec.encodeSkip();
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        boolean newTotal = false;
        if (totalVar == null) {
            totalVar = this.mMaker.var(Integer.TYPE);
            newTotal = true;
        }
        Label end = null;
        if (this.mInfo.isNullable()) {
            end = this.mMaker.label();
            Label notNull = this.mMaker.label();
            srcVar.ifNe(null, notNull);
            this.encodeSkip();
            if (newTotal) {
                totalVar.set((Object)1);
            } else {
                totalVar.inc((Object)1);
            }
            this.mMaker.goto_(end);
            notNull.here();
        }
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        this.mScaleVar.set((Object)rowUtils.invoke("convertSignedVarInt", new Object[]{srcVar.invoke("scale", new Object[0])}));
        Variable lengthVar = rowUtils.invoke("calcUnsignedVarIntLength", new Object[]{this.mScaleVar});
        if (newTotal) {
            totalVar.set((Object)lengthVar);
        } else {
            totalVar.inc((Object)lengthVar);
        }
        this.mUnscaledVar.set((Object)srcVar.invoke("unscaledValue", new Object[0]));
        totalVar = this.mUnscaledCodec.encodeSize(this.mUnscaledVar, totalVar);
        if (end != null) {
            end.here();
        }
        return totalVar;
    }

    @Override
    void encode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        Label end = null;
        if (this.mInfo.isNullable()) {
            end = this.mMaker.label();
            this.encodeNullHeaderIfNull(end, srcVar, dstVar, offsetVar);
        }
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        offsetVar.set((Object)rowUtils.invoke("encodeUnsignedVarInt", new Object[]{dstVar, offsetVar, this.mScaleVar}));
        this.mUnscaledCodec.encode(this.mUnscaledVar, dstVar, offsetVar);
        if (end != null) {
            end.here();
        }
    }

    @Override
    void decode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable endVar) {
        Label end = null;
        if (this.mInfo.isNullable()) {
            end = this.mMaker.label();
            Variable h = srcVar.aget((Object)offsetVar).cast(Integer.TYPE).and((Object)255);
            Label notNull = this.mMaker.label();
            h.ifLt((Object)248, notNull);
            dstVar.set(null);
            offsetVar.inc((Object)1);
            this.mMaker.goto_(end);
            notNull.here();
        }
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        Variable decodedVar = rowUtils.invoke("decodeSignedVarInt", new Object[]{srcVar, offsetVar});
        offsetVar.set((Object)decodedVar.shr((Object)32).cast(Integer.TYPE));
        Variable scaleVar = decodedVar.cast(Integer.TYPE);
        Variable unscaledVar = this.mMaker.var(BigInteger.class);
        this.mUnscaledCodec.decode(unscaledVar, srcVar, offsetVar, endVar);
        dstVar.set((Object)this.mMaker.new_((Object)dstVar, new Object[]{unscaledVar, scaleVar}));
        if (end != null) {
            end.here();
        }
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        if (this.isLast()) {
            this.mUnscaledCodec.decodeSkip(srcVar, offsetVar, endVar);
        } else {
            String method = this.mInfo.isNullable() ? "skipNullableBigDecimal" : "skipBigDecimal";
            offsetVar.set((Object)this.mMaker.var(RowUtils.class).invoke(method, new Object[]{srcVar, offsetVar}));
        }
    }
}

