/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.cojen.tupl.rows.RowUtils;

public class BigDecimalUtils
extends RowUtils {
    static final BigInteger ONE_HUNDRED = BigInteger.valueOf(100L);
    static final BigInteger ONE_THOUSAND = BigInteger.valueOf(1000L);

    public static byte[] encodeBigDecimalLex(BigDecimal bd) {
        return BigDecimalUtils.encodeBigDecimalLex(bd, 0);
    }

    public static byte[] encodeBigDecimalLexDesc(BigDecimal bd) {
        return BigDecimalUtils.encodeBigDecimalLex(bd, -1);
    }

    private static byte[] encodeBigDecimalLex(BigDecimal bd, int xor) {
        int bpos;
        int digitAdjust;
        int terminator;
        if (bd.signum() == 0) {
            byte[] bytes = new byte[5];
            bytes[0] = (byte)(0x80 ^ xor);
            BigDecimalUtils.encodeIntBE(bytes, 1, bd.scale() ^ Integer.MIN_VALUE ^ xor);
            return bytes;
        }
        BigInteger unscaled = bd.unscaledValue();
        int precision = bd.precision();
        switch (precision % 3) {
            default: {
                terminator = 2;
                break;
            }
            case 1: {
                terminator = 0;
                unscaled = unscaled.multiply(ONE_HUNDRED);
                break;
            }
            case 2: {
                terminator = 1;
                unscaled = unscaled.multiply(BigInteger.TEN);
            }
        }
        long exponent = (long)precision - (long)bd.scale();
        if (unscaled.signum() >= 0) {
            digitAdjust = 12;
        } else {
            digitAdjust = 1011;
            terminator = 1023 - terminator;
        }
        int dpos = (unscaled.bitLength() + 9) / 10 + 2;
        int[] digits = new int[dpos];
        digits[--dpos] = terminator;
        while (unscaled.signum() != 0) {
            BigInteger[] divrem = unscaled.divideAndRemainder(ONE_THOUSAND);
            digits[--dpos] = divrem[1].intValue() + digitAdjust;
            unscaled = divrem[0];
        }
        int bytesLength = 1;
        if (exponent < -62L || exponent >= 62L) {
            bytesLength += 4;
        }
        int digitsLength = (digits.length - dpos) * 10 + 7 >>> 3;
        byte[] bytes = new byte[bytesLength += digitsLength];
        if (bd.signum() < 0) {
            if (exponent >= -62L && exponent < 62L) {
                bytes[0] = (byte)(63L - exponent ^ (long)xor);
                bpos = 1;
            } else {
                bytes[0] = (byte)((exponent < 0L ? 126 : 1) ^ xor);
                BigDecimalUtils.encodeIntBE(bytes, 1, (int)exponent ^ Integer.MAX_VALUE ^ xor);
                bpos = 5;
            }
        } else if (exponent >= -62L && exponent < 62L) {
            bytes[0] = (byte)(exponent + 192L ^ (long)xor);
            bpos = 1;
        } else {
            bytes[0] = (byte)((exponent < 0L ? 129 : 254) ^ xor);
            BigDecimalUtils.encodeIntBE(bytes, 1, (int)exponent ^ Integer.MIN_VALUE ^ xor);
            bpos = 5;
        }
        int accum = 0;
        int bits = 0;
        while (dpos < digits.length) {
            accum = accum << 10 | digits[dpos];
            bits += 10;
            do {
                bytes[bpos++] = (byte)(accum >> (bits -= 8) ^ xor);
            } while (bits >= 8);
            ++dpos;
        }
        if (bits != 0) {
            bytes[bpos++] = (byte)(accum << 8 - bits ^ xor);
        }
        assert (bpos == bytes.length);
        return bytes;
    }

    public static int decodeBigDecimalLex(byte[] src, int srcOffset, BigDecimal[] bdRef) {
        return BigDecimalUtils.decodeBigDecimalLex(src, srcOffset, bdRef, 0);
    }

    public static int decodeBigDecimalLexDesc(byte[] src, int srcOffset, BigDecimal[] bdRef) {
        return BigDecimalUtils.decodeBigDecimalLex(src, srcOffset, bdRef, -1);
    }

    private static int decodeBigDecimalLex(byte[] src, int srcOffset, BigDecimal[] bdRef, int xor) {
        int digitAdjust;
        int exponent = (src[srcOffset++] ^ xor) & 0xFF;
        switch (exponent) {
            case 0: 
            case 255: {
                if (bdRef != null) {
                    bdRef[0] = null;
                }
                return srcOffset;
            }
            case 127: 
            case 128: {
                if (bdRef != null) {
                    int scale = BigDecimalUtils.decodeIntBE(src, srcOffset) ^ Integer.MIN_VALUE ^ xor;
                    BigDecimal bd = scale == 0 ? BigDecimal.ZERO : new BigDecimal(BigInteger.ZERO, scale);
                    bdRef[0] = bd;
                }
                return srcOffset + 4;
            }
            case 1: 
            case 126: {
                digitAdjust = 1011;
                exponent = BigDecimalUtils.decodeIntBE(src, srcOffset) ^ Integer.MAX_VALUE ^ xor;
                srcOffset += 4;
                break;
            }
            case 129: 
            case 254: {
                digitAdjust = 12;
                exponent = BigDecimalUtils.decodeIntBE(src, srcOffset) ^ Integer.MIN_VALUE ^ xor;
                srcOffset += 4;
                break;
            }
            default: {
                if (exponent >= 130) {
                    digitAdjust = 12;
                    exponent -= 192;
                    break;
                }
                digitAdjust = 1011;
                exponent = 63 - exponent;
            }
        }
        int accum = 0;
        int bits = 0;
        if (bdRef == null) {
            while (true) {
                accum = accum << 8 | (src[srcOffset++] ^ xor) & 0xFF;
                if ((bits += 8) < 10) continue;
                int digit = accum >> bits - 10 & 0x3FF;
                if (digit <= 11 || digit >= 1012) {
                    return srcOffset;
                }
                bits -= 10;
            }
        }
        BigInteger unscaledValue = null;
        int precision = 0;
        BigInteger lastDigit = null;
        block12: while (true) {
            accum = accum << 8 | (src[srcOffset++] ^ xor) & 0xFF;
            if ((bits += 8) < 10) continue;
            int digit = accum >> bits - 10 & 0x3FF;
            switch (digit) {
                case 0: 
                case 1023: {
                    lastDigit = lastDigit.divide(ONE_HUNDRED);
                    unscaledValue = unscaledValue == null ? lastDigit : unscaledValue.multiply(BigInteger.TEN).add(lastDigit);
                    ++precision;
                    break block12;
                }
                case 1: 
                case 1022: {
                    lastDigit = lastDigit.divide(BigInteger.TEN);
                    unscaledValue = unscaledValue == null ? lastDigit : unscaledValue.multiply(ONE_HUNDRED).add(lastDigit);
                    precision += 2;
                    break block12;
                }
                case 2: 
                case 1021: {
                    unscaledValue = unscaledValue == null ? lastDigit : unscaledValue.multiply(ONE_THOUSAND).add(lastDigit);
                    precision += 3;
                    break block12;
                }
                default: {
                    if (unscaledValue == null) {
                        unscaledValue = lastDigit;
                        if (unscaledValue != null) {
                            precision += 3;
                        }
                    } else {
                        unscaledValue = unscaledValue.multiply(ONE_THOUSAND).add(lastDigit);
                        precision += 3;
                    }
                    bits -= 10;
                    lastDigit = BigInteger.valueOf(digit - digitAdjust);
                    continue block12;
                }
            }
            break;
        }
        bdRef[0] = new BigDecimal(unscaledValue, precision - exponent);
        return srcOffset;
    }

    public static BigDecimal valueOf(float f) {
        return new BigDecimal(Float.toString(f));
    }

    public static BigDecimal toBigDecimal(float f) {
        if (f == 0.0f) {
            return BigDecimal.ZERO;
        }
        if (f == 1.0f) {
            return BigDecimal.ONE;
        }
        return BigDecimalUtils.toBigDecimal(Float.toString(f));
    }

    public static BigDecimal toBigDecimal(double d) {
        if (d == 0.0) {
            return BigDecimal.ZERO;
        }
        if (d == 1.0) {
            return BigDecimal.ONE;
        }
        return BigDecimalUtils.toBigDecimal(Double.toString(d));
    }

    private static BigDecimal toBigDecimal(String str) {
        if (((String)str).endsWith(".0")) {
            str = ((String)str).substring(0, ((String)str).length() - 2);
        } else {
            int ix = ((String)str).indexOf(".0E");
            if (ix > 0) {
                str = ((String)str).substring(0, ix) + ((String)str).substring(ix + 2);
            }
        }
        return new BigDecimal((String)str);
    }

    public static int matches(BigDecimal col, BigDecimal arg) {
        int cmp = col.compareTo(arg);
        if (cmp == 0 && col.scale() < arg.scale()) {
            cmp = -1;
        }
        return cmp;
    }
}

