/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.reflect.Modifier;
import org.cojen.maker.Field;
import org.cojen.maker.FieldMaker;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.filter.ColumnFilter;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.CompareUtils;
import org.cojen.tupl.rows.ConvertUtils;
import org.cojen.tupl.rows.Converter;

abstract class BytesColumnCodec
extends ColumnCodec {
    BytesColumnCodec(ColumnInfo info, MethodMaker mm) {
        super(info, mm);
    }

    @Override
    int minSize() {
        return 0;
    }

    @Override
    void filterDefineExtraFields(boolean in, Variable argVar, String argFieldName) {
        FieldMaker fm;
        Class fieldType = in ? byte[][].class : byte[].class;
        String fieldName = BytesColumnCodec.argFieldName(argFieldName, this.bytesFieldSuffix());
        try {
            fm = this.defineArgField(fieldType, fieldName);
        }
        catch (IllegalStateException e) {
            return;
        }
        if (argVar != null) {
            fm.final_();
            this.mMaker.field(fieldName).set((Object)this.filterPrepareBytes(argVar, in));
            return;
        }
        MethodMaker mm = this.mMaker.classMaker().addMethod(byte[].class, fieldName, new Object[0]);
        BytesColumnCodec codec = (BytesColumnCodec)this.bind(mm);
        Variable bytes = mm.field(fieldName).getOpaque();
        Label doInit = mm.label();
        bytes.ifEq(null, doInit);
        mm.return_((Object)bytes);
        doInit.here();
        bytes.set((Object)codec.filterPrepareBytes((Variable)mm.field(argFieldName), in));
        mm.field(fieldName).setOpaque((Object)bytes);
        mm.return_((Object)bytes);
    }

    private Variable filterPrepareBytes(Variable argVar, boolean in) {
        if (in) {
            Variable lengthVar = argVar.alength();
            return ConvertUtils.convertArray(this.mMaker, byte[][].class, lengthVar, ixVar -> this.filterPrepareBytes(argVar.aget(ixVar)));
        }
        return this.filterPrepareBytes(argVar);
    }

    protected abstract Variable filterPrepareBytes(Variable var1);

    protected abstract boolean compareBytesUnsigned();

    @Override
    boolean canFilterQuick(ColumnInfo dstInfo) {
        return dstInfo.unorderedTypeCode() == this.mInfo.unorderedTypeCode();
    }

    @Override
    Object filterQuickDecode(ColumnInfo dstInfo, Variable srcVar, Variable offsetVar, Variable endVar) {
        Variable lengthVar = this.mMaker.var(Integer.TYPE);
        Variable isNullVar = this.mInfo.isNullable() ? this.mMaker.var(Boolean.TYPE) : null;
        this.decodeHeader(srcVar, offsetVar, endVar, lengthVar, isNullVar);
        Variable dataOffsetVar = offsetVar.get();
        offsetVar.inc((Object)lengthVar);
        return new Variable[]{dataOffsetVar, lengthVar, isNullVar};
    }

    protected abstract void decodeHeader(Variable var1, Variable var2, Variable var3, Variable var4, Variable var5);

    protected void decodeNullableLength(Variable lengthVar, Variable isNullVar) {
        Label notNull = this.mMaker.label();
        lengthVar.ifNe((Object)0, notNull);
        isNullVar.set((Object)true);
        Label cont = this.mMaker.label().goto_();
        notNull.here();
        isNullVar.set((Object)false);
        lengthVar.inc((Object)-1);
        cont.here();
    }

    @Override
    void filterQuickCompare(ColumnInfo dstInfo, Variable srcVar, Variable offsetVar, int op, Object decoded, Variable argObjVar, int argNum, Label pass, Label fail) {
        Variable[] decodedVars = (Variable[])decoded;
        if (!dstInfo.isNullable() && this.mInfo.isNullable()) {
            Label cont = this.mMaker.label();
            Variable isNullVar = decodedVars[2];
            isNullVar.ifFalse(cont);
            Variable columnVar = this.mMaker.var(dstInfo.type);
            Converter.setDefault(this.mMaker, dstInfo, columnVar);
            Field argField = argObjVar.field(this.argFieldName(argNum));
            CompareUtils.compare(this.mMaker, dstInfo, columnVar, dstInfo, (Variable)argField, op, pass, fail);
            cont.here();
        }
        Variable argVar = this.bytesField(argObjVar, argNum);
        if (ColumnFilter.isIn(op)) {
            CompareUtils.compareIn(this.mMaker, argVar, op, pass, fail, (a, p, f) -> this.compareQuickElement(srcVar, 0, decodedVars, a, p, f));
        } else {
            this.compareQuickElement(srcVar, op, decodedVars, argVar, pass, fail);
        }
    }

    private void compareQuickElement(Variable srcVar, int op, Variable[] decodedVars, Variable argVar, Label pass, Label fail) {
        Label match;
        Variable dataOffsetVar = decodedVars[0];
        Variable lengthVar = decodedVars[1];
        Variable isNullVar = decodedVars[2];
        Label notNull = this.mMaker.label();
        argVar.ifNe(null, notNull);
        Label mismatch = CompareUtils.selectColumnToNullArg(op, pass, fail);
        if (isNullVar != null && (match = CompareUtils.selectNullColumnToNullArg(op, pass, fail)) != mismatch) {
            isNullVar.ifTrue(match);
        }
        this.mMaker.goto_(mismatch);
        notNull.here();
        if (isNullVar != null) {
            isNullVar.ifTrue(CompareUtils.selectNullColumnToArg(op, pass, fail));
        }
        CompareUtils.compareArrays(this.mMaker, this.compareBytesUnsigned(), srcVar, dataOffsetVar, dataOffsetVar.add((Object)lengthVar), argVar, 0, argVar.alength(), op, pass, fail);
    }

    protected final void filterQuickCompareLex(ColumnInfo dstInfo, Variable srcVar, Variable offsetVar, Variable endVar, int op, Variable argObjVar, int argNum, Label pass, Label fail) {
        Variable argVar = this.bytesField(argObjVar, argNum);
        if (dstInfo.isDescending()) {
            op = ColumnFilter.descendingOperator(op);
        }
        if (ColumnFilter.isIn(op)) {
            CompareUtils.compareIn(this.mMaker, argVar, op, pass, fail, (a, p, f) -> CompareUtils.compareArrays(this.mMaker, true, srcVar, offsetVar, endVar, a, 0, a.alength(), 0, p, f));
        } else {
            CompareUtils.compareArrays(this.mMaker, true, srcVar, offsetVar, endVar, argVar, 0, argVar.alength(), op, pass, fail);
        }
    }

    private Variable bytesField(Variable argObjVar, int argNum) {
        String name = this.argFieldName(argNum, this.bytesFieldSuffix());
        boolean isFinal = true;
        try {
            isFinal = Modifier.isFinal(argObjVar.classType().getDeclaredField(name).getModifiers());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (isFinal) {
            return argObjVar.field(name).get();
        }
        return argObjVar.invoke(name, new Object[0]);
    }

    private String bytesFieldSuffix() {
        String name = this.getClass().getSimpleName();
        if (!name.endsWith("ColumnCodec")) {
            throw new AssertionError();
        }
        name = name.substring(0, name.length() - 11);
        return name;
    }
}

