/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Predicate;
import org.cojen.dirmi.Pipe;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.Table;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.ComparatorMaker;
import org.cojen.tupl.rows.PlainPredicateMaker;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowHeader;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowMaker;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.TableBasicsMaker;
import org.cojen.tupl.rows.TableMaker;
import org.cojen.tupl.rows.WeakCache;

public abstract class ClientTableHelper<R>
implements Table<R> {
    private static final WeakCache<Class<?>, ClientTableHelper<?>, Object> cCache = new WeakCache<Class<?>, ClientTableHelper<?>, Object>(){

        @Override
        protected ClientTableHelper<?> newValue(Class<?> rowType, Object unused) {
            return ClientTableHelper.make(rowType);
        }
    };

    public static <R> ClientTableHelper<R> find(Class<R> rowType) {
        return (ClientTableHelper)cCache.obtain((Object)rowType, (Object)null);
    }

    public abstract boolean load(R var1, Pipe var2) throws IOException;

    public abstract boolean exists(R var1, Pipe var2) throws IOException;

    public abstract void store(R var1, Pipe var2) throws IOException;

    public abstract R exchange(R var1, Pipe var2) throws IOException;

    public abstract boolean insert(R var1, Pipe var2) throws IOException;

    public abstract boolean replace(R var1, Pipe var2) throws IOException;

    public abstract boolean update(R var1, Pipe var2) throws IOException;

    public abstract boolean merge(R var1, Pipe var2) throws IOException;

    public abstract boolean delete(R var1, Pipe var2) throws IOException;

    public abstract boolean updaterRow(R var1, Pipe var2) throws IOException;

    public abstract boolean updaterStep(R var1, Pipe var2) throws IOException;

    public abstract boolean updaterUpdate(R var1, R var2, Pipe var3) throws IOException;

    public abstract boolean updaterDelete(R var1, R var2, Pipe var3) throws IOException;

    @Override
    public Comparator<R> comparator(String spec) {
        return ComparatorMaker.comparator(this.rowType(), spec);
    }

    @Override
    public Predicate<R> predicate(String query, Object ... args) {
        return PlainPredicateMaker.predicate(this.rowType(), query, args);
    }

    public abstract byte[] rowDescriptor();

    protected void writeAndRead(Pipe pipe, byte[] bytesVar) throws Throwable {
        try {
            pipe.write(bytesVar);
            pipe.flush();
        }
        catch (Throwable e) {
            this.fail(pipe, e);
            throw e;
        }
        this.readThrowable(pipe);
    }

    protected void flushAndRead(Pipe pipe) throws Throwable {
        try {
            pipe.flush();
        }
        catch (Throwable e) {
            this.fail(pipe, e);
            throw e;
        }
        this.readThrowable(pipe);
    }

    protected void readThrowable(Pipe pipe) throws Throwable {
        Object obj;
        try {
            obj = pipe.readThrowable();
        }
        catch (Throwable e) {
            this.fail(pipe, e);
            throw e;
        }
        if (obj instanceof Throwable) {
            e = (Throwable)obj;
            try {
                pipe.recycle();
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    protected void success(Pipe pipe) {
        try {
            pipe.recycle();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void fail(Pipe pipe, Throwable e) {
        try {
            pipe.close();
        }
        catch (Throwable e2) {
            e.addSuppressed(e2);
        }
    }

    private static ClientTableHelper<?> make(Class<?> rowType) {
        RowGen rowGen = RowInfo.find(rowType).rowGen();
        ClassMaker cm = rowGen.beginClassMaker(ClientTableHelper.class, rowType, null);
        cm.public_().extend(ClientTableHelper.class);
        cm.implement(TableBasicsMaker.find(rowType));
        cm.addConstructor(new Object[0]).private_();
        cm.addField(ClientTableHelper.class, "THE").private_().static_().final_();
        cm.addField(Boolean.TYPE, "assert").private_().static_().final_();
        MethodMaker mm = cm.addClinit();
        mm.field("THE").set((Object)mm.new_((Object)cm, new Object[0]));
        mm.field("assert").set((Object)mm.class_().invoke("desiredAssertionStatus", new Object[0]));
        mm = cm.addMethod(byte[].class, "rowDescriptor", new Object[0]).public_();
        Variable descVar = mm.var(byte[].class);
        descVar.setExact((Object)RowHeader.make(rowGen).encode(false));
        mm.return_((Object)descVar);
        Class<?> rowClass = RowMaker.find(rowType);
        ClientTableHelper.addEncodeMethods(cm, rowGen, rowClass);
        ClientTableHelper.addByKeyMethod("load", cm, rowGen, rowClass);
        ClientTableHelper.addByKeyMethod("exists", cm, rowGen, rowClass);
        ClientTableHelper.addByKeyMethod("delete", cm, rowGen, rowClass);
        ClientTableHelper.addStoreMethod("store", null, cm, rowGen, rowClass);
        ClientTableHelper.addStoreMethod("exchange", rowType, cm, rowGen, rowClass);
        ClientTableHelper.addStoreMethod("insert", Boolean.TYPE, cm, rowGen, rowClass);
        ClientTableHelper.addStoreMethod("replace", Boolean.TYPE, cm, rowGen, rowClass);
        ClientTableHelper.addUpdateMethod("update", cm, rowGen, rowClass);
        ClientTableHelper.addUpdateMethod("merge", cm, rowGen, rowClass);
        ClientTableHelper.addUpdaterAccessMethod("updaterRow", cm, rowGen, rowClass);
        ClientTableHelper.addUpdaterAccessMethod("updaterStep", cm, rowGen, rowClass);
        ClientTableHelper.addUpdaterModifyMethod("updaterUpdate", cm, rowGen, rowClass);
        ClientTableHelper.addUpdaterModifyMethod("updaterDelete", cm, rowGen, rowClass);
        MethodMaker mm2 = cm.addMethod(Object.class, "exchange", new Object[]{Object.class, Pipe.class}).public_().bridge();
        mm2.return_((Object)mm2.this_().invoke(rowType, "exchange", null, new Object[]{mm2.param(0), mm2.param(1)}));
        MethodHandles.Lookup lookup = cm.finishHidden();
        try {
            Class<?> clazz = lookup.lookupClass();
            VarHandle vh = lookup.findStaticVarHandle(clazz, "THE", ClientTableHelper.class);
            return vh.get();
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
    }

    private static void addEncodeMethods(ClassMaker cm, RowGen rowGen, Class<?> rowClass) {
        MethodMaker mm = cm.addMethod(byte[].class, "encodeKeyColumns", new Object[]{rowClass}).private_().static_();
        mm.return_((Object)ClientTableHelper.encodeColumns(rowGen, mm.param(0), true, false));
        mm = cm.addMethod(byte[].class, "encodeAllColumns", new Object[]{rowClass}).private_().static_();
        mm.return_((Object)ClientTableHelper.encodeColumns(rowGen, mm.param(0), false, false));
        mm = cm.addMethod(byte[].class, "encodeDirtyColumns", new Object[]{rowClass}).private_().static_();
        mm.return_((Object)ClientTableHelper.encodeColumns(rowGen, mm.param(0), false, true));
    }

    private static void addByKeyMethod(String variant, ClassMaker cm, RowGen rowGen, Class<?> rowClass) {
        MethodMaker mm = cm.addMethod(Boolean.TYPE, variant, new Object[]{Object.class, Pipe.class}).public_();
        Variable rowVar = mm.param(0).cast(rowClass);
        Variable pipeVar = mm.param(1);
        mm.invoke("writeAndRead", new Object[]{pipeVar, mm.invoke("encodeKeyColumns", new Object[]{rowVar})});
        Label tryStart = mm.label().here();
        Variable resultVar = pipeVar.invoke("readByte", new Object[0]);
        if (variant == "load") {
            Label notLoaded = mm.label();
            resultVar.ifEq((Object)0, notLoaded);
            ClientTableHelper.decodeValueColumns(rowGen, rowVar, pipeVar);
            TableMaker.markAllClean(rowVar, rowGen, rowGen);
            Label done = mm.label().goto_();
            notLoaded.here();
            rowGen.markNonPrimaryKeyColumnsUnset(rowVar);
            done.here();
        }
        mm.invoke("success", new Object[]{pipeVar});
        mm.return_((Object)resultVar.ne((Object)0));
        mm.catch_(tryStart, Throwable.class, exVar -> {
            mm.invoke("fail", new Object[]{pipeVar, exVar});
            exVar.throw_();
        });
    }

    private static void addStoreMethod(String variant, Class returnType, ClassMaker cm, RowGen rowGen, Class<?> rowClass) {
        MethodMaker mm = cm.addMethod((Object)returnType, variant, new Object[]{Object.class, Pipe.class}).public_();
        Variable rowVar = mm.param(0).cast(rowClass);
        Variable pipeVar = mm.param(1);
        mm.invoke("writeAndRead", new Object[]{pipeVar, mm.invoke("encodeAllColumns", new Object[]{rowVar})});
        Label tryStart = mm.label().here();
        Variable resultVar = pipeVar.invoke("readByte", new Object[0]);
        if (variant != "replace") {
            ColumnCodec[] codecs = rowGen.keyCodecs();
            ColumnInfo tailInfo = codecs[codecs.length - 1].mInfo;
            if (tailInfo.type == Integer.TYPE || tailInfo.type == Long.TYPE) {
                Label noAutoKey = mm.label();
                resultVar.ifNe((Object)2, noAutoKey);
                if (tailInfo.type == Integer.TYPE) {
                    rowVar.field(tailInfo.name).set((Object)pipeVar.invoke("readInt", new Object[0]));
                } else {
                    rowVar.field(tailInfo.name).set((Object)pipeVar.invoke("readLong", new Object[0]));
                }
                if (variant == "exchange") {
                    TableMaker.markAllClean(rowVar, rowGen, rowGen);
                    mm.invoke("success", new Object[]{pipeVar});
                    mm.return_(null);
                } else if (variant == "insert") {
                    TableMaker.markAllClean(rowVar, rowGen, rowGen);
                    mm.invoke("success", new Object[]{pipeVar});
                    mm.return_((Object)true);
                }
                noAutoKey.here();
            }
        }
        if (variant == "store") {
            TableMaker.markAllClean(rowVar, rowGen, rowGen);
            mm.invoke("success", new Object[]{pipeVar});
            mm.return_();
        } else if (variant == "exchange") {
            TableMaker.markAllClean(rowVar, rowGen, rowGen);
            Variable oldRowVar = mm.var(rowClass).set(null);
            Label noOldRow = mm.label();
            resultVar.ifEq((Object)0, noOldRow);
            oldRowVar.set((Object)mm.invoke("newRow", new Object[0]).cast(rowClass));
            TableMaker.copyFields(rowVar, oldRowVar, rowGen.info.keyColumns.values());
            ClientTableHelper.decodeValueColumns(rowGen, oldRowVar, pipeVar);
            TableMaker.markAllClean(oldRowVar, rowGen, rowGen);
            noOldRow.here();
            mm.invoke("success", new Object[]{pipeVar});
            mm.return_((Object)oldRowVar);
        } else {
            Label noOperation = mm.label();
            resultVar.ifEq((Object)0, noOperation);
            TableMaker.markAllClean(rowVar, rowGen, rowGen);
            noOperation.here();
            mm.invoke("success", new Object[]{pipeVar});
            mm.return_((Object)resultVar.ne((Object)0));
        }
        mm.catch_(tryStart, Throwable.class, exVar -> {
            mm.invoke("fail", new Object[]{pipeVar, exVar});
            exVar.throw_();
        });
    }

    private static void addUpdateMethod(String variant, ClassMaker cm, RowGen rowGen, Class<?> rowClass) {
        MethodMaker mm = cm.addMethod(Boolean.TYPE, variant, new Object[]{Object.class, Pipe.class}).public_();
        Variable rowVar = mm.param(0).cast(rowClass);
        Variable pipeVar = mm.param(1);
        mm.invoke("writeAndRead", new Object[]{pipeVar, mm.invoke("encodeDirtyColumns", new Object[]{rowVar})});
        Label tryStart = mm.label().here();
        Variable resultVar = pipeVar.invoke("readByte", new Object[0]);
        Label noOperation = mm.label();
        resultVar.ifEq((Object)0, noOperation);
        if (variant == "update") {
            TableMaker.markAllUndirty(rowVar, rowGen.info);
        } else {
            ClientTableHelper.decodeValueColumns(rowGen, rowVar, pipeVar);
            TableMaker.markAllClean(rowVar, rowGen, rowGen);
        }
        noOperation.here();
        mm.invoke("success", new Object[]{pipeVar});
        mm.return_((Object)resultVar.ne((Object)0));
        mm.catch_(tryStart, Throwable.class, exVar -> {
            mm.invoke("fail", new Object[]{pipeVar, exVar});
            exVar.throw_();
        });
    }

    private static void addUpdaterAccessMethod(String variant, ClassMaker cm, RowGen rowGen, Class<?> rowClass) {
        MethodMaker mm = cm.addMethod(Boolean.TYPE, variant, new Object[]{Object.class, Pipe.class}).public_();
        Variable rowVar = mm.param(0).cast(rowClass);
        Variable pipeVar = mm.param(1);
        mm.invoke("flushAndRead", new Object[]{pipeVar});
        Label tryStart = mm.label().here();
        Variable resultVar = pipeVar.invoke("readByte", new Object[0]);
        Label finish = mm.label();
        resultVar.ifEq((Object)0, finish);
        ClientTableHelper.decodeKeyColumns(rowGen, rowVar, pipeVar);
        pipeVar.invoke("skip", new Object[]{1});
        ClientTableHelper.decodeValueColumns(rowGen, rowVar, pipeVar);
        ClientTableHelper.decodeStateFields(rowGen, rowVar, pipeVar);
        finish.here();
        mm.invoke("success", new Object[]{pipeVar});
        mm.return_((Object)resultVar.ne((Object)0));
        mm.catch_(tryStart, Throwable.class, exVar -> {
            mm.invoke("fail", new Object[]{pipeVar, exVar});
            exVar.throw_();
        });
    }

    private static void addUpdaterModifyMethod(String variant, ClassMaker cm, RowGen rowGen, Class<?> rowClass) {
        MethodMaker mm = cm.addMethod(Boolean.TYPE, variant, new Object[]{Object.class, Object.class, Pipe.class}).public_();
        Variable rowVar = mm.param(0).cast(rowClass);
        Variable newRowVar = mm.param(1).cast(rowClass);
        Variable pipeVar = mm.param(2);
        if (variant == "updaterUpdate") {
            mm.invoke("writeAndRead", new Object[]{pipeVar, mm.invoke("encodeDirtyColumns", new Object[]{rowVar})});
        } else {
            mm.invoke("writeAndRead", new Object[]{pipeVar, mm.invoke("encodeKeyColumns", new Object[]{rowVar})});
        }
        Label tryStart = mm.label().here();
        Variable resultVar = pipeVar.invoke("readByte", new Object[0]);
        Label finish = mm.label();
        resultVar.ifEq((Object)0, finish);
        ClientTableHelper.decodeKeyColumns(rowGen, newRowVar, pipeVar);
        pipeVar.invoke("skip", new Object[]{1});
        ClientTableHelper.decodeValueColumns(rowGen, newRowVar, pipeVar);
        ClientTableHelper.decodeStateFields(rowGen, newRowVar, pipeVar);
        finish.here();
        mm.invoke("success", new Object[]{pipeVar});
        mm.return_((Object)resultVar.ne((Object)0));
        mm.catch_(tryStart, Throwable.class, exVar -> {
            mm.invoke("fail", new Object[]{pipeVar, exVar});
            exVar.throw_();
        });
    }

    private static void decodeKeyColumns(RowGen rowGen, Variable rowVar, Variable pipeVar) {
        ClientTableHelper.decodeColumns(rowGen.keyCodecs(), rowVar, pipeVar);
    }

    private static void decodeValueColumns(RowGen rowGen, Variable rowVar, Variable pipeVar) {
        ClientTableHelper.decodeColumns(rowGen.valueCodecs(), rowVar, pipeVar);
    }

    private static void decodeColumns(ColumnCodec[] codecs, Variable rowVar, Variable pipeVar) {
        MethodMaker mm = rowVar.methodMaker();
        Variable lengthVar = mm.var(RowUtils.class).invoke("decodePrefixPF", new Object[]{pipeVar});
        Variable bytesVar = mm.new_(byte[].class, new Object[]{lengthVar});
        pipeVar.invoke("readFully", new Object[]{bytesVar});
        codecs = ColumnCodec.bind(codecs, mm);
        Variable offsetVar = mm.var(Integer.TYPE).set((Object)0);
        for (ColumnCodec codec : codecs) {
            codec.decode((Variable)rowVar.field(codec.mInfo.name), bytesVar, offsetVar, null);
        }
    }

    private static void decodeStateFields(RowGen rowGen, Variable rowVar, Variable pipeVar) {
        for (String name : rowGen.stateFields()) {
            rowVar.field(name).set((Object)pipeVar.invoke("readInt", new Object[0]));
        }
    }

    private static Variable encodeColumns(RowGen rowGen, Variable rowVar, boolean keysOnly, boolean dirtyOnly) {
        MethodMaker mm = rowVar.methodMaker();
        ColumnCodec[] keyCodecs = ColumnCodec.bind(rowGen.keyCodecs(), mm);
        ColumnCodec[] valueCodecs = ColumnCodec.bind(rowGen.valueCodecs(), mm);
        Variable keyLengthVar = ClientTableHelper.calcLength(rowGen, rowVar, keyCodecs, false);
        Variable valueLengthVar = keysOnly ? null : ClientTableHelper.calcLength(rowGen, rowVar, valueCodecs, dirtyOnly);
        String[] stateFieldNames = rowGen.stateFields();
        Variable fullLengthVar = mm.var(Integer.TYPE).set((Object)(stateFieldNames.length << 2));
        Variable utilsVar = mm.var(RowUtils.class);
        fullLengthVar.inc((Object)keyLengthVar);
        fullLengthVar.inc((Object)utilsVar.invoke("lengthPrefixPF", new Object[]{keyLengthVar}));
        if (valueLengthVar == null) {
            fullLengthVar.inc((Object)1);
        } else {
            fullLengthVar.inc((Object)valueLengthVar);
            fullLengthVar.inc((Object)utilsVar.invoke("lengthPrefixPF", new Object[]{valueLengthVar}));
        }
        Variable bytesVar = mm.new_(byte[].class, new Object[]{fullLengthVar});
        Variable offsetVar = mm.var(Integer.TYPE).set((Object)0);
        if (valueLengthVar != null || valueCodecs.length == 0) {
            if (!dirtyOnly) {
                for (String name : stateFieldNames) {
                    utilsVar.invoke("encodeIntBE", new Object[]{bytesVar, offsetVar, rowVar.field(name)});
                    offsetVar.inc((Object)4);
                }
            } else {
                int mask = -1431655766;
                int keysRemaining = keyCodecs.length;
                for (int i = 0; i < stateFieldNames.length; ++i) {
                    Variable stateVar = rowVar.field(stateFieldNames[i]).get();
                    if (keysRemaining < 16) {
                        int andMask = 0xAAAAAAAA | (4 << (keysRemaining - 1 << 1)) - 1;
                        stateVar.set((Object)stateVar.and((Object)andMask).or((Object)stateVar.and((Object)-1431655766).ushr((Object)1)));
                    } else {
                        Variable maskedStateVar = stateVar.and((Object)-1431655766);
                        stateVar.set((Object)maskedStateVar.or((Object)maskedStateVar.ushr((Object)1)));
                    }
                    utilsVar.invoke("encodeIntBE", new Object[]{bytesVar, offsetVar, stateVar});
                    offsetVar.inc((Object)4);
                    keysRemaining -= 16;
                }
            }
        } else {
            int keysRemaining = keyCodecs.length;
            for (int i = 0; i < stateFieldNames.length; ++i) {
                if (keysRemaining <= 0) {
                    offsetVar.inc((Object)(4 * (stateFieldNames.length - i)));
                    break;
                }
                Field stateVar = rowVar.field(stateFieldNames[i]);
                if (keysRemaining < 16) {
                    int mask = (4 << (keysRemaining - 1 << 1)) - 1;
                    stateVar = stateVar.and((Object)mask);
                }
                utilsVar.invoke("encodeIntBE", new Object[]{bytesVar, offsetVar, stateVar});
                offsetVar.inc((Object)4);
                keysRemaining -= 16;
            }
        }
        offsetVar.set((Object)utilsVar.invoke("encodePrefixPF", new Object[]{bytesVar, offsetVar, keyLengthVar}));
        ClientTableHelper.encodeColumns(rowGen, rowVar, bytesVar, offsetVar, keyCodecs, false);
        if (valueLengthVar != null) {
            offsetVar.set((Object)utilsVar.invoke("encodePrefixPF", new Object[]{bytesVar, offsetVar, valueLengthVar}));
            ClientTableHelper.encodeColumns(rowGen, rowVar, bytesVar, offsetVar, valueCodecs, dirtyOnly);
        }
        Label cont = mm.label();
        mm.field("assert").ifFalse(cont);
        if (valueLengthVar == null) {
            offsetVar.inc((Object)1);
        }
        offsetVar.ifEq((Object)bytesVar.alength(), cont);
        mm.new_(AssertionError.class, new Object[]{mm.concat(new Object[]{offsetVar, " != ", bytesVar.alength()}), null}).throw_();
        cont.here();
        return bytesVar;
    }

    private static Variable calcLength(RowGen rowGen, Variable rowVar, ColumnCodec[] codecs, boolean dirtyOnly) {
        MethodMaker mm = rowVar.methodMaker();
        Variable totalVar = mm.var(Integer.TYPE).set((Object)0);
        if (codecs.length == 0) {
            return totalVar;
        }
        Map<String, Integer> columnNumbers = rowGen.columnNumbers();
        String stateFieldName = null;
        Variable stateField = null;
        for (int i = 0; i < codecs.length; ++i) {
            ColumnCodec codec = codecs[i];
            codec.encodePrepare();
            ColumnInfo info = codec.mInfo;
            int num = columnNumbers.get(info.name);
            String sfName = rowGen.stateField(num);
            if (!sfName.equals(stateFieldName)) {
                stateFieldName = sfName;
                stateField = rowVar.field(stateFieldName).get();
            }
            int sfMask = RowGen.stateFieldMask(num);
            Label included = mm.label();
            Variable masked = stateField.and((Object)sfMask);
            if (dirtyOnly) {
                masked.ifEq((Object)sfMask, included);
            } else {
                masked.ifNe((Object)0, included);
            }
            codec.encodeSkip();
            Label cont = mm.label().goto_();
            included.here();
            int minSize = codec.minSize();
            if (minSize != 0) {
                totalVar.inc((Object)minSize);
            }
            codec.encodeSize((Variable)rowVar.field(info.name), totalVar);
            cont.here();
        }
        return totalVar;
    }

    private static void encodeColumns(RowGen rowGen, Variable rowVar, Variable bytesVar, Variable offsetVar, ColumnCodec[] codecs, boolean dirtyOnly) {
        if (codecs.length == 0) {
            return;
        }
        MethodMaker mm = rowVar.methodMaker();
        Map<String, Integer> columnNumbers = rowGen.columnNumbers();
        String stateFieldName = null;
        Variable stateField = null;
        for (int i = 0; i < codecs.length; ++i) {
            ColumnCodec codec = codecs[i];
            ColumnInfo info = codec.mInfo;
            int num = columnNumbers.get(info.name);
            String sfName = rowGen.stateField(num);
            if (!sfName.equals(stateFieldName)) {
                stateFieldName = sfName;
                stateField = rowVar.field(stateFieldName).get();
            }
            int sfMask = RowGen.stateFieldMask(num);
            Label skip = mm.label();
            Variable masked = stateField.and((Object)sfMask);
            if (dirtyOnly) {
                masked.ifNe((Object)sfMask, skip);
            } else {
                masked.ifEq((Object)0, skip);
            }
            codec.encode(rowVar.field(info.name).get(), bytesVar, offsetVar);
            skip.here();
        }
    }
}

