/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.cojen.maker.FieldMaker;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.filter.ColumnFilter;
import org.cojen.tupl.rows.BigDecimalColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.CompareUtils;
import org.cojen.tupl.rows.LexBigDecimalColumnCodec;
import org.cojen.tupl.rows.LexBigIntegerColumnCodec;
import org.cojen.tupl.rows.LexPrimitiveArrayColumnCodec;
import org.cojen.tupl.rows.LexStringColumnCodec;
import org.cojen.tupl.rows.NonNullBigIntegerColumnCodec;
import org.cojen.tupl.rows.NonNullLastBigIntegerColumnCodec;
import org.cojen.tupl.rows.NonNullLastPrimitiveArrayColumnCodec;
import org.cojen.tupl.rows.NonNullLastStringColumnCodec;
import org.cojen.tupl.rows.NonNullPrimitiveArrayColumnCodec;
import org.cojen.tupl.rows.NonNullStringColumnCodec;
import org.cojen.tupl.rows.NullableBigIntegerColumnCodec;
import org.cojen.tupl.rows.NullableLastBigIntegerColumnCodec;
import org.cojen.tupl.rows.NullableLastPrimitiveArrayColumnCodec;
import org.cojen.tupl.rows.NullableLastStringColumnCodec;
import org.cojen.tupl.rows.NullablePrimitiveArrayColumnCodec;
import org.cojen.tupl.rows.NullableStringColumnCodec;
import org.cojen.tupl.rows.PrimitiveColumnCodec;
import org.cojen.tupl.rows.RowHeader;
import org.cojen.tupl.rows.SchemaVersionColumnCodec;

abstract class ColumnCodec {
    static final int F_LAST = 1;
    static final int F_LEX = 2;
    final ColumnInfo mInfo;
    final MethodMaker mMaker;

    static ColumnCodec[] make(Map<String, ColumnInfo> infoMap, int flags) {
        return ColumnCodec.make(infoMap.values(), flags);
    }

    static ColumnCodec[] make(Collection<ColumnInfo> infos, int flags) {
        ColumnCodec[] codecs = new ColumnCodec[infos.size()];
        if (codecs.length != 0) {
            int slot = 0;
            Iterator<ColumnInfo> it = infos.iterator();
            ColumnInfo info = it.next();
            while (true) {
                boolean hasNext = it.hasNext();
                codecs[slot++] = ColumnCodec.make(info, hasNext ? flags : flags | 1);
                if (!hasNext) break;
                info = it.next();
            }
        }
        return codecs;
    }

    static ColumnCodec[] make(Collection<ColumnInfo> infos, Map<String, ColumnCodec> pkCodecs) {
        ColumnCodec[] codecs = new ColumnCodec[infos.size()];
        if (codecs.length != 0) {
            int slot = 0;
            Iterator<ColumnInfo> it = infos.iterator();
            ColumnInfo info = it.next();
            while (true) {
                boolean hasNext;
                ColumnCodec codec = ColumnCodec.make(info, (hasNext = it.hasNext()) ? 0 : 1);
                ColumnCodec pkCodec = pkCodecs.get(info.name);
                if (pkCodec != null && (pkCodec.equals(codec) || !pkCodec.isLast() || codec.isLast())) {
                    codec = pkCodec;
                }
                codecs[slot++] = codec;
                if (!hasNext) break;
                info = it.next();
            }
        }
        return codecs;
    }

    static ColumnCodec[] make(RowHeader header) {
        int numColumns = header.columnNames.length;
        ColumnCodec[] codecs = new ColumnCodec[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            ColumnInfo info = new ColumnInfo();
            info.name = header.columnNames[i];
            info.typeCode = header.columnTypes[i];
            info.assignType();
            codecs[i] = ColumnCodec.make(info, header.columnFlags[i]);
        }
        return codecs;
    }

    private static ColumnCodec make(ColumnInfo info, int flags) {
        int typeCode = info.typeCode;
        if (ColumnInfo.isArray(typeCode)) {
            if (!ColumnInfo.isPrimitive(ColumnInfo.plainTypeCode(typeCode))) {
                throw new AssertionError();
            }
            if ((flags & 1) != 0 && !info.isDescending()) {
                if (info.isNullable()) {
                    return new NullableLastPrimitiveArrayColumnCodec(info, null, flags);
                }
                return new NonNullLastPrimitiveArrayColumnCodec(info, null, flags);
            }
            if ((flags & 2) != 0) {
                return new LexPrimitiveArrayColumnCodec(info, null);
            }
            if (info.isNullable()) {
                return new NullablePrimitiveArrayColumnCodec(info, null);
            }
            return new NonNullPrimitiveArrayColumnCodec(info, null);
        }
        if ((typeCode = ColumnInfo.plainTypeCode(typeCode)) <= 15) {
            int bitSize = 1 << (typeCode & 7);
            return new PrimitiveColumnCodec(info, null, flags, bitSize + 7 >>> 3);
        }
        switch (typeCode) {
            case 17: {
                return new PrimitiveColumnCodec(info, null, flags, 4);
            }
            case 18: {
                return new PrimitiveColumnCodec(info, null, flags, 8);
            }
            case 20: {
                return new PrimitiveColumnCodec(info, null, flags, 2);
            }
            case 24: {
                if ((flags & 1) != 0 && !info.isDescending()) {
                    if (info.isNullable()) {
                        return new NullableLastStringColumnCodec(info, null);
                    }
                    return new NonNullLastStringColumnCodec(info, null);
                }
                if ((flags & 2) != 0) {
                    return new LexStringColumnCodec(info, null);
                }
                if (info.isNullable()) {
                    return new NullableStringColumnCodec(info, null);
                }
                return new NonNullStringColumnCodec(info, null);
            }
            case 28: {
                if ((flags & 2) != 0) {
                    return new LexBigIntegerColumnCodec(info, null);
                }
                if ((flags & 1) != 0) {
                    if (info.isNullable()) {
                        return new NullableLastBigIntegerColumnCodec(info, null);
                    }
                    return new NonNullLastBigIntegerColumnCodec(info, null);
                }
                if (info.isNullable()) {
                    return new NullableBigIntegerColumnCodec(info, null);
                }
                return new NonNullBigIntegerColumnCodec(info, null);
            }
            case 29: {
                if ((flags & 2) != 0) {
                    return new LexBigDecimalColumnCodec(info, null);
                }
                ColumnInfo unscaledInfo = info.copy();
                unscaledInfo.type = BigInteger.class;
                unscaledInfo.typeCode = 28;
                ColumnCodec unscaledCodec = ColumnCodec.make(unscaledInfo, flags);
                return new BigDecimalColumnCodec(info, unscaledCodec, null);
            }
        }
        throw new AssertionError();
    }

    ColumnCodec(ColumnInfo info, MethodMaker mm) {
        this.mInfo = info;
        this.mMaker = mm;
    }

    static ColumnCodec[] bind(ColumnCodec[] codecs, MethodMaker mm) {
        if (codecs.length != 0) {
            codecs = (ColumnCodec[])codecs.clone();
            for (int i = 0; i < codecs.length; ++i) {
                codecs[i] = codecs[i].bind(mm);
            }
        }
        return codecs;
    }

    static ColumnCodec[] bind(int schemaVersion, ColumnCodec[] codecs, MethodMaker mm) {
        if (codecs.length == 0) {
            return codecs;
        }
        ColumnCodec[] copy = new ColumnCodec[1 + codecs.length];
        copy[0] = new SchemaVersionColumnCodec(schemaVersion, mm);
        for (int i = 0; i < codecs.length; ++i) {
            copy[1 + i] = codecs[i].bind(mm);
        }
        return copy;
    }

    abstract ColumnCodec bind(MethodMaker var1);

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            return this.doEquals(obj);
        }
        return false;
    }

    public final int hashCode() {
        int hash = this.mInfo == null ? 0 : Objects.hashCode(this.mInfo.name);
        return this.doHashCode() * 31 + hash ^ this.getClass().hashCode();
    }

    protected abstract boolean doEquals(Object var1);

    protected final boolean equalOrdering(Object obj) {
        ColumnCodec other = (ColumnCodec)obj;
        return this.mInfo.isDescending() == other.mInfo.isDescending() && this.mInfo.isNullLow() == other.mInfo.isNullLow();
    }

    protected abstract int doHashCode();

    abstract int codecFlags();

    final boolean isLast() {
        return (this.codecFlags() & 1) != 0;
    }

    final boolean isLex() {
        return (this.codecFlags() & 2) != 0;
    }

    abstract int minSize();

    abstract void encodePrepare();

    abstract void encodeSkip();

    abstract Variable encodeSize(Variable var1, Variable var2);

    abstract void encode(Variable var1, Variable var2, Variable var3);

    abstract void decode(Variable var1, Variable var2, Variable var3, Variable var4);

    abstract void decodeSkip(Variable var1, Variable var2, Variable var3);

    void filterDefineExtraFields(boolean in, Variable argVar, String argFieldName) {
    }

    boolean canFilterQuick(ColumnInfo dstInfo) {
        return false;
    }

    Object filterQuickDecode(ColumnInfo dstInfo, Variable srcVar, Variable offsetVar, Variable endVar) {
        throw new UnsupportedOperationException();
    }

    void filterQuickCompare(ColumnInfo dstInfo, Variable srcVar, Variable offsetVar, int op, Object decoded, Variable argObjVar, int argNum, Label pass, Label fail) {
        throw new UnsupportedOperationException();
    }

    static String argFieldName(String colName, int argNum) {
        return colName + "$" + argNum;
    }

    static String argFieldName(ColumnInfo info, int argNum) {
        return ColumnCodec.argFieldName(info.name, argNum);
    }

    final String argFieldName(int argNum) {
        return ColumnCodec.argFieldName(this.mInfo, argNum);
    }

    final String argFieldName(int argNum, String suffix) {
        return ColumnCodec.argFieldName(this.argFieldName(argNum), suffix);
    }

    static String argFieldName(String base, String suffix) {
        return base + "$" + suffix;
    }

    final void defineArgField(Object type, String name, Variable initVar) {
        this.defineArgField(type, name).final_();
        this.mMaker.field(name).set((Object)initVar);
    }

    final FieldMaker defineArgField(Object type, String name) {
        return this.mMaker.classMaker().addField(type, name);
    }

    protected final Variable accum(Variable accumVar, Object amount) {
        if (accumVar == null) {
            accumVar = this.mMaker.var(Integer.TYPE).set(amount);
        } else {
            accumVar.inc(amount);
        }
        return accumVar;
    }

    protected final byte nullByte() {
        return this.mInfo.isDescending() == this.mInfo.isNullLow() ? (byte)-1 : 0;
    }

    protected final byte notNullByte() {
        return this.mInfo.isDescending() == this.mInfo.isNullLow() ? (byte)-128 : 127;
    }

    protected final void encodeNullHeaderIfNull(Label end, Variable srcVar, Variable dstVar, Variable offsetVar) {
        Label notNull = this.mMaker.label();
        srcVar.ifNe(null, notNull);
        byte nb = this.nullByte();
        if (offsetVar == null) {
            dstVar.aset((Object)0, (Object)nb);
        } else {
            dstVar.aset((Object)offsetVar, (Object)nb);
            offsetVar.inc((Object)1);
        }
        this.mMaker.goto_(end);
        notNull.here();
    }

    protected final void encodeNullHeader(Label end, Variable srcVar, Variable dstVar, Variable offsetVar) {
        this.encodeNullHeaderIfNull(end, srcVar, dstVar, offsetVar);
        dstVar.aset((Object)offsetVar, (Object)this.notNullByte());
        offsetVar.inc((Object)1);
    }

    protected final void decodeNullHeader(Label end, Variable dstVar, Variable srcVar, Variable offsetVar) {
        Variable header = srcVar.aget((Object)offsetVar);
        offsetVar.inc((Object)1);
        byte nullHeader = this.nullByte();
        if (dstVar == null) {
            header.ifEq((Object)nullHeader, end);
        } else if (dstVar.classType() == Boolean.TYPE) {
            dstVar.set((Object)header.eq((Object)nullHeader));
        } else {
            Label notNull = this.mMaker.label();
            header.ifNe((Object)nullHeader, notNull);
            dstVar.set(null);
            this.mMaker.goto_(end);
            notNull.here();
        }
    }

    protected final void compareNullHeader(Variable srcVar, Variable offsetVar, Variable argVar, int op, Label pass, Label fail) {
        Label isColumnNull = this.mMaker.label();
        if (srcVar.classType() == Boolean.TYPE) {
            srcVar.ifTrue(isColumnNull);
        } else {
            this.decodeNullHeader(isColumnNull, null, srcVar, offsetVar);
        }
        Label match = CompareUtils.selectColumnToNullArg(op, pass, fail);
        if (argVar.classType() == Boolean.TYPE) {
            argVar.ifTrue(match);
        } else {
            argVar.ifEq(null, match);
        }
        Label cont = this.mMaker.label().goto_();
        isColumnNull.here();
        match = CompareUtils.selectNullColumnToNullArg(op, pass, fail);
        if (ColumnFilter.isIn(op)) {
            if (argVar.classType() == Boolean.TYPE) {
                argVar.ifTrue(match);
            } else {
                argVar.ifEq(null, match);
            }
            CompareUtils.compareIn(this.mMaker, argVar, op, pass, fail, (a, p, f) -> a.ifEq(null, p));
        } else {
            Label mismatch = CompareUtils.selectNullColumnToArg(op, pass, fail);
            if (match != mismatch) {
                if (argVar.classType() == Boolean.TYPE) {
                    argVar.ifTrue(match);
                } else {
                    argVar.ifEq(null, match);
                }
            }
            this.mMaker.goto_(mismatch);
        }
        cont.here();
    }
}

