/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ColumnInfo
implements Cloneable {
    public static final int TYPE_BOOLEAN = 0;
    public static final int TYPE_UBYTE = 3;
    public static final int TYPE_USHORT = 4;
    public static final int TYPE_UINT = 5;
    public static final int TYPE_ULONG = 6;
    public static final int TYPE_BYTE = 11;
    public static final int TYPE_SHORT = 12;
    public static final int TYPE_INT = 13;
    public static final int TYPE_LONG = 14;
    public static final int TYPE_FLOAT = 17;
    public static final int TYPE_DOUBLE = 18;
    public static final int TYPE_CHAR = 20;
    public static final int TYPE_UTF8 = 24;
    public static final int TYPE_BIG_INTEGER = 28;
    public static final int TYPE_BIG_DECIMAL = 29;
    public static final int TYPE_NULL_LOW = 256;
    public static final int TYPE_DESCENDING = 128;
    public static final int TYPE_NULLABLE = 64;
    public static final int TYPE_ARRAY = 32;
    public String name;
    public Class<?> type;
    public int typeCode;
    Method accessor;
    Method mutator;
    boolean hidden;
    long autoMin;
    long autoMax;

    boolean isAutomatic() {
        return this.autoMin != this.autoMax;
    }

    public int plainTypeCode() {
        return ColumnInfo.plainTypeCode(this.typeCode);
    }

    static int plainTypeCode(int typeCode) {
        return typeCode & 0x1F;
    }

    public int unorderedTypeCode() {
        return ColumnInfo.unorderedTypeCode(this.typeCode);
    }

    static int unorderedTypeCode(int typeCode) {
        return typeCode & 0xFFFFFF7F;
    }

    boolean isUnsigned() {
        return ColumnInfo.isUnsigned(this.typeCode);
    }

    static boolean isUnsigned(int typeCode) {
        return ColumnInfo.plainTypeCode(typeCode) < 8;
    }

    boolean isUnsignedInteger() {
        return ColumnInfo.isUnsignedInteger(this.typeCode);
    }

    static boolean isUnsignedInteger(int typeCode) {
        return ColumnInfo.isUnsigned(typeCode) && ColumnInfo.plainTypeCode(typeCode) != 0;
    }

    boolean isNullLow() {
        return ColumnInfo.isNullLow(this.typeCode);
    }

    static boolean isNullLow(int typeCode) {
        return (typeCode & 0x100) != 0;
    }

    public boolean isDescending() {
        return ColumnInfo.isDescending(this.typeCode);
    }

    static boolean isDescending(int typeCode) {
        return (typeCode & 0x80) != 0;
    }

    boolean isNullable() {
        return ColumnInfo.isNullable(this.typeCode);
    }

    static boolean isNullable(int typeCode) {
        return (typeCode & 0x40) != 0;
    }

    boolean isArray() {
        return ColumnInfo.isArray(this.typeCode);
    }

    static boolean isArray(int typeCode) {
        return (typeCode & 0x20) != 0;
    }

    boolean isPrimitive() {
        return ColumnInfo.isPrimitive(this.typeCode);
    }

    static boolean isPrimitive(int typeCode) {
        return (typeCode & 0xFFFFFF7F) < 24;
    }

    static boolean isFloat(int typeCode) {
        return 16 <= typeCode && typeCode <= 19;
    }

    public void assignType() {
        this.type = !this.isArray() ? (this.isNullable() ? this.boxedType() : this.unboxedType()) : this.unboxedType().arrayType();
    }

    Class<?> boxedType() {
        return switch (this.plainTypeCode()) {
            case 0 -> Boolean.class;
            case 3, 11 -> Byte.class;
            case 4, 12 -> Short.class;
            case 5, 13 -> Integer.class;
            case 6, 14 -> Long.class;
            case 17 -> Float.class;
            case 18 -> Double.class;
            case 24 -> String.class;
            case 28 -> BigInteger.class;
            case 29 -> BigDecimal.class;
            case 20 -> Character.class;
            default -> Object.class;
        };
    }

    Class<?> unboxedType() {
        return switch (this.plainTypeCode()) {
            case 0 -> Boolean.TYPE;
            case 3, 11 -> Byte.TYPE;
            case 4, 12 -> Short.TYPE;
            case 5, 13 -> Integer.TYPE;
            case 6, 14 -> Long.TYPE;
            case 17 -> Float.TYPE;
            case 18 -> Double.TYPE;
            case 24 -> String.class;
            case 28 -> BigInteger.class;
            case 29 -> BigDecimal.class;
            case 20 -> Character.TYPE;
            default -> Object.class;
        };
    }

    boolean isCompatibleWith(ColumnInfo other) {
        return (this.typeCode & 0x7F) == (other.typeCode & 0x7F);
    }

    boolean isAssignableFrom(ColumnInfo other) {
        if (this.typeCode == other.typeCode) {
            return true;
        }
        if (other.isArray() && !this.isArray()) {
            return false;
        }
        if (other.isNullable() && !this.isNullable()) {
            return false;
        }
        return this.isAssignableFrom(other.plainTypeCode());
    }

    boolean isAssignableFrom(int otherPlainTypeCode) {
        int thisPlainTypeCode = this.plainTypeCode();
        if (thisPlainTypeCode == otherPlainTypeCode) {
            return true;
        }
        return switch (thisPlainTypeCode) {
            case 12 -> {
                if (otherPlainTypeCode == 11) {
                    yield true;
                }
                yield false;
            }
            case 13, 17 -> {
                switch (otherPlainTypeCode) {
                    case 11: 
                    case 12: 
                    case 20: {
                        yield true;
                    }
                }
                yield false;
            }
            case 14 -> {
                switch (otherPlainTypeCode) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 20: {
                        yield true;
                    }
                }
                yield false;
            }
            case 18 -> {
                switch (otherPlainTypeCode) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 17: 
                    case 20: {
                        yield true;
                    }
                }
                yield false;
            }
            default -> false;
        };
    }

    ColumnInfo copy() {
        try {
            return (ColumnInfo)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    ColumnInfo nonArray() {
        ColumnInfo info = new ColumnInfo();
        info.name = this.name;
        info.typeCode = this.typeCode & 0xFFFFFF9F;
        if (this.type == null) {
            info.assignType();
        } else {
            info.type = this.type.componentType();
        }
        return info;
    }

    ColumnInfo asArray(boolean nullable) {
        ColumnInfo info = new ColumnInfo();
        info.name = this.name;
        info.typeCode = this.typeCode | 0x20;
        info.typeCode = nullable ? (info.typeCode |= 0x40) : (info.typeCode &= 0xFFFFFFBF);
        if (this.type == null) {
            info.assignType();
        } else {
            info.type = this.type.arrayType();
        }
        return info;
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.typeCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ColumnInfo)) return false;
        ColumnInfo other = (ColumnInfo)obj;
        if (this.typeCode != other.typeCode) return false;
        if (!this.name.equals(other.name)) return false;
        return true;
    }

    public String toString() {
        String typeName = this.type == null ? null : this.type.getSimpleName();
        return (String)(this.typeCode != -1 && this.isDescending() ? "-" + this.name : this.name) + "(" + typeName + "," + this.typeCode + ")";
    }
}

