/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.SecondaryInfo;

class ColumnSet {
    NavigableMap<String, ColumnInfo> allColumns;
    NavigableMap<String, ColumnInfo> valueColumns;
    Map<String, ColumnInfo> keyColumns;

    ColumnSet() {
    }

    final boolean matches(ColumnSet other) {
        return ColumnSet.matches(this.allColumns, other.allColumns) && ColumnSet.matches(this.valueColumns, other.valueColumns) && ColumnSet.matches(this.keyColumns, other.keyColumns);
    }

    private static <K, V> boolean matches(Map<K, V> a, Map<K, V> b) {
        if (a.size() == b.size()) {
            Iterator<Map.Entry<K, V>> ai = a.entrySet().iterator();
            Iterator<Map.Entry<K, V>> bi = b.entrySet().iterator();
            while (ai.hasNext()) {
                if (ai.next().equals(bi.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    String[] keySpec() {
        return ColumnSet.fullSpec(this.keyColumns.values(), Collections.emptySet());
    }

    String[] fullSpec() {
        return ColumnSet.fullSpec(this.keyColumns.values(), this.valueColumns.values());
    }

    private static String[] fullSpec(Collection<ColumnInfo> keys, Collection<ColumnInfo> values) {
        String[] spec = new String[keys.size() + values.size()];
        int i = 0;
        for (ColumnInfo column : keys) {
            Object name = column.name;
            name = (column.isDescending() ? (char)'-' : '+') + (String)name;
            spec[i++] = name;
        }
        for (ColumnInfo column : values) {
            spec[i++] = column.name;
        }
        return spec;
    }

    String indexSpec() {
        return this.appendIndexSpec(new StringBuilder(this.keyColumns.size() << 1)).toString();
    }

    StringBuilder appendIndexSpec(StringBuilder bob) {
        SecondaryInfo info;
        for (ColumnInfo ci : this.keyColumns.values()) {
            bob.append(ci.isDescending() ? (char)'-' : '+');
            if (ci.isNullLow()) {
                bob.append('!');
            }
            bob.append(ci.name);
        }
        ColumnSet columnSet = this;
        if (columnSet instanceof SecondaryInfo && !(info = (SecondaryInfo)columnSet).isAltKey() && !this.valueColumns.isEmpty()) {
            bob.append('|');
            for (ColumnInfo ci : this.valueColumns.values()) {
                bob.append('~').append(ci.name);
            }
        }
        return bob;
    }

    public String toString() {
        return this.keyColumns.values() + " -> " + this.valueColumns.values() + ", allColumns: " + this.allColumns.values();
    }
}

