/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.ColumnSet;

class ColumnSetComparator
implements Comparator<ColumnSet> {
    static final ColumnSetComparator THE = new ColumnSetComparator(false);
    private final boolean mUnspecifiedIsEqual;

    ColumnSetComparator(boolean unspecifiedIsEqual) {
        this.mUnspecifiedIsEqual = unspecifiedIsEqual;
    }

    @Override
    public int compare(ColumnSet a, ColumnSet b) {
        if (a == b) {
            return 0;
        }
        int compare = this.compareColumns(a.keyColumns, b.keyColumns);
        if (compare == 0) {
            compare = this.compareColumns(a.valueColumns, b.valueColumns);
        }
        return compare;
    }

    private int compareColumns(Map<String, ColumnInfo> a, Map<String, ColumnInfo> b) {
        if (a.size() < b.size()) {
            return -1;
        }
        if (a.size() > b.size()) {
            return 1;
        }
        Iterator<ColumnInfo> ait = a.values().iterator();
        Iterator<ColumnInfo> bit = b.values().iterator();
        while (ait.hasNext()) {
            ColumnInfo ainfo = ait.next();
            ColumnInfo binfo = bit.next();
            int compare = ainfo.name.compareTo(binfo.name);
            if (compare != 0) {
                return compare;
            }
            if (this.mUnspecifiedIsEqual && (ainfo.typeCode == -1 || binfo.typeCode == -1) || (compare = Integer.compare(ainfo.typeCode, binfo.typeCode)) == 0) continue;
            return compare;
        }
        return 0;
    }
}

