/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.core.Pair;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.OrderBy;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowMaker;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.WeakCache;

final class ComparatorMaker<R> {
    private static final WeakCache<Pair<Class<?>, String>, Comparator<?>, Object> cCache = new WeakCache<Pair<Class<?>, String>, Comparator<?>, Object>(){

        @Override
        public Comparator<?> newValue(Pair<Class<?>, String> key, Object unused) {
            ComparatorMaker maker;
            String clean;
            Class<?> rowType = key.a();
            String spec = key.b();
            if (spec.equals(clean = (maker = new ComparatorMaker(rowType, spec)).cleanSpec())) {
                return maker.finish();
            }
            return (Comparator)this.obtain(new Pair(rowType, clean), (Object)null);
        }
    };
    private final Class<R> mRowType;
    private final RowInfo mRowInfo;
    private final OrderBy mOrderBy;

    public static <R> Comparator<R> comparator(Class<R> rowType, String spec) {
        return (Comparator)cCache.obtain((Object)new Pair<Class<R>, String>(rowType, spec), (Object)null);
    }

    ComparatorMaker(Class<R> rowType) {
        this.mRowType = rowType;
        this.mRowInfo = RowInfo.find(rowType);
        this.mOrderBy = OrderBy.forPrimaryKey(this.mRowInfo);
    }

    ComparatorMaker(Class<R> rowType, String spec) {
        this.mRowType = rowType;
        this.mRowInfo = RowInfo.find(rowType);
        this.mOrderBy = OrderBy.forSpec(this.mRowInfo, spec);
    }

    String cleanSpec() {
        return this.mOrderBy.spec();
    }

    Comparator<R> finish() {
        Class<R> rowClass = RowMaker.find(this.mRowType);
        ClassMaker cm = this.mRowInfo.rowGen().anotherClassMaker(ComparatorMaker.class, rowClass, "comparator").implement(Comparator.class).final_();
        cm.addField(Comparator.class, "THE").private_().static_();
        MethodMaker mm = cm.addConstructor(new Object[0]).private_();
        mm.invokeSuperConstructor(new Object[0]);
        mm.field("THE").set((Object)mm.this_());
        this.makeCompare(cm.addMethod(Integer.TYPE, "compare", new Object[]{rowClass, rowClass}).public_());
        mm = cm.addMethod(Integer.TYPE, "compare", new Object[]{this.mRowType, this.mRowType}).public_().bridge();
        mm.return_((Object)mm.invoke("compare", new Object[]{mm.param(0).cast(rowClass), mm.param(1).cast(rowClass)}));
        mm = cm.addMethod(Integer.TYPE, "compare", new Object[]{Object.class, Object.class}).public_().bridge();
        mm.return_((Object)mm.invoke("compare", new Object[]{mm.param(0).cast(rowClass), mm.param(1).cast(rowClass)}));
        try {
            MethodHandles.Lookup lookup = cm.finishHidden();
            MethodHandle mh = lookup.findConstructor(lookup.lookupClass(), MethodType.methodType(Void.TYPE));
            return mh.invoke();
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
    }

    void makeCompare(MethodMaker mm) {
        Variable row0 = mm.param(0);
        Variable row1 = mm.param(1);
        Iterator it = this.mOrderBy.values().iterator();
        while (it.hasNext()) {
            Variable resultVar;
            OrderBy.Rule rule = (OrderBy.Rule)it.next();
            ColumnInfo column = rule.column();
            Field field0 = row0.field(column.name);
            Field field1 = row1.field(column.name);
            if (rule.isDescending()) {
                Field temp = field0;
                field0 = field1;
                field1 = temp;
            }
            Label nextLabel = mm.label();
            if (column.isPrimitive()) {
                String compareName = column.isUnsignedInteger() ? "compareUnsigned" : "compare";
                resultVar = field0.invoke(compareName, new Object[]{field0, field1});
            } else {
                field0 = field0.get();
                field1 = field1.get();
                Label cont = mm.label();
                field0.ifNe(null, cont);
                field1.ifEq(null, nextLabel);
                mm.return_((Object)(rule.isNullLow() ? -1 : 1));
                cont.here();
                cont = mm.label();
                field1.ifNe(null, cont);
                mm.return_((Object)(rule.isNullLow() ? 1 : -1));
                cont.here();
                if (column.isArray()) {
                    String compareName = column.isUnsignedInteger() ? "compareUnsigned" : "compare";
                    resultVar = mm.var(Arrays.class).invoke(compareName, new Object[]{field0, field1});
                } else {
                    resultVar = field0.invoke("compareTo", new Object[]{field1});
                }
            }
            if (it.hasNext()) {
                resultVar.ifEq((Object)0, nextLabel);
            }
            mm.return_((Object)resultVar);
            nextLabel.here();
        }
        mm.return_((Object)0);
    }
}

