/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.math.BigDecimal;
import java.util.Arrays;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.filter.ColumnFilter;
import org.cojen.tupl.rows.BigDecimalUtils;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.RowUtils;

class CompareUtils {
    CompareUtils() {
    }

    static void compare(MethodMaker mm, ColumnInfo colInfo, Variable colVar, ColumnInfo argInfo, Variable argVar, int op, Label pass, Label fail) {
        if (ColumnFilter.isIn(op)) {
            if (colInfo.isPrimitive() && !colInfo.isNullable() && argInfo.isPrimitive() && !argInfo.isNullable()) {
                CompareUtils.comparePrimitives(mm, colInfo, colVar, argInfo, argVar, op, pass, fail);
            } else {
                CompareUtils.compareIn(mm, colInfo, colVar, argInfo, argVar, op, pass, fail);
            }
            return;
        }
        if (colInfo.isNullable() && !colVar.classType().isPrimitive()) {
            if (argInfo.isNullable() && !argVar.classType().isPrimitive()) {
                Label argNotNull = mm.label();
                argVar.ifNe(null, argNotNull);
                Label match = CompareUtils.selectNullColumnToNullArg(op, pass, fail);
                Label mismatch = CompareUtils.selectColumnToNullArg(op, pass, fail);
                if (match != mismatch) {
                    colVar.ifEq(null, match);
                }
                mm.goto_(mismatch);
                argNotNull.here();
            }
            colVar.ifEq(null, CompareUtils.selectNullColumnToArg(op, pass, fail));
        } else if (argInfo.isNullable() && !argVar.classType().isPrimitive()) {
            argVar.ifEq(null, CompareUtils.selectColumnToNullArg(op, pass, fail));
        }
        if (colInfo.isPrimitive()) {
            if (!argInfo.isPrimitive()) {
                throw new IllegalArgumentException("Incomparable types");
            }
            CompareUtils.comparePrimitives(mm, colInfo, colVar, argInfo, argVar, op, pass, fail);
            return;
        }
        if (argInfo.isPrimitive()) {
            throw new IllegalArgumentException("Incomparable types");
        }
        if (colInfo.isArray() && argInfo.isArray()) {
            CompareUtils.compareArrays(mm, colInfo.isUnsigned() && argInfo.isUnsigned(), colVar, 0, colVar.alength(), argVar, 0, argVar.alength(), op, pass, fail);
            return;
        }
        if (ColumnFilter.isExact(op)) {
            if (colVar.classType() != BigDecimal.class && argVar.classType() != BigDecimal.class) {
                result = colVar.invoke("equals", new Object[]{argVar});
                if (op == 0) {
                    result.ifTrue(pass);
                } else {
                    result.ifFalse(pass);
                }
            } else {
                result = mm.var(BigDecimalUtils.class).invoke("matches", new Object[]{colVar, argVar});
                if (op == 0) {
                    result.ifEq((Object)0, pass);
                } else {
                    result.ifNe((Object)0, pass);
                }
            }
        } else {
            result = colVar.invoke("compareTo", new Object[]{argVar});
            switch (op) {
                case 2: {
                    result.ifGe((Object)0, pass);
                    break;
                }
                case 3: {
                    result.ifLt((Object)0, pass);
                    break;
                }
                case 4: {
                    result.ifLe((Object)0, pass);
                    break;
                }
                case 5: {
                    result.ifGt((Object)0, pass);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        mm.goto_(fail);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void comparePrimitives(MethodMaker mm, ColumnInfo colInfo, Variable colVar, ColumnInfo argInfo, Variable argVar, int op, Label pass, Label fail) {
        block19: {
            block25: {
                block26: {
                    Class argType;
                    block27: {
                        Class colType;
                        block23: {
                            block24: {
                                block16: {
                                    block18: {
                                        block21: {
                                            block22: {
                                                block20: {
                                                    block17: {
                                                        colType = colVar.classType();
                                                        if (!colType.isPrimitive()) {
                                                            colVar = colVar.unbox();
                                                            colType = colVar.classType();
                                                        }
                                                        if (ColumnFilter.isIn(op)) {
                                                            CompareUtils.compareIn(mm, colInfo, colVar, argInfo, argVar, op, pass, fail);
                                                            return;
                                                        }
                                                        argType = argVar.classType();
                                                        if (!argType.isPrimitive()) {
                                                            argVar = argVar.unbox();
                                                            argType = argVar.classType();
                                                        }
                                                        if (ColumnFilter.isExact(op)) break block16;
                                                        if (!colInfo.isUnsignedInteger()) break block17;
                                                        if (!argInfo.isUnsignedInteger()) break block18;
                                                        colVar = CompareUtils.toLong(colInfo, colVar).add((Object)Long.MIN_VALUE);
                                                        argVar = CompareUtils.toLong(argInfo, argVar).add((Object)Long.MIN_VALUE);
                                                        break block19;
                                                    }
                                                    if (argInfo.isUnsignedInteger()) break block18;
                                                    if (colType != Float.TYPE) break block20;
                                                    if (argType == Float.TYPE) break block21;
                                                    if (argType != Double.TYPE) break block19;
                                                    colVar = colVar.cast(Double.TYPE);
                                                    break block21;
                                                }
                                                if (colType != Double.TYPE) break block19;
                                                if (argType != Float.TYPE) break block22;
                                                argVar = argVar.cast(Double.TYPE);
                                                break block21;
                                            }
                                            if (argType != Double.TYPE) break block19;
                                        }
                                        Variable rowUtils = mm.var(RowUtils.class);
                                        colVar = rowUtils.invoke("floatToBitsCompare", new Object[]{colVar});
                                        argVar = rowUtils.invoke("floatToBitsCompare", new Object[]{argVar});
                                    }
                                    colVar = CompareUtils.toLong(colInfo, colVar);
                                    argVar = CompareUtils.toLong(argInfo, argVar);
                                    if (colInfo.plainTypeCode() == 6) {
                                        CompareUtils.signMismatch(colVar, argVar, ColumnFilter.flipOperator(op), pass, fail);
                                        break block19;
                                    } else if (argInfo.plainTypeCode() == 6) {
                                        CompareUtils.signMismatch(colVar, argVar, op, pass, fail);
                                    }
                                    break block19;
                                }
                                if (colType != Float.TYPE) break block23;
                                if (argType != Float.TYPE) break block24;
                                colVar = colVar.invoke("floatToRawIntBits", new Object[]{colVar});
                                argVar = argVar.invoke("floatToRawIntBits", new Object[]{argVar});
                                break block19;
                            }
                            if (argType != Double.TYPE) break block19;
                            colVar = colVar.cast(Double.TYPE);
                            break block25;
                        }
                        if (colType != Double.TYPE) break block26;
                        if (argType != Float.TYPE) break block27;
                        argVar = argVar.cast(Double.TYPE);
                        break block25;
                    }
                    if (argType == Double.TYPE) break block25;
                    break block19;
                }
                if (colInfo.isUnsignedInteger() || argInfo.isUnsignedInteger()) {
                    colVar = CompareUtils.toLong(colInfo, colVar);
                    argVar = CompareUtils.toLong(argInfo, argVar);
                    if (colInfo.isUnsigned() ^ argInfo.isUnsigned() && (colInfo.plainTypeCode() == 6 || argInfo.plainTypeCode() == 6)) {
                        CompareUtils.signMismatch(colVar, argVar, op, pass, fail);
                    }
                }
                break block19;
            }
            colVar = colVar.invoke("doubleToRawLongBits", new Object[]{colVar});
            argVar = argVar.invoke("doubleToRawLongBits", new Object[]{argVar});
        }
        switch (op) {
            case 0: {
                colVar.ifEq((Object)argVar, pass);
                break;
            }
            case 1: {
                colVar.ifNe((Object)argVar, pass);
                break;
            }
            case 2: {
                colVar.ifGe((Object)argVar, pass);
                break;
            }
            case 3: {
                colVar.ifLt((Object)argVar, pass);
                break;
            }
            case 4: {
                colVar.ifLe((Object)argVar, pass);
                break;
            }
            case 5: {
                colVar.ifGt((Object)argVar, pass);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        mm.goto_(fail);
    }

    static void compareIn(MethodMaker mm, Variable argVar, int op, Label pass, Label fail, CompareArg compareArg) {
        if (op == 7) {
            Label tmp = pass;
            pass = fail;
            fail = tmp;
        }
        Variable lengthVar = argVar.alength();
        Variable ixVar = mm.var(Integer.TYPE).set((Object)0);
        Label start = mm.label().here();
        ixVar.ifGe((Object)lengthVar, fail);
        Label next = mm.label();
        compareArg.apply(argVar.aget((Object)ixVar), pass, next);
        next.here();
        ixVar.inc((Object)1);
        mm.goto_(start);
    }

    private static void compareIn(MethodMaker mm, ColumnInfo colInfo, Variable colVar, ColumnInfo argInfo, Variable argVar, int op, Label pass, Label fail) {
        CompareUtils.compareIn(mm, argVar, op, pass, fail, (a, p, f) -> CompareUtils.compare(mm, colInfo, colVar, argInfo, a, 0, p, f));
    }

    private static Variable toLong(ColumnInfo info, Variable var) {
        block6: {
            if (var.classType() != Long.TYPE) {
                long mask;
                var = var.cast(Long.TYPE);
                switch (info.plainTypeCode()) {
                    case 3: {
                        mask = 255L;
                        break;
                    }
                    case 4: {
                        mask = 65535L;
                        break;
                    }
                    case 5: {
                        mask = 0xFFFFFFFFL;
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                var = var.and((Object)mask);
            }
        }
        return var;
    }

    private static void signMismatch(Variable a, Variable b, int op, Label pass, Label fail) {
        switch (op) {
            case 1: 
            case 3: 
            case 4: {
                a.ifLt((Object)0, pass);
                b.ifLt((Object)0, pass);
                break;
            }
            case 0: 
            case 2: 
            case 5: {
                a.ifLt((Object)0, fail);
                b.ifLt((Object)0, fail);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    static Label selectNullColumnToArg(int op, Label pass, Label fail) {
        return switch (op) {
            case 0 -> fail;
            case 1 -> pass;
            case 2 -> pass;
            case 3 -> fail;
            case 4 -> fail;
            case 5 -> pass;
            default -> throw new AssertionError();
        };
    }

    static Label selectColumnToNullArg(int op, Label pass, Label fail) {
        return switch (op) {
            case 0 -> fail;
            case 1 -> pass;
            case 2 -> fail;
            case 3 -> pass;
            case 4 -> pass;
            case 5 -> fail;
            case 6 -> fail;
            case 7 -> pass;
            default -> throw new AssertionError();
        };
    }

    static Label selectNullColumnToNullArg(int op, Label pass, Label fail) {
        return switch (op) {
            case 0 -> pass;
            case 1 -> fail;
            case 2 -> pass;
            case 3 -> fail;
            case 4 -> pass;
            case 5 -> fail;
            case 6 -> fail;
            case 7 -> pass;
            default -> throw new AssertionError();
        };
    }

    static void compareArrays(MethodMaker mm, boolean unsigned, Object a, Object aFrom, Object aTo, Object b, Object bFrom, Object bTo, int op, Label pass, Label fail) {
        Variable arraysVar = mm.var(Arrays.class);
        block0 : switch (op) {
            case 0: 
            case 1: {
                Variable resultVar = arraysVar.invoke("equals", new Object[]{a, aFrom, aTo, b, bFrom, bTo});
                if (op == 0) {
                    resultVar.ifTrue(pass);
                    break;
                }
                resultVar.ifFalse(pass);
                break;
            }
            default: {
                Object method = "compare";
                if (unsigned) {
                    method = (String)method + "Unsigned";
                }
                Variable resultVar = arraysVar.invoke((String)method, new Object[]{a, aFrom, aTo, b, bFrom, bTo});
                switch (op) {
                    case 2: {
                        resultVar.ifGe((Object)0, pass);
                        break block0;
                    }
                    case 3: {
                        resultVar.ifLt((Object)0, pass);
                        break block0;
                    }
                    case 4: {
                        resultVar.ifLe((Object)0, pass);
                        break block0;
                    }
                    case 5: {
                        resultVar.ifGt((Object)0, pass);
                        break block0;
                    }
                }
                throw new AssertionError();
            }
        }
        mm.goto_(fail);
    }

    @FunctionalInterface
    static interface CompareArg {
        public void apply(Variable var1, Label var2, Label var3);
    }
}

