/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import org.cojen.tupl.Updater;

abstract class ConcatUpdater<R>
implements Updater<R> {
    private Updater<R> mCurrent;

    ConcatUpdater(R dst) throws IOException {
        Updater<R> next = this.next(dst);
        do {
            this.mCurrent = next;
        } while (this.row() == null && (next = this.next(dst)) != null);
    }

    @Override
    public R row() {
        return this.mCurrent.row();
    }

    @Override
    public R step() throws IOException {
        Object row = this.mCurrent.step();
        Updater<Object> next;
        while (row == null && (next = this.next(null)) != null) {
            this.mCurrent = next;
            row = next.row();
        }
        return row;
    }

    @Override
    public R step(R dst) throws IOException {
        R row = this.mCurrent.step(dst);
        Updater<R> next;
        while (row == null && (next = this.next(dst)) != null) {
            this.mCurrent = next;
            row = next.row();
        }
        return row;
    }

    @Override
    public R update() throws IOException {
        R row = this.mCurrent.update();
        if (row == null) {
            row = this.step();
        }
        return row;
    }

    @Override
    public R update(R dst) throws IOException {
        R row = this.mCurrent.update(dst);
        if (row == null) {
            row = this.step(dst);
        }
        return row;
    }

    @Override
    public R delete() throws IOException {
        R row = this.mCurrent.delete();
        if (row == null) {
            row = this.step();
        }
        return row;
    }

    @Override
    public R delete(R dst) throws IOException {
        R row = this.mCurrent.delete(dst);
        if (row == null) {
            row = this.step(dst);
        }
        return row;
    }

    @Override
    public void close() throws IOException {
        this.mCurrent.close();
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 4368;
    }

    protected abstract Updater<R> next(R var1) throws IOException;
}

