/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.TypeDescriptor;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.cojen.maker.Bootstrap;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.rows.BigDecimalUtils;
import org.cojen.tupl.rows.ConvertUtils;

public class ConvertCallSite
extends MutableCallSite {
    private static final MethodHandle cImplementHandle;
    private static final VarHandle cImplementedHandle;
    private volatile int mImplemented;

    private ConvertCallSite(MethodType mt) {
        super(mt);
    }

    static Variable make(MethodMaker mm, Class toType, Variable from) {
        return mm.var(ConvertCallSite.class).indy("makeNext", new Object[0]).invoke((Object)toType, "_", null, new Object[]{from});
    }

    public static CallSite makeNext(MethodHandles.Lookup lookup, String name, MethodType mt) {
        ConvertCallSite cs = new ConvertCallSite(mt);
        cs.setTarget(cImplementHandle.bindTo(cs).asType(mt));
        return cs;
    }

    private Object implement(Object obj) {
        int state;
        while ((state = this.mImplemented) < 2) {
            if (state == 0 && cImplementedHandle.compareAndSet(this, 0, 1)) {
                try {
                    this.setTarget(ConvertCallSite.makeConverter(obj, this.type()));
                    this.mImplemented = 2;
                    break;
                }
                catch (Throwable e) {
                    this.mImplemented = 0;
                    throw e;
                }
            }
            Thread.yield();
        }
        try {
            return this.getTarget().invoke(obj);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private static MethodHandle makeConverter(Object obj, MethodType mt) {
        Object result;
        Class<?> fromType = obj == null ? null : obj.getClass();
        TypeDescriptor.OfField toType = mt.returnType();
        MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)MethodHandles.lookup(), (String)"convert", (MethodType)mt);
        Variable from = mm.param(0);
        Label next = mm.label();
        if (fromType == null) {
            if (((Class)toType).isPrimitive()) {
                result = null;
            } else {
                from.ifNe(null, next);
                result = mm.var((Object)toType).set(null);
            }
        } else {
            if (fromType.isAssignableFrom(from.classType())) {
                from.ifEq(null, next);
            } else {
                ConvertCallSite.instanceOf(from, fromType, next);
            }
            result = !((Class)toType).isPrimitive() && ((Class)toType).isAssignableFrom(fromType) ? from.cast((Object)toType) : (toType == String.class ? ConvertCallSite.toString(mm, fromType, from) : (toType == Long.TYPE || toType == Long.class ? ConvertCallSite.toLong(mm, fromType, from) : (toType == Integer.TYPE || toType == Integer.class ? ConvertCallSite.toInt(mm, fromType, from) : (toType == Double.TYPE || toType == Double.class ? ConvertCallSite.toDouble(mm, fromType, from) : (toType == Float.TYPE || toType == Float.class ? ConvertCallSite.toFloat(mm, fromType, from) : (toType == Boolean.TYPE || toType == Boolean.class ? ConvertCallSite.toBoolean(mm, fromType, from) : (toType == BigInteger.class ? ConvertCallSite.toBigInteger(mm, fromType, from) : (toType == BigDecimal.class ? ConvertCallSite.toBigDecimal(mm, fromType, from) : (toType == Character.TYPE || toType == Character.class ? ConvertCallSite.toChar(mm, fromType, from) : (toType == Byte.TYPE || toType == Byte.class ? ConvertCallSite.toByte(mm, fromType, from) : (toType == Short.TYPE || toType == Short.class ? ConvertCallSite.toShort(mm, fromType, from) : (((Class)toType).isArray() ? ConvertCallSite.toArray(mm, (Class)toType, fromType, from) : null))))))))))));
        }
        if (result != null) {
            mm.return_(result);
        } else {
            mm.new_(IllegalArgumentException.class, new Object[]{"Cannot convert " + (fromType == null ? null : fromType.getSimpleName()) + " to " + ((Class)toType).getSimpleName()}).throw_();
        }
        if (next != null) {
            next.here();
            Bootstrap indy = mm.var(ConvertCallSite.class).indy("makeNext", new Object[0]);
            mm.return_((Object)indy.invoke((Object)toType, "_", null, new Object[]{from}));
        }
        return mm.finish();
    }

    private static void instanceOf(Variable fromVar, Class<?> fromType, Label fail) {
        if (Modifier.isPublic(fromType.getModifiers())) {
            fromVar.instanceOf(fromType).ifFalse(fail);
            return;
        }
        HashSet types = new HashSet();
        ConvertCallSite.gatherAccessibleTypes(types, fromType);
        Iterator<Class<?>> it = types.iterator();
        block0: while (it.hasNext()) {
            Class<?> type = it.next();
            for (Class<?> other : types) {
                if (other == type || !type.isAssignableFrom(other)) continue;
                it.remove();
                continue block0;
            }
        }
        for (Class<?> type : types) {
            fromVar.instanceOf(type).ifFalse(fail);
        }
    }

    private static void gatherAccessibleTypes(HashSet<Class<?>> types, Class<?> type) {
        Class<?>[] ifaces;
        Class<?> superType;
        if (types.contains(type)) {
            return;
        }
        if (Modifier.isPublic(type.getModifiers())) {
            types.add(type);
        }
        if ((superType = type.getSuperclass()) != null && superType != Object.class) {
            ConvertCallSite.gatherAccessibleTypes(types, superType);
        }
        if ((ifaces = type.getInterfaces()) != null) {
            for (Class<?> iface : ifaces) {
                if (iface == Serializable.class) continue;
                ConvertCallSite.gatherAccessibleTypes(types, iface);
            }
        }
    }

    private static Variable toBoolean(MethodMaker mm, Class fromType, Variable from) {
        if (fromType == Boolean.class) {
            return from.cast(Boolean.class);
        }
        if (fromType == String.class) {
            return mm.var(ConvertUtils.class).invoke("stringToBooleanExact", new Object[]{from.cast(String.class)});
        }
        return null;
    }

    private static Variable toByte(MethodMaker mm, Class fromType, Variable from) {
        if (fromType == Byte.class) {
            return from.cast(Byte.class);
        }
        if (fromType == Integer.class) {
            return mm.var(ConvertUtils.class).invoke("intToByteExact", new Object[]{from.cast(Integer.class)});
        }
        if (fromType == Long.class) {
            return mm.var(ConvertUtils.class).invoke("longToByteExact", new Object[]{from.cast(Long.class)});
        }
        if (fromType == String.class) {
            return mm.var(Byte.class).invoke("parseByte", new Object[]{from.cast(String.class)});
        }
        if (fromType == Double.class) {
            return mm.var(ConvertUtils.class).invoke("doubleToByteExact", new Object[]{from.cast(Double.class)});
        }
        if (fromType == Float.class) {
            return mm.var(ConvertUtils.class).invoke("floatToByteExact", new Object[]{from.cast(Float.class)});
        }
        if (fromType == Short.class) {
            return mm.var(ConvertUtils.class).invoke("shortToByteExact", new Object[]{from.cast(Short.class)});
        }
        if (fromType == BigInteger.class) {
            return from.cast(BigInteger.class).invoke("byteValueExact", new Object[0]);
        }
        if (fromType == BigDecimal.class) {
            return from.cast(BigDecimal.class).invoke("byteValueExact", new Object[0]);
        }
        return null;
    }

    private static Variable toShort(MethodMaker mm, Class fromType, Variable from) {
        if (fromType == Short.class) {
            return from.cast(Short.class);
        }
        if (fromType == Integer.class) {
            return mm.var(ConvertUtils.class).invoke("intToShortExact", new Object[]{from.cast(Integer.class)});
        }
        if (fromType == Long.class) {
            return mm.var(ConvertUtils.class).invoke("longToShortExact", new Object[]{from.cast(Long.class)});
        }
        if (fromType == String.class) {
            return mm.var(Short.class).invoke("parseShort", new Object[]{from.cast(String.class)});
        }
        if (fromType == Double.class) {
            return mm.var(ConvertUtils.class).invoke("doubleToShortExact", new Object[]{from.cast(Double.class)});
        }
        if (fromType == Float.class) {
            return mm.var(ConvertUtils.class).invoke("floatToShortExact", new Object[]{from.cast(Float.class)});
        }
        if (fromType == Byte.class) {
            return from.cast(Byte.class).invoke("shortValue", new Object[0]);
        }
        if (fromType == BigInteger.class) {
            return from.cast(BigInteger.class).invoke("shortValueExact", new Object[0]);
        }
        if (fromType == BigDecimal.class) {
            return from.cast(BigDecimal.class).invoke("shortValueExact", new Object[0]);
        }
        return null;
    }

    private static Variable toInt(MethodMaker mm, Class fromType, Variable from) {
        if (fromType == Integer.class) {
            return from.cast(Integer.class);
        }
        if (fromType == Long.class) {
            return mm.var(Math.class).invoke("toIntExact", new Object[]{from.cast(Long.class)});
        }
        if (fromType == String.class) {
            return mm.var(Integer.class).invoke("parseInt", new Object[]{from.cast(String.class)});
        }
        if (fromType == Double.class) {
            return mm.var(ConvertUtils.class).invoke("doubleToIntExact", new Object[]{from.cast(Double.class)});
        }
        if (fromType == Float.class) {
            return mm.var(ConvertUtils.class).invoke("floatToIntExact", new Object[]{from.cast(Float.class)});
        }
        if (fromType == Byte.class) {
            return from.cast(Byte.class).invoke("intValue", new Object[0]);
        }
        if (fromType == Short.class) {
            return from.cast(Short.class).invoke("intValue", new Object[0]);
        }
        if (fromType == BigInteger.class) {
            return from.cast(BigInteger.class).invoke("intValueExact", new Object[0]);
        }
        if (fromType == BigDecimal.class) {
            return from.cast(BigDecimal.class).invoke("intValueExact", new Object[0]);
        }
        return null;
    }

    private static Variable toLong(MethodMaker mm, Class fromType, Variable from) {
        if (fromType == Long.class) {
            return from.cast(Long.class);
        }
        if (fromType == Integer.class) {
            return from.cast(Integer.class).invoke("longValue", new Object[0]);
        }
        if (fromType == String.class) {
            return mm.var(Long.class).invoke("parseLong", new Object[]{from.cast(String.class)});
        }
        if (fromType == Double.class) {
            return mm.var(ConvertUtils.class).invoke("doubleToLongExact", new Object[]{from.cast(Double.class)});
        }
        if (fromType == Float.class) {
            return mm.var(ConvertUtils.class).invoke("floatToLongExact", new Object[]{from.cast(Float.class)});
        }
        if (fromType == Byte.class) {
            return from.cast(Byte.class).invoke("longValue", new Object[0]);
        }
        if (fromType == Short.class) {
            return from.cast(Short.class).invoke("longValue", new Object[0]);
        }
        if (fromType == BigInteger.class) {
            return from.cast(BigInteger.class).invoke("longValueExact", new Object[0]);
        }
        if (fromType == BigDecimal.class) {
            return from.cast(BigDecimal.class).invoke("longValueExact", new Object[0]);
        }
        return null;
    }

    private static Variable toFloat(MethodMaker mm, Class fromType, Variable from) {
        if (fromType == Float.class) {
            return from.cast(Float.class);
        }
        if (fromType == String.class) {
            return mm.var(Float.class).invoke("parseFloat", new Object[]{from.cast(String.class)});
        }
        if (fromType == Integer.class) {
            return mm.var(ConvertUtils.class).invoke("intToFloatExact", new Object[]{from.cast(Integer.class)});
        }
        if (fromType == Double.class) {
            return mm.var(ConvertUtils.class).invoke("doubleToFloatExact", new Object[]{from.cast(Double.class)});
        }
        if (fromType == Long.class) {
            return mm.var(ConvertUtils.class).invoke("longToFloatExact", new Object[]{from.cast(Long.class)});
        }
        if (fromType == Byte.class) {
            return from.cast(Byte.class).invoke("floatValue", new Object[0]);
        }
        if (fromType == Short.class) {
            return from.cast(Short.class).invoke("floatValue", new Object[0]);
        }
        if (fromType == BigInteger.class) {
            return mm.var(ConvertUtils.class).invoke("biToFloatExact", new Object[]{from.cast(BigInteger.class)});
        }
        if (fromType == BigDecimal.class) {
            return mm.var(ConvertUtils.class).invoke("bdToFloatExact", new Object[]{from.cast(BigDecimal.class)});
        }
        return null;
    }

    private static Variable toDouble(MethodMaker mm, Class fromType, Variable from) {
        if (fromType == Double.class) {
            return from.cast(Double.class);
        }
        if (fromType == String.class) {
            return mm.var(Double.class).invoke("parseDouble", new Object[]{from.cast(String.class)});
        }
        if (fromType == Integer.class) {
            return from.cast(Integer.class);
        }
        if (fromType == Long.class) {
            return mm.var(ConvertUtils.class).invoke("longToDoubleExact", new Object[]{from.cast(Long.class)});
        }
        if (fromType == Float.class) {
            return from.cast(Float.class).invoke("doubleValue", new Object[0]);
        }
        if (fromType == Byte.class) {
            return from.cast(Byte.class).invoke("doubleValue", new Object[0]);
        }
        if (fromType == Short.class) {
            return from.cast(Short.class).invoke("doubleValue", new Object[0]);
        }
        if (fromType == BigInteger.class) {
            return mm.var(ConvertUtils.class).invoke("biToDoubleExact", new Object[]{from.cast(BigInteger.class)});
        }
        if (fromType == BigDecimal.class) {
            return mm.var(ConvertUtils.class).invoke("bdToDoubleExact", new Object[]{from.cast(BigDecimal.class)});
        }
        return null;
    }

    private static Variable toChar(MethodMaker mm, Class fromType, Variable from) {
        if (fromType == Character.class) {
            return from.cast(Character.class);
        }
        if (fromType == String.class) {
            return mm.var(ConvertUtils.class).invoke("stringToCharExact", new Object[]{from.cast(String.class)});
        }
        return null;
    }

    private static Variable toString(MethodMaker mm, Class fromType, Variable from) {
        return mm.var(String.class).invoke("valueOf", new Object[]{from});
    }

    private static Variable toBigInteger(MethodMaker mm, Class fromType, Variable from) {
        Variable longVar;
        if (fromType == Integer.class) {
            longVar = from.cast(Integer.class);
        } else if (fromType == Long.class) {
            longVar = from.cast(Long.class);
        } else {
            if (fromType == String.class) {
                return mm.new_(BigInteger.class, new Object[]{from.cast(String.class)});
            }
            if (fromType == Double.class) {
                longVar = mm.var(ConvertUtils.class).invoke("doubleToLongExact", new Object[]{from.cast(Double.class)});
            } else if (fromType == Float.class) {
                longVar = mm.var(ConvertUtils.class).invoke("floatToLongExact", new Object[]{from.cast(Float.class)});
            } else if (fromType == Byte.class) {
                longVar = from.cast(Byte.class);
            } else if (fromType == Short.class) {
                longVar = from.cast(Short.class);
            } else {
                if (fromType == BigDecimal.class) {
                    return from.cast(BigDecimal.class).invoke("toBigIntegerExact", new Object[0]);
                }
                return null;
            }
        }
        return mm.var(BigInteger.class).invoke("valueOf", new Object[]{longVar});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Variable toBigDecimal(MethodMaker mm, Class fromType, Variable from) {
        Variable numVar;
        if (fromType == String.class) {
            return mm.new_(BigDecimal.class, new Object[]{from.cast(String.class)});
        }
        if (fromType == Integer.class) {
            numVar = from.cast(Integer.class);
            return mm.var(BigDecimal.class).invoke("valueOf", new Object[]{numVar});
        }
        if (fromType == Long.class) {
            numVar = from.cast(Long.class);
            return mm.var(BigDecimal.class).invoke("valueOf", new Object[]{numVar});
        }
        if (fromType == Double.class) {
            numVar = from.cast(Double.class);
            return mm.var(BigDecimalUtils.class).invoke("toBigDecimal", new Object[]{numVar});
        } else if (fromType == Float.class) {
            numVar = from.cast(Float.class);
            return mm.var(BigDecimalUtils.class).invoke("toBigDecimal", new Object[]{numVar});
        } else if (fromType == Byte.class) {
            numVar = from.cast(Byte.class);
            return mm.var(BigDecimal.class).invoke("valueOf", new Object[]{numVar});
        } else if (fromType == Short.class) {
            numVar = from.cast(Short.class);
            return mm.var(BigDecimal.class).invoke("valueOf", new Object[]{numVar});
        } else {
            if (fromType != BigInteger.class) return null;
            return mm.new_(BigDecimal.class, new Object[]{from.cast(BigInteger.class)});
        }
    }

    private static Variable toArray(MethodMaker mm, Class toType, Class fromType, Variable from) {
        Class<?> toElementType = toType.getComponentType();
        if (fromType.isArray()) {
            Variable fromArrayVar = from.cast((Object)fromType);
            Variable lengthVar = fromArrayVar.alength();
            return ConvertUtils.convertArray(mm, toType, lengthVar, ixVar -> ConvertCallSite.make(mm, toElementType, fromArrayVar.aget(ixVar).box()));
        }
        if (List.class.isAssignableFrom(fromType) && RandomAccess.class.isAssignableFrom(fromType)) {
            Variable fromListVar = from.cast(List.class);
            Variable lengthVar = fromListVar.invoke("size", new Object[0]);
            return ConvertUtils.convertArray(mm, toType, lengthVar, ixVar -> ConvertCallSite.make(mm, toElementType, fromListVar.invoke("get", new Object[]{ixVar})));
        }
        if (Collection.class.isAssignableFrom(fromType)) {
            Variable fromCollectionVar = from.cast(Collection.class);
            Variable lengthVar = fromCollectionVar.invoke("size", new Object[0]);
            Variable itVar = fromCollectionVar.invoke("iterator", new Object[0]);
            return ConvertUtils.convertArray(mm, toType, lengthVar, ixVar -> ConvertCallSite.make(mm, toElementType, itVar.invoke("next", new Object[0])));
        }
        return null;
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cImplementHandle = lookup.findVirtual(ConvertCallSite.class, "implement", MethodType.methodType(Object.class, Object.class));
            cImplementedHandle = lookup.findVarHandle(ConvertCallSite.class, "mImplemented", Integer.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }
}

