/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Function;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.filter.ColumnFilter;
import org.cojen.tupl.rows.BigDecimalUtils;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.RowUtils;

public class ConvertUtils {
    static Variable convertArray(MethodMaker mm, Class toType, Variable lengthVar, Function<Variable, Variable> elementConverter) {
        Variable toArrayVar = mm.new_((Object)toType, new Object[]{lengthVar});
        Variable ixVar = mm.var(Integer.TYPE).set((Object)0);
        Label start = mm.label().here();
        Label end = mm.label();
        ixVar.ifGe((Object)lengthVar, end);
        toArrayVar.aset((Object)ixVar, (Object)elementConverter.apply(ixVar));
        ixVar.inc((Object)1);
        mm.goto_(start);
        end.here();
        return toArrayVar;
    }

    public static ColumnInfo commonType(ColumnInfo aInfo, ColumnInfo bInfo, int op) {
        int cPlainCode;
        int bPlainCode;
        int aPlainCode;
        int bTypeCode;
        int aTypeCode = aInfo.unorderedTypeCode();
        if (aTypeCode == (bTypeCode = bInfo.unorderedTypeCode())) {
            return aInfo;
        }
        if (ColumnInfo.isNullable(aTypeCode) || ColumnInfo.isNullable(bTypeCode)) {
            aTypeCode |= 0x40;
            bTypeCode |= 0x40;
        }
        if (ColumnInfo.isArray(aTypeCode) || ColumnInfo.isArray(bTypeCode)) {
            ColumnInfo cInfo;
            if (ColumnInfo.isArray(aTypeCode)) {
                aInfo = aInfo.nonArray();
            }
            if (ColumnInfo.isArray(bTypeCode)) {
                bInfo = bInfo.nonArray();
            }
            if ((cInfo = ConvertUtils.commonType(aInfo, bInfo, op)) != null) {
                cInfo = cInfo.asArray(ColumnInfo.isNullable(aTypeCode));
            }
            return cInfo;
        }
        if (bTypeCode < aTypeCode) {
            int tmp = aTypeCode;
            aTypeCode = bTypeCode;
            bTypeCode = tmp;
        }
        if ((aPlainCode = ColumnInfo.plainTypeCode(aTypeCode)) == (bPlainCode = ColumnInfo.plainTypeCode(bTypeCode))) {
            cPlainCode = aPlainCode;
        } else {
            block0 : switch (aPlainCode) {
                case 0: {
                    if (!ColumnFilter.isExact(op)) {
                        return null;
                    }
                    switch (bPlainCode) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 17: 
                        case 18: 
                        case 20: 
                        case 24: 
                        case 28: 
                        case 29: {
                            cPlainCode = bPlainCode;
                            break block0;
                        }
                    }
                    return null;
                }
                case 3: {
                    switch (bPlainCode) {
                        case 4: {
                            cPlainCode = 4;
                            break block0;
                        }
                        case 5: {
                            cPlainCode = 5;
                            break block0;
                        }
                        case 6: {
                            cPlainCode = 6;
                            break block0;
                        }
                        case 11: 
                        case 12: {
                            cPlainCode = 12;
                            break block0;
                        }
                        case 13: {
                            cPlainCode = 13;
                            break block0;
                        }
                        case 14: {
                            cPlainCode = 14;
                            break block0;
                        }
                        case 17: {
                            cPlainCode = 17;
                            break block0;
                        }
                        case 18: {
                            cPlainCode = 18;
                            break block0;
                        }
                        case 20: {
                            cPlainCode = 4;
                            break block0;
                        }
                        case 24: {
                            cPlainCode = -1;
                            break block0;
                        }
                        case 28: {
                            cPlainCode = 28;
                            break block0;
                        }
                        case 29: {
                            cPlainCode = 29;
                            break block0;
                        }
                    }
                    return null;
                }
                case 4: {
                    switch (bPlainCode) {
                        case 5: {
                            cPlainCode = 5;
                            break block0;
                        }
                        case 6: {
                            cPlainCode = 6;
                            break block0;
                        }
                        case 11: 
                        case 12: 
                        case 13: {
                            cPlainCode = 13;
                            break block0;
                        }
                        case 14: {
                            cPlainCode = 14;
                            break block0;
                        }
                        case 17: {
                            cPlainCode = 17;
                            break block0;
                        }
                        case 18: {
                            cPlainCode = 18;
                            break block0;
                        }
                        case 20: {
                            cPlainCode = 4;
                            break block0;
                        }
                        case 24: {
                            cPlainCode = -1;
                            break block0;
                        }
                        case 28: {
                            cPlainCode = 28;
                            break block0;
                        }
                        case 29: {
                            cPlainCode = 29;
                            break block0;
                        }
                    }
                    return null;
                }
                case 5: {
                    switch (bPlainCode) {
                        case 6: {
                            cPlainCode = 6;
                            break block0;
                        }
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: {
                            cPlainCode = 14;
                            break block0;
                        }
                        case 17: {
                            cPlainCode = 18;
                            break block0;
                        }
                        case 18: {
                            cPlainCode = 29;
                            break block0;
                        }
                        case 20: {
                            cPlainCode = 5;
                            break block0;
                        }
                        case 24: {
                            cPlainCode = -1;
                            break block0;
                        }
                        case 28: {
                            cPlainCode = 28;
                            break block0;
                        }
                        case 29: {
                            cPlainCode = 29;
                            break block0;
                        }
                    }
                    return null;
                }
                case 6: {
                    switch (bPlainCode) {
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: {
                            cPlainCode = 28;
                            break block0;
                        }
                        case 17: 
                        case 18: {
                            cPlainCode = 29;
                            break block0;
                        }
                        case 20: {
                            cPlainCode = 6;
                            break block0;
                        }
                        case 24: {
                            cPlainCode = -1;
                            break block0;
                        }
                        case 28: {
                            cPlainCode = 28;
                            break block0;
                        }
                        case 29: {
                            cPlainCode = 29;
                            break block0;
                        }
                    }
                    return null;
                }
                case 11: {
                    switch (bPlainCode) {
                        case 12: {
                            cPlainCode = 12;
                            break block0;
                        }
                        case 13: {
                            cPlainCode = 13;
                            break block0;
                        }
                        case 14: {
                            cPlainCode = 14;
                            break block0;
                        }
                        case 17: {
                            cPlainCode = 17;
                            break block0;
                        }
                        case 18: {
                            cPlainCode = 18;
                            break block0;
                        }
                        case 20: {
                            cPlainCode = 13;
                            break block0;
                        }
                        case 24: {
                            cPlainCode = -1;
                            break block0;
                        }
                        case 28: {
                            cPlainCode = 28;
                            break block0;
                        }
                        case 29: {
                            cPlainCode = 29;
                            break block0;
                        }
                    }
                    return null;
                }
                case 12: {
                    switch (bPlainCode) {
                        case 13: {
                            cPlainCode = 13;
                            break block0;
                        }
                        case 14: {
                            cPlainCode = 14;
                            break block0;
                        }
                        case 17: {
                            cPlainCode = 17;
                            break block0;
                        }
                        case 18: {
                            cPlainCode = 18;
                            break block0;
                        }
                        case 20: {
                            cPlainCode = 13;
                            break block0;
                        }
                        case 24: {
                            cPlainCode = -1;
                            break block0;
                        }
                        case 28: {
                            cPlainCode = 28;
                            break block0;
                        }
                        case 29: {
                            cPlainCode = 29;
                            break block0;
                        }
                    }
                    return null;
                }
                case 13: {
                    switch (bPlainCode) {
                        case 14: {
                            cPlainCode = 14;
                            break block0;
                        }
                        case 17: 
                        case 18: {
                            cPlainCode = 18;
                            break block0;
                        }
                        case 20: {
                            cPlainCode = 13;
                            break block0;
                        }
                        case 24: {
                            cPlainCode = -1;
                            break block0;
                        }
                        case 28: {
                            cPlainCode = 28;
                            break block0;
                        }
                        case 29: {
                            cPlainCode = 29;
                            break block0;
                        }
                    }
                    return null;
                }
                case 14: {
                    switch (bPlainCode) {
                        case 17: 
                        case 18: {
                            cPlainCode = 29;
                            break block0;
                        }
                        case 20: {
                            cPlainCode = 14;
                            break block0;
                        }
                        case 24: {
                            cPlainCode = -1;
                            break block0;
                        }
                        case 28: {
                            cPlainCode = 28;
                            break block0;
                        }
                        case 29: {
                            cPlainCode = 29;
                            break block0;
                        }
                    }
                    return null;
                }
                case 17: {
                    switch (bPlainCode) {
                        case 18: {
                            cPlainCode = 18;
                            break block0;
                        }
                        case 20: {
                            cPlainCode = 17;
                            break block0;
                        }
                        case 24: {
                            cPlainCode = -1;
                            break block0;
                        }
                        case 28: 
                        case 29: {
                            cPlainCode = 29;
                            break block0;
                        }
                    }
                    return null;
                }
                case 18: {
                    switch (bPlainCode) {
                        case 20: {
                            cPlainCode = 18;
                            break block0;
                        }
                        case 24: {
                            cPlainCode = -1;
                            break block0;
                        }
                        case 28: 
                        case 29: {
                            cPlainCode = 29;
                            break block0;
                        }
                    }
                    return null;
                }
                case 20: {
                    switch (bPlainCode) {
                        case 24: {
                            cPlainCode = 24;
                            break block0;
                        }
                        case 28: {
                            cPlainCode = 28;
                            break block0;
                        }
                        case 29: {
                            cPlainCode = 29;
                            break block0;
                        }
                    }
                    return null;
                }
                case 24: {
                    switch (bPlainCode) {
                        case 28: 
                        case 29: {
                            cPlainCode = -1;
                            break block0;
                        }
                    }
                    return null;
                }
                case 28: {
                    switch (bPlainCode) {
                        case 29: {
                            cPlainCode = 29;
                            break block0;
                        }
                    }
                    return null;
                }
                case 29: {
                    switch (bPlainCode) {
                        default: 
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        int cTypeCode = cPlainCode;
        if (cTypeCode == -1) {
            if (!ColumnFilter.isExact(op)) {
                return null;
            }
            cTypeCode = 24;
        }
        ColumnInfo cInfo = new ColumnInfo();
        cInfo.typeCode = cTypeCode |= aTypeCode & 0x40;
        cInfo.assignType();
        return cInfo;
    }

    public static boolean stringToBooleanExact(String str) {
        if (str.equalsIgnoreCase("false")) {
            return false;
        }
        if (str.equalsIgnoreCase("true")) {
            return true;
        }
        throw new IllegalArgumentException("Cannot convert to Boolean: " + str);
    }

    public static char stringToCharExact(String str) {
        if (str.length() == 1) {
            return str.charAt(0);
        }
        throw new IllegalArgumentException("Cannot convert to Character: " + str);
    }

    public static int doubleToIntExact(double d) {
        int i = (int)d;
        if ((double)i != d) {
            throw ConvertUtils.loss(Integer.class, d);
        }
        return i;
    }

    public static int doubleToUnsignedIntExact(double d) {
        if (d < 0.0 || d >= 4.294967296E9 || Math.floor(d) != d) {
            throw ConvertUtils.lossUnsigned(Integer.class, d);
        }
        return (int)d;
    }

    public static long doubleToLongExact(double d) {
        long i = (long)d;
        if ((double)i != d) {
            throw ConvertUtils.loss(Long.class, d);
        }
        return i;
    }

    public static long doubleToUnsignedLongExact(double d) {
        if (d < 0.0 || d >= 1.8446744073709552E19 || Math.floor(d) != d) {
            throw ConvertUtils.lossUnsigned(Long.class, d);
        }
        return d <= 9.223372036854776E18 ? (long)d : ((long)(d / 2.0) << 1) + (long)d % 2L;
    }

    public static float doubleToFloatExact(double d) {
        float f = (float)d;
        if ((double)f != d && !Double.isNaN(d)) {
            throw ConvertUtils.loss(Float.class, d);
        }
        return f;
    }

    public static byte doubleToByteExact(double d) {
        byte b = (byte)d;
        if ((double)b != d) {
            throw ConvertUtils.loss(Byte.class, d);
        }
        return b;
    }

    public static byte doubleToUnsignedByteExact(double d) {
        int i = (int)d;
        if ((double)i != d || Integer.compareUnsigned(i, 256) >= 0) {
            throw ConvertUtils.lossUnsigned(Byte.class, d);
        }
        return (byte)i;
    }

    public static short doubleToShortExact(double d) {
        short s = (short)d;
        if ((double)s != d) {
            throw ConvertUtils.loss(Short.class, d);
        }
        return s;
    }

    public static short doubleToUnsignedShortExact(double d) {
        int i = (int)d;
        if ((double)i != d || Integer.compareUnsigned(i, 65536) >= 0) {
            throw ConvertUtils.lossUnsigned(Short.class, d);
        }
        return (short)i;
    }

    public static int floatToIntExact(float f) {
        int i = (int)f;
        if ((float)i != f) {
            throw ConvertUtils.loss(Integer.class, Float.valueOf(f));
        }
        return i;
    }

    public static int floatToUnsignedIntExact(float f) {
        if (f < 0.0f || (double)f >= 4.294967296E9 || Math.floor(f) != (double)f) {
            throw ConvertUtils.lossUnsigned(Integer.class, Float.valueOf(f));
        }
        return (int)f;
    }

    public static long floatToLongExact(float f) {
        long i = (long)f;
        if ((float)i != f) {
            throw ConvertUtils.loss(Long.class, Float.valueOf(f));
        }
        return i;
    }

    public static long floatToUnsignedLongExact(float f) {
        if (f < 0.0f || (double)f >= 1.8446744073709552E19 || Math.floor(f) != (double)f) {
            throw ConvertUtils.lossUnsigned(Long.class, Float.valueOf(f));
        }
        return (double)f <= 9.223372036854776E18 ? (long)f : ((long)(f / 2.0f) << 1) + (long)f % 2L;
    }

    public static byte floatToByteExact(float f) {
        byte b = (byte)f;
        if ((float)b != f) {
            throw ConvertUtils.loss(Byte.class, Float.valueOf(f));
        }
        return b;
    }

    public static byte floatToUnsignedByteExact(float f) {
        int i = (int)f;
        if ((float)i != f || Integer.compareUnsigned(i, 256) >= 0) {
            throw ConvertUtils.lossUnsigned(Byte.class, Float.valueOf(f));
        }
        return (byte)i;
    }

    public static short floatToShortExact(float f) {
        short s = (short)f;
        if ((float)s != f) {
            throw ConvertUtils.loss(Short.class, Float.valueOf(f));
        }
        return s;
    }

    public static short floatToUnsignedShortExact(float f) {
        int i = (int)f;
        if ((float)i != f || Integer.compareUnsigned(i, 65536) >= 0) {
            throw ConvertUtils.lossUnsigned(Short.class, Float.valueOf(f));
        }
        return (short)i;
    }

    public static byte shortToByteExact(short i) {
        byte b = (byte)i;
        if ((short)b != i) {
            throw ConvertUtils.loss(Byte.class, i);
        }
        return b;
    }

    public static byte intToByteExact(int i) {
        byte b = (byte)i;
        if (b != i) {
            throw ConvertUtils.loss(Byte.class, i);
        }
        return b;
    }

    public static byte intToUnsignedByteExact(int i) {
        if (Integer.compareUnsigned(i, 256) >= 0) {
            throw ConvertUtils.lossUnsigned(Byte.class, i);
        }
        return (byte)i;
    }

    public static short intToShortExact(int i) {
        short s = (short)i;
        if (s != i) {
            throw ConvertUtils.loss(Short.class, i);
        }
        return s;
    }

    public static short intToUnsignedShortExact(int i) {
        if (Integer.compareUnsigned(i, 65536) >= 0) {
            throw ConvertUtils.lossUnsigned(Short.class, i);
        }
        return (short)i;
    }

    public static int intToUnsignedIntExact(int i) {
        if (i < 0) {
            throw ConvertUtils.lossUnsigned(Integer.class, i);
        }
        return i;
    }

    public static long intToUnsignedLongExact(int i) {
        if (i < 0) {
            throw ConvertUtils.lossUnsigned(Long.class, i);
        }
        return i;
    }

    public static byte unsignedIntToByteExact(int i) {
        if (Integer.compareUnsigned(i, 128) >= 0) {
            throw ConvertUtils.loss(Byte.class, Integer.toUnsignedString(i));
        }
        return (byte)i;
    }

    public static byte unsignedIntToUnsignedByteExact(int i) {
        if (Integer.compareUnsigned(i, 256) >= 0) {
            throw ConvertUtils.lossUnsigned(Byte.class, Integer.toUnsignedString(i));
        }
        return (byte)i;
    }

    public static short unsignedIntToShortExact(int i) {
        if (Integer.compareUnsigned(i, 32768) >= 0) {
            throw ConvertUtils.loss(Short.class, Integer.toUnsignedString(i));
        }
        return (short)i;
    }

    public static short unsignedIntToUnsignedShortExact(int i) {
        if (Integer.compareUnsigned(i, 65536) >= 0) {
            throw ConvertUtils.lossUnsigned(Short.class, Integer.toUnsignedString(i));
        }
        return (short)i;
    }

    public static int unsignedIntToIntExact(int i) {
        if (i < 0) {
            throw ConvertUtils.loss(Integer.class, Integer.toUnsignedString(i));
        }
        return i;
    }

    public static float intToFloatExact(int i) {
        float f = i;
        if ((int)f != i) {
            throw ConvertUtils.loss(Float.class, i);
        }
        return f;
    }

    public static byte longToByteExact(long i) {
        byte b = (byte)i;
        if ((long)b != i) {
            throw ConvertUtils.loss(Byte.class, i);
        }
        return b;
    }

    public static byte longToUnsignedByteExact(long i) {
        if (Long.compareUnsigned(i, 256L) >= 0) {
            throw ConvertUtils.lossUnsigned(Byte.class, i);
        }
        return (byte)i;
    }

    public static short longToShortExact(long i) {
        short s = (short)i;
        if ((long)s != i) {
            throw ConvertUtils.loss(Short.class, i);
        }
        return s;
    }

    public static short longToUnsignedShortExact(long i) {
        if (Long.compareUnsigned(i, 65536L) >= 0) {
            throw ConvertUtils.lossUnsigned(Short.class, i);
        }
        return (short)i;
    }

    public static int longToUnsignedIntExact(long i) {
        if (Long.compareUnsigned(i, 0x100000000L) >= 0) {
            throw ConvertUtils.lossUnsigned(Integer.class, i);
        }
        return (int)i;
    }

    public static long longToUnsignedLongExact(long i) {
        if (i < 0L) {
            throw ConvertUtils.lossUnsigned(Long.class, i);
        }
        return i;
    }

    public static byte unsignedLongToByteExact(long i) {
        if (Long.compareUnsigned(i, 128L) >= 0) {
            throw ConvertUtils.loss(Byte.class, Long.toUnsignedString(i));
        }
        return (byte)i;
    }

    public static byte unsignedLongToUnsignedByteExact(long i) {
        if (Long.compareUnsigned(i, 256L) >= 0) {
            throw ConvertUtils.lossUnsigned(Byte.class, Long.toUnsignedString(i));
        }
        return (byte)i;
    }

    public static short unsignedLongToShortExact(long i) {
        if (Long.compareUnsigned(i, 32768L) >= 0) {
            throw ConvertUtils.loss(Short.class, Long.toUnsignedString(i));
        }
        return (short)i;
    }

    public static short unsignedLongToUnsignedShortExact(long i) {
        if (Long.compareUnsigned(i, 65536L) >= 0) {
            throw ConvertUtils.lossUnsigned(Short.class, Long.toUnsignedString(i));
        }
        return (short)i;
    }

    public static int unsignedLongToIntExact(long i) {
        if (Long.compareUnsigned(i, 0x80000000L) >= 0) {
            throw ConvertUtils.loss(Integer.class, Long.toUnsignedString(i));
        }
        return (int)i;
    }

    public static int unsignedLongToUnsignedIntExact(long i) {
        if (Long.compareUnsigned(i, 0x100000000L) >= 0) {
            throw ConvertUtils.lossUnsigned(Integer.class, Long.toUnsignedString(i));
        }
        return (int)i;
    }

    public static long unsignedLongToLongExact(long i) {
        if (i < 0L) {
            throw ConvertUtils.loss(Long.class, Long.toUnsignedString(i));
        }
        return i;
    }

    public static float unsignedLongToFloatExact(long i) {
        float f = ConvertUtils.unsignedLongToBigDecimalExact(i).floatValue();
        if ((long)f != i) {
            throw ConvertUtils.loss(Float.class, Long.toUnsignedString(i));
        }
        return f;
    }

    public static double unsignedLongToDoubleExact(long i) {
        double d = ConvertUtils.unsignedLongToBigDecimalExact(i).doubleValue();
        if ((long)d != i) {
            throw ConvertUtils.loss(Double.class, Long.toUnsignedString(i));
        }
        return d;
    }

    public static BigInteger unsignedLongToBigIntegerExact(long i) {
        if (i >= 0L) {
            return BigInteger.valueOf(i);
        }
        byte[] magnitude = new byte[8];
        RowUtils.encodeLongBE(magnitude, 0, i);
        return new BigInteger(1, magnitude);
    }

    public static BigDecimal unsignedLongToBigDecimalExact(long i) {
        if (i >= 0L) {
            return BigDecimal.valueOf(i);
        }
        byte[] magnitude = new byte[8];
        RowUtils.encodeLongBE(magnitude, 0, i);
        return new BigDecimal(new BigInteger(1, magnitude));
    }

    public static float longToFloatExact(long i) {
        float f = i;
        if ((long)f != i) {
            throw ConvertUtils.loss(Float.class, i);
        }
        return f;
    }

    public static double longToDoubleExact(long i) {
        double d = i;
        if ((long)d != i) {
            throw ConvertUtils.loss(Double.class, i);
        }
        return d;
    }

    public static byte biToUnsignedByteExact(BigInteger bi) {
        try {
            int i = bi.intValueExact();
            if (Integer.compareUnsigned(i, 256) < 0) {
                return (byte)i;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        throw ConvertUtils.lossUnsigned(Byte.class, bi);
    }

    public static short biToUnsignedShortExact(BigInteger bi) {
        try {
            int i = bi.intValueExact();
            if (Integer.compareUnsigned(i, 65536) < 0) {
                return (short)i;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        throw ConvertUtils.lossUnsigned(Short.class, bi);
    }

    public static int biToUnsignedIntExact(BigInteger bi) {
        try {
            long i = bi.longValueExact();
            if (Long.compareUnsigned(i, 0x100000000L) < 0) {
                return (int)i;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        throw ConvertUtils.lossUnsigned(Integer.class, bi);
    }

    public static long biToUnsignedLongExact(BigInteger bi) {
        if (bi.signum() < 0 || bi.bitLength() > 64) {
            throw ConvertUtils.lossUnsigned(Long.class, bi);
        }
        return bi.longValue();
    }

    public static float biToFloatExact(BigInteger bi) {
        return ConvertUtils.bdToFloatExact(new BigDecimal(bi));
    }

    public static double biToDoubleExact(BigInteger bi) {
        return ConvertUtils.bdToDoubleExact(new BigDecimal(bi));
    }

    public static byte bdToUnsignedByteExact(BigDecimal bd) {
        try {
            int i = bd.intValueExact();
            if (Integer.compareUnsigned(i, 256) < 0) {
                return (byte)i;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        throw ConvertUtils.lossUnsigned(Byte.class, bd);
    }

    public static short bdToUnsignedShortExact(BigDecimal bd) {
        try {
            int i = bd.intValueExact();
            if (Integer.compareUnsigned(i, 65536) < 0) {
                return (short)i;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        throw ConvertUtils.lossUnsigned(Short.class, bd);
    }

    public static int bdToUnsignedIntExact(BigDecimal bd) {
        try {
            long i = bd.longValueExact();
            if (Long.compareUnsigned(i, 0x100000000L) < 0) {
                return (int)i;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        throw ConvertUtils.lossUnsigned(Integer.class, bd);
    }

    public static long bdToUnsignedLongExact(BigDecimal bd) {
        try {
            BigInteger bi = bd.toBigIntegerExact();
            if (bi.signum() >= 0 && bi.bitLength() <= 64) {
                return bi.longValue();
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        throw ConvertUtils.lossUnsigned(Long.class, bd);
    }

    public static float bdToFloatExact(BigDecimal bd) {
        float f = bd.floatValue();
        if (BigDecimalUtils.valueOf(f).compareTo(bd) != 0) {
            throw ConvertUtils.loss(Float.class, bd);
        }
        return f;
    }

    public static double bdToDoubleExact(BigDecimal bd) {
        double d = bd.doubleValue();
        if (BigDecimal.valueOf(d).compareTo(bd) != 0) {
            throw ConvertUtils.loss(Double.class, bd);
        }
        return d;
    }

    private static ArithmeticException loss(Class to, Object value) {
        return ConvertUtils.loss("", to, value);
    }

    private static ArithmeticException lossUnsigned(Class to, Object value) {
        return ConvertUtils.loss("unsigned ", to, value);
    }

    private static ArithmeticException loss(String prefix, Class to, Object value) {
        return new ArithmeticException("Cannot exactly convert to " + prefix + to.getSimpleName() + ": " + value);
    }
}

