/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.ConversionException;
import org.cojen.tupl.rows.BigDecimalUtils;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.ConvertUtils;

public class Converter {
    static void decodeLossy(MethodMaker mm, Variable srcVar, Variable offsetVar, Variable endVar, ColumnCodec srcCodec, ColumnInfo dstInfo, Variable dstVar) {
        if (dstInfo.type.isAssignableFrom(srcCodec.mInfo.type) && (!srcCodec.mInfo.isNullable() || dstInfo.isNullable())) {
            srcCodec.decode(dstVar, srcVar, offsetVar, endVar);
        } else {
            Variable tempVar = mm.var(srcCodec.mInfo.type);
            srcCodec.decode(tempVar, srcVar, offsetVar, endVar);
            Converter.convertLossy(mm, srcCodec.mInfo, tempVar, dstInfo, dstVar);
        }
    }

    static void convertLossy(MethodMaker mm, ColumnInfo srcInfo, Variable srcVar, ColumnInfo dstInfo, Variable dstVar) {
        if (srcInfo.isCompatibleWith(dstInfo)) {
            dstVar.set((Object)srcVar);
            return;
        }
        Label end = mm.label();
        if (srcInfo.isNullable()) {
            Label notNull = mm.label();
            srcVar.ifNe(null, notNull);
            if (dstInfo.isNullable()) {
                dstVar.set(null);
            } else {
                Converter.setDefault(mm, dstInfo, dstVar);
            }
            mm.goto_(end);
            notNull.here();
        }
        if (dstInfo.isArray()) {
            ColumnInfo dstElementInfo = dstInfo.nonArray();
            if (srcInfo.isArray()) {
                ColumnInfo srcElementInfo = srcInfo.nonArray();
                dstVar.set((Object)ConvertUtils.convertArray(mm, dstVar.classType(), srcVar.alength(), ixVar -> {
                    Variable dstElementVar = mm.var(dstElementInfo.type);
                    Converter.convertLossy(mm, srcElementInfo, srcVar.aget(ixVar), dstElementInfo, dstElementVar);
                    return dstElementVar;
                }));
            } else if (srcInfo.plainTypeCode() == 24 && dstElementInfo.plainTypeCode() == 20) {
                Variable lengthVar = srcVar.invoke("length", new Object[0]);
                dstVar.set((Object)mm.new_((Object)dstVar, new Object[]{lengthVar}));
                srcVar.invoke("getChars", new Object[]{0, lengthVar, dstVar, 0});
            } else {
                Variable dstElementVar = mm.var(dstElementInfo.type);
                Converter.convertLossy(mm, srcInfo, srcVar, dstElementInfo, dstElementVar);
                dstVar.set((Object)mm.new_((Object)dstVar, new Object[]{1}));
                dstVar.aset((Object)0, (Object)dstElementVar);
            }
            end.here();
            return;
        }
        if (srcInfo.isArray()) {
            ColumnInfo srcElementInfo = srcInfo.nonArray();
            if (srcElementInfo.plainTypeCode() == 20 && dstInfo.plainTypeCode() == 24) {
                dstVar.set((Object)mm.var(String.class).invoke("valueOf", new Object[]{srcVar}));
            } else {
                Label notEmpty = mm.label();
                srcVar.alength().ifNe((Object)0, notEmpty);
                Converter.setDefault(mm, dstInfo, dstVar);
                mm.goto_(end);
                notEmpty.here();
                Converter.convertLossy(mm, srcElementInfo, srcVar.aget((Object)0), dstInfo, dstVar);
            }
            end.here();
            return;
        }
        int srcPlainTypeCode = srcInfo.plainTypeCode();
        if (dstInfo.isAssignableFrom(srcPlainTypeCode)) {
            dstVar.set((Object)srcVar);
            end.here();
            return;
        }
        int dstPlainTypeCode = dstInfo.plainTypeCode();
        boolean handled = true;
        block0 : switch (dstPlainTypeCode) {
            case 0: {
                switch (srcPlainTypeCode) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        dstVar.set((Object)srcVar.gt((Object)0));
                        break block0;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        dstVar.set((Object)srcVar.ne((Object)0));
                        break block0;
                    }
                    case 17: {
                        dstVar.set((Object)srcVar.ge((Object)Float.valueOf(1.0f)));
                        break block0;
                    }
                    case 18: {
                        dstVar.set((Object)srcVar.ge((Object)1.0));
                        break block0;
                    }
                    case 28: {
                        dstVar.set((Object)srcVar.invoke("compareTo", new Object[]{mm.var(BigInteger.class).field("ZERO")}).gt((Object)0));
                        break block0;
                    }
                    case 29: {
                        dstVar.set((Object)srcVar.invoke("compareTo", new Object[]{mm.var(BigDecimal.class).field("ONE")}).ge((Object)0));
                        break block0;
                    }
                    case 20: {
                        Variable utils = mm.var(Converter.class);
                        if (dstInfo.type.isPrimitive()) {
                            dstVar.set((Object)utils.invoke("charToBoolean", new Object[]{srcVar}));
                            break block0;
                        }
                        Boolean default_ = dstInfo.isNullable() ? null : Boolean.valueOf(false);
                        dstVar.set((Object)utils.invoke("charToBoolean", new Object[]{srcVar, default_}));
                        break block0;
                    }
                    case 24: {
                        Variable utils = mm.var(Converter.class);
                        if (dstInfo.type.isPrimitive()) {
                            dstVar.set((Object)utils.invoke("stringToBoolean", new Object[]{srcVar}));
                            break block0;
                        }
                        Boolean default_ = dstInfo.isNullable() ? null : Boolean.valueOf(false);
                        dstVar.set((Object)utils.invoke("stringToBoolean", new Object[]{srcVar, default_}));
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 11: {
                switch (srcPlainTypeCode) {
                    case 0: {
                        Converter.boolToNum(mm, srcVar, dstVar);
                        break block0;
                    }
                    case 12: 
                    case 13: 
                    case 14: {
                        Converter.clampSS(mm, srcVar, -128, 127, dstVar);
                        break block0;
                    }
                    case 3: {
                        Converter.clampUS(mm, srcVar, 127L, dstVar);
                        break block0;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        Converter.clampUS_narrow(mm, srcVar, 127, dstVar);
                        break block0;
                    }
                    case 20: {
                        Converter.clampUS_narrow(mm, srcVar.cast(Integer.TYPE), 127, dstVar);
                        break block0;
                    }
                    case 17: 
                    case 18: {
                        Converter.clampSS(mm, srcVar.cast(Integer.TYPE), -128, 127, dstVar);
                        break block0;
                    }
                    case 28: {
                        Converter.clampBigInteger_narrow(mm, srcVar, -128L, 127L, dstInfo, dstVar, "byteValue");
                        break block0;
                    }
                    case 29: {
                        Converter.clampBigDecimal_narrow(mm, srcVar, -128L, 127L, dstInfo, dstVar, "byteValue");
                        break block0;
                    }
                    case 24: {
                        Variable bd = Converter.parseBigDecimal(mm, srcVar, dstInfo, dstVar, end);
                        Converter.clampBigDecimal_narrow(mm, bd, -128L, 127L, dstInfo, dstVar, "byteValue");
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 12: {
                switch (srcPlainTypeCode) {
                    case 0: {
                        Converter.boolToNum(mm, srcVar, dstVar);
                        break block0;
                    }
                    case 13: 
                    case 14: {
                        Converter.clampSS(mm, srcVar, Short.MIN_VALUE, Short.MAX_VALUE, dstVar);
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)255).cast(Short.TYPE));
                        break block0;
                    }
                    case 4: {
                        Converter.clampUS(mm, srcVar, 32767L, dstVar);
                        break block0;
                    }
                    case 5: 
                    case 6: {
                        Converter.clampUS_narrow(mm, srcVar, Short.MAX_VALUE, dstVar);
                        break block0;
                    }
                    case 20: {
                        Converter.clampUS_narrow(mm, srcVar.cast(Integer.TYPE), Short.MAX_VALUE, dstVar);
                        break block0;
                    }
                    case 17: 
                    case 18: {
                        Converter.clampSS(mm, srcVar.cast(Integer.TYPE), Short.MIN_VALUE, Short.MAX_VALUE, dstVar);
                        break block0;
                    }
                    case 28: {
                        Converter.clampBigInteger_narrow(mm, srcVar, -32768L, 32767L, dstInfo, dstVar, "shortValue");
                        break block0;
                    }
                    case 29: {
                        Converter.clampBigDecimal_narrow(mm, srcVar, -32768L, 32767L, dstInfo, dstVar, "shortValue");
                        break block0;
                    }
                    case 24: {
                        Variable bd = Converter.parseBigDecimal(mm, srcVar, dstInfo, dstVar, end);
                        Converter.clampBigDecimal_narrow(mm, bd, -32768L, 32767L, dstInfo, dstVar, "shortValue");
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 13: {
                switch (srcPlainTypeCode) {
                    case 0: {
                        Converter.boolToNum(mm, srcVar, dstVar);
                        break block0;
                    }
                    case 14: {
                        Converter.clampSS(mm, srcVar, Integer.MIN_VALUE, Integer.MAX_VALUE, dstVar);
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)255));
                        break block0;
                    }
                    case 4: 
                    case 20: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)65535));
                        break block0;
                    }
                    case 5: {
                        Converter.clampUS(mm, srcVar, Integer.MAX_VALUE, dstVar);
                        break block0;
                    }
                    case 6: {
                        Converter.clampUS_narrow(mm, srcVar, Integer.MAX_VALUE, dstVar);
                        break block0;
                    }
                    case 17: 
                    case 18: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE));
                        break block0;
                    }
                    case 28: {
                        Converter.clampBigInteger_narrow(mm, srcVar, Integer.MIN_VALUE, Integer.MAX_VALUE, dstInfo, dstVar, "intValue");
                        break block0;
                    }
                    case 29: {
                        Converter.clampBigDecimal_narrow(mm, srcVar, Integer.MIN_VALUE, Integer.MAX_VALUE, dstInfo, dstVar, "intValue");
                        break block0;
                    }
                    case 24: {
                        Variable bd = Converter.parseBigDecimal(mm, srcVar, dstInfo, dstVar, end);
                        Converter.clampBigDecimal_narrow(mm, bd, Integer.MIN_VALUE, Integer.MAX_VALUE, dstInfo, dstVar, "intValue");
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 14: {
                switch (srcPlainTypeCode) {
                    case 0: {
                        Converter.boolToNum(mm, srcVar, dstVar);
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE).and((Object)255L));
                        break block0;
                    }
                    case 4: 
                    case 20: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE).and((Object)65535L));
                        break block0;
                    }
                    case 5: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE).and((Object)0xFFFFFFFFL));
                        break block0;
                    }
                    case 6: {
                        Converter.clampUS(mm, srcVar, Long.MAX_VALUE, dstVar);
                        break block0;
                    }
                    case 17: 
                    case 18: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE));
                        break block0;
                    }
                    case 28: {
                        Converter.clampBigInteger_narrow(mm, srcVar, Long.MIN_VALUE, Long.MAX_VALUE, dstInfo, dstVar, "longValue");
                        break block0;
                    }
                    case 29: {
                        Converter.clampBigDecimal_narrow(mm, srcVar, Long.MIN_VALUE, Long.MAX_VALUE, dstInfo, dstVar, "longValue");
                        break block0;
                    }
                    case 24: {
                        Variable bd = Converter.parseBigDecimal(mm, srcVar, dstInfo, dstVar, end);
                        Converter.clampBigDecimal_narrow(mm, bd, Long.MIN_VALUE, Long.MAX_VALUE, dstInfo, dstVar, "longValue");
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 3: {
                switch (srcPlainTypeCode) {
                    case 0: {
                        Converter.boolToNum(mm, srcVar, dstVar);
                        break block0;
                    }
                    case 11: {
                        Converter.clampSU(mm, srcVar, dstVar);
                        break block0;
                    }
                    case 12: 
                    case 13: 
                    case 14: {
                        Converter.clampSU_narrow(mm, srcVar, 255, dstVar);
                        break block0;
                    }
                    case 4: 
                    case 5: {
                        Converter.clampUU_narrow(mm, srcVar, 255, dstVar);
                        break block0;
                    }
                    case 20: {
                        Converter.clampUU_narrow(mm, srcVar.cast(Integer.TYPE), 255, dstVar);
                        break block0;
                    }
                    case 6: {
                        Converter.clampUU_narrow(mm, srcVar, 255L, dstVar);
                        break block0;
                    }
                    case 17: {
                        Converter.clampSU_narrow(mm, srcVar.cast(Integer.TYPE), 255, dstVar);
                        break block0;
                    }
                    case 18: {
                        Converter.clampSU_narrow(mm, srcVar.cast(Long.TYPE), 255L, dstVar);
                        break block0;
                    }
                    case 28: {
                        Converter.clampBigInteger_narrow(mm, srcVar, 0L, 255L, dstInfo, dstVar, "byteValue");
                        break block0;
                    }
                    case 29: {
                        Converter.clampBigDecimal_narrow(mm, srcVar, 0L, 255L, dstInfo, dstVar, "byteValue");
                        break block0;
                    }
                    case 24: {
                        Variable bd = Converter.parseBigDecimal(mm, srcVar, dstInfo, dstVar, end);
                        Converter.clampBigDecimal_narrow(mm, bd, 0L, 255L, dstInfo, dstVar, "byteValue");
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 4: {
                switch (srcPlainTypeCode) {
                    case 0: {
                        Converter.boolToNum(mm, srcVar, dstVar);
                        break block0;
                    }
                    case 11: 
                    case 12: {
                        Converter.clampSU(mm, srcVar, dstVar);
                        break block0;
                    }
                    case 13: 
                    case 14: {
                        Converter.clampSU_narrow(mm, srcVar, 65535, dstVar);
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)255).cast(Short.TYPE));
                        break block0;
                    }
                    case 5: {
                        Converter.clampUU_narrow(mm, srcVar, 65535, dstVar);
                        break block0;
                    }
                    case 6: {
                        Converter.clampUU_narrow(mm, srcVar, 65535L, dstVar);
                        break block0;
                    }
                    case 17: {
                        Converter.clampSU_narrow(mm, srcVar.cast(Integer.TYPE), 65535, dstVar);
                        break block0;
                    }
                    case 18: {
                        Converter.clampSU_narrow(mm, srcVar.cast(Long.TYPE), 65535L, dstVar);
                        break block0;
                    }
                    case 20: {
                        dstVar.set((Object)srcVar.cast(Short.TYPE));
                        break block0;
                    }
                    case 28: {
                        Converter.clampBigInteger_narrow(mm, srcVar, 0L, 65535L, dstInfo, dstVar, "shortValue");
                        break block0;
                    }
                    case 29: {
                        Converter.clampBigDecimal_narrow(mm, srcVar, 0L, 65535L, dstInfo, dstVar, "shortValue");
                        break block0;
                    }
                    case 24: {
                        Variable bd = Converter.parseBigDecimal(mm, srcVar, dstInfo, dstVar, end);
                        Converter.clampBigDecimal_narrow(mm, bd, 0L, 65535L, dstInfo, dstVar, "shortValue");
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 5: {
                switch (srcPlainTypeCode) {
                    case 0: {
                        Converter.boolToNum(mm, srcVar, dstVar);
                        break block0;
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        Converter.clampSU(mm, srcVar, dstVar);
                        break block0;
                    }
                    case 14: {
                        Converter.clampSU_narrow(mm, srcVar, 0xFFFFFFFFL, dstVar);
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)255));
                        break block0;
                    }
                    case 4: 
                    case 20: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)65535));
                        break block0;
                    }
                    case 6: {
                        Converter.clampUU_narrow(mm, srcVar, 0xFFFFFFFFL, dstVar);
                        break block0;
                    }
                    case 17: 
                    case 18: {
                        Converter.clampSU_narrow(mm, srcVar.cast(Long.TYPE), 0xFFFFFFFFL, dstVar);
                        break block0;
                    }
                    case 28: {
                        Converter.clampBigInteger_narrow(mm, srcVar, 0L, 0xFFFFFFFFL, dstInfo, dstVar, "intValue");
                        break block0;
                    }
                    case 29: {
                        Converter.clampBigDecimal_narrow(mm, srcVar, 0L, 0xFFFFFFFFL, dstInfo, dstVar, "intValue");
                        break block0;
                    }
                    case 24: {
                        Variable bd = Converter.parseBigDecimal(mm, srcVar, dstInfo, dstVar, end);
                        Converter.clampBigDecimal_narrow(mm, bd, 0L, 0xFFFFFFFFL, dstInfo, dstVar, "intValue");
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 6: {
                switch (srcPlainTypeCode) {
                    case 0: {
                        Converter.boolToNum(mm, srcVar, dstVar);
                        break block0;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        Converter.clampSU(mm, srcVar, dstVar);
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE).and((Object)255));
                        break block0;
                    }
                    case 4: 
                    case 20: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE).and((Object)65535));
                        break block0;
                    }
                    case 5: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE).and((Object)0xFFFFFFFFL));
                        break block0;
                    }
                    case 17: 
                    case 18: {
                        dstVar.set((Object)mm.var(Converter.class).invoke("doubleToUnsignedLong", new Object[]{srcVar}));
                        break block0;
                    }
                    case 28: {
                        Converter.clampBigIntegerU_narrow(mm, srcVar, dstInfo, dstVar);
                        break block0;
                    }
                    case 29: {
                        Converter.clampBigDecimalU_narrow(mm, srcVar, dstInfo, dstVar);
                        break block0;
                    }
                    case 24: {
                        Variable bd = Converter.parseBigDecimal(mm, srcVar, dstInfo, dstVar, end);
                        Converter.clampBigDecimalU_narrow(mm, bd, dstInfo, dstVar);
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 17: {
                switch (srcPlainTypeCode) {
                    case 0: {
                        Converter.boolToNum(mm, srcVar, dstVar);
                        break block0;
                    }
                    case 13: 
                    case 14: 
                    case 18: {
                        dstVar.set((Object)Converter.unbox(srcVar).cast((Object)dstVar));
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)255).cast((Object)dstVar));
                        break block0;
                    }
                    case 4: 
                    case 20: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)65535).cast((Object)dstVar));
                        break block0;
                    }
                    case 5: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE).and((Object)0xFFFFFFFFL).cast((Object)dstVar));
                        break block0;
                    }
                    case 6: {
                        Variable bd = mm.var(BigDecimal.class);
                        Converter.convert("unsignedLongToBigDecimalExact", srcVar, bd);
                        dstVar.set((Object)bd.invoke("floatValue", new Object[0]));
                        break block0;
                    }
                    case 28: 
                    case 29: {
                        dstVar.set((Object)srcVar.invoke("floatValue", new Object[0]));
                        break block0;
                    }
                    case 24: {
                        Converter.parseNumber(mm, "parseFloat", srcVar, dstInfo, dstVar);
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 18: {
                switch (srcPlainTypeCode) {
                    case 0: {
                        Converter.boolToNum(mm, srcVar, dstVar);
                        break block0;
                    }
                    case 14: {
                        dstVar.set((Object)Converter.unbox(srcVar).cast((Object)dstVar));
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)255).cast((Object)dstVar));
                        break block0;
                    }
                    case 4: 
                    case 20: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)65535).cast((Object)dstVar));
                        break block0;
                    }
                    case 5: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE).and((Object)0xFFFFFFFFL).cast((Object)dstVar));
                        break block0;
                    }
                    case 6: {
                        Variable bd = mm.var(BigDecimal.class);
                        Converter.convert("unsignedLongToBigDecimalExact", srcVar, bd);
                        dstVar.set((Object)bd.invoke("doubleValue", new Object[0]));
                        break block0;
                    }
                    case 28: 
                    case 29: {
                        dstVar.set((Object)srcVar.invoke("doubleValue", new Object[0]));
                        break block0;
                    }
                    case 24: {
                        Converter.parseNumber(mm, "parseDouble", srcVar, dstInfo, dstVar);
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 20: {
                switch (srcPlainTypeCode) {
                    case 0: {
                        Label L1 = mm.label();
                        srcVar.ifTrue(L1);
                        Label cont = mm.label();
                        dstVar.set((Object)Character.valueOf('f'));
                        mm.goto_(cont);
                        L1.here();
                        dstVar.set((Object)Character.valueOf('t'));
                        cont.here();
                        break block0;
                    }
                    case 11: 
                    case 12: {
                        Converter.clampSU(mm, srcVar, dstVar);
                        break block0;
                    }
                    case 13: 
                    case 14: {
                        Converter.clampSU_narrow(mm, srcVar, 65535, (Object)Character.valueOf('\uffff'), dstVar);
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)255).cast(Character.TYPE));
                        break block0;
                    }
                    case 4: {
                        dstVar.set((Object)srcVar.cast(Character.TYPE));
                        break block0;
                    }
                    case 5: {
                        Converter.clampUU_narrow(mm, srcVar, 65535, (Object)Character.valueOf('\uffff'), dstVar);
                        break block0;
                    }
                    case 6: {
                        Converter.clampUU_narrow(mm, srcVar, 65535L, (Object)Character.valueOf('\uffff'), dstVar);
                        break block0;
                    }
                    case 17: {
                        Converter.clampSU_narrow(mm, srcVar.cast(Integer.TYPE), 65535, (Object)Character.valueOf('\uffff'), dstVar);
                        break block0;
                    }
                    case 18: {
                        Converter.clampSU_narrow(mm, srcVar.cast(Long.TYPE), 65535L, (Object)Character.valueOf('\uffff'), dstVar);
                        break block0;
                    }
                    case 28: {
                        Converter.clampBigInteger_narrow(mm, srcVar, 0L, 65535L, dstInfo, dstVar, "intValue");
                        break block0;
                    }
                    case 29: {
                        Converter.clampBigDecimal_narrow(mm, srcVar, 0L, 65535L, dstInfo, dstVar, "intValue");
                        break block0;
                    }
                    case 24: {
                        Label L1 = mm.label();
                        srcVar.invoke("isEmpty", new Object[0]).ifFalse(L1);
                        Converter.setDefault(mm, dstInfo, dstVar);
                        Label cont = mm.label().goto_();
                        L1.here();
                        dstVar.set((Object)srcVar.invoke("charAt", new Object[]{0}));
                        cont.here();
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 24: {
                switch (srcPlainTypeCode) {
                    case 3: {
                        dstVar.set((Object)mm.var(Integer.class).invoke("toUnsignedString", new Object[]{srcVar.cast(Integer.TYPE).and((Object)255)}));
                        break block0;
                    }
                    case 4: {
                        dstVar.set((Object)mm.var(Integer.class).invoke("toUnsignedString", new Object[]{srcVar.cast(Integer.TYPE).and((Object)65535)}));
                        break block0;
                    }
                    case 5: 
                    case 6: {
                        dstVar.set((Object)srcVar.invoke("toUnsignedString", new Object[]{srcVar}));
                        break block0;
                    }
                }
                dstVar.set((Object)mm.var(String.class).invoke("valueOf", new Object[]{srcVar}));
                break;
            }
            case 28: {
                Variable bi = mm.var(BigInteger.class);
                switch (srcPlainTypeCode) {
                    case 0: {
                        Label isFalse = mm.label();
                        srcVar.ifFalse(isFalse);
                        dstVar.set((Object)bi.field("ONE"));
                        mm.goto_(end);
                        isFalse.here();
                        dstVar.set((Object)bi.field("ZERO"));
                        break block0;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        dstVar.set((Object)bi.invoke("valueOf", new Object[]{srcVar}));
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)bi.invoke("valueOf", new Object[]{srcVar.cast(Long.TYPE).and((Object)255L)}));
                        break block0;
                    }
                    case 4: 
                    case 20: {
                        dstVar.set((Object)bi.invoke("valueOf", new Object[]{srcVar.cast(Long.TYPE).and((Object)65535L)}));
                        break block0;
                    }
                    case 5: {
                        dstVar.set((Object)bi.invoke("valueOf", new Object[]{srcVar.cast(Long.TYPE).and((Object)0xFFFFFFFFL)}));
                        break block0;
                    }
                    case 6: {
                        Converter.convert("unsignedLongToBigIntegerExact", srcVar, dstVar);
                        break block0;
                    }
                    case 29: {
                        dstVar.set((Object)srcVar.invoke("toBigInteger", new Object[0]));
                        break block0;
                    }
                    case 17: 
                    case 18: {
                        Label tryStart = mm.label().here();
                        Class clazz = srcPlainTypeCode == 17 ? BigDecimalUtils.class : BigDecimal.class;
                        dstVar.set((Object)mm.var(clazz).invoke("valueOf", new Object[]{srcVar}).invoke("toBigInteger", new Object[0]));
                        mm.catch_(tryStart, NumberFormatException.class, exVar -> {
                            Converter.setDefault(mm, dstInfo, dstVar);
                            mm.goto_(end);
                        });
                        break block0;
                    }
                    case 24: {
                        Variable bd = Converter.parseBigDecimal(mm, srcVar, dstInfo, dstVar, end);
                        dstVar.set((Object)bd.invoke("toBigInteger", new Object[0]));
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 29: {
                Variable bd = mm.var(BigDecimal.class);
                switch (srcPlainTypeCode) {
                    case 0: {
                        Label isFalse = mm.label();
                        srcVar.ifFalse(isFalse);
                        dstVar.set((Object)bd.field("ONE"));
                        mm.goto_(end);
                        isFalse.here();
                        dstVar.set((Object)bd.field("ZERO"));
                        break block0;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        dstVar.set((Object)bd.invoke("valueOf", new Object[]{srcVar}));
                        break block0;
                    }
                    case 17: 
                    case 18: {
                        Label tryStart = mm.label().here();
                        dstVar.set((Object)mm.var(BigDecimalUtils.class).invoke("toBigDecimal", new Object[]{srcVar}));
                        mm.catch_(tryStart, NumberFormatException.class, exVar -> {
                            Converter.setDefault(mm, dstInfo, dstVar);
                            mm.goto_(end);
                        });
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)bd.invoke("valueOf", new Object[]{srcVar.cast(Long.TYPE).and((Object)255L)}));
                        break block0;
                    }
                    case 4: 
                    case 20: {
                        dstVar.set((Object)bd.invoke("valueOf", new Object[]{srcVar.cast(Long.TYPE).and((Object)65535L)}));
                        break block0;
                    }
                    case 5: {
                        dstVar.set((Object)bd.invoke("valueOf", new Object[]{srcVar.cast(Long.TYPE).and((Object)0xFFFFFFFFL)}));
                        break block0;
                    }
                    case 6: {
                        Converter.convert("unsignedLongToBigDecimalExact", srcVar, dstVar);
                        break block0;
                    }
                    case 28: {
                        dstVar.set((Object)mm.new_((Object)bd, new Object[]{srcVar}));
                        break block0;
                    }
                    case 24: {
                        Converter.parseBigDecimal(mm, srcVar, dstInfo, dstVar, end);
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            default: {
                handled = false;
            }
        }
        if (!handled) {
            Converter.setDefault(mm, dstInfo, dstVar);
        }
        end.here();
    }

    static void decodeExact(MethodMaker mm, String columnName, Variable srcVar, Variable offsetVar, Variable endVar, ColumnCodec srcCodec, ColumnInfo dstInfo, Variable dstVar) {
        if (dstInfo.type.isAssignableFrom(srcCodec.mInfo.type) && (!srcCodec.mInfo.isNullable() || dstInfo.isNullable())) {
            srcCodec.decode(dstVar, srcVar, offsetVar, endVar);
        } else {
            Variable tempVar = mm.var(srcCodec.mInfo.type);
            srcCodec.decode(tempVar, srcVar, offsetVar, endVar);
            Converter.convertExact(mm, columnName, srcCodec.mInfo, tempVar, dstInfo, dstVar);
        }
    }

    static void convertExact(MethodMaker mm, String columnName, ColumnInfo srcInfo, Variable srcVar, ColumnInfo dstInfo, Variable dstVar) {
        if (srcInfo.isCompatibleWith(dstInfo)) {
            dstVar.set((Object)srcVar);
            return;
        }
        Label tryStart = mm.label().here();
        Converter.doConvertExact(mm, columnName, srcInfo, srcVar, dstInfo, dstVar);
        Label tryEnd = mm.label().here();
        Label done = mm.label().goto_();
        mm.catch_(tryStart, tryEnd, ConversionException.class).throw_();
        Variable exVar = mm.catch_(tryStart, tryEnd, RuntimeException.class);
        Variable messageVar = mm.var(Converter.class).invoke("exceptionMessage", new Object[]{exVar});
        mm.new_(ConversionException.class, new Object[]{messageVar, columnName}).throw_();
        done.here();
    }

    private static void doConvertExact(MethodMaker mm, String columnName, ColumnInfo srcInfo, Variable srcVar, ColumnInfo dstInfo, Variable dstVar) {
        Label end = mm.label();
        if (srcInfo.isNullable()) {
            Label notNull = mm.label();
            srcVar.ifNe(null, notNull);
            if (dstInfo.isNullable()) {
                dstVar.set(null);
            } else {
                mm.new_(ConversionException.class, new Object[]{"Cannot assign null to non-nullable type", columnName}).throw_();
            }
            mm.goto_(end);
            notNull.here();
        }
        if (dstInfo.isArray()) {
            ColumnInfo dstElementInfo = dstInfo.nonArray();
            if (srcInfo.isArray()) {
                ColumnInfo srcElementInfo = srcInfo.nonArray();
                dstVar.set((Object)ConvertUtils.convertArray(mm, dstVar.classType(), srcVar.alength(), ixVar -> {
                    Variable dstElementVar = mm.var(dstElementInfo.type);
                    Converter.convertExact(mm, columnName, srcElementInfo, srcVar.aget(ixVar), dstElementInfo, dstElementVar);
                    return dstElementVar;
                }));
            } else {
                Converter.throwConvertFailException(mm, columnName, srcInfo, dstInfo);
            }
            end.here();
            return;
        }
        if (srcInfo.isArray()) {
            Converter.throwConvertFailException(mm, columnName, srcInfo, dstInfo);
            end.here();
            return;
        }
        int srcPlainTypeCode = srcInfo.plainTypeCode();
        if (dstInfo.isAssignableFrom(srcPlainTypeCode)) {
            dstVar.set((Object)srcVar);
            end.here();
            return;
        }
        int dstPlainTypeCode = dstInfo.plainTypeCode();
        boolean handled = true;
        block0 : switch (dstPlainTypeCode) {
            case 0: {
                switch (srcPlainTypeCode) {
                    case 24: {
                        Converter.convert("stringToBooleanExact", srcVar, dstVar);
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 11: {
                switch (srcPlainTypeCode) {
                    case 12: {
                        Converter.convert("shortToByteExact", srcVar, dstVar);
                        break block0;
                    }
                    case 13: {
                        Converter.convert("intToByteExact", srcVar, dstVar);
                        break block0;
                    }
                    case 14: {
                        Converter.convert("longToByteExact", srcVar, dstVar);
                        break block0;
                    }
                    case 3: {
                        Converter.convert("unsignedIntToByteExact", srcVar.cast(Integer.TYPE).and((Object)255), dstVar);
                        break block0;
                    }
                    case 4: {
                        Converter.convert("unsignedIntToByteExact", srcVar.cast(Integer.TYPE).and((Object)65535), dstVar);
                        break block0;
                    }
                    case 5: {
                        Converter.convert("unsignedIntToByteExact", srcVar, dstVar);
                        break block0;
                    }
                    case 6: {
                        Converter.convert("unsignedLongToByteExact", srcVar, dstVar);
                        break block0;
                    }
                    case 17: {
                        Converter.convert("floatToByteExact", srcVar, dstVar);
                        break block0;
                    }
                    case 18: {
                        Converter.convert("doubleToByteExact", srcVar, dstVar);
                        break block0;
                    }
                    case 28: 
                    case 29: {
                        dstVar.set((Object)srcVar.invoke("byteValueExact", new Object[0]));
                        break block0;
                    }
                    case 24: {
                        dstVar.set((Object)mm.var(Byte.class).invoke("parseByte", new Object[]{srcVar}));
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 12: {
                switch (srcPlainTypeCode) {
                    case 13: {
                        Converter.convert("intToShortExact", srcVar, dstVar);
                        break block0;
                    }
                    case 14: {
                        Converter.convert("longToShortExact", srcVar, dstVar);
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)255).cast(Short.TYPE));
                        break block0;
                    }
                    case 4: {
                        Converter.convert("unsignedIntToShortExact", srcVar.cast(Integer.TYPE).and((Object)65535), dstVar);
                        break block0;
                    }
                    case 5: {
                        Converter.convert("unsignedIntToShortExact", srcVar, dstVar);
                        break block0;
                    }
                    case 6: {
                        Converter.convert("unsignedLongToShortExact", srcVar, dstVar);
                        break block0;
                    }
                    case 17: {
                        Converter.convert("floatToShortExact", srcVar, dstVar);
                        break block0;
                    }
                    case 18: {
                        Converter.convert("doubleToShortExact", srcVar, dstVar);
                        break block0;
                    }
                    case 28: 
                    case 29: {
                        dstVar.set((Object)srcVar.invoke("shortValueExact", new Object[0]));
                        break block0;
                    }
                    case 24: {
                        dstVar.set((Object)mm.var(Short.class).invoke("parseShort", new Object[]{srcVar}));
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 13: {
                switch (srcPlainTypeCode) {
                    case 14: {
                        dstVar.set((Object)mm.var(Math.class).invoke("toIntExact", new Object[]{srcVar}));
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)255));
                        break block0;
                    }
                    case 4: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)65535));
                        break block0;
                    }
                    case 5: {
                        Converter.convert("unsignedIntToIntExact", srcVar, dstVar);
                        break block0;
                    }
                    case 6: {
                        Converter.convert("unsignedLongToIntExact", srcVar, dstVar);
                        break block0;
                    }
                    case 17: {
                        Converter.convert("floatToIntExact", srcVar, dstVar);
                        break block0;
                    }
                    case 18: {
                        Converter.convert("doubleToIntExact", srcVar, dstVar);
                        break block0;
                    }
                    case 28: 
                    case 29: {
                        dstVar.set((Object)srcVar.invoke("intValueExact", new Object[0]));
                        break block0;
                    }
                    case 24: {
                        dstVar.set((Object)mm.var(Integer.class).invoke("parseInt", new Object[]{srcVar}));
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 14: {
                switch (srcPlainTypeCode) {
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE).and((Object)255L));
                        break block0;
                    }
                    case 4: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE).and((Object)65535L));
                        break block0;
                    }
                    case 5: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE).and((Object)0xFFFFFFFFL));
                        break block0;
                    }
                    case 6: {
                        Converter.convert("unsignedLongToLongExact", srcVar, dstVar);
                        break block0;
                    }
                    case 17: {
                        Converter.convert("floatToLongExact", srcVar, dstVar);
                        break block0;
                    }
                    case 18: {
                        Converter.convert("doubleToLongExact", srcVar, dstVar);
                        break block0;
                    }
                    case 28: 
                    case 29: {
                        dstVar.set((Object)srcVar.invoke("longValueExact", new Object[0]));
                        break block0;
                    }
                    case 24: {
                        dstVar.set((Object)mm.var(Long.class).invoke("parseLong", new Object[]{srcVar}));
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 3: {
                switch (srcPlainTypeCode) {
                    case 11: 
                    case 12: 
                    case 13: {
                        Converter.convert("intToUnsignedByteExact", srcVar, dstVar);
                        break block0;
                    }
                    case 14: {
                        Converter.convert("longToUnsignedByteExact", srcVar, dstVar);
                        break block0;
                    }
                    case 4: {
                        Converter.convert("unsignedIntToUnsignedByteExact", srcVar.cast(Integer.TYPE).and((Object)65535), dstVar);
                        break block0;
                    }
                    case 5: {
                        Converter.convert("unsignedIntToUnsignedByteExact", srcVar, dstVar);
                        break block0;
                    }
                    case 6: {
                        Converter.convert("unsignedLongToUnsignedByteExact", srcVar, dstVar);
                        break block0;
                    }
                    case 17: {
                        Converter.convert("floatToUnsignedByteExact", srcVar, dstVar);
                        break block0;
                    }
                    case 18: {
                        Converter.convert("doubleToUnsignedByteExact", srcVar, dstVar);
                        break block0;
                    }
                    case 28: {
                        Converter.convert("biToUnsignedByteExact", srcVar, dstVar);
                        break block0;
                    }
                    case 29: {
                        Converter.convert("bdToUnsignedByteExact", srcVar, dstVar);
                        break block0;
                    }
                    case 24: {
                        Variable intVar = mm.var(Integer.class).invoke("parseUnsignedInt", new Object[]{srcVar, 10});
                        Converter.convert("intToUnsignedByteExact", intVar, dstVar);
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 4: {
                switch (srcPlainTypeCode) {
                    case 11: 
                    case 12: 
                    case 13: {
                        Converter.convert("intToUnsignedShortExact", srcVar, dstVar);
                        break block0;
                    }
                    case 14: {
                        Converter.convert("longToUnsignedShortExact", srcVar, dstVar);
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)255).cast(Short.TYPE));
                        break block0;
                    }
                    case 5: {
                        Converter.convert("unsignedIntToUnsignedShortExact", srcVar, dstVar);
                        break block0;
                    }
                    case 6: {
                        Converter.convert("unsignedLongToUnsignedShortExact", srcVar, dstVar);
                        break block0;
                    }
                    case 17: {
                        Converter.convert("floatToUnsignedShortExact", srcVar, dstVar);
                        break block0;
                    }
                    case 18: {
                        Converter.convert("doubleToUnsignedShortExact", srcVar, dstVar);
                        break block0;
                    }
                    case 28: {
                        Converter.convert("biToUnsignedShortExact", srcVar, dstVar);
                        break block0;
                    }
                    case 29: {
                        Converter.convert("bdToUnsignedShortExact", srcVar, dstVar);
                        break block0;
                    }
                    case 24: {
                        Variable intVar = mm.var(Integer.class).invoke("parseUnsignedInt", new Object[]{srcVar, 10});
                        Converter.convert("intToUnsignedShortExact", intVar, dstVar);
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 5: {
                switch (srcPlainTypeCode) {
                    case 11: 
                    case 12: 
                    case 13: {
                        Converter.convert("intToUnsignedIntExact", srcVar, dstVar);
                        break block0;
                    }
                    case 14: {
                        Converter.convert("longToUnsignedIntExact", srcVar, dstVar);
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)255));
                        break block0;
                    }
                    case 4: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)65535));
                        break block0;
                    }
                    case 6: {
                        Converter.convert("unsignedLongToUnsignedIntExact", srcVar, dstVar);
                        break block0;
                    }
                    case 17: {
                        Converter.convert("floatToUnsignedIntExact", srcVar, dstVar);
                        break block0;
                    }
                    case 18: {
                        Converter.convert("doubleToUnsignedIntExact", srcVar, dstVar);
                        break block0;
                    }
                    case 28: {
                        Converter.convert("biToUnsignedIntExact", srcVar, dstVar);
                        break block0;
                    }
                    case 29: {
                        Converter.convert("bdToUnsignedIntExact", srcVar, dstVar);
                        break block0;
                    }
                    case 24: {
                        dstVar.set((Object)mm.var(Integer.class).invoke("parseUnsignedInt", new Object[]{srcVar, 10}));
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 6: {
                switch (srcPlainTypeCode) {
                    case 11: 
                    case 12: 
                    case 13: {
                        Converter.convert("intToUnsignedLongExact", srcVar, dstVar);
                        break block0;
                    }
                    case 14: {
                        Converter.convert("longToUnsignedLongExact", srcVar, dstVar);
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE).and((Object)255));
                        break block0;
                    }
                    case 4: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE).and((Object)65535));
                        break block0;
                    }
                    case 5: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE).and((Object)0xFFFFFFFFL));
                        break block0;
                    }
                    case 17: {
                        Converter.convert("floatToUnsignedLongExact", srcVar, dstVar);
                        break block0;
                    }
                    case 18: {
                        Converter.convert("doubleToUnsignedLongExact", srcVar, dstVar);
                        break block0;
                    }
                    case 28: {
                        Converter.convert("biToUnsignedLongExact", srcVar, dstVar);
                        break block0;
                    }
                    case 29: {
                        Converter.convert("bdToUnsignedLongExact", srcVar, dstVar);
                        break block0;
                    }
                    case 24: {
                        dstVar.set((Object)mm.var(Long.class).invoke("parseUnsignedLong", new Object[]{srcVar, 10}));
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 17: {
                switch (srcPlainTypeCode) {
                    case 13: {
                        Converter.convert("intToFloatExact", srcVar, dstVar);
                        break block0;
                    }
                    case 14: {
                        Converter.convert("longToFloatExact", srcVar, dstVar);
                        break block0;
                    }
                    case 18: {
                        Converter.convert("doubleToFloatExact", srcVar, dstVar);
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)255).cast((Object)dstVar));
                        break block0;
                    }
                    case 4: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)65535).cast((Object)dstVar));
                        break block0;
                    }
                    case 5: {
                        Converter.convert("longToFloatExact", srcVar.cast(Long.TYPE).and((Object)0xFFFFFFFFL), dstVar);
                        break block0;
                    }
                    case 6: {
                        Converter.convert("unsignedLongToFloatExact", srcVar, dstVar);
                        break block0;
                    }
                    case 28: {
                        Converter.convert("biToFloatExact", srcVar, dstVar);
                        break block0;
                    }
                    case 29: {
                        Converter.convert("bdToFloatExact", srcVar, dstVar);
                        break block0;
                    }
                    case 24: {
                        dstVar.set((Object)mm.var(Float.class).invoke("parseFloat", new Object[]{srcVar}));
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 18: {
                switch (srcPlainTypeCode) {
                    case 14: {
                        Converter.convert("longToDoubleExact", srcVar, dstVar);
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)255).cast((Object)dstVar));
                        break block0;
                    }
                    case 4: {
                        dstVar.set((Object)srcVar.cast(Integer.TYPE).and((Object)65535).cast((Object)dstVar));
                        break block0;
                    }
                    case 5: {
                        dstVar.set((Object)srcVar.cast(Long.TYPE).and((Object)0xFFFFFFFFL).cast((Object)dstVar));
                        break block0;
                    }
                    case 6: {
                        Converter.convert("unsignedLongToDoubleExact", srcVar, dstVar);
                        break block0;
                    }
                    case 28: {
                        Converter.convert("biToDoubleExact", srcVar, dstVar);
                        break block0;
                    }
                    case 29: {
                        Converter.convert("bdToDoubleExact", srcVar, dstVar);
                        break block0;
                    }
                    case 24: {
                        dstVar.set((Object)mm.var(Double.class).invoke("parseDouble", new Object[]{srcVar}));
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 20: {
                switch (srcPlainTypeCode) {
                    case 24: {
                        Converter.convert("stringToCharExact", srcVar, dstVar);
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 24: {
                switch (srcPlainTypeCode) {
                    case 3: {
                        dstVar.set((Object)mm.var(Integer.class).invoke("toUnsignedString", new Object[]{srcVar.cast(Integer.TYPE).and((Object)255)}));
                        break block0;
                    }
                    case 4: {
                        dstVar.set((Object)mm.var(Integer.class).invoke("toUnsignedString", new Object[]{srcVar.cast(Integer.TYPE).and((Object)65535)}));
                        break block0;
                    }
                    case 5: 
                    case 6: {
                        dstVar.set((Object)srcVar.invoke("toUnsignedString", new Object[]{srcVar}));
                        break block0;
                    }
                }
                dstVar.set((Object)mm.var(String.class).invoke("valueOf", new Object[]{srcVar}));
                break;
            }
            case 28: {
                Variable bi = mm.var(BigInteger.class);
                switch (srcPlainTypeCode) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        dstVar.set((Object)bi.invoke("valueOf", new Object[]{srcVar}));
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)bi.invoke("valueOf", new Object[]{srcVar.cast(Long.TYPE).and((Object)255L)}));
                        break block0;
                    }
                    case 4: {
                        dstVar.set((Object)bi.invoke("valueOf", new Object[]{srcVar.cast(Long.TYPE).and((Object)65535L)}));
                        break block0;
                    }
                    case 5: {
                        dstVar.set((Object)bi.invoke("valueOf", new Object[]{srcVar.cast(Long.TYPE).and((Object)0xFFFFFFFFL)}));
                        break block0;
                    }
                    case 6: {
                        Converter.convert("unsignedLongToBigIntegerExact", srcVar, dstVar);
                        break block0;
                    }
                    case 29: {
                        dstVar.set((Object)srcVar.invoke("toBigIntegerExact", new Object[0]));
                        break block0;
                    }
                    case 17: {
                        dstVar.set((Object)mm.var(BigDecimalUtils.class).invoke("valueOf", new Object[]{srcVar}).invoke("toBigIntegerExact", new Object[0]));
                        break block0;
                    }
                    case 18: {
                        dstVar.set((Object)mm.var(BigDecimal.class).invoke("valueOf", new Object[]{srcVar}).invoke("toBigIntegerExact", new Object[0]));
                        break block0;
                    }
                    case 24: {
                        dstVar.set((Object)mm.new_((Object)bi, new Object[]{srcVar}));
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            case 29: {
                Variable bd = mm.var(BigDecimal.class);
                switch (srcPlainTypeCode) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        dstVar.set((Object)bd.invoke("valueOf", new Object[]{srcVar}));
                        break block0;
                    }
                    case 17: 
                    case 18: {
                        dstVar.set((Object)mm.var(BigDecimalUtils.class).invoke("toBigDecimal", new Object[]{srcVar}));
                        break block0;
                    }
                    case 3: {
                        dstVar.set((Object)bd.invoke("valueOf", new Object[]{srcVar.cast(Long.TYPE).and((Object)255L)}));
                        break block0;
                    }
                    case 4: {
                        dstVar.set((Object)bd.invoke("valueOf", new Object[]{srcVar.cast(Long.TYPE).and((Object)65535L)}));
                        break block0;
                    }
                    case 5: {
                        dstVar.set((Object)bd.invoke("valueOf", new Object[]{srcVar.cast(Long.TYPE).and((Object)0xFFFFFFFFL)}));
                        break block0;
                    }
                    case 6: {
                        Converter.convert("unsignedLongToBigDecimalExact", srcVar, dstVar);
                        break block0;
                    }
                    case 24: 
                    case 28: {
                        dstVar.set((Object)mm.new_((Object)bd, new Object[]{srcVar}));
                        break block0;
                    }
                }
                handled = false;
                break;
            }
            default: {
                handled = false;
            }
        }
        if (!handled) {
            Converter.throwConvertFailException(mm, columnName, srcInfo, dstInfo);
        }
        end.here();
    }

    static void setDefault(MethodMaker mm, ColumnInfo dstInfo, Variable dstVar) {
        if (dstInfo.isNullable()) {
            dstVar.set(null);
        } else if (dstInfo.isArray()) {
            dstVar.set((Object)mm.new_((Object)dstVar.classType(), new Object[]{0}));
        } else {
            switch (dstInfo.plainTypeCode()) {
                case 0: {
                    dstVar.set((Object)false);
                    break;
                }
                case 24: {
                    dstVar.set((Object)"");
                    break;
                }
                case 28: 
                case 29: {
                    dstVar.set((Object)dstVar.field("ZERO"));
                    break;
                }
                default: {
                    dstVar.set((Object)0);
                }
            }
        }
    }

    private static void throwConvertFailException(MethodMaker mm, String columnName, ColumnInfo srcInfo, ColumnInfo dstInfo) {
        Variable messageVar = mm.var(String.class);
        messageVar.set((Object)("Cannot convert " + Converter.typeName(srcInfo) + " to " + Converter.typeName(dstInfo)));
        mm.new_(ConversionException.class, new Object[]{messageVar, columnName}).throw_();
    }

    private static String typeName(ColumnInfo info) {
        String name = info.boxedType().getSimpleName();
        if (info.isUnsigned()) {
            return "unsigned " + name;
        }
        return name;
    }

    private static void convert(String methodName, Variable srcVar, Variable dstVar) {
        MethodMaker mm = srcVar.methodMaker();
        dstVar.set((Object)mm.var(ConvertUtils.class).invoke(methodName, new Object[]{srcVar}));
    }

    private static void boolToNum(MethodMaker mm, Variable srcVar, Variable dstVar) {
        Label isFalse = mm.label();
        srcVar.ifFalse(isFalse);
        dstVar.set((Object)1);
        Label cont = mm.label().goto_();
        isFalse.here();
        dstVar.set((Object)0);
        cont.here();
    }

    private static void parseNumber(MethodMaker mm, String method, Variable srcVar, ColumnInfo dstInfo, Variable dstVar) {
        Label tryStart = mm.label().here();
        dstVar.set((Object)dstVar.invoke(method, new Object[]{srcVar}));
        mm.catch_(tryStart, NumberFormatException.class, ex -> Converter.setDefault(mm, dstInfo, dstVar));
    }

    private static void clampSS(MethodMaker mm, Variable srcVar, int min, int max, Variable dstVar) {
        srcVar = Converter.unbox(srcVar);
        Label cont = mm.label();
        Label L1 = mm.label();
        srcVar.ifGt((Object)min, L1);
        dstVar.set((Object)min);
        mm.goto_(cont);
        L1.here();
        Label L2 = mm.label();
        srcVar.ifLe((Object)max, L2);
        dstVar.set((Object)max);
        mm.goto_(cont);
        L2.here();
        dstVar.set((Object)srcVar.cast((Object)dstVar));
        cont.here();
    }

    private static void clampUS(MethodMaker mm, Variable srcVar, long max, Variable dstVar) {
        srcVar = Converter.unbox(srcVar);
        Label cont = mm.label();
        Label L1 = mm.label();
        srcVar.ifGe((Object)0, L1);
        dstVar.set((Object)max);
        mm.goto_(cont);
        L1.here();
        dstVar.set((Object)srcVar.cast((Object)dstVar));
        cont.here();
    }

    private static void clampUS_narrow(MethodMaker mm, Variable srcVar, int max, Variable dstVar) {
        srcVar = Converter.unbox(srcVar);
        Label cont = mm.label();
        Label L1 = mm.label();
        srcVar.and((Object)(~max)).ifEq((Object)0, L1);
        dstVar.set((Object)max);
        mm.goto_(cont);
        L1.here();
        dstVar.set((Object)srcVar.cast((Object)dstVar));
        cont.here();
    }

    private static void clampUU_narrow(MethodMaker mm, Variable srcVar, int max, Variable dstVar) {
        Converter.clampUU_narrow(mm, srcVar, max, (Object)-1, dstVar);
    }

    private static void clampUU_narrow(MethodMaker mm, Variable srcVar, int max, Object clampMax, Variable dstVar) {
        srcVar = Converter.unbox(srcVar);
        Label cont = mm.label();
        Label L1 = mm.label();
        srcVar.and((Object)(~max)).ifEq((Object)0, L1);
        dstVar.set(clampMax);
        mm.goto_(cont);
        L1.here();
        dstVar.set((Object)srcVar.and((Object)max).cast((Object)dstVar));
        cont.here();
    }

    private static void clampUU_narrow(MethodMaker mm, Variable srcVar, long max, Variable dstVar) {
        Converter.clampUU_narrow(mm, srcVar, max, (Object)-1L, dstVar);
    }

    private static void clampUU_narrow(MethodMaker mm, Variable srcVar, long max, Object clampMax, Variable dstVar) {
        srcVar = Converter.unbox(srcVar);
        Label cont = mm.label();
        Label L1 = mm.label();
        srcVar.and((Object)(max ^ 0xFFFFFFFFFFFFFFFFL)).ifEq((Object)0, L1);
        dstVar.set(clampMax);
        mm.goto_(cont);
        L1.here();
        dstVar.set((Object)srcVar.and((Object)max).cast((Object)dstVar));
        cont.here();
    }

    private static void clampSU(MethodMaker mm, Variable srcVar, Variable dstVar) {
        srcVar = Converter.unbox(srcVar);
        Label cont = mm.label();
        Label L1 = mm.label();
        srcVar.ifGe((Object)0, L1);
        dstVar.set((Object)0);
        mm.goto_(cont);
        L1.here();
        dstVar.set((Object)srcVar.cast((Object)dstVar));
        cont.here();
    }

    private static void clampSU_narrow(MethodMaker mm, Variable srcVar, int max, Variable dstVar) {
        Converter.clampSU_narrow(mm, srcVar, max, (Object)-1, dstVar);
    }

    private static void clampSU_narrow(MethodMaker mm, Variable srcVar, int max, Object clampMax, Variable dstVar) {
        srcVar = Converter.unbox(srcVar);
        Label cont = mm.label();
        Label L1 = mm.label();
        srcVar.ifGt((Object)0, L1);
        dstVar.set((Object)0);
        mm.goto_(cont);
        L1.here();
        Label L2 = mm.label();
        srcVar.ifLe((Object)max, L2);
        dstVar.set(clampMax);
        mm.goto_(cont);
        L2.here();
        dstVar.set((Object)srcVar.cast((Object)dstVar));
        cont.here();
    }

    private static void clampSU_narrow(MethodMaker mm, Variable srcVar, long max, Variable dstVar) {
        Converter.clampSU_narrow(mm, srcVar, max, (Object)-1L, dstVar);
    }

    private static void clampSU_narrow(MethodMaker mm, Variable srcVar, long max, Object clampMax, Variable dstVar) {
        srcVar = Converter.unbox(srcVar);
        Label cont = mm.label();
        Label L1 = mm.label();
        srcVar.ifGt((Object)0, L1);
        dstVar.set((Object)0);
        mm.goto_(cont);
        L1.here();
        Label L2 = mm.label();
        srcVar.ifLe((Object)max, L2);
        dstVar.set(clampMax);
        mm.goto_(cont);
        L2.here();
        dstVar.set((Object)srcVar.cast((Object)dstVar));
        cont.here();
    }

    private static void clampBigInteger_narrow(MethodMaker mm, Variable srcVar, long min, long max, ColumnInfo dstInfo, Variable dstVar, String method) {
        Converter.clampBig_narrow(mm, srcVar, min, BigInteger.valueOf(min), max, BigInteger.valueOf(max), dstInfo, dstVar, method);
    }

    private static void clampBigDecimal_narrow(MethodMaker mm, Variable srcVar, long min, long max, ColumnInfo dstInfo, Variable dstVar, String method) {
        Converter.clampBig_narrow(mm, srcVar, min, BigDecimal.valueOf(min), max, BigDecimal.valueOf(max), dstInfo, dstVar, method);
    }

    private static void clampBigIntegerU_narrow(MethodMaker mm, Variable srcVar, ColumnInfo dstInfo, Variable dstVar) {
        Converter.clampBig_narrow(mm, srcVar, 0L, BigInteger.ZERO, -1L, new BigInteger(Long.toUnsignedString(-1L)), dstInfo, dstVar, "longValue");
    }

    private static void clampBigDecimalU_narrow(MethodMaker mm, Variable srcVar, ColumnInfo dstInfo, Variable dstVar) {
        Converter.clampBig_narrow(mm, srcVar, 0L, BigDecimal.ZERO, -1L, new BigDecimal(Long.toUnsignedString(-1L)), dstInfo, dstVar, "longValue");
    }

    private static void clampBig_narrow(MethodMaker mm, Variable srcVar, long min, Number minObj, long max, Number maxObj, ColumnInfo dstInfo, Variable dstVar, String method) {
        Label cont = mm.label();
        Label L1 = mm.label();
        srcVar.invoke("compareTo", new Object[]{mm.var((Object)srcVar).setExact((Object)minObj)}).ifGt((Object)0, L1);
        dstVar.set((Object)min);
        mm.goto_(cont);
        L1.here();
        Label L2 = mm.label();
        srcVar.invoke("compareTo", new Object[]{mm.var((Object)srcVar).setExact((Object)maxObj)}).ifLe((Object)0, L2);
        switch (dstInfo.plainTypeCode()) {
            case 3: 
            case 11: {
                dstVar.set((Object)((byte)max));
                break;
            }
            case 4: 
            case 12: {
                dstVar.set((Object)((short)max));
                break;
            }
            case 5: 
            case 13: {
                dstVar.set((Object)((int)max));
                break;
            }
            default: {
                dstVar.set((Object)max);
            }
        }
        mm.goto_(cont);
        L2.here();
        Variable v = srcVar.invoke(method, new Object[0]);
        if (dstInfo.plainTypeCode() == 20) {
            v = v.cast(Character.TYPE);
        }
        dstVar.set((Object)v);
        cont.here();
    }

    private static Variable parseBigDecimal(MethodMaker mm, Variable srcVar, ColumnInfo dstInfo, Variable dstVar, Label end) {
        Label tryStart = mm.label().here();
        Variable bd = mm.new_(BigDecimal.class, new Object[]{srcVar});
        if (dstInfo.type == BigDecimal.class) {
            dstVar.set((Object)bd);
            bd = null;
        }
        mm.catch_(tryStart, NumberFormatException.class, exVar -> {
            Converter.setDefault(mm, dstInfo, dstVar);
            mm.goto_(end);
        });
        return bd;
    }

    private static Variable unbox(Variable v) {
        return v.classType().isPrimitive() ? v : v.unbox();
    }

    public static boolean charToBoolean(char c) {
        return switch (c) {
            case '\u0000', '0', 'F', 'f' -> false;
            case '\u0001', '1', 'T', 't' -> true;
            default -> c <= '\t' || '1' < c && c <= '9';
        };
    }

    public static Boolean charToBoolean(char c, Boolean default_) {
        switch (c) {
            case '\u0000': 
            case '0': 
            case 'F': 
            case 'f': {
                return false;
            }
            case '\u0001': 
            case '1': 
            case 'T': 
            case 't': {
                return true;
            }
        }
        if (c <= '\t' || '1' < c && c <= '9') {
            return true;
        }
        return default_;
    }

    public static boolean stringToBoolean(String str) {
        if (str.equalsIgnoreCase("false")) {
            return false;
        }
        if (str.equalsIgnoreCase("true")) {
            return true;
        }
        try {
            return new BigDecimal(str).compareTo(BigDecimal.ONE) >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static Boolean stringToBoolean(String str, Boolean default_) {
        if (str.equalsIgnoreCase("false")) {
            return false;
        }
        if (str.equalsIgnoreCase("true")) {
            return true;
        }
        try {
            return new BigDecimal(str).compareTo(BigDecimal.ONE) >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return default_;
        }
    }

    public static long doubleToUnsignedLong(double d) {
        if (d <= 0.0) {
            return 0L;
        }
        long result = (long)d;
        if (result < Long.MAX_VALUE) {
            return result;
        }
        if (d >= 1.8446744073709552E19) {
            return -1L;
        }
        return BigDecimal.valueOf(d).longValue();
    }

    public static String exceptionMessage(Throwable e) {
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        return message;
    }
}

