/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import java.util.Set;
import org.cojen.maker.Field;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.Converter;
import org.cojen.tupl.rows.Encoder;
import org.cojen.tupl.rows.ExceptionCallSite;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.rows.RowUtils;

public class DecodePartialMaker {
    private DecodePartialMaker() {
    }

    public static byte[] makeFullSpec(RowGen rowGen, RowGen primaryRowGen, Map<String, ColumnInfo> projection) {
        return projection == null ? null : DecodePartialMaker.makeFullSpec(rowGen, primaryRowGen, projection.keySet());
    }

    public static byte[] makeFullSpec(RowGen rowGen, RowGen primaryRowGen, Set<String> projection) {
        BitSet toMarkCleanBits;
        if (projection == null) {
            return null;
        }
        BitSet toDecodeBits = new BitSet();
        Map<String, Integer> columnNumbers = rowGen.columnNumbers();
        for (String name : projection) {
            toDecodeBits.set(columnNumbers.get(name));
        }
        if (primaryRowGen == null) {
            toMarkCleanBits = null;
        } else {
            toMarkCleanBits = new BitSet();
            Map<String, Integer> columnNumbers2 = primaryRowGen.columnNumbers();
            for (String name : projection) {
                toMarkCleanBits.set(columnNumbers2.get(name));
            }
        }
        return DecodePartialMaker.makeSpec(toDecodeBits, toMarkCleanBits);
    }

    private static byte[] makeSpec(BitSet toDecodeBits, BitSet toMarkCleanBits) {
        Encoder encoder;
        byte[] toDecode = toDecodeBits.toByteArray();
        byte[] toMarkClean = toMarkCleanBits == null ? null : toMarkCleanBits.toByteArray();
        int capacity = 1 + toDecode.length;
        if (toMarkClean == null) {
            encoder = new Encoder(capacity);
            encoder.writeBytes(toDecode);
        } else {
            encoder = new Encoder(capacity + 1 + toMarkClean.length);
            encoder.writeBytes(toDecode);
            encoder.writeBytes(toMarkClean);
        }
        return encoder.toByteArray();
    }

    static BitSet[] decodeSpec(byte[] spec) {
        BitSet toMarkClean;
        int len = RowUtils.decodePrefixPF(spec, 0);
        int offset = RowUtils.lengthPrefixPF(len);
        BitSet toDecode = BitSet.valueOf(Arrays.copyOfRange(spec, offset, offset += len));
        if (offset >= spec.length) {
            toMarkClean = toDecode;
        } else {
            len = RowUtils.decodePrefixPF(spec, offset);
            toMarkClean = BitSet.valueOf(Arrays.copyOfRange(spec, offset += RowUtils.lengthPrefixPF(len), offset + len));
        }
        return new BitSet[]{toDecode, toMarkClean};
    }

    public static MethodHandle makeDecoder(MethodHandles.Lookup lookup, WeakReference<RowStore> storeRef, Class<?> rowType, Class<?> rowClass, Class<?> tableClass, long indexId, byte[] spec, int schemaVersion) {
        return ExceptionCallSite.make(() -> {
            MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, null, (String)"decodeRow", (Object[])new Object[]{rowClass, byte[].class, byte[].class});
            RowStore store = (RowStore)storeRef.get();
            if (store == null) {
                mm.new_(DatabaseException.class, new Object[]{"Closed"}).throw_();
                return mm.finish();
            }
            Variable rowVar = mm.param(0);
            Variable keyVar = mm.param(1);
            Variable valueVar = mm.param(2);
            RowInfo dstRowInfo = RowInfo.find(rowType);
            RowGen dstRowGen = dstRowInfo.rowGen();
            BitSet[] sets = DecodePartialMaker.decodeSpec(spec);
            BitSet toDecode = sets[0];
            BitSet toMarkClean = sets[1];
            ColumnCodec[] keyCodecs = dstRowGen.keyCodecs();
            if (DecodePartialMaker.allRequested(toDecode, 0, keyCodecs.length)) {
                mm.var((Object)tableClass).invoke("decodePrimaryKey", new Object[]{rowVar, keyVar});
            } else {
                DecodePartialMaker.addDecodeColumns(mm, toDecode, rowVar, dstRowInfo, keyVar, keyCodecs, 0);
            }
            if (DecodePartialMaker.allRequested(toDecode, keyCodecs.length, dstRowInfo.allColumns.size())) {
                try {
                    MethodHandle mh = lookup.findStatic(tableClass, "decodeValueHandle", MethodType.methodType(MethodHandle.class, Integer.TYPE));
                    mh = mh.invokeExact(schemaVersion);
                    mm.invoke(mh, new Object[]{rowVar, valueVar});
                }
                catch (Throwable e) {
                    throw RowUtils.rethrow(e);
                }
            }
            if (schemaVersion == 0) {
                DecodePartialMaker.addDefaultColumns(mm, toDecode, rowVar, dstRowGen, dstRowInfo.valueColumns, null);
            } else {
                RowInfo srcRowInfo;
                try {
                    srcRowInfo = store.rowInfo(rowType, indexId, schemaVersion);
                }
                catch (Exception e) {
                    return new ExceptionCallSite.Failed(MethodType.methodType(Void.TYPE, rowClass, byte[].class, byte[].class), mm, e);
                }
                ColumnCodec[] srcCodecs = srcRowInfo.rowGen().valueCodecs();
                int fixedOffset = schemaVersion < 128 ? 1 : 4;
                DecodePartialMaker.addDecodeColumns(mm, toDecode, rowVar, dstRowInfo, valueVar, srcCodecs, fixedOffset);
                if (dstRowInfo != srcRowInfo) {
                    DecodePartialMaker.addDefaultColumns(mm, toDecode, rowVar, dstRowGen, dstRowInfo.valueColumns, srcRowInfo.valueColumns);
                }
            }
            int maxNum = dstRowInfo.allColumns.size();
            int mask = 0;
            int num = 0;
            while (num < maxNum) {
                if (toMarkClean.get(num)) {
                    mask |= RowGen.stateFieldMask(num, 1);
                }
                if ((++num & 0xF) != 0 && num < maxNum) continue;
                rowVar.field(dstRowGen.stateField(num - 1)).set((Object)mask);
                mask = 0;
            }
            return mm.finish();
        }).dynamicInvoker();
    }

    public static MethodHandle makeDecoder(MethodHandles.Lookup lookup, Class<?> rowType, Class<?> rowClass, Class<?> tableClass, byte[] secondaryDesc, byte[] spec) {
        MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, null, (String)"decodeRow", (Object[])new Object[]{rowClass, byte[].class, byte[].class});
        Variable rowVar = mm.param(0);
        Variable keyVar = mm.param(1);
        Variable valueVar = mm.param(2);
        RowInfo primaryRowInfo = RowInfo.find(rowType);
        RowInfo rowInfo = secondaryDesc == null ? primaryRowInfo : RowStore.secondaryRowInfo(primaryRowInfo, secondaryDesc);
        RowGen rowGen = rowInfo.rowGen();
        BitSet[] sets = DecodePartialMaker.decodeSpec(spec);
        BitSet toDecode = sets[0];
        BitSet toMarkClean = sets[1];
        ColumnCodec[] keyCodecs = rowGen.keyCodecs();
        if (DecodePartialMaker.allRequested(toDecode, 0, keyCodecs.length)) {
            mm.var(tableClass).invoke("decodePrimaryKey", new Object[]{rowVar, keyVar});
        } else {
            DecodePartialMaker.addDecodeColumns(mm, toDecode, rowVar, rowInfo, keyVar, keyCodecs, 0);
        }
        if (DecodePartialMaker.allRequested(toDecode, keyCodecs.length, rowInfo.allColumns.size())) {
            mm.var(tableClass).invoke("decodeValue", new Object[]{rowVar, valueVar});
        } else {
            ColumnCodec[] valueCodecs = rowGen.valueCodecs();
            DecodePartialMaker.addDecodeColumns(mm, toDecode, rowVar, rowInfo, valueVar, valueCodecs, 0);
        }
        RowGen primaryRowGen = primaryRowInfo.rowGen();
        Map<String, Integer> primaryColumnNumbers = primaryRowGen.columnNumbers();
        int maxNum = primaryColumnNumbers.size();
        int mask = 0;
        int num = 0;
        while (num < maxNum) {
            if (toMarkClean.get(num)) {
                mask |= RowGen.stateFieldMask(num, 1);
            }
            if ((++num & 0xF) != 0 && num < maxNum) continue;
            rowVar.field(primaryRowGen.stateField(num - 1)).set((Object)mask);
            mask = 0;
        }
        return mm.finish();
    }

    static boolean allRequested(BitSet toDecode, int from, int to) {
        return toDecode.get(from, to).cardinality() == to - from;
    }

    private static void addDecodeColumns(MethodMaker mm, BitSet toDecode, Variable rowVar, RowInfo dstRowInfo, Variable srcVar, ColumnCodec[] srcCodecs, int fixedOffset) {
        Map<String, Integer> columnNumbers = dstRowInfo.rowGen().columnNumbers();
        srcCodecs = ColumnCodec.bind(srcCodecs, mm);
        Variable offsetVar = mm.var(Integer.TYPE).set((Object)fixedOffset);
        int remaining = 0;
        for (ColumnCodec srcCodec : srcCodecs) {
            if (!toDecode.get(columnNumbers.get(srcCodec.mInfo.name))) continue;
            ++remaining;
        }
        if (remaining == 0) {
            return;
        }
        for (ColumnCodec srcCodec : srcCodecs) {
            ColumnInfo dstInfo;
            String name = srcCodec.mInfo.name;
            if (toDecode.get(columnNumbers.get(name)) && (dstInfo = (ColumnInfo)dstRowInfo.allColumns.get(name)) != null) {
                Field dstVar = rowVar.field(name);
                Converter.decodeLossy(mm, srcVar, offsetVar, null, srcCodec, dstInfo, (Variable)dstVar);
                if (--remaining > 0) continue;
                break;
            }
            srcCodec.decodeSkip(srcVar, offsetVar, null);
        }
    }

    private static void addDefaultColumns(MethodMaker mm, BitSet toDecode, Variable rowVar, RowGen dstRowGen, Map<String, ColumnInfo> dstColumns, Map<String, ColumnInfo> srcColumns) {
        for (Map.Entry<String, ColumnInfo> e : dstColumns.entrySet()) {
            String name = e.getKey();
            if (srcColumns != null && srcColumns.containsKey(name) || !toDecode.get(dstRowGen.columnNumbers().get(name))) continue;
            Converter.setDefault(mm, e.getValue(), (Variable)rowVar.field(name));
        }
    }
}

