/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.MethodHandle;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.filter.AndFilter;
import org.cojen.tupl.filter.ColumnToArgFilter;
import org.cojen.tupl.filter.ColumnToColumnFilter;
import org.cojen.tupl.filter.OrFilter;
import org.cojen.tupl.filter.RowFilter;
import org.cojen.tupl.filter.TrueFilter;
import org.cojen.tupl.filter.Visitor;
import org.cojen.tupl.rows.CodeUtils;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.CompareUtils;
import org.cojen.tupl.rows.Converter;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.SecondaryInfo;
import org.cojen.tupl.rows.StoppedCursorException;

class DecodeVisitor
extends Visitor {
    private final MethodMaker mMaker;
    private Variable mRowVar;
    private Variable mKeyVar;
    private Variable mValueVar;
    private Variable mCursorVar;
    private final int mValueOffset;
    private final RowGen mRowGen;
    private final Variable mPredicateVar;
    private final String mStopColumn;
    private final int mStopArgument;
    private final ColumnCodec[] mKeyCodecs;
    private final ColumnCodec[] mValueCodecs;
    private Label mPass;
    private Label mFail;
    private LocatedColumn[] mLocatedKeys;
    private int mHighestLocatedKey;
    private LocatedColumn[] mLocatedValues;
    private int mHighestLocatedValue;

    DecodeVisitor(MethodMaker mm, int valueOffset, RowGen rowGen, Variable predicateVar, String stopColumn, int stopArgument) {
        this.mMaker = mm;
        this.mValueOffset = valueOffset;
        this.mRowGen = rowGen;
        this.mPredicateVar = predicateVar;
        this.mStopColumn = stopColumn;
        this.mStopArgument = stopArgument;
        this.mKeyCodecs = ColumnCodec.bind(rowGen.keyCodecs(), mm);
        this.mValueCodecs = ColumnCodec.bind(rowGen.valueCodecs(), mm);
    }

    private void initVars(boolean requireValue) {
        if (this.mKeyVar != null) {
            return;
        }
        int offset = 0;
        this.mKeyVar = this.mMaker.param(offset);
        Class keyType = this.mKeyVar.classType();
        if (keyType == Cursor.class) {
            this.mCursorVar = this.mKeyVar;
            this.mKeyVar = this.mCursorVar.invoke("key", new Object[0]);
            if (requireValue) {
                this.mValueVar = this.mCursorVar.invoke("value", new Object[0]);
            }
        } else if (keyType == byte[].class) {
            this.mValueVar = this.mMaker.param(offset + 1);
            if (this.mValueVar.classType() == Cursor.class) {
                this.mCursorVar = this.mValueVar;
                this.mValueVar = requireValue ? this.mCursorVar.invoke("value", new Object[0]) : null;
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void applyFilter(RowFilter filter) {
        if (filter != TrueFilter.THE) {
            this.mPass = this.mMaker.label();
            this.mFail = this.mMaker.label();
            this.initVars(true);
            filter.accept(this);
        }
    }

    Variable[] joinToPrimary(Variable resultVar, Variable primaryCursorVar) {
        SecondaryInfo secInfo = (SecondaryInfo)this.mRowGen.info;
        boolean isAltKey = secInfo.isAltKey();
        this.initVars(isAltKey);
        if (this.mCursorVar == null) {
            throw new IllegalStateException();
        }
        this.passFail(null);
        Variable primaryKeyVar = isAltKey ? this.mMaker.invoke("toPrimaryKey", new Object[]{this.mKeyVar, this.mValueVar}) : this.mMaker.invoke("toPrimaryKey", new Object[]{this.mKeyVar});
        Variable primaryValueVar = primaryCursorVar == null ? this.mMaker.invoke("join", new Object[]{this.mCursorVar, resultVar, primaryKeyVar}) : this.mMaker.invoke("join", new Object[]{this.mCursorVar, resultVar, primaryKeyVar, primaryCursorVar});
        Label hasValue = this.mMaker.label();
        primaryValueVar.ifNe(null, hasValue);
        this.mMaker.return_(null);
        hasValue.here();
        return new Variable[]{primaryKeyVar, primaryValueVar};
    }

    void finishDecode(MethodHandle decoder, MethodHandle valueDecoder, Class<?> tableClass, Class<?> rowClass, Variable rowVar) {
        if (decoder != null && valueDecoder != null) {
            throw new IllegalArgumentException();
        }
        this.passFail(null);
        this.initVars(true);
        Label notRow = this.mMaker.label();
        Variable typedRowVar = CodeUtils.castOrNew(rowVar, rowClass, notRow);
        if (decoder != null) {
            this.mMaker.invoke(decoder, new Object[]{typedRowVar, this.mKeyVar, this.mValueVar});
        } else {
            Variable tableVar = this.mMaker.var(tableClass);
            tableVar.invoke("decodePrimaryKey", new Object[]{typedRowVar, this.mKeyVar});
            if (valueDecoder != null) {
                this.mMaker.invoke(valueDecoder, new Object[]{typedRowVar, this.mValueVar});
            } else {
                tableVar.invoke("decodeValue", new Object[]{typedRowVar, this.mValueVar});
            }
            tableVar.invoke("markAllClean", new Object[]{typedRowVar});
        }
        this.mMaker.return_((Object)typedRowVar);
        notRow.here();
        CodeUtils.acceptAsRowConsumerAndReturn(rowVar, rowClass, this.mKeyVar, this.mValueVar);
    }

    void finishPredicate() {
        this.passFail(false);
        this.mMaker.return_((Object)true);
    }

    private void passFail(Object failResult) {
        if (this.mFail != null) {
            this.mFail.here();
            this.mMaker.return_(failResult);
            this.mPass.here();
        }
    }

    @Override
    public void visit(OrFilter filter) {
        Label originalFail = this.mFail;
        RowFilter[] subFilters = filter.subFilters();
        if (subFilters.length == 0) {
            this.mMaker.goto_(originalFail);
            return;
        }
        this.mFail = this.mMaker.label();
        subFilters[0].accept(this);
        this.mFail.here();
        int hk = this.mHighestLocatedKey;
        int hv = this.mHighestLocatedValue;
        for (int i = 1; i < subFilters.length; ++i) {
            this.mFail = this.mMaker.label();
            subFilters[i].accept(this);
            this.mFail.here();
        }
        this.resetHighestLocatedKey(hk);
        this.resetHighestLocatedValue(hv);
        this.mMaker.goto_(originalFail);
        this.mFail = originalFail;
    }

    @Override
    public void visit(AndFilter filter) {
        Label originalPass = this.mPass;
        RowFilter[] subFilters = filter.subFilters();
        if (subFilters.length == 0) {
            this.mMaker.goto_(originalPass);
            return;
        }
        this.mPass = this.mMaker.label();
        subFilters[0].accept(this);
        this.mPass.here();
        int hk = this.mHighestLocatedKey;
        int hv = this.mHighestLocatedValue;
        for (int i = 1; i < subFilters.length; ++i) {
            this.mPass = this.mMaker.label();
            subFilters[i].accept(this);
            this.mPass.here();
        }
        this.resetHighestLocatedKey(hk);
        this.resetHighestLocatedValue(hv);
        this.mMaker.goto_(originalPass);
        this.mPass = originalPass;
    }

    @Override
    public void visit(ColumnToArgFilter filter) {
        Label originalFail = this.mFail;
        ColumnInfo colInfo = filter.column();
        int op = filter.operator();
        int argNum = filter.argument();
        Integer colNum = this.columnNumberFor(colInfo.name);
        Label stop = null;
        if (argNum == this.mStopArgument && colInfo.name.equals(this.mStopColumn) && this.mCursorVar != null) {
            this.mFail = stop = this.mMaker.label();
        }
        if (colNum != null) {
            ColumnCodec codec = this.codecFor(colNum);
            LocatedColumn located = this.decodeColumn(colNum, colInfo, true);
            Object decoded = located.mDecodedQuick;
            if (decoded != null) {
                codec.filterQuickCompare(colInfo, located.mSrcVar, located.mOffsetVar, op, decoded, this.mPredicateVar, argNum, this.mPass, this.mFail);
            } else {
                Variable columnVar = located.mDecodedVar;
                Field argField = this.mPredicateVar.field(ColumnCodec.argFieldName(colInfo, argNum));
                CompareUtils.compare(this.mMaker, colInfo, columnVar, colInfo, (Variable)argField, op, this.mPass, this.mFail);
            }
        } else {
            Field argField = this.mPredicateVar.field(ColumnCodec.argFieldName(colInfo, argNum));
            Variable columnVar = this.mMaker.var(colInfo.type);
            Converter.setDefault(this.mMaker, colInfo, columnVar);
            CompareUtils.compare(this.mMaker, colInfo, columnVar, colInfo, (Variable)argField, op, this.mPass, this.mFail);
        }
        if (stop != null) {
            stop.here();
            this.mCursorVar.invoke("reset", new Object[0]);
            this.mMaker.var(StoppedCursorException.class).field("THE").throw_();
            this.mFail = originalFail;
        }
    }

    @Override
    public void visit(ColumnToColumnFilter filter) {
        ColumnInfo aColInfo = filter.column();
        int op = filter.operator();
        ColumnInfo bColInfo = filter.otherColumn();
        Integer aColNum = this.columnNumberFor(aColInfo.name);
        Integer bColNum = this.columnNumberFor(bColInfo.name);
        if (aColNum == null && bColNum == null) {
            this.mMaker.goto_(CompareUtils.selectNullColumnToNullArg(op, this.mPass, this.mFail));
            return;
        }
        Variable aVar = this.decodeColumnOrDefault(aColNum, aColInfo);
        Variable bVar = this.decodeColumnOrDefault(bColNum, bColInfo);
        if (aVar.classType() != bVar.classType()) {
            ColumnInfo cColInfo = filter.common();
            Variable aConvertedVar = this.mMaker.var(cColInfo.type);
            Converter.convertLossy(this.mMaker, aColInfo, aVar, cColInfo, aConvertedVar);
            aColInfo = cColInfo;
            aVar = aConvertedVar;
            Variable bConvertedVar = this.mMaker.var(cColInfo.type);
            Converter.convertLossy(this.mMaker, bColInfo, bVar, cColInfo, bConvertedVar);
            bColInfo = cColInfo;
            bVar = bConvertedVar;
        }
        CompareUtils.compare(this.mMaker, aColInfo, aVar, bColInfo, bVar, op, this.mPass, this.mFail);
    }

    private Variable decodeColumnOrDefault(Integer colNum, ColumnInfo colInfo) {
        if (colNum != null) {
            return this.decodeColumn((int)colNum.intValue(), (ColumnInfo)colInfo, (boolean)false).mDecodedVar;
        }
        Variable colVar = this.mMaker.var(colInfo.type);
        Converter.setDefault(this.mMaker, colInfo, colVar);
        return colVar;
    }

    private Integer columnNumberFor(String colName) {
        return this.mRowGen.columnNumbers().get(colName);
    }

    private ColumnCodec codecFor(int colNum) {
        ColumnCodec[] codecs = this.mKeyCodecs;
        return colNum < codecs.length ? codecs[colNum] : this.mValueCodecs[colNum - codecs.length];
    }

    /*
     * Unable to fully structure code
     */
    private LocatedColumn decodeColumn(int colNum, ColumnInfo colInfo, boolean quick) {
        block20: {
            block21: {
                block19: {
                    codecs = this.mKeyCodecs;
                    if (colNum >= codecs.length) break block19;
                    highestNum = this.mHighestLocatedKey;
                    srcVar = this.mKeyVar;
                    located = this.mLocatedKeys;
                    if (this.mLocatedKeys != null) break block20;
                    this.mLocatedKeys = located = new LocatedColumn[this.mRowGen.info.keyColumns.size()];
                    startOffset = 0;
                    break block21;
                }
                colNum -= codecs.length;
                highestNum = this.mHighestLocatedValue;
                srcVar = this.mValueVar;
                codecs = this.mValueCodecs;
                located = this.mLocatedValues;
                if (this.mLocatedValues != null) break block20;
                located = new LocatedColumn[this.mRowGen.info.valueColumns.size()];
                this.mLocatedValues = located;
                startOffset = this.mValueOffset;
            }
            located[0] = new LocatedColumn();
            located[0].located(srcVar, this.mMaker.var(Integer.TYPE).set((Object)startOffset));
        }
        if (colNum < highestNum) {
            col = located[colNum];
            if (col.isDecoded(quick)) {
                return col;
            }
            highestNum = colNum;
        }
        if (!located[highestNum].isLocated()) {
            throw new AssertionError();
        }
        while (highestNum <= colNum) {
            block23: {
                block22: {
                    offsetVar = located[highestNum].mOffsetVar;
                    if (highestNum + 1 < located.length) break block22;
                    next = null;
                    ** GOTO lbl-1000
                }
                next = located[highestNum + 1];
                if (next != null) break block23;
                located[highestNum + 1] = next = new LocatedColumn();
                ** GOTO lbl-1000
            }
            if (!next.isLocated() && (freeVar = next.mOffsetVar) != null) {
                freeVar.set((Object)offsetVar);
                offsetVar = freeVar;
            } else lbl-1000:
            // 3 sources

            {
                offsetVar = offsetVar.get();
            }
            codec = codecs[highestNum];
            endVar = null;
            if (highestNum < colNum) {
                codec.decodeSkip(srcVar, offsetVar, endVar);
            } else if (quick && codec.canFilterQuick(colInfo)) {
                decoded = codec.filterQuickDecode(colInfo, srcVar, offsetVar, endVar);
                located[highestNum].decodedQuick(decoded);
            } else {
                dstVar = this.mMaker.var(colInfo.type);
                Converter.decodeLossy(this.mMaker, srcVar, offsetVar, endVar, codec, colInfo, dstVar);
                located[highestNum].decodedVar(dstVar);
            }
            if (next != null && !next.isLocated()) {
                next.located(srcVar, offsetVar);
            }
            ++highestNum;
        }
        highestNum = Math.min(highestNum, located.length - 1);
        if (located == this.mLocatedKeys) {
            if (highestNum > this.mHighestLocatedKey) {
                this.mHighestLocatedKey = highestNum;
            }
        } else if (highestNum > this.mHighestLocatedValue) {
            this.mHighestLocatedValue = highestNum;
        }
        return located[colNum];
    }

    private void resetHighestLocatedKey(int colNum) {
        if (colNum < this.mHighestLocatedKey) {
            this.mHighestLocatedKey = colNum;
            DecodeVisitor.finishReset(this.mLocatedKeys, colNum);
        }
    }

    private void resetHighestLocatedValue(int colNum) {
        if (colNum < this.mHighestLocatedValue) {
            this.mHighestLocatedValue = colNum;
            DecodeVisitor.finishReset(this.mLocatedValues, colNum);
        }
    }

    private static void finishReset(LocatedColumn[] columns, int colNum) {
        LocatedColumn col;
        while (++colNum < columns.length && (col = columns[colNum]) != null) {
            col.unlocated();
        }
    }

    private static class LocatedColumn {
        private static final int UNLOCATED = 0;
        private static final int LOCATED = 1;
        private static final int DECODED = 2;
        private int mState;
        Variable mSrcVar;
        Variable mOffsetVar;
        Object mDecodedQuick;
        Variable mDecodedVar;

        LocatedColumn() {
        }

        boolean isLocated() {
            return this.mState >= 1;
        }

        boolean isDecoded(boolean quick) {
            return this.mState == 2 && (quick || this.mDecodedVar != null);
        }

        void located(Variable srcVar, Variable offsetVar) {
            this.mSrcVar = srcVar;
            this.mOffsetVar = offsetVar;
            this.mState = 1;
        }

        void decodedQuick(Object decoded) {
            if (this.mState == 0) {
                throw new IllegalStateException();
            }
            this.mDecodedQuick = decoded;
            this.mState = 2;
        }

        void decodedVar(Variable decodedVar) {
            if (this.mState == 0) {
                throw new IllegalStateException();
            }
            this.mDecodedVar = decodedVar;
            this.mState = 2;
        }

        void unlocated() {
            this.mDecodedQuick = null;
            this.mDecodedVar = null;
            this.mState = 0;
        }
    }
}

