/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import java.util.Set;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Updater;
import org.cojen.tupl.diag.QueryPlan;
import org.cojen.tupl.rows.ConcatScanner;
import org.cojen.tupl.rows.ConcatUpdater;
import org.cojen.tupl.rows.QueryLauncher;
import org.cojen.tupl.rows.RowWriter;

final class DisjointUnionQueryLauncher<R>
implements QueryLauncher<R> {
    private final QueryLauncher<R>[] mLaunchers;

    DisjointUnionQueryLauncher(QueryLauncher<R>[] launchers) {
        this.mLaunchers = launchers;
    }

    @Override
    public Scanner<R> newScanner(final Transaction txn, R row, final Object ... args) throws IOException {
        return new ConcatScanner<R>(row){
            private int mWhich;

            @Override
            public Scanner<R> next(R dst) throws IOException {
                int which = this.mWhich;
                if (which >= DisjointUnionQueryLauncher.this.mLaunchers.length) {
                    return null;
                }
                Scanner next = DisjointUnionQueryLauncher.this.mLaunchers[which].newScanner(txn, dst, args);
                this.mWhich = which + 1;
                return next;
            }
        };
    }

    @Override
    public Updater<R> newUpdater(final Transaction txn, R row, final Object ... args) throws IOException {
        return new ConcatUpdater<R>(row){
            private int mWhich;

            @Override
            public Updater<R> next(R dst) throws IOException {
                int which = this.mWhich;
                if (which >= DisjointUnionQueryLauncher.this.mLaunchers.length) {
                    return null;
                }
                Updater next = DisjointUnionQueryLauncher.this.mLaunchers[which].newUpdater(txn, dst, args);
                this.mWhich = which + 1;
                return next;
            }
        };
    }

    @Override
    public void scanWrite(Transaction txn, RowWriter writer, Object ... args) throws IOException {
        writer.writeCharacteristics(4368, 0L);
        for (QueryLauncher<R> launcher : this.mLaunchers) {
            launcher.scanWrite(txn, writer, args);
        }
    }

    @Override
    public QueryPlan plan(Object ... args) {
        QueryPlan[] subPlans = new QueryPlan[this.mLaunchers.length];
        for (int i = 0; i < subPlans.length; ++i) {
            subPlans[i] = this.mLaunchers[i].plan(args);
        }
        return new QueryPlan.DisjointUnion(subPlans);
    }

    @Override
    public Set<String> projection() {
        return this.mLaunchers[0].projection();
    }
}

