/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.cojen.maker.Bootstrap;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.Index;
import org.cojen.tupl.core.RowPredicateLock;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.Converter;
import org.cojen.tupl.rows.ExceptionCallSite;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.RowWriter;
import org.cojen.tupl.rows.StaticTableMaker;
import org.cojen.tupl.rows.SwitchCallSite;
import org.cojen.tupl.rows.TableMaker;
import org.cojen.tupl.rows.TableManager;
import org.cojen.tupl.rows.WriteRowMaker;

public class DynamicTableMaker
extends TableMaker {
    private final RowStore mStore;
    private final long mTableId;
    private final Class mBaseClass;

    DynamicTableMaker(Class<?> type, RowGen rowGen, RowStore store, long tableId) {
        super(type, rowGen, rowGen, null);
        this.mStore = store;
        this.mTableId = tableId;
        this.mBaseClass = StaticTableMaker.obtain(type, rowGen);
    }

    DynamicTableMaker(Class<?> type, RowGen rowGen, RowGen codecGen, byte[] secondaryDesc, RowStore store, long tableId) {
        super(type, rowGen, codecGen, secondaryDesc);
        this.mStore = store;
        this.mTableId = tableId;
        this.mBaseClass = StaticTableMaker.obtain(type, rowGen, secondaryDesc);
    }

    MethodHandle finish() {
        String suffix = this.isPrimaryTable() ? "table" : "unjoined";
        this.mClassMaker = this.mCodecGen.beginClassMaker(this.getClass(), this.mRowType, suffix).public_().extend((Object)this.mBaseClass);
        MethodType mt = MethodType.methodType(Void.TYPE, TableManager.class, Index.class, RowPredicateLock.class);
        MethodMaker ctor = this.mClassMaker.addConstructor(mt);
        ctor.invokeSuperConstructor(new Object[]{ctor.param(0), ctor.param(1), ctor.param(2)});
        if (this.isPrimaryTable()) {
            this.addDynamicEncodeValueColumns();
            this.addDynamicDecodeValueColumns();
            MethodMaker mm = this.mClassMaker.addMethod(byte[].class, "doEncodeValue", new Object[]{this.mRowClass}).protected_();
            mm.return_((Object)mm.invoke("encodeValue", new Object[]{mm.param(0)}));
            mm = this.mClassMaker.addMethod(null, "doDecodeValue", new Object[]{this.mRowClass, byte[].class}).protected_();
            this.addDynamicUpdateValueColumns();
            this.addDoUpdateMethod();
            mm.invoke("decodeValue", new Object[]{mm.param(0), mm.param(1)});
            this.addDynamicWriteRowMethod();
        }
        this.addUnfilteredMethods(this.mTableId);
        return this.doFinish(mt);
    }

    private void addDynamicEncodeValueColumns() {
        MethodMaker mm = this.mClassMaker.addMethod(byte[].class, "encodeValue", new Object[]{this.mRowClass}).static_();
        Bootstrap indy = mm.var(DynamicTableMaker.class).indy("indyEncodeValueColumns", new Object[]{this.mStore.ref(), this.mRowType, this.mTableId});
        mm.return_((Object)indy.invoke(byte[].class, "encodeValue", null, new Object[]{mm.param(0)}));
    }

    public static CallSite indyEncodeValueColumns(MethodHandles.Lookup lookup, String name, MethodType mt, WeakReference<RowStore> storeRef, Class<?> rowType, long tableId) {
        return DynamicTableMaker.doIndyEncode(lookup, name, mt, storeRef, rowType, tableId, (mm, info, schemaVersion) -> {
            ColumnCodec[] codecs = info.rowGen().valueCodecs();
            DynamicTableMaker.addEncodeColumns(mm, ColumnCodec.bind(schemaVersion, codecs, mm));
        });
    }

    private void addDynamicUpdateValueColumns() {
        MethodMaker mm = this.mClassMaker.addMethod(byte[].class, "updateValue", new Object[]{this.mRowClass, byte[].class}).static_();
        if (this.mCodecGen.info.valueColumns.isEmpty()) {
            mm.return_((Object)mm.var(RowUtils.class).field("EMPTY_BYTES"));
            return;
        }
        Variable rowVar = mm.param(0);
        Label partiallyDirty = mm.label();
        mm.invoke("checkValueAllDirty", new Object[]{rowVar}).ifFalse(partiallyDirty);
        mm.return_((Object)mm.invoke("encodeValue", new Object[]{rowVar}));
        partiallyDirty.here();
        Bootstrap indy = mm.var(DynamicTableMaker.class).indy("indyUpdateValueColumns", new Object[]{this.mStore.ref(), this.mRowType, this.mTableId});
        mm.return_((Object)indy.invoke(byte[].class, "updateValue", null, new Object[]{rowVar, mm.param(1)}));
    }

    public static CallSite indyUpdateValueColumns(MethodHandles.Lookup lookup, String name, MethodType mt, WeakReference<RowStore> storeRef, Class<?> rowType, long tableId) {
        return DynamicTableMaker.doIndyEncode(lookup, name, mt, storeRef, rowType, tableId, (mm, info, schemaVersion) -> {
            Variable rowVar = mm.param(0);
            Variable originalVar = mm.param(1);
            Variable tableVar = mm.var(lookup.lookupClass());
            TableMaker.UpdateEntry ue = DynamicTableMaker.encodeUpdateValue(mm, info, schemaVersion, tableVar, rowVar, originalVar);
            mm.return_((Object)ue.newEntryVar);
        });
    }

    private static CallSite doIndyEncode(MethodHandles.Lookup lookup, String name, MethodType mt, WeakReference<RowStore> storeRef, Class<?> rowType, long tableId, EncodeFinisher finisher) {
        return ExceptionCallSite.make(() -> {
            MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)name, (MethodType)mt);
            RowStore store = (RowStore)storeRef.get();
            if (store == null) {
                mm.new_(DatabaseException.class, new Object[]{"Closed"}).throw_();
            } else {
                int schemaVersion;
                RowInfo info = RowInfo.find(rowType);
                try {
                    schemaVersion = store.schemaVersion(info, false, tableId, true);
                }
                catch (Exception e) {
                    return new ExceptionCallSite.Failed(mt, mm, e);
                }
                finisher.finish(mm, info, schemaVersion);
            }
            return mm.finish();
        });
    }

    private void addDynamicDecodeValueColumns() {
        MethodMaker mm = this.mClassMaker.addMethod(SwitchCallSite.class, "decodeValueSwitchCallSite", new Object[0]).static_();
        Bootstrap condy = mm.var(DynamicTableMaker.class).condy("condyDecodeValueColumns", new Object[]{this.mStore.ref(), this.mRowType, this.mRowClass, this.mTableId});
        mm.return_((Object)condy.invoke(SwitchCallSite.class, "_"));
        mm = this.mClassMaker.addMethod(MethodHandle.class, "decodeValueHandle", new Object[]{Integer.TYPE}).static_();
        Variable lookup = mm.var(MethodHandles.class).invoke("lookup", new Object[0]);
        Variable mh = mm.invoke("decodeValueSwitchCallSite", new Object[0]).invoke("getCase", new Object[]{lookup, mm.param(0)});
        mm.return_((Object)mh);
        mm = this.mClassMaker.addMethod(null, "decodeValue", new Object[]{this.mRowClass, byte[].class}).static_().public_();
        Variable data = mm.param(1);
        Variable schemaVersion = mm.var(RowUtils.class).invoke("decodeSchemaVersion", new Object[]{data});
        Bootstrap indy = mm.var(DynamicTableMaker.class).indy("indyDecodeValueColumns", new Object[0]);
        indy.invoke(null, "decodeValue", null, new Object[]{schemaVersion, mm.param(0), data});
    }

    public static SwitchCallSite condyDecodeValueColumns(MethodHandles.Lookup lookup, String name, Class<?> type, WeakReference<RowStore> storeRef, Class<?> rowType, Class<?> rowClass, long tableId) {
        MethodType mt = MethodType.methodType(Void.TYPE, Integer.TYPE, rowClass, byte[].class);
        return new SwitchCallSite(lookup, mt, schemaVersion -> {
            MethodMaker mm;
            block5: {
                RowInfo srcRowInfo;
                RowInfo dstRowInfo;
                RowStore store;
                block6: {
                    block4: {
                        mm = MethodMaker.begin((MethodHandles.Lookup)lookup, null, (String)"decode", (Object[])new Object[]{rowClass, byte[].class});
                        store = (RowStore)storeRef.get();
                        if (store != null) break block4;
                        mm.new_(DatabaseException.class, new Object[]{"Closed"}).throw_();
                        break block5;
                    }
                    dstRowInfo = RowInfo.find(rowType);
                    if (schemaVersion != 0) break block6;
                    for (Map.Entry e : dstRowInfo.valueColumns.entrySet()) {
                        Converter.setDefault(mm, (ColumnInfo)e.getValue(), (Variable)mm.param(0).field((String)e.getKey()));
                    }
                    break block5;
                }
                try {
                    srcRowInfo = store.rowInfo(rowType, tableId, schemaVersion);
                }
                catch (Exception e) {
                    return new ExceptionCallSite.Failed(MethodType.methodType(Void.TYPE, rowClass, byte[].class), mm, e);
                }
                ColumnCodec[] srcCodecs = srcRowInfo.rowGen().valueCodecs();
                int fixedOffset = schemaVersion < 128 ? 1 : 4;
                DynamicTableMaker.addDecodeColumns(mm, dstRowInfo, srcCodecs, fixedOffset);
                if (dstRowInfo == srcRowInfo) break block5;
                for (Map.Entry e : dstRowInfo.valueColumns.entrySet()) {
                    String fieldName = (String)e.getKey();
                    if (srcRowInfo.valueColumns.containsKey(fieldName)) continue;
                    Converter.setDefault(mm, (ColumnInfo)e.getValue(), (Variable)mm.param(0).field(fieldName));
                }
            }
            return mm.finish();
        });
    }

    public static SwitchCallSite indyDecodeValueColumns(MethodHandles.Lookup lookup, String name, MethodType mt) throws Throwable {
        MethodHandle mh = lookup.findStatic(lookup.lookupClass(), "decodeValueSwitchCallSite", MethodType.methodType(SwitchCallSite.class));
        return mh.invokeExact();
    }

    private void addDynamicWriteRowMethod() {
        MethodMaker mm = this.mClassMaker.addMethod(null, "writeRow", new Object[]{RowWriter.class, byte[].class, byte[].class}).static_();
        Variable writerVar = mm.param(0);
        Variable keyVar = mm.param(1);
        Variable valueVar = mm.param(2);
        Variable schemaVersion = mm.var(RowUtils.class).invoke("decodeSchemaVersion", new Object[]{valueVar});
        Bootstrap indy = mm.var(WriteRowMaker.class).indy("indyWriteRow", new Object[]{this.mStore.ref(), this.mRowType, this.mTableId, null});
        indy.invoke(null, "writeRow", null, new Object[]{schemaVersion, writerVar, keyVar, valueVar});
    }

    @Override
    protected void finishDoUpdate(MethodMaker mm, Variable rowVar, Variable mergeVar, Variable cursorVar) {
        Bootstrap indy = mm.var(DynamicTableMaker.class).indy("indyDoUpdate", new Object[]{this.mStore.ref(), this.mRowType, this.mTableId, this.supportsTriggers() ? 1 : 0});
        indy.invoke(null, "doUpdate", null, new Object[]{mm.this_(), rowVar, mergeVar, cursorVar});
    }

    public static CallSite indyDoUpdate(MethodHandles.Lookup lookup, String name, MethodType mt, WeakReference<RowStore> storeRef, Class<?> rowType, long tableId, int triggers) {
        return DynamicTableMaker.doIndyEncode(lookup, name, mt, storeRef, rowType, tableId, (mm, info, schemaVersion) -> {
            Variable tableVar = mm.param(0);
            Variable rowVar = mm.param(1);
            Variable mergeVar = mm.param(2);
            Variable cursorVar = mm.param(3);
            DynamicTableMaker.finishDoUpdate(mm, info, schemaVersion, triggers, false, tableVar, rowVar, mergeVar, cursorVar);
        });
    }

    @FunctionalInterface
    static interface EncodeFinisher {
        public void finish(MethodMaker var1, RowInfo var2, int var3);
    }
}

