/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.util.Arrays;
import org.cojen.tupl.rows.RowUtils;

class Encoder {
    private byte[] mBuffer;
    private int mLength;

    Encoder(int capacity) {
        this.mBuffer = new byte[capacity];
    }

    public void reset(int amt) {
        this.mLength = 0;
        this.ensureCapacity(amt);
        this.mLength = amt;
    }

    public void writeByte(int v) {
        this.ensureCapacity(1);
        this.mBuffer[this.mLength++] = (byte)v;
    }

    public void writeIntBE(int v) {
        this.ensureCapacity(4);
        RowUtils.encodeIntBE(this.mBuffer, this.mLength, v);
        this.mLength += 4;
    }

    public void writeIntLE(int v) {
        this.ensureCapacity(4);
        RowUtils.encodeIntLE(this.mBuffer, this.mLength, v);
        this.mLength += 4;
    }

    public void writeLongLE(long v) {
        this.ensureCapacity(8);
        RowUtils.encodeLongLE(this.mBuffer, this.mLength, v);
        this.mLength += 8;
    }

    public void writePrefixPF(int value) {
        int prefixLen = RowUtils.lengthPrefixPF(value);
        this.ensureCapacity(prefixLen);
        RowUtils.encodePrefixPF(this.mBuffer, this.mLength, value);
        this.mLength += prefixLen;
    }

    public void writeStringUTF(String str) {
        int prefixLen = RowUtils.lengthPrefixPF(str.length());
        int strLen = RowUtils.lengthStringUTF(str);
        this.ensureCapacity(prefixLen + strLen);
        RowUtils.encodePrefixPF(this.mBuffer, this.mLength, str.length());
        RowUtils.encodeStringUTF(this.mBuffer, this.mLength + prefixLen, str);
        this.mLength += prefixLen + strLen;
    }

    public void writeBytes(byte[] bytes) {
        int prefixLen = RowUtils.lengthPrefixPF(bytes.length);
        this.ensureCapacity(prefixLen + bytes.length);
        RowUtils.encodePrefixPF(this.mBuffer, this.mLength, bytes.length);
        System.arraycopy(bytes, 0, this.mBuffer, this.mLength + prefixLen, bytes.length);
        this.mLength += prefixLen + bytes.length;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.mBuffer, this.mLength);
    }

    private void ensureCapacity(int amt) {
        if (this.mLength + amt > this.mBuffer.length) {
            this.mBuffer = Arrays.copyOf(this.mBuffer, Math.max(this.mLength + amt, this.mLength << 1));
        }
    }
}

