/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.util.function.Supplier;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;

public class ExceptionCallSite
extends MutableCallSite {
    private final Supplier<Object> mGenerator;
    private Throwable mException;
    private Thread mOrigin;

    static CallSite make(Supplier<Object> generator) {
        Object result = generator.get();
        if (result instanceof MethodHandle) {
            MethodHandle mh = (MethodHandle)result;
            return new ConstantCallSite(mh);
        }
        if (result instanceof Failed) {
            Failed f = (Failed)result;
            return new ExceptionCallSite(generator, f);
        }
        throw new IllegalStateException(String.valueOf(result));
    }

    private ExceptionCallSite(Supplier<Object> generator, Failed f) {
        super(f.mt);
        this.mGenerator = generator;
        this.mException = f.ex;
        this.mOrigin = Thread.currentThread();
        Variable ecs = f.mm.var(ExceptionCallSite.class).setExact((Object)this);
        Variable mh = ecs.invoke("call", new Object[0]);
        ecs.invoke("setTarget", new Object[]{mh});
        Object[] paramTypes = f.mt.parameterArray();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = f.mm.param(i);
        }
        Variable result = mh.invoke((Object)f.mt.returnType(), "invokeExact", paramTypes, params);
        if (f.mt.returnType() == Void.TYPE) {
            f.mm.return_();
        } else {
            f.mm.return_((Object)result);
        }
        this.setTarget(f.mm.finish());
    }

    public MethodHandle call() throws Throwable {
        Throwable e = this.mException;
        if (e != null && this.mOrigin == Thread.currentThread()) {
            this.mException = null;
            this.mOrigin = null;
            throw e;
        }
        Object result = this.mGenerator.get();
        if (result instanceof MethodHandle) {
            MethodHandle mh = (MethodHandle)result;
            return mh;
        }
        if (result instanceof Failed) {
            Failed f = (Failed)result;
            throw f.ex;
        }
        throw new IllegalStateException(String.valueOf(result));
    }

    record Failed(MethodType mt, MethodMaker mm, Throwable ex) {
    }
}

