/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.util.Map;
import java.util.function.IntFunction;
import org.cojen.maker.Bootstrap;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.Entry;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.core.RowPredicate;
import org.cojen.tupl.diag.QueryPlan;
import org.cojen.tupl.filter.ColumnToArgFilter;
import org.cojen.tupl.filter.RowFilter;
import org.cojen.tupl.filter.TrueFilter;
import org.cojen.tupl.filter.Visitor;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.CodeUtils;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.DecodePartialMaker;
import org.cojen.tupl.rows.DecodeVisitor;
import org.cojen.tupl.rows.ExceptionCallSite;
import org.cojen.tupl.rows.JoinedScanController;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowMaker;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.RowWriter;
import org.cojen.tupl.rows.ScanController;
import org.cojen.tupl.rows.ScanControllerFactory;
import org.cojen.tupl.rows.SingleScanController;
import org.cojen.tupl.rows.SwitchCallSite;

public class FilteredScanMaker<R> {
    private final WeakReference<RowStore> mStoreRef;
    private final byte[] mSecondaryDescriptor;
    private final BaseTable<R> mTable;
    private final Class<?> mPrimaryTableClass;
    private final SingleScanController<R> mUnfiltered;
    private final Class<?> mPredicateClass;
    private final Class<R> mRowType;
    private final RowGen mRowGen;
    private final long mIndexId;
    private final RowFilter mLowBound;
    private final RowFilter mHighBound;
    private final RowFilter mFilter;
    private final RowFilter mJoinFilter;
    private final byte[] mProjectionSpec;
    private final byte[] mJoinProjectionSpec;
    private final boolean mAlwaysJoin;
    private final boolean mDistinct;
    private final ClassMaker mFilterMaker;
    private final MethodMaker mFilterCtorMaker;
    private String mStopColumn;
    private int mStopArgument;

    public FilteredScanMaker(WeakReference<RowStore> storeRef, BaseTable<R> table, RowGen rowGen, SingleScanController<R> unfiltered, Class<? extends RowPredicate> predClass, RowFilter lowBound, RowFilter highBound, RowFilter filter, RowFilter joinFilter, Map<String, ColumnInfo> projection) {
        Object[] mainCtorParams;
        MethodMaker ctor;
        RowGen primaryRowGen;
        Class rowType = table.rowType();
        byte[] secondaryDescriptor = table.secondaryDescriptor();
        Class<?> primaryTableClass = table.joinedPrimaryTableClass();
        if (primaryTableClass == null) {
            this.mJoinProjectionSpec = null;
            this.mAlwaysJoin = false;
            if (secondaryDescriptor == null) {
                primaryRowGen = rowGen;
                this.mProjectionSpec = DecodePartialMaker.makeFullSpec(rowGen, null, projection);
            } else {
                primaryRowGen = RowInfo.find(rowType).rowGen();
                this.mProjectionSpec = DecodePartialMaker.makeFullSpec(rowGen, primaryRowGen, projection);
            }
        } else {
            primaryRowGen = RowInfo.find(rowType).rowGen();
            this.mJoinProjectionSpec = DecodePartialMaker.makeFullSpec(primaryRowGen, null, projection);
            if (FilteredScanMaker.isCovering(rowGen, primaryRowGen, joinFilter, projection)) {
                this.mAlwaysJoin = false;
                this.mProjectionSpec = DecodePartialMaker.makeFullSpec(rowGen, primaryRowGen, projection);
            } else {
                this.mAlwaysJoin = true;
                this.mProjectionSpec = this.mJoinProjectionSpec;
            }
        }
        this.mDistinct = projection == null ? true : primaryRowGen.info.isDistinct(projection.keySet());
        this.mStoreRef = storeRef;
        this.mSecondaryDescriptor = secondaryDescriptor;
        this.mTable = table;
        this.mPrimaryTableClass = primaryTableClass;
        this.mUnfiltered = unfiltered;
        this.mPredicateClass = predClass;
        this.mRowType = rowType;
        this.mRowGen = rowGen;
        this.mIndexId = table.mSource.id();
        this.mLowBound = lowBound;
        this.mHighBound = highBound;
        this.mFilter = filter;
        this.mJoinFilter = joinFilter;
        this.mFilterMaker = this.mRowGen.anotherClassMaker(this.getClass(), predClass, "filter").public_().final_().extend(unfiltered.getClass()).implement(ScanControllerFactory.class);
        this.mFilterMaker.addField(predClass, "predicate").private_().final_();
        if (unfiltered instanceof JoinedScanController) {
            ctor = this.mFilterMaker.addConstructor(new Object[]{Index.class}).public_();
            ctor.invokeSuperConstructor(new Object[]{null, false, null, false, false, ctor.param(0)});
            mainCtorParams = new Class[]{Boolean.TYPE, predClass, Index.class};
        } else {
            ctor = this.mFilterMaker.addConstructor(new Object[0]).public_();
            ctor.invokeSuperConstructor(new Object[]{null, false, null, false, false});
            mainCtorParams = new Class[]{Boolean.TYPE, predClass};
        }
        this.mFilterCtorMaker = this.mFilterMaker.addConstructor(mainCtorParams).private_();
        this.mFilterCtorMaker.field("predicate").set((Object)this.mFilterCtorMaker.param(1));
        ctor = this.mFilterMaker.addConstructor(new Object[]{this.mFilterMaker}).private_();
        Variable from = ctor.param(0);
        ctor.invokeSuperConstructor(new Object[]{from});
        ctor.field("predicate").set((Object)from.field("predicate"));
    }

    private static boolean isCovering(RowGen rowGen, RowGen primaryRowGen, RowFilter joinFilter, Map<String, ColumnInfo> projection) {
        if (joinFilter != null && joinFilter != TrueFilter.THE) {
            return false;
        }
        if (projection == null) {
            projection = primaryRowGen.info.allColumns;
        }
        return rowGen.info.allColumns.keySet().containsAll(projection.keySet());
    }

    public ScanControllerFactory<R> finish() {
        Object[] ctorParams;
        Variable reverseVar = this.mFilterCtorMaker.param(0);
        if (this.mUnfiltered instanceof JoinedScanController) {
            ctorParams = new Object[6];
            ctorParams[5] = this.mFilterCtorMaker.param(2);
        } else {
            ctorParams = new Object[]{null, false, null, false, reverseVar};
        }
        if (this.mLowBound != null) {
            this.encodeBound(ctorParams, this.mLowBound, true);
        }
        if (this.mHighBound != null) {
            ColumnInfo[] keyColumns;
            if (this.mLowBound != null && this.mLowBound.matchesOne(this.mHighBound, keyColumns = (ColumnInfo[])this.mRowGen.info.keyColumns.values().toArray(ColumnInfo[]::new))) {
                if (ctorParams[1] != Boolean.TRUE) {
                    throw new AssertionError();
                }
                ctorParams[2] = ctorParams[0];
                ctorParams[3] = true;
            } else {
                this.encodeBound(ctorParams, this.mHighBound, false);
            }
        }
        this.mFilterCtorMaker.invokeSuperConstructor(ctorParams);
        this.addEvalRowMethod();
        this.addWriteRowMethod();
        MethodMaker mm = this.mFilterMaker.addMethod(RowPredicate.class, "predicate", new Object[0]).public_();
        mm.return_((Object)mm.field("predicate"));
        mm = this.mFilterMaker.addMethod(RowPredicate.class, "predicate", new Object[]{Object[].class}).public_();
        mm.return_((Object)mm.new_(this.mPredicateClass, new Object[]{mm.param(0)}));
        for (int i = 0; i <= 1; ++i) {
            String name = i == 0 ? "plan" : "planReverse";
            MethodMaker mm2 = this.mFilterMaker.addMethod(QueryPlan.class, name, new Object[0]).private_().static_();
            int option = i + (this.mAlwaysJoin ? 2 : 0);
            Bootstrap condy = mm2.var(FilteredScanMaker.class).condy("condyPlan", new Object[]{this.mRowType, this.mSecondaryDescriptor, option, FilteredScanMaker.toString(this.mLowBound), FilteredScanMaker.toString(this.mHighBound), FilteredScanMaker.toString(this.mFilter), FilteredScanMaker.toString(this.mJoinFilter)});
            mm2.return_((Object)condy.invoke(QueryPlan.class, name));
        }
        mm = this.mFilterMaker.addMethod(QueryPlan.class, "plan", new Object[]{Object[].class}).public_();
        Variable planVar = mm.var(QueryPlan.class);
        Label isReverse = mm.label();
        mm.invoke("isReverse", new Object[0]).ifTrue(isReverse);
        planVar.set((Object)mm.invoke("plan", new Object[0]));
        Label cont = mm.label().goto_();
        isReverse.here();
        planVar.set((Object)mm.invoke("planReverse", new Object[0]));
        cont.here();
        mm.return_((Object)planVar);
        mm = this.mFilterMaker.addMethod(ScanControllerFactory.class, "reverse", new Object[0]).public_();
        mm.return_((Object)mm.new_((Object)this.mFilterMaker, new Object[]{mm.this_()}));
        if (!this.mDistinct) {
            mm = this.mFilterMaker.addMethod(Integer.TYPE, "characteristics", new Object[0]).public_();
            mm.return_((Object)4368);
        }
        this.addFactoryMethod(Object[].class);
        this.addFactoryMethod(RowPredicate.class);
        return FilteredScanMaker.newFactory(this.mUnfiltered, this.mFilterMaker.finish());
    }

    public static <R> ScanControllerFactory<R> newFactory(SingleScanController<R> unfiltered, Class<?> filterClass) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            if (unfiltered instanceof JoinedScanController) {
                JoinedScanController joined = (JoinedScanController)unfiltered;
                return lookup.findConstructor(filterClass, MethodType.methodType(Void.TYPE, Index.class)).invoke(joined.mPrimaryIndex);
            }
            return lookup.findConstructor(filterClass, MethodType.methodType(Void.TYPE)).invoke();
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private void encodeBound(Object[] ctorParams, RowFilter bound, final boolean low) {
        Variable dstVar;
        boolean inclusive;
        boolean increment;
        boolean ulp;
        int numArgs;
        Variable[] argVars;
        ColumnCodec[] codecs;
        block23: {
            ColumnToArgFilter last;
            block22: {
                codecs = this.mRowGen.keyCodecs();
                argVars = new Variable[codecs.length];
                var visitor = new Visitor(){
                    ColumnToArgFilter last;
                    int pos;
                    boolean ulp;

                    /*
                     * Enabled aggressive block sorting
                     */
                    @Override
                    public void visit(ColumnToArgFilter filter) {
                        ColumnInfo column = filter.column();
                        if (filter.operator() == 0 && column.type == BigDecimal.class) {
                            if (!column.isDescending()) {
                                if (!low) {
                                    FilteredScanMaker.this.mStopColumn = column.name;
                                    FilteredScanMaker.this.mStopArgument = filter.argument();
                                    return;
                                }
                                filter = filter.withOperator(2);
                            } else if (low) {
                                filter = filter.withOperator(5);
                                this.ulp = true;
                            } else {
                                filter = filter.withOperator(4);
                            }
                        }
                        this.last = filter;
                        String fieldName = ColumnCodec.argFieldName(filter.column(), filter.argument());
                        Field argVar = FilteredScanMaker.this.mFilterCtorMaker.param(1).field(fieldName);
                        if (this.ulp) {
                            argVar = argVar.get();
                            Label cont = FilteredScanMaker.this.mFilterCtorMaker.label();
                            argVar.ifEq(null, cont);
                            argVar.set((Object)argVar.invoke("add", new Object[]{argVar.invoke("ulp", new Object[0])}));
                            cont.here();
                        }
                        argVars[this.pos++] = argVar;
                    }
                };
                bound.accept(visitor);
                last = visitor.last;
                if (last == null) {
                    return;
                }
                numArgs = visitor.pos;
                ulp = visitor.ulp;
                increment = false;
                if (!low) break block22;
                switch (last.operator()) {
                    case 0: 
                    case 2: {
                        inclusive = true;
                        break block23;
                    }
                    case 5: {
                        if (numArgs == codecs.length && !ulp) {
                            inclusive = false;
                        } else {
                            inclusive = true;
                            increment = true;
                        }
                        break block23;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            switch (last.operator()) {
                case 3: {
                    inclusive = false;
                    break;
                }
                case 0: 
                case 4: {
                    if (numArgs == codecs.length) {
                        inclusive = true;
                        break;
                    }
                    inclusive = false;
                    increment = true;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        ColumnCodec[] boundCodecs = new ColumnCodec[numArgs];
        int minSize = 0;
        for (int i = 0; i < numArgs; ++i) {
            ColumnCodec codec;
            boundCodecs[i] = codec = codecs[i].bind(this.mFilterCtorMaker);
            minSize += codec.minSize();
            codec.encodePrepare();
        }
        codecs = boundCodecs;
        Variable totalVar = null;
        for (int i = 0; i < codecs.length; ++i) {
            totalVar = codecs[i].encodeSize(argVars[i], totalVar);
        }
        if (totalVar == null) {
            dstVar = this.mFilterCtorMaker.new_(byte[].class, new Object[]{minSize});
        } else {
            if (minSize != 0) {
                totalVar = totalVar.add((Object)minSize);
            }
            dstVar = this.mFilterCtorMaker.new_(byte[].class, new Object[]{totalVar});
        }
        Variable offsetVar = this.mFilterCtorMaker.var(Integer.TYPE).set((Object)0);
        for (int i = 0; i < codecs.length; ++i) {
            codecs[i].encode(argVars[i], dstVar, offsetVar);
        }
        Variable rowUtilsVar = this.mFilterCtorMaker.var(RowUtils.class);
        if (increment) {
            Field overflow = null;
            if (low) {
                overflow = this.mFilterCtorMaker.var(ScanController.class).field("EMPTY");
            }
            Label cont = null;
            if (ulp) {
                cont = this.mFilterCtorMaker.label();
                argVars[numArgs - 1].ifEq(null, cont);
            }
            dstVar.set((Object)rowUtilsVar.invoke("increment", new Object[]{dstVar, overflow}));
            if (cont != null) {
                cont.here();
            }
        }
        int ctorParamOffset = low ? 0 : 2;
        ctorParams[ctorParamOffset++] = dstVar;
        ctorParams[ctorParamOffset] = inclusive;
    }

    private void addFactoryMethod(Class which) {
        Object[] params;
        Variable predicateVar;
        MethodMaker mm = this.mFilterMaker.addMethod(ScanController.class, "scanController", new Object[]{which}).public_();
        if (which == Object[].class) {
            mm.varargs();
            predicateVar = mm.new_(this.mPredicateClass, new Object[]{mm.param(0)});
        } else {
            predicateVar = mm.param(0).cast(this.mPredicateClass);
        }
        if (this.mUnfiltered instanceof JoinedScanController) {
            params = new Object[3];
            params[2] = mm.field("mPrimaryIndex");
        } else {
            params = new Object[]{mm.invoke("isReverse", new Object[0]), predicateVar};
        }
        mm.return_((Object)mm.new_((Object)this.mFilterMaker, params));
    }

    private void addEvalRowMethod() {
        if (this.mProjectionSpec == null && (this.mFilter == null || this.mSecondaryDescriptor == null && this.mFilter == TrueFilter.THE)) {
            return;
        }
        MethodMaker mm = this.mFilterMaker.addMethod(Object.class, "evalRow", new Object[]{Cursor.class, LockResult.class, Object.class}).public_();
        Variable cursorVar = mm.param(0);
        Variable resultVar = mm.param(1);
        Variable rowVar = mm.param(2);
        Field predicateVar = mm.field("predicate");
        if (this.mSecondaryDescriptor == null && this.mTable.rowType() != Entry.class) {
            String filterStr;
            WeakReference<RowFilter> filterRef;
            if (this.mFilter == null) {
                filterRef = null;
                filterStr = null;
            } else {
                filterRef = new WeakReference<RowFilter>(this.mFilter);
                filterStr = this.mFilter.toString();
            }
            Bootstrap indy = mm.var(FilteredScanMaker.class).indy("indyFilter", new Object[]{this.mStoreRef, this.mTable.getClass(), this.mRowType, this.mIndexId, filterRef, filterStr, this.mProjectionSpec, this.mStopColumn, this.mStopArgument});
            Variable valueVar = cursorVar.invoke("value", new Object[0]);
            Variable schemaVersion = mm.var(RowUtils.class).invoke("decodeSchemaVersion", new Object[]{valueVar});
            mm.return_((Object)indy.invoke(Object.class, "evalRow", null, new Object[]{schemaVersion, cursorVar, rowVar, predicateVar}));
            if (this.mProjectionSpec != null) {
                this.overrideDecodeRow();
            }
            return;
        }
        DecodeVisitor visitor = new DecodeVisitor(mm, 0, this.mRowGen, (Variable)predicateVar, this.mStopColumn, this.mStopArgument);
        if (this.mFilter != null) {
            visitor.applyFilter(this.mFilter);
        }
        if (this.mPrimaryTableClass != null) {
            this.addJoinedEval();
            this.addEvalRowWithPrimaryCursorMethod();
        }
        if (!this.mAlwaysJoin) {
            if (this.mUnfiltered.isJoined()) {
                this.mFilterMaker.addMethod(Boolean.TYPE, "isJoined", new Object[0]).public_().return_((Object)false);
            }
            MethodHandle decoder = null;
            if (this.mProjectionSpec != null) {
                decoder = this.mTable.decodePartialHandle(this.mProjectionSpec, 0);
            }
            Class<R> rowClass = RowMaker.find(this.mRowType);
            visitor.finishDecode(decoder, null, this.mTable.getClass(), rowClass, rowVar);
            mm = this.mFilterMaker.addMethod(byte[].class, "secondaryDescriptor", new Object[0]).public_();
            mm.return_((Object)mm.var(byte[].class).setExact((Object)this.mSecondaryDescriptor));
            if (decoder != null) {
                mm = this.mFilterMaker.addMethod(Object.class, "decodeRow", new Object[]{Object.class, byte[].class, byte[].class}).public_().override();
                rowVar = CodeUtils.castOrNew(mm.param(0), rowClass);
                mm.invoke(decoder, new Object[]{rowVar, mm.param(1), mm.param(2)});
                mm.return_((Object)rowVar);
            }
            return;
        }
        Variable[] primaryVars = visitor.joinToPrimary(resultVar, null);
        Variable primaryKeyVar = primaryVars[0];
        Variable primaryValueVar = primaryVars[1];
        mm.return_((Object)mm.invoke("joinedEval", new Object[]{primaryKeyVar, primaryValueVar, rowVar}));
        this.overrideDecodeRowForJoin();
    }

    private void overrideDecodeRow() {
        MethodMaker mm = this.mFilterMaker.addMethod(Object.class, "decodeRow", new Object[]{Object.class, byte[].class, byte[].class}).public_().override();
        Bootstrap indy = mm.var(FilteredScanMaker.class).indy("indyFilter", new Object[]{this.mStoreRef, this.mTable.getClass(), this.mRowType, this.mIndexId, null, null, this.mProjectionSpec, this.mStopColumn, this.mStopArgument});
        Variable rowVar = mm.param(0);
        Variable keyVar = mm.param(1);
        Variable valueVar = mm.param(2);
        Field predicateVar = mm.field("predicate");
        Variable schemaVersion = mm.var(RowUtils.class).invoke("decodeSchemaVersion", new Object[]{valueVar});
        mm.return_((Object)indy.invoke(Object.class, "decodeRow", null, new Object[]{schemaVersion, keyVar, valueVar, rowVar, predicateVar}));
    }

    private void overrideDecodeRowForJoin() {
        MethodMaker mm = this.mFilterMaker.addMethod(Object.class, "decodeRow", new Object[]{Object.class, byte[].class, byte[].class}).public_();
        Variable rowVar = mm.param(0);
        Variable primaryKeyVar = mm.param(1);
        Variable primaryValueVar = mm.param(2);
        if (this.mJoinFilter == null && this.mJoinFilter == TrueFilter.THE) {
            mm.return_((Object)mm.invoke("joinedEval", new Object[]{primaryKeyVar, primaryValueVar, rowVar}));
            return;
        }
        Field predicateVar = mm.field("predicate");
        long primaryIndexId = ((JoinedScanController)this.mUnfiltered).mPrimaryIndex.id();
        Bootstrap indy = mm.var(FilteredScanMaker.class).indy("indyFilter", new Object[]{this.mStoreRef, this.mPrimaryTableClass, this.mRowType, primaryIndexId, null, null, this.mJoinProjectionSpec, null, 0});
        Variable schemaVersion = mm.var(RowUtils.class).invoke("decodeSchemaVersion", new Object[]{primaryValueVar});
        mm.return_((Object)indy.invoke(Object.class, "decodeRow", null, new Object[]{schemaVersion, primaryKeyVar, primaryValueVar, rowVar, predicateVar}));
    }

    private void addJoinedEval() {
        MethodMaker mm = this.mFilterMaker.addMethod(Object.class, "joinedEval", new Object[]{byte[].class, byte[].class, Object.class}).private_();
        Variable primaryKeyVar = mm.param(0);
        Variable primaryValueVar = mm.param(1);
        Variable rowVar = mm.param(2);
        Field predicateVar = mm.field("predicate");
        long primaryIndexId = ((JoinedScanController)this.mUnfiltered).mPrimaryIndex.id();
        WeakReference<RowFilter> filterRef = null;
        String filterStr = null;
        if (this.mJoinFilter != null && this.mJoinFilter != TrueFilter.THE) {
            filterRef = new WeakReference<RowFilter>(this.mJoinFilter);
            filterStr = this.mJoinFilter.toString();
        }
        Bootstrap indy = mm.var(FilteredScanMaker.class).indy("indyFilter", new Object[]{this.mStoreRef, this.mPrimaryTableClass, this.mRowType, primaryIndexId, filterRef, filterStr, this.mJoinProjectionSpec, null, 0});
        Variable schemaVersion = mm.var(RowUtils.class).invoke("decodeSchemaVersion", new Object[]{primaryValueVar});
        mm.return_((Object)indy.invoke(Object.class, "evalRow", null, new Object[]{schemaVersion, primaryKeyVar, primaryValueVar, rowVar, predicateVar}));
    }

    private void addEvalRowWithPrimaryCursorMethod() {
        MethodMaker mm = this.mFilterMaker.addMethod(Object.class, "evalRow", new Object[]{Cursor.class, LockResult.class, Object.class, Cursor.class}).public_();
        Variable resultVar = mm.param(1);
        Variable rowVar = mm.param(2);
        Variable primaryCursorVar = mm.param(3);
        Field predicateVar = mm.field("predicate");
        DecodeVisitor visitor = new DecodeVisitor(mm, 0, this.mRowGen, (Variable)predicateVar, this.mStopColumn, this.mStopArgument);
        if (this.mFilter != null) {
            visitor.applyFilter(this.mFilter);
        }
        Variable[] primaryVars = visitor.joinToPrimary(resultVar, primaryCursorVar);
        Variable primaryKeyVar = primaryVars[0];
        Variable primaryValueVar = primaryVars[1];
        mm.return_((Object)mm.invoke("joinedEval", new Object[]{primaryKeyVar, primaryValueVar, rowVar}));
    }

    public static CallSite indyFilter(MethodHandles.Lookup lookup, String name, MethodType mt, WeakReference<RowStore> storeRef, Class<?> tableClass, Class<?> rowType, long indexId, WeakReference<RowFilter> filterRef, String filterStr, byte[] projectionSpec, String stopColumn, int stopArgument) {
        FilterMaker dm = new FilterMaker(lookup, mt, storeRef, tableClass, rowType, indexId, filterRef, filterStr, projectionSpec, stopColumn, stopArgument);
        return new SwitchCallSite(lookup, mt, dm);
    }

    private static String toString(RowFilter filter) {
        return filter == null || filter == TrueFilter.THE ? null : filter.toString();
    }

    public static QueryPlan condyPlan(MethodHandles.Lookup lookup, String name, Class type, Class rowType, byte[] secondaryDesc, int option, String lowBoundStr, String highBoundStr, String filterStr, String joinFilterStr) {
        String which;
        RowInfo rowInfo;
        RowInfo primaryRowInfo = RowInfo.find(rowType);
        if (secondaryDesc == null) {
            rowInfo = primaryRowInfo;
            which = "primary key";
        } else {
            rowInfo = RowStore.secondaryRowInfo(primaryRowInfo, secondaryDesc);
            which = rowInfo.isAltKey() ? "alternate key" : "secondary index";
        }
        boolean reverse = (option & 1) != 0;
        QueryPlan plan = lowBoundStr == null && highBoundStr == null ? new QueryPlan.FullScan(rowInfo.name, which, rowInfo.keySpec(), reverse) : new QueryPlan.RangeScan(rowInfo.name, which, rowInfo.keySpec(), reverse, lowBoundStr, highBoundStr);
        if (filterStr != null) {
            plan = new QueryPlan.Filter(filterStr, plan);
        }
        if ((option & 2) != 0) {
            rowInfo = primaryRowInfo;
            plan = new QueryPlan.PrimaryJoin(rowInfo.name, rowInfo.keySpec(), plan);
            if (joinFilterStr != null) {
                plan = new QueryPlan.Filter(joinFilterStr, plan);
            }
        }
        return plan;
    }

    private void addWriteRowMethod() {
        MethodHandle mh;
        if (this.mProjectionSpec == null) {
            return;
        }
        MethodMaker mm = this.mFilterMaker.addMethod(null, "writeRow", new Object[]{RowWriter.class, byte[].class, byte[].class}).public_().override();
        Variable writerVar = mm.param(0);
        Variable keyVar = mm.param(1);
        Variable valueVar = mm.param(2);
        BaseTable<R> table = this.mTable;
        if (this.mAlwaysJoin) {
            table = table.joinedPrimaryTable();
        }
        if ((mh = table.writeRowHandle(this.mProjectionSpec)).type().parameterType(0) == Integer.TYPE) {
            Variable schemaVersion = mm.var(RowUtils.class).invoke("decodeSchemaVersion", new Object[]{valueVar});
            mm.invoke(mh, new Object[]{schemaVersion, writerVar, keyVar, valueVar});
        } else {
            mm.invoke(mh, new Object[]{writerVar, keyVar, valueVar});
        }
    }

    private static class FilterMaker
    implements IntFunction<Object> {
        private final MethodHandles.Lookup mLookup;
        private final MethodType mMethodType;
        private final WeakReference<RowStore> mStoreRef;
        private final Class<?> mTableClass;
        private final Class<?> mRowType;
        private final long mIndexId;
        private final String mFilterStr;
        private final byte[] mProjectionSpec;
        private final String mStopColumn;
        private final int mStopArgument;
        private WeakReference<RowFilter> mFilterRef;

        FilterMaker(MethodHandles.Lookup lookup, MethodType mt, WeakReference<RowStore> storeRef, Class<?> tableClass, Class<?> rowType, long indexId, WeakReference<RowFilter> filterRef, String filterStr, byte[] projectionSpec, String stopColumn, int stopArgument) {
            this.mLookup = lookup;
            this.mMethodType = mt.dropParameterTypes(0, 1);
            this.mStoreRef = storeRef;
            this.mTableClass = tableClass;
            this.mRowType = rowType;
            this.mIndexId = indexId;
            this.mFilterStr = filterStr;
            this.mFilterRef = filterRef;
            this.mProjectionSpec = projectionSpec;
            this.mStopColumn = stopColumn;
            this.mStopArgument = stopArgument;
        }

        @Override
        public Object apply(int schemaVersion) {
            MethodHandle valueDecoder;
            MethodHandle decoder;
            RowInfo rowInfo;
            RowFilter filter;
            MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)this.mLookup, (String)"evalRow", (MethodType)this.mMethodType);
            if (this.mFilterRef == null) {
                filter = TrueFilter.THE;
            } else {
                filter = (RowFilter)this.mFilterRef.get();
                if (filter == null) {
                    filter = BaseTable.parseFilter(this.mRowType, this.mFilterStr);
                    this.mFilterRef = new WeakReference<TrueFilter>((TrueFilter)filter);
                }
            }
            RowStore store = (RowStore)this.mStoreRef.get();
            if (store == null) {
                mm.new_(DatabaseException.class, new Object[]{"Closed"}).throw_();
                return mm.finish();
            }
            try {
                rowInfo = store.rowInfo(this.mRowType, this.mIndexId, schemaVersion);
                if (this.mProjectionSpec == null) {
                    decoder = null;
                    valueDecoder = this.mLookup.findStatic(this.mLookup.lookupClass(), "decodeValueHandle", MethodType.methodType(MethodHandle.class, Integer.TYPE)).invokeExact(schemaVersion);
                } else {
                    BaseTable<?> table = store.findTable(this.mIndexId, this.mRowType);
                    decoder = table.decodePartialHandle(this.mProjectionSpec, schemaVersion);
                    valueDecoder = null;
                }
            }
            catch (Throwable e) {
                return new ExceptionCallSite.Failed(this.mMethodType, mm, e);
            }
            RowGen rowGen = rowInfo.rowGen();
            int valueOffset = RowUtils.lengthPrefixPF(schemaVersion);
            Variable predicateVar = mm.param(this.mMethodType.parameterCount() - 1);
            DecodeVisitor visitor = new DecodeVisitor(mm, valueOffset, rowGen, predicateVar, this.mStopColumn, this.mStopArgument);
            visitor.applyFilter(filter);
            Class<?> rowClass = RowMaker.find(this.mRowType);
            Variable rowVar = mm.param(this.mMethodType.parameterCount() - 2);
            visitor.finishDecode(decoder, valueDecoder, this.mTableClass, rowClass, rowVar);
            return mm.finish();
        }
    }
}

