/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashSet;
import java.util.Set;
import org.cojen.tupl.ClosedIndexException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.Sorter;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.core.CoreDatabase;
import org.cojen.tupl.core.RedoListener;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.TableManager;
import org.cojen.tupl.rows.Trigger;
import org.cojen.tupl.util.Runner;
import org.cojen.tupl.util.Worker;

public abstract class IndexBackfill<R>
extends Worker.Task
implements RedoListener,
Closeable {
    final TableManager<R> mManager;
    final RowStore mRowStore;
    final boolean mAutoload;
    final Index mSecondaryIndex;
    final byte[] mSecondaryDescriptor;
    final String mSecondaryStr;
    private volatile Sorter mSorter;
    private volatile Index mDeleted;
    private Set<Trigger<R>> mTriggers;
    private Index mNewSecondaryIndex;

    protected IndexBackfill(RowStore rs, TableManager<R> manager, boolean autoload, Index secondaryIndex, byte[] secondaryDesc, String secondaryStr) throws IOException {
        this.mRowStore = rs;
        this.mManager = manager;
        this.mAutoload = autoload;
        this.mSecondaryIndex = secondaryIndex;
        this.mSecondaryDescriptor = secondaryDesc;
        this.mSecondaryStr = secondaryStr;
        CoreDatabase db = this.mRowStore.mDatabase;
        this.mSorter = db.newSorter();
        this.mDeleted = db.newTemporaryIndex();
        this.mTriggers = new HashSet<Trigger<R>>();
    }

    @Override
    public void run() {
        EventListener listener;
        block10: {
            block9: {
                try {
                    if (!this.mManager.mPrimaryIndex.isEmpty()) break block9;
                    listener = null;
                    break block10;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            listener = this.mRowStore.mDatabase.eventListener();
        }
        if (listener != null) {
            listener.notify(EventType.TABLE_INDEX_INFO, "Starting backfill for %1$s", this.mSecondaryStr);
        }
        boolean success = false;
        try {
            success = this.doRun();
            if (!success && listener != null) {
                listener.notify(EventType.TABLE_INDEX_INFO, "Stopped backfill for %1$s", this.mSecondaryStr);
            }
        }
        catch (Throwable e) {
            this.error("Unable to backfill %1$s: %2$s", e);
        }
        try {
            this.mRowStore.activateSecondaryIndex(this, success);
            if (success && listener != null) {
                listener.notify(EventType.TABLE_INDEX_INFO, "Finished backfill for %1$s", this.mSecondaryStr);
            }
        }
        catch (Throwable e) {
            this.error("Unable to activate %1$s: %2$s", e);
        }
    }

    private void error(String message, Throwable e) {
        if (!this.mRowStore.mDatabase.isClosed()) {
            EventListener listener = this.mRowStore.mDatabase.eventListener();
            if (listener == null) {
                RowUtils.uncaught(e);
            } else {
                listener.notify(EventType.TABLE_INDEX_ERROR, message, this.mSecondaryStr, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRun() throws IOException {
        Index deleted;
        Index newIndex;
        byte[][] primaryBatch = new byte[200][];
        byte[][] secondaryBatch = new byte[primaryBatch.length][];
        Transaction txn = this.mRowStore.mDatabase.newTransaction();
        txn.lockMode(LockMode.READ_COMMITTED);
        txn.lockTimeout(-1L, null);
        txn.durabilityMode(DurabilityMode.NO_REDO);
        try (Cursor c = this.mManager.mPrimaryIndex.newCursor(txn);){
            c.autoload(this.mAutoload);
            c.first();
            int length = 0;
            while (true) {
                byte[] key;
                if ((key = c.key()) == null) {
                    if (length > 0 && !this.addBatch(primaryBatch, secondaryBatch, length)) {
                        boolean bl = false;
                        return bl;
                    }
                    break;
                }
                primaryBatch[length++] = key;
                primaryBatch[length++] = c.value();
                if (length >= primaryBatch.length) {
                    if (!this.addBatch(primaryBatch, secondaryBatch, length)) {
                        boolean bl = false;
                        return bl;
                    }
                    length = 0;
                }
                c.next();
            }
        }
        Sorter sorter = this.mSorter;
        if (sorter == null) {
            return false;
        }
        try {
            newIndex = sorter.finish();
        }
        catch (InterruptedIOException e) {
            if (this.mSorter != null) {
                throw e;
            }
            return false;
        }
        IndexBackfill indexBackfill = this;
        synchronized (indexBackfill) {
            deleted = this.mDeleted;
            if (deleted == null) {
                return false;
            }
            this.withTriggerLock(() -> {
                this.mNewSecondaryIndex = newIndex;
            });
        }
        txn.lockMode(LockMode.UPGRADABLE_READ);
        try (Cursor secondaryCursor = this.mSecondaryIndex.newCursor(txn);
             Cursor deletedCursor = deleted.newCursor(Transaction.BOGUS);){
            byte[] key;
            secondaryCursor.first();
            while ((key = secondaryCursor.key()) != null) {
                deletedCursor.findNearby(key);
                if (deletedCursor.value() == null) {
                    newIndex.store(txn, key, secondaryCursor.value());
                } else {
                    deletedCursor.delete();
                }
                secondaryCursor.commit(null);
                secondaryCursor.next();
            }
        }
        try (Cursor deletedCursor = deleted.newCursor(Transaction.BOGUS);){
            byte[] key;
            deletedCursor.first();
            while ((key = deletedCursor.key()) != null) {
                newIndex.lockUpgradable(txn, key);
                try {
                    deletedCursor.load();
                    if (deletedCursor.value() != null) {
                        newIndex.store(txn, key, null);
                        deletedCursor.store(null);
                        txn.commit();
                    }
                }
                finally {
                    txn.exit();
                }
                deletedCursor.next();
            }
        }
        this.withTriggerLock(() -> {
            try {
                this.mRowStore.mDatabase.rootSwap(newIndex, this.mSecondaryIndex);
            }
            catch (IOException e) {
                throw RowUtils.rethrow(e);
            }
            this.mDeleted = null;
            this.mNewSecondaryIndex = null;
        });
        try {
            this.mRowStore.mDatabase.deleteIndex(newIndex).run();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mRowStore.mDatabase.deleteIndex(deleted).run();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void withTriggerLock(Runnable r) {
        for (Trigger<R> trigger : this.mTriggers) {
            trigger.acquireExclusive();
        }
        Throwable ex = null;
        try {
            this.mRowStore.mDatabase.withRedoLock(r);
        }
        catch (Throwable e) {
            ex = e;
        }
        for (Trigger<R> trigger : this.mTriggers) {
            trigger.releaseExclusive();
        }
        if (ex != null) {
            throw RowUtils.rethrow(ex);
        }
    }

    private boolean addBatch(byte[][] primaryBatch, byte[][] secondaryBatch, int length) throws IOException {
        Sorter sorter = this.mSorter;
        if (sorter == null) {
            return false;
        }
        for (int i = 0; i < length; i += 2) {
            this.encode(primaryBatch[i], primaryBatch[i + 1], secondaryBatch, i);
        }
        sorter.addBatch(secondaryBatch, 0, length >> 1);
        if (this.mSorter != null) {
            return true;
        }
        try {
            sorter.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void close() {
        this.unused(null, true);
    }

    @Override
    public final void store(Transaction txn, Index ix, byte[] key, byte[] value) {
        if (ix == this.mSecondaryIndex) {
            try {
                if (value == null) {
                    this.deleted(txn, key);
                } else {
                    this.inserted(txn, key, value);
                }
            }
            catch (Throwable e) {
                this.error("Uncaught exception during backfill of %1$s: %2$s", e);
            }
        }
    }

    public synchronized void used(Trigger<R> trigger) {
        if (this.mTriggers == null) {
            throw new IllegalStateException("Closed");
        }
        this.mTriggers.add(trigger);
    }

    public void unused(Trigger<R> trigger) {
        this.unused(trigger, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unused(Trigger<R> trigger, boolean close) {
        Index deleted;
        Sorter sorter;
        IndexBackfill indexBackfill = this;
        synchronized (indexBackfill) {
            if (this.mTriggers == null) {
                return;
            }
            this.mTriggers.remove(trigger);
            if (!close && !this.mTriggers.isEmpty()) {
                return;
            }
            this.mTriggers = null;
            sorter = this.mSorter;
            this.mSorter = null;
            deleted = this.mDeleted;
            this.mDeleted = null;
        }
        if (sorter == null && deleted == null) {
            return;
        }
        CoreDatabase db = this.mRowStore.mDatabase;
        db.removeRedoListener(this);
        Runner.start(() -> {
            Runnable deleteTask = null;
            if (deleted != null) {
                try {
                    deleteTask = db.deleteIndex(deleted);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (sorter != null) {
                try {
                    sorter.reset();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (deleteTask != null) {
                deleteTask.run();
            }
        });
    }

    public void deleted(Transaction txn, byte[] secondaryKey) throws IOException {
        Index deleted = this.mDeleted;
        if (deleted == null) {
            return;
        }
        try {
            Index newIndex = this.mNewSecondaryIndex;
            if (newIndex == null) {
                deleted.store(txn, secondaryKey, RowUtils.EMPTY_BYTES);
            } else {
                deleted.delete(txn, secondaryKey);
                newIndex.delete(txn, secondaryKey);
            }
        }
        catch (ClosedIndexException closedIndexException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inserted(Transaction txn, byte[] secondaryKey, byte[] secondaryValue) throws IOException {
        Index newIndex = this.mNewSecondaryIndex;
        Index deleted = this.mDeleted;
        if (newIndex == null || deleted == null) {
            return;
        }
        if (txn.isBogus()) {
            txn = this.mRowStore.mDatabase.newTransaction(DurabilityMode.NO_REDO);
            txn.lockTimeout(-1L, null);
        } else {
            txn.enter();
        }
        try {
            this.mSecondaryIndex.delete(txn, secondaryKey);
            deleted.delete(txn, secondaryKey);
            newIndex.store(txn, secondaryKey, secondaryValue);
            txn.commit();
        }
        catch (ClosedIndexException closedIndexException) {
        }
        finally {
            txn.exit();
        }
    }

    protected abstract void encode(byte[] var1, byte[] var2, byte[][] var3, int var4);
}

