/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.cojen.tupl.filter.AndFilter;
import org.cojen.tupl.filter.ColumnFilter;
import org.cojen.tupl.filter.ColumnToArgFilter;
import org.cojen.tupl.filter.ColumnToColumnFilter;
import org.cojen.tupl.filter.OrFilter;
import org.cojen.tupl.filter.Query;
import org.cojen.tupl.filter.RowFilter;
import org.cojen.tupl.filter.TrueFilter;
import org.cojen.tupl.filter.Visitor;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.BaseTableIndex;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.ColumnSet;
import org.cojen.tupl.rows.NoSuchIndexException;
import org.cojen.tupl.rows.OrderBy;
import org.cojen.tupl.rows.RowInfo;

final class IndexSelector<R> {
    private final RowInfo mPrimaryInfo;
    private final Query mQuery;
    private final boolean mForUpdate;
    private NavigableSet<ColumnSet> mAlternateKeys;
    private NavigableSet<ColumnSet> mSecondaryIndexes;
    private int mAnyTermMatches;
    private boolean mAnyFirstOrderMatches;
    private boolean mMultipleSelections;
    private ColumnSet[] mSelectedIndexes;
    private BaseTable[] mSelectedIndexTables;
    private Query[] mSelectedQueries;
    private boolean[] mSelectedReverse;
    private OrderBy mOrderBy;
    private OrderBy mGrouping;
    private Set<String> mProjection;
    private boolean mForUpdateRule;
    private static final int EQUALITY = 1;
    private static final int FULL_RANGE = 2;
    private static final int HALF_RANGE = 3;
    private static final int REMAINDER = 4;
    private static final int CANDIDATE = 5;

    IndexSelector(BaseTable<R> table, RowInfo primaryInfo, Query query, boolean forUpdate) throws IOException {
        block10: {
            BaseTable[] selectedIndexTables;
            this.mPrimaryInfo = primaryInfo;
            this.mQuery = query;
            this.mForUpdate = forUpdate;
            this.mAlternateKeys = primaryInfo.alternateKeys;
            this.mSecondaryIndexes = primaryInfo.secondaryIndexes;
            block4: while (true) {
                this.analyze();
                if (table == null) break block10;
                selectedIndexTables = new BaseTable[this.numSelected()];
                for (int i = 0; i < selectedIndexTables.length; ++i) {
                    BaseTableIndex<R> subTable;
                    block11: {
                        ColumnSet subIndex = this.selectedIndex(i);
                        if (subIndex.matches(primaryInfo)) {
                            selectedIndexTables[i] = table;
                            continue;
                        }
                        if (this.mAlternateKeys.contains(subIndex)) {
                            try {
                                subTable = table.viewIndexTable(true, subIndex.keySpec());
                                break block11;
                            }
                            catch (NoSuchIndexException e) {
                                if (this.mAlternateKeys == primaryInfo.alternateKeys) {
                                    this.mAlternateKeys = new TreeSet<ColumnSet>((SortedSet<ColumnSet>)this.mAlternateKeys);
                                }
                                this.mAlternateKeys.remove(subIndex);
                                continue block4;
                            }
                        }
                        try {
                            subTable = table.viewIndexTable(false, subIndex.fullSpec());
                        }
                        catch (NoSuchIndexException e) {
                            if (this.mSecondaryIndexes == primaryInfo.secondaryIndexes) {
                                this.mSecondaryIndexes = new TreeSet<ColumnSet>((SortedSet<ColumnSet>)this.mSecondaryIndexes);
                            }
                            this.mSecondaryIndexes.remove(subIndex);
                            continue block4;
                        }
                    }
                    selectedIndexTables[i] = subTable;
                }
                break;
            }
            this.mSelectedIndexTables = selectedIndexTables;
        }
    }

    private void analyze() {
        this.selectIndexes();
        int num = this.numSelected();
        OrderBy orderBy = this.mQuery.orderBy();
        if (orderBy != null && (orderBy = this.reduceOrdering(orderBy, this.mPrimaryInfo)) != null) {
            ColumnSet key;
            Iterator<ColumnSet> iterator = this.mAlternateKeys.iterator();
            while (iterator.hasNext() && (orderBy = this.reduceOrdering(orderBy, key = iterator.next())) != null) {
            }
        }
        this.mOrderBy = orderBy;
        if (orderBy == null || orderBy.isEmpty()) {
            for (int i = 0; i < num; ++i) {
                if (!this.shouldReverseScan(i)) continue;
                if (this.mSelectedReverse == null) {
                    this.mSelectedReverse = new boolean[num];
                }
                this.mSelectedReverse[i] = true;
            }
            return;
        }
        this.mSelectedReverse = new boolean[num];
        block2: for (int i = 0; i < num; ++i) {
            Iterator<ColumnInfo> columns = this.mSelectedIndexes[i].keyColumns.values().iterator();
            Iterator rules = orderBy.values().iterator();
            int direction = 0;
            int numMatches = 0;
            while (true) {
                OrderBy.Rule rule;
                if (!rules.hasNext()) {
                    if (num != 1) continue block2;
                    this.mOrderBy = null;
                    break block2;
                }
                if (!columns.hasNext()) {
                    if (num != 1) break;
                    this.mOrderBy = null;
                    break block2;
                }
                ColumnInfo column = columns.next();
                int match = IndexSelector.compareOrdering(column, rule = (OrderBy.Rule)rules.next(), direction);
                if (match == 0) break;
                if (direction == 0 && match < 0) {
                    this.mSelectedReverse[i] = true;
                }
                direction = match;
                ++numMatches;
            }
            if (num != 1) continue;
            this.mGrouping = orderBy.truncate(numMatches);
        }
    }

    private OrderBy reduceOrdering(OrderBy orderBy, ColumnSet key) {
        Map<String, ColumnInfo> keyColumns = key.keyColumns;
        int remaining = keyColumns.size();
        int num = 0;
        for (String name : orderBy.keySet()) {
            ++num;
            if (!keyColumns.containsKey(name) || --remaining > 0) continue;
            break;
        }
        if ((orderBy = orderBy.truncate(num)) == null) {
            return null;
        }
        RowFilter filter = this.mQuery.filter();
        boolean copied = false;
        for (String name : orderBy.keySet()) {
            if (!filter.matchesOne(name)) continue;
            if (!copied) {
                orderBy = new OrderBy(orderBy);
                copied = true;
            }
            orderBy.remove(name);
        }
        return orderBy.isEmpty() ? null : orderBy;
    }

    private void selectIndexes() {
        ColumnSet theOne;
        block16: {
            if (this.mAlternateKeys.isEmpty() && this.mSecondaryIndexes.isEmpty()) {
                theOne = this.mPrimaryInfo;
            } else {
                RowFilter dnf = this.mQuery.filter().dnf();
                if (!(dnf instanceof OrFilter)) {
                    theOne = dnf == TrueFilter.THE ? this.findBestFullScanIndex() : this.selectIndex(dnf);
                } else {
                    OrFilter orf = (OrFilter)dnf;
                    LinkedHashMap<ColumnSet, RowFilter> selections = new LinkedHashMap<ColumnSet, RowFilter>();
                    block0: while (true) {
                        boolean fullScan = false;
                        for (RowFilter group : orf.subFilters()) {
                            ColumnSet index = this.selectIndex(group);
                            fullScan |= this.mAnyTermMatches == 0;
                            RowFilter existing = (RowFilter)selections.get(index);
                            if (existing == null) {
                                selections.put(index, group);
                            } else {
                                selections.put(index, existing.or(group).reduce());
                            }
                            if (selections.size() <= 1) continue;
                            if (fullScan) {
                                theOne = this.findBestFullScanIndex();
                                break block16;
                            }
                            this.mMultipleSelections = true;
                            if (!this.mAnyFirstOrderMatches) continue;
                            this.mAnyFirstOrderMatches = false;
                            selections.clear();
                            continue block0;
                        }
                        break;
                    }
                    if (selections.size() == 1) {
                        theOne = (ColumnSet)selections.keySet().iterator().next();
                    } else if (selections.isEmpty()) {
                        theOne = this.mPrimaryInfo;
                    } else {
                        ArrayList entries = new ArrayList(selections.entrySet());
                        entries.sort(Comparator.comparingInt(e -> ((RowFilter)e.getValue()).numTerms()));
                        this.mSelectedIndexes = new ColumnSet[entries.size()];
                        this.mSelectedQueries = new Query[this.mSelectedIndexes.length];
                        Iterator it = entries.iterator();
                        RowFilter reject = null;
                        for (int i = 0; i < this.mSelectedIndexes.length; ++i) {
                            Map.Entry selected = it.next();
                            this.mSelectedIndexes[i] = (ColumnSet)selected.getKey();
                            RowFilter filter = (RowFilter)selected.getValue();
                            if (reject == null) {
                                reject = filter.not();
                            } else {
                                RowFilter disjoint = filter.and(reject).reduce();
                                reject = reject.and(filter.not());
                                filter = disjoint;
                            }
                            this.mSelectedQueries[i] = this.mQuery.withFilter(filter).withOrderBy(null);
                        }
                        return;
                    }
                }
            }
        }
        this.mSelectedIndexes = new ColumnSet[]{theOne};
        this.mSelectedQueries = new Query[]{this.mQuery.withOrderBy(null)};
    }

    RowInfo primaryInfo() {
        return this.mPrimaryInfo;
    }

    Query query() {
        return this.mQuery;
    }

    boolean forUpdate() {
        return this.mForUpdate;
    }

    int numSelected() {
        return this.mSelectedIndexes.length;
    }

    ColumnSet selectedIndex(int i) {
        return this.mSelectedIndexes[i];
    }

    BaseTable<R> selectedIndexTable(int i) {
        return this.mSelectedIndexTables[i];
    }

    Query selectedQuery(int i) {
        return this.mSelectedQueries[i];
    }

    boolean selectedReverse(int i) {
        return this.mSelectedReverse != null && this.mSelectedReverse[i];
    }

    OrderBy orderBy() {
        return this.mOrderBy;
    }

    OrderBy grouping() {
        return this.mGrouping;
    }

    Set<String> projection() {
        if (this.mProjection == null && this.mQuery.projection() != null) {
            this.mProjection = Set.of((String[])this.mQuery.projection().keySet().toArray(String[]::new));
        }
        return this.mProjection;
    }

    boolean forUpdateRuleChosen() {
        return this.mForUpdateRule;
    }

    private boolean shouldReverseScan(int i) {
        int descending;
        RowFilter rf = this.mSelectedQueries[i].filter();
        if (!(rf instanceof ColumnToArgFilter)) {
            return false;
        }
        ColumnToArgFilter cf = (ColumnToArgFilter)rf;
        switch (cf.operator()) {
            case 3: 
            case 4: {
                descending = 0;
                break;
            }
            case 2: 
            case 5: {
                descending = 128;
                break;
            }
            default: {
                return false;
            }
        }
        ColumnInfo ixColumn = this.mSelectedIndexes[i].keyColumns.values().iterator().next();
        if ((ixColumn.typeCode & 0x80) != descending) {
            return false;
        }
        return ixColumn.name.equals(cf.column().name);
    }

    private ColumnSet selectIndex(RowFilter group) {
        this.mAnyTermMatches = 0;
        List<Term> terms = IndexSelector.makeTerms(group);
        ColumnSet best = this.mPrimaryInfo;
        for (ColumnSet cs : this.mAlternateKeys) {
            if (this.compareIndexes(group, terms, cs, best) >= 0) continue;
            best = cs;
        }
        for (ColumnSet cs : this.mSecondaryIndexes) {
            if (this.compareIndexes(group, terms, cs, best) >= 0) continue;
            best = cs;
        }
        return best;
    }

    private int compareIndexes(RowFilter group, List<Term> terms, ColumnSet cs1, ColumnSet cs2) {
        int cmp = Long.compare(this.keyMatchScore(terms, cs2), this.keyMatchScore(terms, cs1));
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compareCovering(terms, cs1, cs2);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(IndexSelector.columnAvailability(terms, cs2), IndexSelector.columnAvailability(terms, cs1));
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compareOrdering(cs1, cs2);
        if (cmp != 0) {
            return cmp;
        }
        cmp = IndexSelector.comparePreference(group, cs1, cs2);
        if (cmp != 0) {
            return cmp;
        }
        return Integer.compare(cs1.allColumns.size(), cs2.allColumns.size());
    }

    /*
     * Unable to fully structure code
     */
    private long keyMatchScore(List<Term> terms, ColumnSet cs) {
        score = 0L;
        primaryMatches = 0;
        block5: for (ColumnInfo column : cs.keyColumns.values()) {
            for (Term t : terms) {
                if (t.mType > 3) break block5;
                if (!t.mFilter.column().name.equals(column.name)) continue;
                term = t;
                switch (term.mType) {
                    case 1: {
                        if (cs != this.mPrimaryInfo && this.mPrimaryInfo.keyColumns.containsKey(column.name) && ++primaryMatches == this.mPrimaryInfo.keyColumns.size()) {
                            score = primaryMatches * 3;
                            break block5;
                        }
                        score += 3L;
                        continue block5;
                    }
                    case 2: {
                        score += 2L;
                        break block5;
                    }
                    case 3: {
                        if (score > 0L || this.isCovering(terms, cs) || this.isFirstOrderByColumn(column)) {
                            ++score;
                        } else {
                            ** GOTO lbl21
                        }
                    }
                }
            }
        }
lbl21:
        // 9 sources

        this.mAnyTermMatches = (int)((long)this.mAnyTermMatches + score);
        return score;
    }

    private boolean isFirstOrderByColumn(ColumnInfo column) {
        if (this.mMultipleSelections) {
            return false;
        }
        OrderBy orderBy = this.mQuery.orderBy();
        if (orderBy == null || orderBy.isEmpty() || IndexSelector.compareOrdering(column, (OrderBy.Rule)orderBy.values().iterator().next()) == 0) {
            return false;
        }
        this.mAnyFirstOrderMatches = true;
        return true;
    }

    private static int compareOrdering(ColumnInfo column, OrderBy.Rule rule) {
        int rt;
        block3: {
            block2: {
                if (!column.name.equals(rule.column().name)) break block2;
                rt = rule.type();
                if (column.unorderedTypeCode() == ColumnInfo.unorderedTypeCode(rt)) break block3;
            }
            return 0;
        }
        return column.isDescending() == ColumnInfo.isDescending(rt) ? 1 : -1;
    }

    private static int compareOrdering(ColumnInfo column, OrderBy.Rule rule, int direction) {
        int cmp = IndexSelector.compareOrdering(column, rule);
        return cmp == 0 || direction != 0 && direction != cmp ? 0 : cmp;
    }

    private boolean isCovering(List<Term> terms, ColumnSet cs) {
        if (cs == this.mPrimaryInfo) {
            return true;
        }
        NavigableMap pmap = this.mQuery.projection();
        if (pmap == null) {
            pmap = this.mPrimaryInfo.allColumns;
        }
        if (!cs.allColumns.keySet().containsAll(pmap.keySet())) {
            return false;
        }
        for (Term term : terms) {
            ColumnFilter filter = term.mFilter;
            if (!cs.allColumns.containsKey(filter.column().name)) {
                return false;
            }
            if (!(filter instanceof ColumnToColumnFilter)) continue;
            ColumnToColumnFilter ctc = (ColumnToColumnFilter)filter;
            if (cs.allColumns.containsKey(ctc.otherColumn().name)) continue;
            return false;
        }
        return true;
    }

    private int compareCovering(List<Term> terms, ColumnSet cs1, ColumnSet cs2) {
        Set<String> required;
        Map<String, ColumnInfo> pmap = this.mQuery.projection();
        if (pmap == null) {
            required = this.mPrimaryInfo.allColumns.keySet();
        } else {
            required = new HashSet<String>(pmap.keySet());
            for (Term term : terms) {
                ColumnFilter filter = term.mFilter;
                required.add(filter.column().name);
                if (!(filter instanceof ColumnToColumnFilter)) continue;
                ColumnToColumnFilter ctc = (ColumnToColumnFilter)filter;
                required.add(ctc.otherColumn().name);
            }
        }
        return this.compareCovering(required, cs1, cs2);
    }

    private int compareCovering(Set<String> required, ColumnSet cs1, ColumnSet cs2) {
        if (cs1.allColumns.keySet().containsAll(required)) {
            if (cs2.allColumns.keySet().containsAll(required)) {
                return Integer.compare(cs1.allColumns.size(), cs2.allColumns.size());
            }
            return -1;
        }
        if (cs2.allColumns.keySet().containsAll(required)) {
            return 1;
        }
        return 0;
    }

    private static int columnAvailability(List<Term> terms, ColumnSet cs) {
        HashSet<String> available = new HashSet<String>();
        NavigableMap<String, ColumnInfo> columns = cs.allColumns;
        for (Term term : terms) {
            ColumnFilter filter = term.mFilter;
            String name = filter.column().name;
            if (columns.containsKey(name)) {
                available.add(name);
            }
            if (!(filter instanceof ColumnToColumnFilter)) continue;
            ColumnToColumnFilter ctc = (ColumnToColumnFilter)filter;
            name = ctc.otherColumn().name;
            if (!columns.containsKey(name)) continue;
            available.add(name);
        }
        return available.size();
    }

    private static int comparePreference(RowFilter group, ColumnSet cs1, ColumnSet cs2) {
        if (group instanceof ColumnFilter) {
            ColumnFilter cf = (ColumnFilter)group;
            return IndexSelector.comparePreference(cf, cs1, cs2);
        }
        if (group instanceof AndFilter) {
            AndFilter andf = (AndFilter)group;
            for (RowFilter sub : andf.subFilters()) {
                ColumnFilter cf;
                int cmp;
                if (!(sub instanceof ColumnFilter) || (cmp = IndexSelector.comparePreference(cf = (ColumnFilter)sub, cs1, cs2)) == 0) continue;
                return cmp;
            }
        }
        return 0;
    }

    private static int comparePreference(ColumnFilter cf, ColumnSet cs1, ColumnSet cs2) {
        String name = cf.column().name;
        Iterator<String> it1 = cs1.keyColumns.keySet().iterator();
        Iterator<String> it2 = cs2.keyColumns.keySet().iterator();
        while (it1.hasNext() && it2.hasNext()) {
            String key1 = it1.next();
            String key2 = it2.next();
            if (name.equals(key1)) {
                return name.equals(key2) ? 0 : -1;
            }
            if (!name.equals(key2)) continue;
            return 1;
        }
        return 0;
    }

    private int compareOrdering(ColumnSet cs1, ColumnSet cs2) {
        OrderBy orderBy = this.mQuery.orderBy();
        if (orderBy == null || orderBy.isEmpty()) {
            return 0;
        }
        Iterator rules = orderBy.values().iterator();
        Iterator<ColumnInfo> it1 = cs1.keyColumns.values().iterator();
        Iterator<ColumnInfo> it2 = cs2.keyColumns.values().iterator();
        int dir1 = 0;
        int dir2 = 0;
        while (rules.hasNext() && it1.hasNext() && it2.hasNext()) {
            OrderBy.Rule rule = (OrderBy.Rule)rules.next();
            ColumnInfo col1 = it1.next();
            ColumnInfo col2 = it2.next();
            dir1 = IndexSelector.compareOrdering(col1, rule, dir1);
            dir2 = IndexSelector.compareOrdering(col2, rule, dir2);
            if (dir1 == 0) {
                return dir2 == 0 ? 0 : 1;
            }
            if (dir2 != 0) continue;
            return -1;
        }
        return 0;
    }

    private ColumnSet findBestFullScanIndex() {
        OrderBy.Rule firstOrderBy;
        ColumnInfo firstColumn;
        OrderBy orderBy;
        ColumnSet best = this.mPrimaryInfo;
        if (this.mQuery.filter() == TrueFilter.THE && (orderBy = this.mQuery.orderBy()) != null && !orderBy.isEmpty() && IndexSelector.compareOrdering(firstColumn = best.keyColumns.values().iterator().next(), firstOrderBy = (OrderBy.Rule)orderBy.values().iterator().next()) != 0) {
            return best;
        }
        Map<String, ColumnInfo> pmap = this.mQuery.projection();
        if (pmap != null) {
            final HashSet<String> required = new HashSet<String>(pmap.keySet());
            this.mQuery.filter().accept(new Visitor(){

                @Override
                public void visit(ColumnToArgFilter filter) {
                    required.add(filter.column().name);
                }

                @Override
                public void visit(ColumnToColumnFilter filter) {
                    required.add(filter.column().name);
                    required.add(filter.otherColumn().name);
                }
            });
            for (ColumnSet cs : this.mAlternateKeys) {
                if (this.compareCovering(required, cs, best) >= 0) continue;
                best = cs;
            }
            for (ColumnSet cs : this.mSecondaryIndexes) {
                if (this.compareCovering(required, cs, best) >= 0) continue;
                best = cs;
            }
        }
        if (this.mForUpdate && best != this.mPrimaryInfo) {
            best = this.mPrimaryInfo;
            this.mForUpdateRule = true;
        }
        return best;
    }

    private static List<Term> makeTerms(RowFilter group) {
        Term term;
        if (group instanceof ColumnFilter) {
            ColumnFilter cf = (ColumnFilter)group;
            Term term2 = IndexSelector.makeTerm(cf);
            if (term2.mType == 5) {
                term2.mType = 3;
            }
            return List.of(term2);
        }
        if (!(group instanceof AndFilter)) {
            throw new AssertionError();
        }
        AndFilter andf = (AndFilter)group;
        RowFilter[] subFilters = andf.subFilters();
        ArrayList<Term> terms = new ArrayList<Term>(subFilters.length);
        ArrayList<Term> candidates = null;
        for (RowFilter sub : subFilters) {
            if (!(sub instanceof ColumnFilter)) {
                throw new AssertionError();
            }
            ColumnFilter cf = (ColumnFilter)sub;
            term = IndexSelector.makeTerm(cf);
            if (term.mType != 5) {
                terms.add(term);
                continue;
            }
            if (candidates == null) {
                candidates = new ArrayList<Term>(subFilters.length >> 1);
            }
            candidates.add(term);
        }
        Collections.sort(terms);
        if (candidates == null) {
            return terms;
        }
        int scanEnd = terms.size();
        block1: for (int scanStart = 0; scanStart < scanEnd; ++scanStart) {
            if (((Term)terms.get((int)scanStart)).mType != 3) continue;
            for (int i = scanStart + 1; i < scanEnd; ++i) {
                if (((Term)terms.get((int)i)).mType <= 3) continue;
                scanEnd = i;
                break block1;
            }
            break;
        }
        block3: for (Term candidate : candidates) {
            for (int i = scanStart; i < scanEnd; ++i) {
                term = (Term)terms.get(i);
                if (term.mType != 3 || !term.mFilter.column().equals(candidate.mFilter.column())) continue;
                term.mType = 2;
                term.mCompanion = candidate.mFilter;
                continue block3;
            }
            candidate.mType = 3;
            terms.add(candidate);
        }
        Collections.sort(terms);
        return terms;
    }

    private static Term makeTerm(ColumnFilter filter) {
        int type = 4;
        if (filter instanceof ColumnToArgFilter) {
            ColumnToArgFilter cf = (ColumnToArgFilter)filter;
            switch (cf.operator()) {
                case 0: {
                    type = 1;
                    break;
                }
                case 2: 
                case 5: {
                    type = 3;
                    break;
                }
                case 3: 
                case 4: {
                    type = 5;
                }
            }
        }
        return new Term(type, filter);
    }

    private static class Term
    implements Comparable<Term> {
        int mType;
        ColumnFilter mFilter;
        ColumnFilter mCompanion;

        Term(int type, ColumnFilter filter) {
            this.mType = type;
            this.mFilter = filter;
        }

        @Override
        public int compareTo(Term other) {
            int cmp = Integer.compare(this.mType, other.mType);
            if (cmp == 0 && (cmp = Integer.compare(Term.opOrder(this.mFilter), Term.opOrder(other.mFilter))) == 0 && this.mCompanion != null && other.mCompanion != null) {
                cmp = Integer.compare(Term.opOrder(this.mCompanion), Term.opOrder(other.mCompanion));
            }
            return cmp;
        }

        private static int opOrder(ColumnFilter filter) {
            return switch (filter.operator()) {
                case 0 -> 1;
                case 2, 3, 4, 5 -> 2;
                case 1 -> 3;
                case 6 -> 4;
                default -> 5;
            };
        }
    }
}

