/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import org.cojen.maker.Bootstrap;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DeletedIndexException;
import org.cojen.tupl.Index;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.UniqueConstraintException;
import org.cojen.tupl.core.RowPredicateLock;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.ExceptionCallSite;
import org.cojen.tupl.rows.IndexBackfill;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowMaker;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.SecondaryInfo;
import org.cojen.tupl.rows.SwitchCallSite;
import org.cojen.tupl.rows.TableMaker;
import org.cojen.tupl.rows.TableManager;
import org.cojen.tupl.rows.TransformMaker;
import org.cojen.tupl.rows.Trigger;
import org.cojen.tupl.rows.TriggerIndexAccessor;

public class IndexTriggerMaker<R> {
    private final Class<R> mRowType;
    private final Class<? extends R> mRowClass;
    private final RowGen mPrimaryGen;
    final byte[][] mSecondaryDescriptors;
    final RowInfo[] mSecondaryInfos;
    final Index[] mSecondaryIndexes;
    final RowPredicateLock<R>[] mSecondaryLocks;
    final IndexBackfill<R>[] mBackfills;
    private ClassMaker mClassMaker;

    IndexTriggerMaker(Class<R> rowType, RowInfo primaryInfo, int numIndexes) {
        this.mRowType = rowType;
        this.mRowClass = rowType == null ? null : RowMaker.find(rowType);
        this.mPrimaryGen = primaryInfo.rowGen();
        this.mSecondaryDescriptors = new byte[numIndexes][];
        this.mSecondaryInfos = new RowInfo[numIndexes];
        this.mSecondaryIndexes = new Index[numIndexes];
        this.mSecondaryLocks = new RowPredicateLock[numIndexes];
        this.mBackfills = new IndexBackfill[numIndexes];
    }

    IndexBackfill<R> makeBackfill(RowStore rs, long primaryIndexId, TableManager<R> manager, int which) {
        ClassMaker cm = this.mPrimaryGen.beginClassMaker(IndexTriggerMaker.class, this.mRowType, "backfill");
        cm.extend(IndexBackfill.class).final_();
        MethodMaker mm = cm.addMethod(null, "encode", new Object[]{byte[].class, byte[].class, byte[][].class, Integer.TYPE});
        mm.protected_();
        Variable primaryKeyVar = mm.param(0);
        Variable primaryValueVar = mm.param(1);
        Variable secondaryEntryVar = mm.param(2);
        Variable offsetVar = mm.param(3);
        byte[] secondaryDesc = this.mSecondaryDescriptors[which];
        Bootstrap indy = mm.var(IndexTriggerMaker.class).indy("indyBackfillEncode", new Object[]{rs.ref(), this.mRowType, primaryIndexId, secondaryDesc});
        Variable schemaVersion = mm.var(RowUtils.class).invoke("decodeSchemaVersion", new Object[]{primaryValueVar});
        indy.invoke(null, "encode", null, new Object[]{schemaVersion, primaryKeyVar, primaryValueVar, secondaryEntryVar, offsetVar});
        MethodType ctorMethodType = MethodType.methodType(Void.TYPE, RowStore.class, TableManager.class, Index.class, byte[].class, String.class);
        mm = cm.addConstructor(ctorMethodType);
        mm.invokeSuperConstructor(new Object[]{mm.param(0), mm.param(1), true, mm.param(2), mm.param(3), mm.param(4)});
        MethodHandles.Lookup lookup = cm.finishHidden();
        Index secondaryIndex = this.mSecondaryIndexes[which];
        String secondaryStr = this.mSecondaryInfos[which].eventString();
        try {
            MethodHandle ctor = lookup.findConstructor(lookup.lookupClass(), ctorMethodType);
            return ctor.invoke(rs, manager, secondaryIndex, secondaryDesc, secondaryStr);
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
    }

    public static SwitchCallSite indyBackfillEncode(MethodHandles.Lookup lookup, String name, MethodType mt, WeakReference<RowStore> storeRef, Class<?> rowType, long primaryIndexId, byte[] secondaryDesc) {
        return new SwitchCallSite(lookup, mt, schemaVersion -> {
            RowInfo primaryInfo;
            MethodType mtx = mt.dropParameterTypes(0, 1);
            RowStore store = (RowStore)storeRef.get();
            if (store == null) {
                MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)"encode", (MethodType)mtx);
                mm.new_(DatabaseException.class, new Object[]{"Closed"}).throw_();
                return mm.finish();
            }
            try {
                primaryInfo = store.rowInfo(rowType, primaryIndexId, schemaVersion);
            }
            catch (Exception e) {
                MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)"encode", (MethodType)mtx);
                return new ExceptionCallSite.Failed(mtx, mm, e);
            }
            MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)"encode", (MethodType)mtx);
            Variable primaryKeyVar = mm.param(0);
            Variable primaryValueVar = mm.param(1);
            Variable secondaryEntryVar = mm.param(2);
            Variable offsetVar = mm.param(3);
            TransformMaker tm = new TransformMaker(null, primaryInfo, null);
            SecondaryInfo secondaryInfo = RowStore.secondaryRowInfo(primaryInfo, secondaryDesc);
            tm.addKeyTarget(secondaryInfo, 0, true);
            tm.addValueTarget(secondaryInfo, 0, true);
            int valueOffset = RowUtils.lengthPrefixPF(schemaVersion);
            tm.begin(mm, null, primaryKeyVar, primaryValueVar, valueOffset);
            secondaryEntryVar.aset((Object)offsetVar, (Object)tm.encode(0));
            secondaryEntryVar.aset((Object)offsetVar.add((Object)1), (Object)tm.encode(1));
            return mm.finish();
        });
    }

    Trigger<R> makeTrigger(RowStore rs, long primaryIndexId, BaseTable<R> table) {
        Trigger trigger;
        int i;
        this.mClassMaker = this.mPrimaryGen.beginClassMaker(IndexTriggerMaker.class, this.mRowType, "trigger");
        this.mClassMaker.extend(Trigger.class).final_();
        boolean hasBackfills = false;
        for (int i2 = 0; i2 < this.mSecondaryIndexes.length; ++i2) {
            IndexBackfill<R> backfill;
            this.mClassMaker.addField(Index.class, "ix" + i2).private_().final_();
            if (this.mSecondaryLocks[i2] != null) {
                this.mClassMaker.addField(RowPredicateLock.class, "lock" + i2).private_().final_();
            }
            if ((backfill = this.mBackfills[i2]) == null) continue;
            hasBackfills = true;
            this.mClassMaker.addField(IndexBackfill.class, "backfill" + i2).private_().final_();
        }
        MethodType ctorMethodType = !hasBackfills ? MethodType.methodType(Void.TYPE, Index[].class, RowPredicateLock[].class) : MethodType.methodType(Void.TYPE, Index[].class, RowPredicateLock[].class, IndexBackfill[].class);
        MethodMaker mm = this.mClassMaker.addConstructor(ctorMethodType);
        mm.invokeSuperConstructor(new Object[0]);
        for (i = 0; i < this.mSecondaryIndexes.length; ++i) {
            mm.field("ix" + i).set((Object)mm.param(0).aget((Object)i));
        }
        for (i = 0; i < this.mSecondaryLocks.length; ++i) {
            if (this.mSecondaryLocks[i] == null) continue;
            mm.field("lock" + i).set((Object)mm.param(1).aget((Object)i));
        }
        if (hasBackfills) {
            for (i = 0; i < this.mBackfills.length; ++i) {
                if (this.mBackfills[i] == null) continue;
                mm.field("backfill" + i).set((Object)mm.param(2).aget((Object)i));
            }
        }
        boolean requiresRow = this.addInsertMethod("insert", true);
        this.addInsertMethod("insertP", requiresRow);
        this.addDeleteMethod(rs, primaryIndexId, true, hasBackfills);
        this.addDeleteMethod(rs, primaryIndexId, false, hasBackfills);
        requiresRow = this.addStoreMethod("store", true, table);
        this.addStoreMethod("storeP", requiresRow, table);
        if (hasBackfills) {
            mm = this.mClassMaker.addMethod(null, "notifyDisabled", new Object[0]).protected_();
            for (i = 0; i < this.mBackfills.length; ++i) {
                if (this.mBackfills[i] == null) continue;
                mm.field("backfill" + i).invoke("unused", new Object[]{mm.this_()});
            }
        }
        MethodHandles.Lookup lookup = this.mClassMaker.finishHidden();
        try {
            MethodHandle ctor = lookup.findConstructor(lookup.lookupClass(), ctorMethodType);
            trigger = !hasBackfills ? ctor.invoke(this.mSecondaryIndexes, this.mSecondaryLocks) : ctor.invoke(this.mSecondaryIndexes, this.mSecondaryLocks, this.mBackfills);
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
        if (hasBackfills) {
            for (IndexBackfill<R> b : this.mBackfills) {
                if (b == null) continue;
                b.used(trigger);
            }
        }
        return trigger;
    }

    private boolean addInsertMethod(String variant, boolean define) {
        int i;
        MethodMaker mm = this.mClassMaker.addMethod(null, variant, new Object[]{Transaction.class, Object.class, byte[].class, byte[].class}).public_();
        boolean isPartial = variant == "insertP";
        Variable txnVar = mm.param(0);
        Variable rowVar = mm.param(1);
        Variable keyVar = mm.param(2);
        Variable newValueVar = mm.param(3);
        if (isPartial && !define) {
            mm.invoke("insert", new Object[]{txnVar, rowVar, keyVar, newValueVar});
            return false;
        }
        rowVar = rowVar.cast(this.mRowClass);
        HashMap<String, TransformMaker.Availability> available = new HashMap<String, TransformMaker.Availability>();
        TransformMaker.Availability avail = isPartial ? TransformMaker.Availability.CONDITIONAL : TransformMaker.Availability.ALWAYS;
        for (String colName : this.mPrimaryGen.info.allColumns.keySet()) {
            available.put(colName, avail);
        }
        TransformMaker<R> tm = new TransformMaker<R>(this.mRowType, this.mPrimaryGen.info, available);
        for (i = 0; i < this.mSecondaryInfos.length; ++i) {
            RowInfo secondaryInfo = this.mSecondaryInfos[i];
            tm.addKeyTarget(secondaryInfo, 0, true);
            tm.addValueTarget(secondaryInfo, 0, true);
        }
        tm.begin(mm, rowVar, keyVar, newValueVar, -1);
        for (i = 0; i < this.mSecondaryInfos.length; ++i) {
            Variable secondaryKeyVar = tm.encode(i << 1);
            Variable secondaryValueVar = tm.encode((i << 1) + 1);
            Variable closerVar = this.acquirePredicateLock(mm, i, isPartial, txnVar, rowVar, secondaryKeyVar, secondaryValueVar);
            Label opStart = mm.label().here();
            Field ixField = mm.field("ix" + i);
            if (!this.mSecondaryInfos[i].isAltKey()) {
                ixField.invoke("store", new Object[]{txnVar, secondaryKeyVar, secondaryValueVar});
                if (closerVar != null) {
                    mm.finally_(opStart, () -> closerVar.invoke("close", new Object[0]));
                }
            } else {
                Variable result = ixField.invoke("insert", new Object[]{txnVar, secondaryKeyVar, secondaryValueVar});
                if (closerVar != null) {
                    mm.finally_(opStart, () -> closerVar.invoke("close", new Object[0]));
                }
                Label pass = mm.label();
                result.ifTrue(pass);
                mm.new_(UniqueConstraintException.class, new Object[]{"Alternate key"}).throw_();
                pass.here();
            }
            if (isPartial) {
                Variable attachment = txnVar.invoke("attachment", new Object[0]);
                Label noAttachment = mm.label();
                attachment.instanceOf(TriggerIndexAccessor.class).ifFalse(noAttachment);
                attachment.cast(TriggerIndexAccessor.class).invoke("stored", new Object[]{ixField, secondaryKeyVar, secondaryValueVar});
                noAttachment.here();
            }
            if (this.mBackfills[i] != null) {
                mm.field("backfill" + i).invoke("inserted", new Object[]{txnVar, secondaryKeyVar, secondaryValueVar});
            }
            mm.catch_(opStart, DeletedIndexException.class, exVar -> {});
        }
        return tm.requiresRow();
    }

    private void addDeleteMethod(RowStore rs, long primaryIndexId, boolean hasRow, boolean hasBackfills) {
        Variable oldValueVar;
        Variable keyVar;
        Variable rowVar;
        Object[] params = hasRow ? new Object[]{Transaction.class, Object.class, byte[].class, byte[].class} : new Object[]{Transaction.class, byte[].class, byte[].class};
        MethodMaker mm = this.mClassMaker.addMethod(null, "delete", params).public_();
        Variable txnVar = mm.param(0);
        if (hasRow) {
            rowVar = mm.param(1).cast(this.mRowClass);
            keyVar = mm.param(2);
            oldValueVar = mm.param(3);
        } else {
            rowVar = null;
            keyVar = mm.param(1);
            oldValueVar = mm.param(2);
        }
        Variable schemaVersion = mm.var(RowUtils.class).invoke("decodeSchemaVersion", new Object[]{oldValueVar});
        long[] secondaryIndexIds = new long[this.mSecondaryIndexes.length];
        for (int i = 0; i < secondaryIndexIds.length; ++i) {
            secondaryIndexIds[i] = this.mSecondaryIndexes[i].id();
        }
        WeakReference[] backfillRefs = null;
        if (hasBackfills) {
            backfillRefs = new WeakReference[this.mBackfills.length];
            for (int i = 0; i < this.mBackfills.length; ++i) {
                IndexBackfill<R> backfill = this.mBackfills[i];
                if (backfill == null) continue;
                backfillRefs[i] = new WeakReference<IndexBackfill<R>>(backfill);
            }
        }
        Bootstrap indy = mm.var(IndexTriggerMaker.class).indy("indyDelete", new Object[]{rs.ref(), this.mRowType, primaryIndexId, this.mSecondaryDescriptors, secondaryIndexIds, backfillRefs});
        if (hasRow) {
            indy.invoke(null, "delete", null, new Object[]{schemaVersion, txnVar, rowVar, keyVar, oldValueVar});
        } else {
            indy.invoke(null, "delete", null, new Object[]{schemaVersion, txnVar, keyVar, oldValueVar});
        }
    }

    public static SwitchCallSite indyDelete(MethodHandles.Lookup lookup, String name, MethodType mt, WeakReference<RowStore> storeRef, Class<?> rowType, long indexId, byte[][] secondaryDescs, long[] secondaryIndexIds, WeakReference<IndexBackfill>[] backfillRefs) {
        TypeDescriptor.OfField rowClass = mt.parameterCount() == 5 ? mt.parameterType(2) : null;
        return new SwitchCallSite(lookup, mt, arg_0 -> IndexTriggerMaker.lambda$indyDelete$4(mt, storeRef, lookup, rowType, indexId, secondaryIndexIds, secondaryDescs, backfillRefs, (Class)rowClass, arg_0));
    }

    private static MethodHandle makeDeleteMethod(MethodType mt, int schemaVersion, Class<?> rowType, Class rowClass, RowInfo primaryInfo, RowInfo[] secondaryInfos, Index[] secondaryIndexes, IndexBackfill[] backfills) {
        HashMap<String, TransformMaker.Availability> available;
        Variable oldValueVar;
        Variable keyVar;
        Variable rowVar;
        ClassMaker cm = primaryInfo.rowGen().beginClassMaker(IndexTriggerMaker.class, rowType, "trigger-delete").final_();
        MethodType ctorMethodType = backfills == null ? MethodType.methodType(Void.TYPE, Index[].class) : MethodType.methodType(Void.TYPE, Index[].class, IndexBackfill.class);
        MethodMaker ctorMaker = cm.addConstructor(ctorMethodType);
        ctorMaker.invokeSuperConstructor(new Object[0]);
        MethodMaker mm = cm.addMethod("delete", mt);
        Variable txnVar = mm.param(0);
        if (rowClass != null) {
            rowVar = mm.param(1);
            keyVar = mm.param(2);
            oldValueVar = mm.param(3);
            available = new HashMap<String, TransformMaker.Availability>();
            for (String colName : primaryInfo.keyColumns.keySet()) {
                available.put(colName, TransformMaker.Availability.ALWAYS);
            }
        } else {
            rowVar = null;
            keyVar = mm.param(1);
            oldValueVar = mm.param(2);
            available = null;
        }
        TransformMaker tm = new TransformMaker(rowType, primaryInfo, available);
        for (int i = 0; i < secondaryInfos.length; ++i) {
            if (secondaryIndexes[i] == null) continue;
            tm.addKeyTarget(secondaryInfos[i], 0, true);
        }
        int valueOffset = schemaVersion == 0 ? 0 : (schemaVersion < 128 ? 1 : 4);
        tm.begin(mm, rowVar, keyVar, oldValueVar, valueOffset);
        for (int i = 0; i < secondaryInfos.length; ++i) {
            if (secondaryIndexes[i] == null) continue;
            Variable secondaryKeyVar = tm.encode(i);
            String ixFieldName = "ix" + i;
            cm.addField(Index.class, ixFieldName).private_().final_();
            ctorMaker.field(ixFieldName).set((Object)ctorMaker.param(0).aget((Object)i));
            String backfillFieldName = null;
            if (backfills != null && backfills[i] != null) {
                backfillFieldName = "backfill" + i;
                cm.addField(IndexBackfill.class, backfillFieldName).private_().final_();
                ctorMaker.field(backfillFieldName).set((Object)ctorMaker.param(1).aget((Object)i));
            }
            Label opStart = mm.label().here();
            Field ixField = mm.field(ixFieldName);
            if (rowVar != null) {
                ixField.invoke("store", new Object[]{txnVar, secondaryKeyVar, null});
            } else {
                Variable attachment = txnVar.invoke("attachment", new Object[0]);
                Label noAttachment = mm.label();
                attachment.instanceOf(TriggerIndexAccessor.class).ifFalse(noAttachment);
                Label cont = mm.label();
                attachment.cast(TriggerIndexAccessor.class).invoke("delete", new Object[]{ixField, secondaryKeyVar}).ifTrue(cont);
                noAttachment.here();
                ixField.invoke("store", new Object[]{txnVar, secondaryKeyVar, null});
                cont.here();
            }
            if (backfillFieldName != null) {
                mm.field(backfillFieldName).invoke("deleted", new Object[]{txnVar, secondaryKeyVar});
            }
            mm.catch_(opStart, DeletedIndexException.class, exVar -> {});
        }
        MethodHandles.Lookup lookup = cm.finishHidden();
        Class<?> clazz = lookup.lookupClass();
        try {
            MethodHandle ctor = lookup.findConstructor(clazz, ctorMethodType);
            Object deleter = backfills == null ? ctor.invoke(secondaryIndexes) : ctor.invoke(secondaryIndexes, backfills);
            return lookup.findVirtual(clazz, "delete", mt).bindTo(deleter);
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
    }

    private boolean addStoreMethod(String variant, boolean define, BaseTable<R> table) {
        MethodMaker mm = this.mClassMaker.addMethod(null, variant, new Object[]{Transaction.class, Object.class, byte[].class, byte[].class, byte[].class}).public_();
        boolean isPartial = variant == "storeP";
        Variable txnVar = mm.param(0);
        Variable rowVar = mm.param(1);
        Variable keyVar = mm.param(2);
        Variable oldValueVar = mm.param(3);
        Variable newValueVar = mm.param(4);
        if (isPartial && !define) {
            mm.invoke("store", new Object[]{txnVar, rowVar, keyVar, oldValueVar, newValueVar});
            return false;
        }
        HashMap<String, TransformMaker.Availability> available = new HashMap<String, TransformMaker.Availability>();
        TransformMaker.Availability avail = isPartial ? TransformMaker.Availability.CONDITIONAL : TransformMaker.Availability.ALWAYS;
        for (String colName : this.mPrimaryGen.info.allColumns.keySet()) {
            available.put(colName, avail);
        }
        TransformMaker<R> tm = new TransformMaker<R>(this.mRowType, this.mPrimaryGen.info, available);
        for (int i = 0; i < this.mSecondaryInfos.length; ++i) {
            RowInfo secondaryInfo = this.mSecondaryInfos[i];
            tm.addKeyTarget(secondaryInfo, 0, false);
            tm.addValueTarget(secondaryInfo, 0, false);
        }
        if (tm.onlyNeedsKeys()) {
            mm.return_();
            return false;
        }
        rowVar = rowVar.cast(this.mRowClass);
        Variable newVersion = mm.var(RowUtils.class).invoke("decodeSchemaVersion", new Object[]{newValueVar});
        Variable tableVar = mm.var(table.getClass());
        TableMaker.convertValueIfNecessary(tableVar, rowVar, newVersion, oldValueVar);
        TransformMaker<R> otm = tm.beginValueDiff(mm, rowVar, keyVar, newValueVar, -1, oldValueVar);
        for (int i = 0; i < this.mSecondaryInfos.length; ++i) {
            Label modified = mm.label();
            Label cont = mm.label();
            if (!otm.diffValueCheck(cont, i << 1, (i << 1) + 1)) continue;
            Variable secondaryKeyVar = tm.encode(i << 1);
            Variable secondaryValueVar = tm.encode((i << 1) + 1);
            Variable closerVar = this.acquirePredicateLock(mm, i, isPartial, txnVar, rowVar, secondaryKeyVar, secondaryValueVar);
            Label opStart = mm.label().here();
            Field ixField = mm.field("ix" + i);
            RowInfo secondaryInfo = this.mSecondaryInfos[i];
            RowGen secondaryGen = secondaryInfo.rowGen();
            if (!secondaryInfo.isAltKey()) {
                ixField.invoke("store", new Object[]{txnVar, secondaryKeyVar, secondaryValueVar});
                if (closerVar != null) {
                    mm.finally_(opStart, () -> closerVar.invoke("close", new Object[0]));
                }
            } else {
                Variable result = ixField.invoke("insert", new Object[]{txnVar, secondaryKeyVar, secondaryValueVar});
                if (closerVar != null) {
                    mm.finally_(opStart, () -> closerVar.invoke("close", new Object[0]));
                }
                Label pass = mm.label();
                result.ifTrue(pass);
                mm.new_(UniqueConstraintException.class, new Object[]{"Alternate key"}).throw_();
                pass.here();
            }
            if (isPartial) {
                Variable attachment = txnVar.invoke("attachment", new Object[0]);
                Label noAttachment = mm.label();
                attachment.instanceOf(TriggerIndexAccessor.class).ifFalse(noAttachment);
                attachment.cast(TriggerIndexAccessor.class).invoke("stored", new Object[]{ixField, secondaryKeyVar, secondaryValueVar});
                noAttachment.here();
            }
            if (this.mBackfills[i] != null) {
                mm.field("backfill" + i).invoke("inserted", new Object[]{txnVar, secondaryKeyVar, secondaryValueVar});
            }
            Variable deleteKeyVar = otm.encode(i << 1);
            if (!secondaryInfo.isAltKey() && !secondaryInfo.valueColumns.isEmpty()) {
                mm.var(Arrays.class).invoke("equals", new Object[]{secondaryKeyVar, deleteKeyVar}).ifTrue(cont);
            }
            ixField.invoke("store", new Object[]{txnVar, deleteKeyVar, null});
            if (this.mBackfills[i] != null) {
                mm.field("backfill" + i).invoke("deleted", new Object[]{txnVar, deleteKeyVar});
            }
            mm.catch_(opStart, DeletedIndexException.class, exVar -> {});
            cont.here();
        }
        return tm.requiresRow();
    }

    private Variable acquirePredicateLock(MethodMaker mm, int i, boolean isPartial, Variable txnVar, Variable rowVar, Variable secondaryKeyVar, Variable secondaryValueVar) {
        if (this.mSecondaryLocks[i] == null) {
            return null;
        }
        Field lockVar = mm.field("lock" + i);
        if (!isPartial) {
            return lockVar.invoke("openAcquire", new Object[]{txnVar, rowVar});
        }
        return lockVar.invoke("openAcquireP", new Object[]{txnVar, rowVar, secondaryKeyVar, secondaryValueVar});
    }

    private static /* synthetic */ Object lambda$indyDelete$4(MethodType mt, WeakReference storeRef, MethodHandles.Lookup lookup, Class rowType, long indexId, long[] secondaryIndexIds, byte[][] secondaryDescs, WeakReference[] backfillRefs, Class rowClass, int schemaVersion) {
        Index[] secondaryIndexes;
        RowInfo primaryInfo;
        MethodType mtx = mt.dropParameterTypes(0, 1);
        RowStore store = (RowStore)storeRef.get();
        if (store == null) {
            MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)"delete", (MethodType)mtx);
            mm.new_(DatabaseException.class, new Object[]{"Closed"}).throw_();
            return mm.finish();
        }
        try {
            primaryInfo = store.rowInfo(rowType, indexId, schemaVersion);
            secondaryIndexes = new Index[secondaryIndexIds.length];
            RowPredicateLock[] secondaryLocks = new RowPredicateLock[secondaryIndexes.length];
            for (int i = 0; i < secondaryIndexIds.length; ++i) {
                secondaryIndexes[i] = store.mDatabase.indexById(secondaryIndexIds[i]);
                secondaryLocks[i] = store.indexLock(secondaryIndexes[i]);
            }
        }
        catch (Exception e) {
            MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)"delete", (MethodType)mtx);
            return new ExceptionCallSite.Failed(mtx, mm, e);
        }
        RowInfo[] secondaryInfos = RowStore.secondaryRowInfos(primaryInfo, secondaryDescs);
        IndexBackfill[] backfills = null;
        if (backfillRefs != null) {
            backfills = new IndexBackfill[backfillRefs.length];
            for (int i = 0; i < backfills.length; ++i) {
                WeakReference backfillRef = backfillRefs[i];
                if (backfillRef == null) continue;
                backfills[i] = (IndexBackfill)backfillRef.get();
            }
        }
        return IndexTriggerMaker.makeDeleteMethod(mtx, schemaVersion, rowType, rowClass, primaryInfo, secondaryInfos, secondaryIndexes, backfills);
    }
}

