/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.rows.SingleScanController;

public abstract class JoinedScanController<R>
extends SingleScanController<R> {
    protected final Index mPrimaryIndex;

    protected JoinedScanController(byte[] lowBound, boolean lowInclusive, byte[] highBound, boolean highInclusive, boolean reverse, Index primaryIndex) {
        super(lowBound, lowInclusive, highBound, highInclusive, reverse);
        this.mPrimaryIndex = primaryIndex;
    }

    protected JoinedScanController(JoinedScanController from) {
        super(from);
        this.mPrimaryIndex = from.mPrimaryIndex;
    }

    @Override
    public final long evolvableTableId() {
        return 0L;
    }

    @Override
    public boolean isJoined() {
        return true;
    }

    protected byte[] join(Cursor secondaryCursor, LockResult result, byte[] primaryKey) throws IOException {
        Transaction txn = secondaryCursor.link();
        byte[] primaryValue = this.mPrimaryIndex.load(txn, primaryKey);
        if (result == LockResult.ACQUIRED && txn.lastLockedKey() == primaryKey && txn.lastLockedIndex() == this.mPrimaryIndex.id()) {
            txn.unlockCombine();
        }
        return JoinedScanController.validate(secondaryCursor, txn, primaryValue);
    }

    protected final byte[] join(Cursor secondaryCursor, LockResult secondaryResult, byte[] primaryKey, Cursor primaryCursor) throws IOException {
        LockResult primaryResult = primaryCursor.find(primaryKey);
        Transaction txn = primaryCursor.link();
        if (primaryResult == LockResult.ACQUIRED && secondaryResult == LockResult.ACQUIRED) {
            txn.unlockCombine();
        }
        return JoinedScanController.validate(secondaryCursor, txn, primaryCursor.value());
    }

    private static byte[] validate(Cursor secondaryCursor, Transaction txn, byte[] primaryValue) throws IOException {
        if (primaryValue != null && txn.lockMode() == LockMode.READ_COMMITTED && !secondaryCursor.exists()) {
            primaryValue = null;
        }
        return primaryValue;
    }
}

