/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import org.cojen.maker.Bootstrap;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Table;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Updater;
import org.cojen.tupl.core.RowPredicateLock;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.CodeUtils;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.CompareUtils;
import org.cojen.tupl.rows.JoinedScanController;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.RowWriter;
import org.cojen.tupl.rows.ScanController;
import org.cojen.tupl.rows.SecondaryInfo;
import org.cojen.tupl.rows.SingleScanController;
import org.cojen.tupl.rows.TableMaker;
import org.cojen.tupl.rows.TransformMaker;

public class JoinedTableMaker
extends TableMaker {
    final Class<?> mPrimaryTableClass;
    final Class<?> mUnjoinedClass;

    JoinedTableMaker(Class<?> type, RowGen rowGen, RowGen codecGen, byte[] secondaryDesc, Class<?> primaryTableClass, Class<?> unjoinedClass) {
        super(type, rowGen, codecGen, secondaryDesc);
        this.mPrimaryTableClass = primaryTableClass;
        this.mUnjoinedClass = unjoinedClass;
    }

    MethodHandle finish() {
        int mode;
        Objects.requireNonNull(this.mPrimaryTableClass);
        this.mClassMaker = this.mCodecGen.beginClassMaker(this.getClass(), this.mRowType, "joined").public_().final_().extend(this.mUnjoinedClass);
        MethodType mt = MethodType.methodType(Void.TYPE, Index.class, RowPredicateLock.class, this.mPrimaryTableClass, this.mUnjoinedClass);
        MethodMaker ctor = this.mClassMaker.addConstructor(mt);
        Variable indexVar = ctor.param(0);
        Variable lockVar = ctor.param(1);
        Variable primaryVar = ctor.param(2);
        Variable unjoinedVar = ctor.param(3);
        Variable managerVar = primaryVar.invoke("tableManager", new Object[0]);
        ctor.invokeSuperConstructor(new Object[]{managerVar, indexVar, lockVar});
        this.mClassMaker.addField(this.mPrimaryTableClass, "primaryTable").private_().final_();
        ctor.field("primaryTable").set((Object)primaryVar);
        this.mClassMaker.addField(Index.class, "primaryIndex").private_().final_();
        ctor.field("primaryIndex").set((Object)managerVar.invoke("primaryIndex", new Object[0]));
        this.mClassMaker.addField(this.mUnjoinedClass, "unjoined").private_().final_();
        ctor.field("unjoined").set((Object)unjoinedVar);
        MethodMaker mm = this.mClassMaker.addMethod(BaseTable.class, "joinedPrimaryTable", new Object[0]).protected_();
        mm.return_((Object)mm.field("primaryTable"));
        mm = this.mClassMaker.addMethod(Class.class, "joinedPrimaryTableClass", new Object[0]).protected_();
        mm.return_(this.mPrimaryTableClass);
        mm = this.mClassMaker.addMethod(Table.class, "viewUnjoined", new Object[0]).protected_();
        mm.return_((Object)mm.field("unjoined"));
        int n = mode = this.mCodecGen.info.isAltKey() ? 3 : 2;
        while (mode <= 7) {
            this.addToPrimaryKeyMethod(mode);
            mode += 2;
        }
        this.addJoinedLoadMethod();
        this.addJoinedUnfilteredMethods();
        this.addPlanMethod(2);
        this.addPlanMethod(3);
        mm = this.mClassMaker.addMethod(Updater.class, "newUpdater", new Object[]{Transaction.class, Object.class, ScanController.class});
        mm.protected_();
        mm.return_((Object)mm.invoke("newJoinedUpdater", new Object[]{mm.param(0), mm.param(1), mm.param(2), mm.field("primaryTable")}));
        return this.doFinish(mt);
    }

    private void addToPrimaryKeyMethod(int options) {
        ArrayList<Class<byte[]>> paramList = new ArrayList<Class<byte[]>>(3);
        if ((options & 4) != 0) {
            paramList.add(this.mRowClass);
        }
        if ((options & 2) != 0) {
            paramList.add(byte[].class);
        }
        if ((options & 1) != 0) {
            paramList.add(byte[].class);
        }
        Object[] params = paramList.toArray();
        MethodMaker mm = this.mClassMaker.addMethod(byte[].class, "toPrimaryKey", params).static_();
        Object[] paramVars = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramVars[i] = mm.param(i);
        }
        Bootstrap indy = mm.var(JoinedTableMaker.class).indy("toPrimaryKey", new Object[]{this.mRowType, this.mSecondaryDescriptor, options});
        mm.return_((Object)indy.invoke(byte[].class, "toPrimaryKey", null, paramVars));
    }

    public static CallSite toPrimaryKey(MethodHandles.Lookup lookup, String name, MethodType mt, Class<?> rowType, byte[] secondaryDesc, int options) {
        RowInfo primaryInfo = RowInfo.find(rowType);
        SecondaryInfo secondaryInfo = RowStore.secondaryRowInfo(primaryInfo, secondaryDesc);
        MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)name, (MethodType)mt);
        Variable rowVar = null;
        Variable keyVar = null;
        Variable valueVar = null;
        int offset = 0;
        if ((options & 4) != 0) {
            rowVar = mm.param(offset++);
        }
        if ((options & 2) != 0) {
            keyVar = mm.param(offset++);
        }
        if ((options & 1) != 0) {
            valueVar = mm.param(offset++);
        }
        HashMap<String, TransformMaker.Availability> available = null;
        if (rowVar != null) {
            available = new HashMap<String, TransformMaker.Availability>();
            for (String colName : secondaryInfo.keyColumns.keySet()) {
                available.put(colName, TransformMaker.Availability.ALWAYS);
            }
        }
        TransformMaker tm = new TransformMaker(rowType, secondaryInfo, available);
        tm.addKeyTarget(primaryInfo, 0, true);
        tm.begin(mm, rowVar, keyVar, valueVar, 0);
        mm.return_((Object)tm.encode(0));
        return new ConstantCallSite(mm.finish());
    }

    private void addJoinedLoadMethod() {
        Variable joinedPkVar;
        MethodMaker mm = this.mClassMaker.addMethod(Boolean.TYPE, "load", new Object[]{Transaction.class, Object.class}).public_();
        Variable txnVar = mm.param(0);
        Variable rowVar = mm.param(1).cast((Object)this.mRowClass);
        Label ready = mm.label();
        mm.invoke("checkPrimaryKeySet", new Object[]{rowVar}).ifTrue(ready);
        mm.new_(IllegalStateException.class, new Object[]{"Primary key isn't fully specified"}).throw_();
        ready.here();
        Variable valueVar = null;
        Variable repeatableVar = null;
        Label notFound = mm.label();
        if (this.mCodecGen.info.isAltKey()) {
            Variable keyVar = mm.invoke("encodePrimaryKey", new Object[]{rowVar});
            valueVar = mm.field("mSource").invoke("load", new Object[]{txnVar, keyVar});
            valueVar.ifEq(null, notFound);
            joinedPkVar = mm.invoke("toPrimaryKey", new Object[]{rowVar, keyVar, valueVar});
        } else {
            joinedPkVar = mm.var(byte[].class);
            Label cont = mm.label();
            Label repeatable = mm.label();
            mm.var(RowUtils.class).invoke("isRepeatable", new Object[]{txnVar}).ifTrue(repeatable);
            joinedPkVar.set((Object)mm.invoke("toPrimaryKey", new Object[]{rowVar}));
            mm.goto_(cont);
            repeatable.here();
            Variable keyVar = mm.invoke("encodePrimaryKey", new Object[]{rowVar});
            mm.field("mSource").invoke("exists", new Object[]{txnVar, keyVar}).ifFalse(notFound);
            joinedPkVar.set((Object)mm.invoke("toPrimaryKey", new Object[]{rowVar, keyVar}));
            cont.here();
        }
        Variable joinedValueVar = mm.field("primaryIndex").invoke("load", new Object[]{txnVar, joinedPkVar});
        Label notNull = mm.label();
        joinedValueVar.ifNe(null, notNull);
        notFound.here();
        this.markValuesUnset(rowVar);
        mm.return_((Object)false);
        notNull.here();
        if (repeatableVar == null) {
            repeatableVar = mm.var(RowUtils.class).invoke("isRepeatable", new Object[]{txnVar});
        }
        Label checked = mm.label();
        repeatableVar.ifFalse(checked);
        if (valueVar != null) {
            mm.invoke("decodeValue", new Object[]{rowVar, valueVar});
        }
        mm.var(this.mPrimaryTableClass).invoke("decodeValue", new Object[]{rowVar, joinedValueVar});
        Label success = mm.label().here();
        JoinedTableMaker.markAllClean(rowVar, this.mRowGen, this.mRowGen);
        mm.return_((Object)true);
        checked.here();
        NavigableMap copiedColumns = valueVar != null ? this.mRowInfo.allColumns : this.mRowInfo.valueColumns;
        LinkedHashMap<String, Variable> copiedVars = new LinkedHashMap<String, Variable>(copiedColumns.size());
        for (String name : copiedColumns.keySet()) {
            copiedVars.put(name, rowVar.field(name).get());
        }
        if (valueVar != null) {
            mm.invoke("decodeValue", new Object[]{rowVar, valueVar});
        }
        mm.var(this.mPrimaryTableClass).invoke("decodeValue", new Object[]{rowVar, joinedValueVar});
        Label fail = mm.label();
        Map pkColumns = this.mRowInfo.keyColumns;
        for (ColumnInfo columnInfo : this.mCodecGen.info.allColumns.values()) {
            String name = columnInfo.name;
            if (pkColumns.containsKey(name)) continue;
            Label pass = mm.label();
            CompareUtils.compare(mm, columnInfo, (Variable)rowVar.field(name), (ColumnInfo)copiedColumns.get(name), (Variable)copiedVars.get(name), 0, pass, fail);
            pass.here();
        }
        mm.goto_(success);
        fail.here();
        for (Map.Entry entry : copiedVars.entrySet()) {
            rowVar.field((String)entry.getKey()).set(entry.getValue());
        }
        mm.goto_(notFound);
    }

    private void addJoinedUnfilteredMethods() {
        MethodMaker mm = this.mClassMaker.addMethod(SingleScanController.class, "unfiltered", new Object[0]).protected_();
        Bootstrap condyClass = mm.var(JoinedTableMaker.class).condy("condyDefineJoinedUnfiltered", new Object[]{this.mRowType, this.mRowClass, this.mSecondaryDescriptor, mm.class_(), this.mPrimaryTableClass});
        Variable scanControllerCtor = condyClass.invoke(MethodHandle.class, "unfiltered");
        Object[] paramTypes = new Class[]{byte[].class, Boolean.TYPE, byte[].class, Boolean.TYPE, Boolean.TYPE, Index.class};
        mm.return_((Object)scanControllerCtor.invoke(JoinedScanController.class, "invokeExact", paramTypes, new Object[]{null, false, null, false, false, mm.field("primaryIndex")}));
        mm = this.mClassMaker.addMethod(SingleScanController.class, "unfilteredReverse", new Object[0]).protected_();
        scanControllerCtor = mm.var(MethodHandle.class).set((Object)scanControllerCtor);
        mm.return_((Object)scanControllerCtor.invoke(JoinedScanController.class, "invokeExact", paramTypes, new Object[]{null, false, null, false, true, mm.field("primaryIndex")}));
    }

    public static MethodHandle condyDefineJoinedUnfiltered(MethodHandles.Lookup lookup, String name, Class type, Class rowType, Class rowClass, byte[] secondaryDesc, Class<?> tableClass, Class<?> primaryTableClass) throws Throwable {
        RowInfo rowInfo = RowInfo.find(rowType);
        RowGen rowGen = rowInfo.rowGen();
        RowGen codecGen = RowStore.secondaryRowInfo(rowInfo, secondaryDesc).rowGen();
        ClassMaker cm = RowGen.beginClassMaker(JoinedTableMaker.class, rowType, rowInfo, null, name).extend(JoinedScanController.class).public_();
        MethodType ctorType = MethodType.methodType(Void.TYPE, byte[].class, Boolean.TYPE, byte[].class, Boolean.TYPE, Boolean.TYPE, Index.class);
        MethodMaker mm = cm.addConstructor(ctorType).protected_();
        mm.invokeSuperConstructor(new Object[]{mm.param(0), mm.param(1), mm.param(2), mm.param(3), mm.param(4), mm.param(5)});
        mm = cm.addConstructor(new Object[]{JoinedScanController.class}).protected_();
        mm.invokeSuperConstructor(new Object[]{mm.param(0)});
        if (codecGen.info.isAltKey()) {
            mm = cm.addMethod(byte[].class, "toPrimaryKey", new Object[]{byte[].class, byte[].class});
            mm.static_().protected_();
            mm.return_((Object)mm.var(tableClass).invoke("toPrimaryKey", new Object[]{mm.param(0), mm.param(1)}));
        } else {
            mm = cm.addMethod(byte[].class, "toPrimaryKey", new Object[]{byte[].class});
            mm.static_().protected_();
            mm.return_((Object)mm.var(tableClass).invoke("toPrimaryKey", new Object[]{mm.param(0)}));
        }
        JoinedTableMaker.addJoinedDecodeRow(cm, codecGen, rowClass, tableClass, primaryTableClass, false);
        JoinedTableMaker.addJoinedDecodeRow(cm, codecGen, rowClass, tableClass, primaryTableClass, true);
        mm = cm.addMethod(Object.class, "decodeRow", new Object[]{Object.class, byte[].class, byte[].class}).public_();
        Variable rowVar = CodeUtils.castOrNew(mm.param(0), rowClass);
        Variable tableVar = mm.var(primaryTableClass);
        tableVar.invoke("decodePrimaryKey", new Object[]{rowVar, mm.param(1)});
        tableVar.invoke("decodeValue", new Object[]{rowVar, mm.param(2)});
        tableVar.invoke("markAllClean", new Object[]{rowVar});
        mm.return_((Object)rowVar);
        mm = cm.addMethod(null, "writeRow", new Object[]{RowWriter.class, byte[].class, byte[].class}).public_();
        mm.var(primaryTableClass).invoke("writeRow", new Object[]{mm.param(0), mm.param(1), mm.param(2)});
        mm = cm.addMethod(byte[].class, "updateKey", new Object[]{Object.class, byte[].class}).public_();
        rowVar = mm.param(0).cast((Object)rowClass);
        tableVar = mm.var(primaryTableClass);
        mm.return_((Object)tableVar.invoke("updatePrimaryKey", new Object[]{rowVar, mm.param(1)}));
        mm = cm.addMethod(byte[].class, "updateValue", new Object[]{Object.class, byte[].class}).public_();
        rowVar = mm.param(0).cast((Object)rowClass);
        tableVar = mm.var(primaryTableClass);
        mm.return_((Object)tableVar.invoke("updateValue", new Object[]{rowVar, mm.param(1)}));
        mm = cm.addMethod(MethodHandle.class, "decodeValueHandle", new Object[]{Integer.TYPE}).protected_().static_();
        Variable tableVar2 = mm.var(primaryTableClass);
        mm.return_((Object)tableVar2.invoke("decodeValueHandle", new Object[]{mm.param(0)}));
        lookup = cm.finishLookup();
        MethodHandle mh = lookup.findConstructor(lookup.lookupClass(), ctorType);
        return mh.asType(mh.type().changeReturnType(JoinedScanController.class));
    }

    private static void addJoinedDecodeRow(ClassMaker cm, RowGen codecGen, Class rowClass, Class<?> tableClass, Class<?> primaryTableClass, boolean withPrimaryCursor) {
        Variable primaryKeyVar;
        Object[] params = !withPrimaryCursor ? new Object[]{Cursor.class, LockResult.class, Object.class} : new Object[]{Cursor.class, LockResult.class, Object.class, Cursor.class};
        MethodMaker mm = cm.addMethod(Object.class, "evalRow", params).public_();
        Variable cursorVar = mm.param(0);
        Variable resultVar = mm.param(1);
        Variable rowVar = mm.param(2);
        Variable keyVar = cursorVar.invoke("key", new Object[0]);
        Variable tableVar = mm.var(tableClass);
        if (codecGen.info.isAltKey()) {
            Variable valueVar = cursorVar.invoke("value", new Object[0]);
            primaryKeyVar = tableVar.invoke("toPrimaryKey", new Object[]{keyVar, valueVar});
        } else {
            primaryKeyVar = tableVar.invoke("toPrimaryKey", new Object[]{keyVar});
        }
        params = !withPrimaryCursor ? new Object[]{cursorVar, resultVar, primaryKeyVar} : new Object[]{cursorVar, resultVar, primaryKeyVar, mm.param(3)};
        Variable primaryValueVar = mm.invoke("join", params);
        Label hasValue = mm.label();
        primaryValueVar.ifNe(null, hasValue);
        mm.return_(null);
        hasValue.here();
        Label notRow = mm.label();
        Variable typedRowVar = CodeUtils.castOrNew(rowVar, rowClass, notRow);
        Variable tableVar2 = mm.var(primaryTableClass);
        tableVar2.invoke("decodePrimaryKey", new Object[]{typedRowVar, primaryKeyVar});
        tableVar2.invoke("decodeValue", new Object[]{typedRowVar, primaryValueVar});
        tableVar2.invoke("markAllClean", new Object[]{typedRowVar});
        mm.return_((Object)typedRowVar);
        notRow.here();
        CodeUtils.acceptAsRowConsumerAndReturn(rowVar, rowClass, primaryKeyVar, primaryValueVar);
    }
}

