/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Updater;
import org.cojen.tupl.rows.BaseTableIndex;
import org.cojen.tupl.rows.BasicScanner;
import org.cojen.tupl.rows.BasicUpdater;
import org.cojen.tupl.rows.RowEvaluator;
import org.cojen.tupl.rows.ScanController;
import org.cojen.tupl.rows.TriggerIndexAccessor;

final class JoinedUpdater<R>
extends BasicScanner<R>
implements Updater<R> {
    private final BasicUpdater<R> mPrimaryUpdater;
    private final TriggerIndexAccessor mAccessor;
    private Cursor mPrimaryCursor;

    JoinedUpdater(BaseTableIndex<R> table, ScanController<R> controller, BasicUpdater<R> primaryUpdater) {
        super(table, controller);
        this.mPrimaryUpdater = primaryUpdater;
        this.mAccessor = new TriggerIndexAccessor(){

            @Override
            public void stored(Index ix, byte[] key, byte[] value) throws IOException {
                JoinedUpdater.this.triggerStored(ix, key, value);
            }

            @Override
            public boolean delete(Index ix, byte[] key) throws IOException {
                return JoinedUpdater.this.triggerDelete(ix, key);
            }
        };
    }

    @Override
    void init(Transaction txn, R row) throws IOException {
        this.mPrimaryUpdater.mCursor = this.mPrimaryCursor = this.mPrimaryUpdater.mTable.mSource.newCursor(txn);
        super.init(txn, row);
    }

    @Override
    protected void beginBatch(R row, RowEvaluator<R> evaluator) throws IOException {
        super.beginBatch(row, evaluator);
        this.mPrimaryUpdater.mEvaluator = evaluator;
    }

    @Override
    protected R evalRow(Cursor c, LockResult result, R row) throws IOException {
        if (this.mPrimaryUpdater.mKeysToSkip != null && this.mPrimaryUpdater.mKeysToSkip.remove(c.key())) {
            return null;
        }
        return this.mEvaluator.evalRow(c, result, row, this.mPrimaryCursor);
    }

    @Override
    protected LockResult toFirst(Cursor c) throws IOException {
        return this.mPrimaryUpdater.toFirst(c);
    }

    @Override
    protected LockResult toNext(Cursor c) throws IOException {
        return this.mPrimaryUpdater.toNext(c);
    }

    @Override
    protected void unlocked() {
        this.mPrimaryUpdater.unlocked();
    }

    @Override
    protected void finished() throws IOException {
        super.finished();
        this.mPrimaryUpdater.close();
    }

    @Override
    public final R update() throws IOException {
        this.updateCurrent();
        return this.doStep(null);
    }

    @Override
    public final R update(R row) throws IOException {
        Objects.requireNonNull(row);
        this.updateCurrent();
        return this.doStep(row);
    }

    private void updateCurrent() throws IOException {
        Transaction txn = this.txn();
        Object old = this.attachAccessor(txn);
        try {
            this.mPrimaryUpdater.mRow = this.mRow;
            this.mPrimaryUpdater.joinedUpdateCurrent();
        }
        finally {
            txn.attach(old);
        }
    }

    @Override
    public final R delete() throws IOException {
        this.deleteCurrent();
        return this.doStep(null);
    }

    @Override
    public final R delete(R row) throws IOException {
        Objects.requireNonNull(row);
        this.deleteCurrent();
        return this.doStep(row);
    }

    private void deleteCurrent() throws IOException {
        Transaction txn = this.txn();
        Object old = this.attachAccessor(txn);
        try {
            this.mPrimaryUpdater.mRow = this.mRow;
            this.mPrimaryUpdater.deleteCurrent();
        }
        finally {
            txn.attach(old);
        }
    }

    private Transaction txn() {
        return this.mCursor.link();
    }

    private Object attachAccessor(Transaction txn) {
        Object old = txn.attachment();
        txn.attach(this.mAccessor);
        return old;
    }

    private void triggerStored(Index ix, byte[] key, byte[] value) throws IOException {
        if (this.mTable.mSource == ix && this.mController.predicate().testP(this.mRow, key, value) && this.mCursor.compareKeyTo(key) < 0) {
            this.mPrimaryUpdater.addKeyToSkip(key);
        }
    }

    private boolean triggerDelete(Index ix, byte[] key) throws IOException {
        Cursor c;
        if (this.mTable.mSource == ix && Arrays.equals((c = this.mCursor).key(), key)) {
            c.delete();
            return true;
        }
        return false;
    }
}

