/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.math.BigDecimal;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.BigDecimalUtils;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;

final class LexBigDecimalColumnCodec
extends ColumnCodec {
    private Variable mBytesVar;

    LexBigDecimalColumnCodec(ColumnInfo info, MethodMaker mm) {
        super(info, mm);
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new LexBigDecimalColumnCodec(this.mInfo, mm);
    }

    @Override
    protected final boolean doEquals(Object obj) {
        return this.equalOrdering(obj);
    }

    @Override
    public final int doHashCode() {
        return 0;
    }

    @Override
    int codecFlags() {
        return 2;
    }

    @Override
    int minSize() {
        return 0;
    }

    @Override
    void encodePrepare() {
        this.mBytesVar = this.mMaker.var(byte[].class);
    }

    @Override
    void encodeSkip() {
        this.mBytesVar.set(null);
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        Object methodName = "encodeBigDecimalLex";
        if (this.mInfo.isDescending()) {
            methodName = (String)methodName + "Desc";
        }
        Variable utilsVar = this.mMaker.var(BigDecimalUtils.class);
        if (!this.mInfo.isNullable()) {
            this.mBytesVar.set((Object)utilsVar.invoke((String)methodName, new Object[]{srcVar}));
            return this.accum(totalVar, this.mBytesVar.alength());
        }
        boolean unset = false;
        if (totalVar == null) {
            unset = true;
            totalVar = this.mMaker.var(Integer.TYPE);
        }
        Label notNull = this.mMaker.label();
        srcVar.ifNe(null, notNull);
        this.mBytesVar.set((Object)this.mMaker.new_(byte[].class, new Object[]{1}));
        this.mBytesVar.aset((Object)0, (Object)this.nullByte());
        if (unset) {
            totalVar.set((Object)1);
        } else {
            totalVar.inc((Object)1);
        }
        Label end = this.mMaker.label().goto_();
        notNull.here();
        this.mBytesVar.set((Object)utilsVar.invoke((String)methodName, new Object[]{srcVar}));
        Variable lenVar = this.mBytesVar.alength();
        if (unset) {
            totalVar.set((Object)lenVar);
        } else {
            totalVar.inc((Object)lenVar);
        }
        end.here();
        return totalVar;
    }

    @Override
    void encode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        Variable lengthVar = this.mBytesVar.alength();
        this.mMaker.var(System.class).invoke("arraycopy", new Object[]{this.mBytesVar, 0, dstVar, offsetVar, lengthVar});
        offsetVar.inc((Object)lengthVar);
    }

    @Override
    void decode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable endVar) {
        Object methodName = "decodeBigDecimalLex";
        if (this.mInfo.isDescending()) {
            methodName = (String)methodName + "Desc";
        }
        Variable bdRefVar = dstVar == null ? null : this.mMaker.new_(BigDecimal[].class, new Object[]{1});
        Variable rowUtils = this.mMaker.var(BigDecimalUtils.class);
        offsetVar.set((Object)rowUtils.invoke((String)methodName, new Object[]{srcVar, offsetVar, bdRefVar}));
        if (dstVar != null) {
            dstVar.set((Object)bdRefVar.aget((Object)0));
        }
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        this.decode(null, srcVar, offsetVar, endVar);
    }
}

