/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.BigIntegerColumnCodec;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.RowUtils;

final class LexBigIntegerColumnCodec
extends BigIntegerColumnCodec {
    private Variable mBytesVar;

    LexBigIntegerColumnCodec(ColumnInfo info, MethodMaker mm) {
        super(info, mm);
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new LexBigIntegerColumnCodec(this.mInfo, mm);
    }

    @Override
    protected final boolean doEquals(Object obj) {
        return this.equalOrdering(obj);
    }

    @Override
    int codecFlags() {
        return 2;
    }

    @Override
    int minSize() {
        return 1;
    }

    @Override
    void encodePrepare() {
        this.mBytesVar = this.mMaker.var(byte[].class);
    }

    @Override
    void encodeSkip() {
        this.mBytesVar.set(null);
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        return this.encodeSize(srcVar, totalVar, this.mBytesVar);
    }

    private Variable encodeSize(Variable srcVar, Variable totalVar, Variable bytesVar) {
        if (totalVar == null) {
            totalVar = this.mMaker.var(Integer.TYPE).set((Object)0);
        }
        Label notNull = this.mMaker.label();
        srcVar.ifNe(null, notNull);
        bytesVar.set(null);
        Label cont = this.mMaker.label().goto_();
        notNull.here();
        bytesVar.set((Object)srcVar.invoke("toByteArray", new Object[0]));
        Variable lengthVar = bytesVar.alength();
        totalVar.inc((Object)lengthVar);
        lengthVar.ifLt((Object)127, cont);
        totalVar.inc((Object)4);
        cont.here();
        return totalVar;
    }

    @Override
    void encode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        this.doEncode(this.mBytesVar, dstVar, offsetVar);
    }

    private void doEncode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        Label end = null;
        if (this.mInfo.isNullable()) {
            end = this.mMaker.label();
            this.encodeNullHeaderIfNull(end, srcVar, dstVar, offsetVar);
        }
        Object methodName = "encodeBigIntegerLex";
        if (this.mInfo.isDescending()) {
            methodName = (String)methodName + "Desc";
        }
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        if (offsetVar == null) {
            rowUtils.invoke((String)methodName, new Object[]{dstVar, 0, srcVar});
        } else {
            offsetVar.set((Object)rowUtils.invoke((String)methodName, new Object[]{dstVar, offsetVar, srcVar}));
        }
        if (end != null) {
            end.here();
        }
    }

    @Override
    void decode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable endVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        Variable resultVar = rowUtils.invoke("decodeBigIntegerLexHeader", new Object[]{srcVar, offsetVar});
        offsetVar.set((Object)resultVar.cast(Integer.TYPE));
        Variable lengthVar = resultVar.shr((Object)32).cast(Integer.TYPE);
        if (dstVar == null) {
            offsetVar.inc((Object)lengthVar);
        } else {
            Label notNull = this.mMaker.label();
            lengthVar.ifNe((Object)0, notNull);
            dstVar.set(null);
            Label cont = this.mMaker.label().goto_();
            notNull.here();
            if (this.mInfo.isDescending()) {
                rowUtils.invoke("flip", new Object[]{srcVar, offsetVar, lengthVar});
                Label tryStart = this.mMaker.label().here();
                dstVar.set((Object)this.mMaker.new_((Object)dstVar, new Object[]{srcVar, offsetVar, lengthVar}));
                this.mMaker.finally_(tryStart, () -> rowUtils.invoke("flip", new Object[]{srcVar, offsetVar, lengthVar}));
            } else {
                dstVar.set((Object)this.mMaker.new_((Object)dstVar, new Object[]{srcVar, offsetVar, lengthVar}));
            }
            offsetVar.inc((Object)lengthVar);
            cont.here();
        }
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        this.decode(null, srcVar, offsetVar, endVar);
    }

    @Override
    protected Variable filterPrepareBytes(Variable argVar) {
        Variable bytesVar = this.mMaker.var(byte[].class);
        Variable lengthVar = this.encodeSize(argVar, this.mMaker.var(Integer.TYPE).set((Object)this.minSize()), bytesVar);
        Variable encodedBytesVar = this.mMaker.new_(byte[].class, new Object[]{lengthVar});
        this.doEncode(bytesVar, encodedBytesVar, null);
        return encodedBytesVar;
    }

    @Override
    protected boolean compareBytesUnsigned() {
        return true;
    }

    @Override
    boolean canFilterQuick(ColumnInfo dstInfo) {
        return dstInfo.typeCode == this.mInfo.typeCode;
    }

    @Override
    Object filterQuickDecode(ColumnInfo dstInfo, Variable srcVar, Variable offsetVar, Variable endVar) {
        this.decodeSkip(srcVar, offsetVar, endVar);
        return offsetVar.get();
    }

    @Override
    void filterQuickCompare(ColumnInfo dstInfo, Variable srcVar, Variable offsetVar, int op, Object decoded, Variable argObjVar, int argNum, Label pass, Label fail) {
        this.filterQuickCompareLex(dstInfo, srcVar, offsetVar, (Variable)decoded, op, argObjVar, argNum, pass, fail);
    }

    @Override
    protected void decodeHeader(Variable srcVar, Variable offsetVar, Variable endVar, Variable lengthVar, Variable isNullVar) {
        throw new UnsupportedOperationException();
    }
}

