/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.PrimitiveArrayColumnCodec;
import org.cojen.tupl.rows.PrimitiveArrayUtils;

final class LexPrimitiveArrayColumnCodec
extends PrimitiveArrayColumnCodec {
    LexPrimitiveArrayColumnCodec(ColumnInfo info, MethodMaker mm) {
        super(info, mm, 2);
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new LexPrimitiveArrayColumnCodec(this.mInfo, mm);
    }

    @Override
    void encodePrepare() {
    }

    @Override
    void encodeSkip() {
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        return this.accum(totalVar, this.calcLength(this.mMaker.var(PrimitiveArrayUtils.class), srcVar));
    }

    private Variable calcLength(Variable rowUtils, Variable srcVar) {
        Variable lengthVar = this.mMaker.var(Integer.TYPE);
        Label cont = null;
        if (this.mInfo.isNullable()) {
            Label notNull = this.mMaker.label();
            srcVar.ifNe(null, notNull);
            lengthVar.set((Object)1);
            cont = this.mMaker.label().goto_();
            notNull.here();
        }
        lengthVar.set((Object)rowUtils.invoke("lengthBytes32K", new Object[]{this.byteArrayLength(srcVar)}));
        if (cont != null) {
            cont.here();
        }
        return lengthVar;
    }

    @Override
    void encode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        this.doEncode(this.mMaker.var(PrimitiveArrayUtils.class), srcVar, dstVar, offsetVar);
    }

    private void doEncode(Variable rowUtils, Variable srcVar, Variable dstVar, Variable offsetVar) {
        if (this.mInfo.plainTypeCode() != 3) {
            srcVar = super.filterPrepareBytes(srcVar);
        }
        Label end = null;
        if (this.mInfo.isNullable()) {
            end = this.mMaker.label();
            this.encodeNullHeaderIfNull(end, srcVar, dstVar, offsetVar);
        }
        Object methodName = "encodeBytes32K";
        if (this.mInfo.isDescending()) {
            methodName = (String)methodName + "Desc";
        }
        if (offsetVar == null) {
            rowUtils.invoke((String)methodName, new Object[]{dstVar, 0, srcVar});
        } else {
            offsetVar.set((Object)rowUtils.invoke((String)methodName, new Object[]{dstVar, offsetVar, srcVar}));
        }
        if (end != null) {
            end.here();
        }
    }

    @Override
    void decode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable endVar) {
        Object methodName = "decodeBytes32K";
        if (this.mInfo.isDescending()) {
            methodName = (String)methodName + "Desc";
        }
        Variable rowUtils = this.mMaker.var(PrimitiveArrayUtils.class);
        Variable lengthVar = rowUtils.invoke("lengthBytes32K", new Object[]{srcVar, offsetVar});
        Variable arrayVar = rowUtils.invoke((String)methodName, new Object[]{srcVar, offsetVar, lengthVar});
        offsetVar.inc((Object)lengthVar);
        int plain = this.mInfo.plainTypeCode();
        if (plain == 11) {
            if (!this.mInfo.isNullable()) {
                rowUtils.invoke("signFlip", new Object[]{arrayVar, 0, arrayVar.alength()});
            } else {
                Label isNull = this.mMaker.label();
                arrayVar.ifEq(null, isNull);
                rowUtils.invoke("signFlip", new Object[]{arrayVar, 0, arrayVar.alength()});
                isNull.here();
            }
        } else if (plain != 3) {
            Variable newArrayVar = this.mMaker.var(this.mInfo.type);
            if (!this.mInfo.isNullable()) {
                this.decodeByteArray(newArrayVar, arrayVar, 0, arrayVar.alength());
            } else {
                Label notNull = this.mMaker.label();
                arrayVar.ifNe(null, notNull);
                Label cont = this.mMaker.label();
                newArrayVar.set(null);
                this.mMaker.goto_(cont);
                notNull.here();
                this.decodeByteArray(newArrayVar, arrayVar, 0, arrayVar.alength());
                cont.here();
            }
            arrayVar = newArrayVar;
        }
        dstVar.set((Object)arrayVar);
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        Variable utilsVar = this.mMaker.var(PrimitiveArrayUtils.class);
        offsetVar.inc((Object)utilsVar.invoke("lengthBytes32K", new Object[]{srcVar, offsetVar}));
    }

    @Override
    protected Variable filterPrepareBytes(Variable argVar) {
        Variable rowUtils = this.mMaker.var(PrimitiveArrayUtils.class);
        Variable bytesVar = this.mMaker.new_(byte[].class, new Object[]{this.calcLength(rowUtils, argVar)});
        this.doEncode(rowUtils, argVar, bytesVar, null);
        return bytesVar;
    }

    @Override
    protected boolean compareBytesUnsigned() {
        return true;
    }

    @Override
    boolean canFilterQuick(ColumnInfo dstInfo) {
        return dstInfo.typeCode == this.mInfo.typeCode;
    }

    @Override
    Object filterQuickDecode(ColumnInfo dstInfo, Variable srcVar, Variable offsetVar, Variable endVar) {
        this.decodeSkip(srcVar, offsetVar, endVar);
        return offsetVar.get();
    }

    @Override
    void filterQuickCompare(ColumnInfo dstInfo, Variable srcVar, Variable offsetVar, int op, Object decoded, Variable argObjVar, int argNum, Label pass, Label fail) {
        this.filterQuickCompareLex(dstInfo, srcVar, offsetVar, (Variable)decoded, op, argObjVar, argNum, pass, fail);
    }

    @Override
    protected void decodeHeader(Variable srcVar, Variable offsetVar, Variable endVar, Variable lengthVar, Variable isNullVar) {
        throw new UnsupportedOperationException();
    }
}

