/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.StringColumnCodec;

final class LexStringColumnCodec
extends StringColumnCodec {
    LexStringColumnCodec(ColumnInfo info, MethodMaker mm) {
        super(info, mm);
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new LexStringColumnCodec(this.mInfo, mm);
    }

    @Override
    int codecFlags() {
        return 2;
    }

    @Override
    void encodePrepare() {
    }

    @Override
    void encodeSkip() {
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        return this.accum(totalVar, rowUtils.invoke("lengthStringLex", new Object[]{srcVar}));
    }

    @Override
    void encode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        this.doEncode(this.mMaker.var(RowUtils.class), srcVar, dstVar, offsetVar);
    }

    private void doEncode(Variable rowUtils, Variable srcVar, Variable dstVar, Variable offsetVar) {
        Label end = null;
        if (this.mInfo.isNullable()) {
            end = this.mMaker.label();
            this.encodeNullHeaderIfNull(end, srcVar, dstVar, offsetVar);
        }
        Object methodName = "encodeStringLex";
        if (this.mInfo.isDescending()) {
            methodName = (String)methodName + "Desc";
        }
        if (offsetVar == null) {
            rowUtils.invoke((String)methodName, new Object[]{dstVar, 0, srcVar});
        } else {
            offsetVar.set((Object)rowUtils.invoke((String)methodName, new Object[]{dstVar, offsetVar, srcVar}));
        }
        if (end != null) {
            end.here();
        }
    }

    @Override
    void decode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable endVar) {
        Object methodName = "decodeStringLex";
        if (this.mInfo.isDescending()) {
            methodName = (String)methodName + "Desc";
        }
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        Variable lengthVar = rowUtils.invoke("lengthStringLex", new Object[]{srcVar, offsetVar});
        Variable valueVar = rowUtils.invoke((String)methodName, new Object[]{srcVar, offsetVar, lengthVar});
        offsetVar.inc((Object)lengthVar);
        dstVar.set((Object)valueVar);
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        offsetVar.inc((Object)this.mMaker.var(RowUtils.class).invoke("lengthStringLex", new Object[]{srcVar, offsetVar}));
    }

    @Override
    protected Variable filterPrepareBytes(Variable strVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        Variable lengthVar = rowUtils.invoke("lengthStringLex", new Object[]{strVar});
        Variable bytesVar = this.mMaker.new_(byte[].class, new Object[]{lengthVar});
        this.doEncode(rowUtils, strVar, bytesVar, null);
        return bytesVar;
    }

    @Override
    boolean canFilterQuick(ColumnInfo dstInfo) {
        return dstInfo.typeCode == this.mInfo.typeCode;
    }

    @Override
    Object filterQuickDecode(ColumnInfo dstInfo, Variable srcVar, Variable offsetVar, Variable endVar) {
        this.decodeSkip(srcVar, offsetVar, endVar);
        return offsetVar.get();
    }

    @Override
    void filterQuickCompare(ColumnInfo dstInfo, Variable srcVar, Variable offsetVar, int op, Object decoded, Variable argObjVar, int argNum, Label pass, Label fail) {
        this.filterQuickCompareLex(dstInfo, srcVar, offsetVar, (Variable)decoded, op, argObjVar, argNum, pass, fail);
    }

    @Override
    protected void decodeHeader(Variable srcVar, Variable offsetVar, Variable endVar, Variable lengthVar, Variable isNullVar) {
        throw new UnsupportedOperationException();
    }
}

