/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import java.util.Comparator;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.rows.RowEvaluator;
import org.cojen.tupl.rows.RowWriter;
import org.cojen.tupl.rows.SingleScanController;

final class MergedScanController<R>
extends SingleScanController<R> {
    private final SingleScanController<R> mLow;
    private final SingleScanController<R> mHigh;
    private final RowEvaluator<R> mLowEvaluator;
    private final RowEvaluator<R> mHighEvaluator;
    private int mMode;

    static <R> MergedScanController<R> tryMerge(Comparator<byte[]> comparator, SingleScanController<R> low, SingleScanController<R> high) {
        boolean highInclusive;
        byte[] highBound;
        int cmp;
        byte[] lowLow = low.lowBound();
        if (lowLow == EMPTY) {
            return null;
        }
        byte[] highLow = high.lowBound();
        if (highLow == EMPTY) {
            return null;
        }
        byte[] lowHigh = low.highBound();
        if (!(lowHigh == null || highLow == null || (cmp = comparator.compare(lowHigh, highLow)) >= 0 && (cmp != 0 || low.highInclusive() && high.lowInclusive()))) {
            return null;
        }
        if (low.compareHigh(high) < 0) {
            highBound = high.highBound();
            highInclusive = high.highInclusive();
        } else {
            highBound = lowHigh;
            highInclusive = low.highInclusive();
        }
        int mode = low.compareLow(high) == 0 ? 1 : 0;
        boolean reverse = low.isReverse();
        if (reverse != high.isReverse()) {
            throw new AssertionError();
        }
        return new MergedScanController<R>(lowLow, low.lowInclusive(), highBound, highInclusive, low, high, reverse, mode);
    }

    private MergedScanController(byte[] lowBound, boolean lowInclusive, byte[] highBound, boolean highInclusive, SingleScanController<R> low, SingleScanController<R> high, boolean reverse, int mode) {
        super(reverse, lowBound, lowInclusive, highBound, highInclusive);
        this.mLow = low;
        this.mHigh = high;
        this.mLowEvaluator = low.evaluator();
        this.mHighEvaluator = high.evaluator();
        this.mMode = mode;
    }

    @Override
    public R evalRow(Cursor c, LockResult result, R row) throws IOException {
        if (this.mMode == 2) {
            return this.mLowEvaluator.evalRow(c, result, row);
        }
        if (this.mMode != 3) {
            byte[] key = c.key();
            if (this.mLow.isTooHigh(key)) {
                this.mMode = 3;
            } else {
                R decoded = this.mLowEvaluator.evalRow(c, result, row);
                if (decoded != null) {
                    return decoded;
                }
                if (this.mMode == 0) {
                    if (this.mHigh.isTooLow(key)) {
                        return null;
                    }
                    this.mMode = 1;
                }
                if (this.mHigh.isTooHigh(key)) {
                    this.mMode = 2;
                    return null;
                }
            }
        }
        return this.mHighEvaluator.evalRow(c, result, row);
    }

    @Override
    public long estimateSize() {
        try {
            long size = this.mLow.estimateSize();
            if (size != Long.MAX_VALUE) {
                long nextSize = this.mHigh.estimateSize();
                if (nextSize == Long.MAX_VALUE) {
                    return nextSize;
                }
                size = Math.addExact(size, nextSize);
            }
            return size;
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }

    @Override
    public int characteristics() {
        return this.mLow.characteristics();
    }

    @Override
    public long evolvableTableId() {
        return this.mLowEvaluator.evolvableTableId();
    }

    @Override
    public byte[] secondaryDescriptor() {
        return this.mLowEvaluator.secondaryDescriptor();
    }

    @Override
    public R decodeRow(R row, byte[] key, byte[] value) throws IOException {
        return this.mLowEvaluator.decodeRow(row, key, value);
    }

    @Override
    public void writeRow(RowWriter writer, byte[] key, byte[] value) throws IOException {
        this.mLowEvaluator.writeRow(writer, key, value);
    }

    @Override
    public byte[] updateKey(R row, byte[] original) throws IOException {
        return this.mLowEvaluator.updateKey(row, original);
    }

    @Override
    public byte[] updateValue(R row, byte[] original) throws IOException {
        return this.mLowEvaluator.updateValue(row, original);
    }
}

