/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.util.function.IntFunction;
import org.cojen.tupl.rows.RefCache;
import org.cojen.tupl.rows.SoftCache;
import org.cojen.tupl.rows.WeakCache;

final class MultiCache<K, V, H> {
    private final RefCache<K, V, H>[] mCaches;

    public static <K, V, H> MultiCache<K, V, H> newSoftCache(int[] typeMap, final Factory<K, V, H> factory) {
        return new MultiCache<K, V, H>(typeMap, type -> new SoftCache<K, V, H>(){

            @Override
            protected V newValue(K key, H helper) {
                return factory.newValue(type, key, helper);
            }
        });
    }

    public static <K, V, H> MultiCache<K, V, H> newWeakCache(int[] typeMap, final Factory<K, V, H> factory) {
        return new MultiCache<K, V, H>(typeMap, type -> new WeakCache<K, V, H>(){

            @Override
            protected V newValue(K key, H helper) {
                return factory.newValue(type, key, helper);
            }
        });
    }

    private MultiCache(int[] typeMap, IntFunction<RefCache<K, V, H>> f) {
        int type;
        int i;
        RefCache[] caches = new RefCache[typeMap.length];
        for (i = 0; i < caches.length; ++i) {
            type = typeMap[i];
            if (type != i) continue;
            caches[i] = f.apply(type);
        }
        for (i = 0; i < caches.length; ++i) {
            type = typeMap[i];
            if (type == i || (caches[i] = caches[type]) != null) continue;
            throw new IllegalArgumentException();
        }
        this.mCaches = caches;
    }

    public void clear() {
        for (RefCache<K, V, H> cache : this.mCaches) {
            cache.clear();
        }
    }

    public V obtain(int type, K key, H helper) {
        return this.mCaches[type].obtain(key, helper);
    }

    @FunctionalInterface
    public static interface Factory<K, V, H> {
        public V newValue(int var1, K var2, H var3);
    }
}

