/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.BigIntegerColumnCodec;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.RowUtils;

class NonNullBigIntegerColumnCodec
extends BigIntegerColumnCodec {
    protected Variable mBytesVar;
    protected Variable mLengthVar;

    NonNullBigIntegerColumnCodec(ColumnInfo info, MethodMaker mm) {
        super(info, mm);
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new NonNullBigIntegerColumnCodec(this.mInfo, mm);
    }

    @Override
    int codecFlags() {
        return 0;
    }

    @Override
    void encodePrepare() {
        this.mBytesVar = this.mMaker.var(byte[].class);
        this.mLengthVar = this.mMaker.var(Integer.TYPE);
    }

    @Override
    void encodeSkip() {
        this.mBytesVar.set(null);
        this.mLengthVar.set((Object)0);
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        this.mBytesVar.set((Object)srcVar.invoke("toByteArray", new Object[0]));
        this.mLengthVar.set((Object)this.mBytesVar.alength());
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        totalVar = this.accum(totalVar, rowUtils.invoke("lengthPrefixPF", new Object[]{this.mLengthVar}));
        return this.accum(totalVar, this.mLengthVar);
    }

    @Override
    void encode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        offsetVar.set((Object)rowUtils.invoke("encodePrefixPF", new Object[]{dstVar, offsetVar, this.mLengthVar}));
        this.finishEncode(dstVar, offsetVar, this.mLengthVar);
    }

    @Override
    void decode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable endVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        Variable lengthVar = rowUtils.invoke("decodePrefixPF", new Object[]{srcVar, offsetVar});
        offsetVar.inc((Object)rowUtils.invoke("lengthPrefixPF", new Object[]{lengthVar}));
        this.finishDecode(dstVar, srcVar, offsetVar, lengthVar);
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        offsetVar.set((Object)this.mMaker.var(RowUtils.class).invoke("skipBytesPF", new Object[]{srcVar, offsetVar}));
    }

    @Override
    protected void decodeHeader(Variable srcVar, Variable offsetVar, Variable endVar, Variable lengthVar, Variable isNullVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        lengthVar.set((Object)rowUtils.invoke("decodePrefixPF", new Object[]{srcVar, offsetVar}));
        offsetVar.inc((Object)rowUtils.invoke("lengthPrefixPF", new Object[]{lengthVar}));
    }

    protected void finishEncode(Variable dstVar, Variable offsetVar, Variable lengthVar) {
        this.mMaker.var(System.class).invoke("arraycopy", new Object[]{this.mBytesVar, 0, dstVar, offsetVar, lengthVar});
        offsetVar.inc((Object)lengthVar);
    }

    protected void finishDecode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable lengthVar) {
        dstVar.set((Object)this.mMaker.new_((Object)dstVar, new Object[]{srcVar, offsetVar, lengthVar}));
        offsetVar.inc((Object)lengthVar);
    }
}

