/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.BigIntegerColumnCodec;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;

class NonNullLastBigIntegerColumnCodec
extends BigIntegerColumnCodec {
    protected Variable mBytesVar;

    NonNullLastBigIntegerColumnCodec(ColumnInfo info, MethodMaker mm) {
        super(info, mm);
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new NonNullLastBigIntegerColumnCodec(this.mInfo, mm);
    }

    @Override
    int codecFlags() {
        return 1;
    }

    @Override
    void encodePrepare() {
        this.mBytesVar = this.mMaker.var(byte[].class);
    }

    @Override
    void encodeSkip() {
        this.mBytesVar.set(null);
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        this.mBytesVar.set((Object)srcVar.invoke("toByteArray", new Object[0]));
        return this.accum(totalVar, this.mBytesVar.alength());
    }

    @Override
    void encode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        Variable lengthVar = this.mBytesVar.alength();
        this.mMaker.var(System.class).invoke("arraycopy", new Object[]{this.mBytesVar, 0, dstVar, offsetVar, lengthVar});
        offsetVar.inc((Object)lengthVar);
    }

    @Override
    void decode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable endVar) {
        Variable alengthVar = endVar == null ? srcVar.alength() : endVar;
        Variable lengthVar = alengthVar.sub((Object)offsetVar);
        Variable valueVar = this.mMaker.new_((Object)dstVar, new Object[]{srcVar, offsetVar, lengthVar});
        dstVar.set((Object)valueVar);
        offsetVar.set((Object)alengthVar);
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        offsetVar.set((Object)(endVar == null ? srcVar.alength() : endVar));
    }

    @Override
    protected void decodeHeader(Variable srcVar, Variable offsetVar, Variable endVar, Variable lengthVar, Variable isNullVar) {
        Variable alengthVar = endVar == null ? srcVar.alength() : endVar;
        lengthVar.set((Object)alengthVar.sub((Object)offsetVar));
    }
}

