/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.PrimitiveArrayColumnCodec;

class NonNullLastPrimitiveArrayColumnCodec
extends PrimitiveArrayColumnCodec {
    NonNullLastPrimitiveArrayColumnCodec(ColumnInfo info, MethodMaker mm, int flags) {
        super(info, mm, flags);
        if (info.isDescending()) {
            throw new AssertionError();
        }
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new NonNullLastPrimitiveArrayColumnCodec(this.mInfo, mm, this.mFlags);
    }

    @Override
    void encodePrepare() {
    }

    @Override
    void encodeSkip() {
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        return this.accum(totalVar, this.byteArrayLength(srcVar));
    }

    @Override
    void encode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        this.encodeByteArray(srcVar, dstVar, offsetVar);
        offsetVar.inc((Object)this.byteArrayLength(srcVar));
    }

    @Override
    void decode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable endVar) {
        Variable alengthVar = endVar == null ? srcVar.alength() : endVar;
        this.decodeByteArray(dstVar, srcVar, offsetVar, alengthVar.sub((Object)offsetVar));
        offsetVar.set((Object)alengthVar);
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        offsetVar.set((Object)(endVar == null ? srcVar.alength() : endVar));
    }

    @Override
    protected void decodeHeader(Variable srcVar, Variable offsetVar, Variable endVar, Variable lengthVar, Variable isNullVar) {
        Variable alengthVar = endVar == null ? srcVar.alength() : endVar;
        lengthVar.set((Object)alengthVar.sub((Object)offsetVar));
    }
}

