/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.StringColumnCodec;

class NonNullLastStringColumnCodec
extends StringColumnCodec {
    NonNullLastStringColumnCodec(ColumnInfo info, MethodMaker mm) {
        super(info, mm);
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new NonNullLastStringColumnCodec(this.mInfo, mm);
    }

    @Override
    int codecFlags() {
        return 1;
    }

    @Override
    void encodePrepare() {
    }

    @Override
    void encodeSkip() {
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        return this.accum(totalVar, rowUtils.invoke("lengthStringUTF", new Object[]{srcVar}));
    }

    @Override
    void encode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        offsetVar.set((Object)rowUtils.invoke("encodeStringUTF", new Object[]{dstVar, offsetVar, srcVar}));
    }

    @Override
    void decode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable endVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        Variable alengthVar = endVar == null ? srcVar.alength() : endVar;
        Variable lengthVar = alengthVar.sub((Object)offsetVar);
        Variable valueVar = rowUtils.invoke("decodeStringUTF", new Object[]{srcVar, offsetVar, lengthVar});
        offsetVar.set((Object)alengthVar);
        dstVar.set((Object)valueVar);
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        offsetVar.set((Object)(endVar == null ? srcVar.alength() : endVar));
    }

    @Override
    protected void decodeHeader(Variable srcVar, Variable offsetVar, Variable endVar, Variable lengthVar, Variable isNullVar) {
        Variable alengthVar = endVar == null ? srcVar.alength() : endVar;
        lengthVar.set((Object)alengthVar.sub((Object)offsetVar));
    }
}

