/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.PrimitiveArrayColumnCodec;
import org.cojen.tupl.rows.RowUtils;

class NonNullPrimitiveArrayColumnCodec
extends PrimitiveArrayColumnCodec {
    protected Variable mLengthVar;

    NonNullPrimitiveArrayColumnCodec(ColumnInfo info, MethodMaker mm) {
        super(info, mm, 0);
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new NonNullPrimitiveArrayColumnCodec(this.mInfo, mm);
    }

    @Override
    void encodePrepare() {
        this.mLengthVar = this.mMaker.var(Integer.TYPE);
    }

    @Override
    void encodeSkip() {
        this.mLengthVar.set((Object)0);
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        this.mLengthVar.set((Object)this.byteArrayLength(srcVar));
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        totalVar = this.accum(totalVar, rowUtils.invoke("lengthPrefixPF", new Object[]{this.mLengthVar}));
        return this.accum(totalVar, this.mLengthVar);
    }

    @Override
    void encode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        offsetVar.set((Object)rowUtils.invoke("encodePrefixPF", new Object[]{dstVar, offsetVar, this.mLengthVar}));
        this.finishEncode(srcVar, dstVar, offsetVar);
    }

    @Override
    void decode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable endVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        Variable lengthVar = rowUtils.invoke("decodePrefixPF", new Object[]{srcVar, offsetVar});
        offsetVar.inc((Object)rowUtils.invoke("lengthPrefixPF", new Object[]{lengthVar}));
        this.finishDecode(dstVar, srcVar, offsetVar, lengthVar);
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        offsetVar.set((Object)this.mMaker.var(RowUtils.class).invoke("skipBytesPF", new Object[]{srcVar, offsetVar}));
    }

    @Override
    protected void decodeHeader(Variable srcVar, Variable offsetVar, Variable endVar, Variable lengthVar, Variable isNullVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        lengthVar.set((Object)rowUtils.invoke("decodePrefixPF", new Object[]{srcVar, offsetVar}));
        offsetVar.inc((Object)rowUtils.invoke("lengthPrefixPF", new Object[]{lengthVar}));
    }

    protected void finishEncode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        this.encodeByteArray(srcVar, dstVar, offsetVar);
        offsetVar.inc((Object)this.mLengthVar);
    }

    protected void finishDecode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable lengthVar) {
        this.decodeByteArray(dstVar, srcVar, offsetVar, lengthVar);
        offsetVar.inc((Object)lengthVar);
    }
}

